/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.security.Principal;
import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.apache.http.util.LangUtils;

@Immutable
public class NTUserPrincipal
implements Principal {
    private final String username;
    private final String domain;
    private final String ntname;

    public NTUserPrincipal(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("User name may not be null");
        }
        this.username = string2;
        this.domain = string != null ? string.toUpperCase(Locale.ENGLISH) : null;
        if (this.domain != null && this.domain.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.domain);
            stringBuilder.append('/');
            stringBuilder.append(this.username);
            this.ntname = stringBuilder.toString();
        } else {
            this.ntname = this.username;
        }
    }

    @Override
    public String getName() {
        return this.ntname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode((int)n, (Object)this.username);
        n = LangUtils.hashCode((int)n, (Object)this.domain);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof NTUserPrincipal) {
            NTUserPrincipal nTUserPrincipal = (NTUserPrincipal)object;
            if (LangUtils.equals((Object)this.username, (Object)nTUserPrincipal.username) && LangUtils.equals((Object)this.domain, (Object)nTUserPrincipal.domain)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ntname;
    }
}

