/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.ui.OSXAdapter;
import davmail.ui.tray.AwtGatewayTray;
import davmail.ui.tray.DavGatewayTray;
import info.growl.Growl;
import info.growl.GrowlException;
import info.growl.GrowlUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class OSXAwtGatewayTray
extends AwtGatewayTray {
    protected static final String OSX_TRAY_ACTIVE_PNG = "osxtray2.png";
    protected static final String OSX_TRAY_PNG = "osxtray.png";
    protected static final String OSX_TRAY_INACTIVE_PNG = "osxtrayinactive.png";
    private static final Logger LOGGER = Logger.getLogger(OSXAwtGatewayTray.class);

    public boolean quit() {
        DavGateway.stop();
        settingsFrame.dispose();
        aboutFrame.dispose();
        if (logBrokerMonitor != null) {
            logBrokerMonitor.dispose();
        }
        return true;
    }

    @Override
    protected void createAndShowGUI() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        super.createAndShowGUI();
        trayIcon.removeActionListener(this.settingsListener);
        try {
            OSXAdapter.setAboutHandler(this, AwtGatewayTray.class.getDeclaredMethod("about", null));
            OSXAdapter.setPreferencesHandler(this, AwtGatewayTray.class.getDeclaredMethod("preferences", null));
            OSXAdapter.setQuitHandler(this, OSXAwtGatewayTray.class.getDeclaredMethod("quit", null));
        }
        catch (Exception e) {
            DavGatewayTray.error(new BundleMessage("LOG_ERROR_LOADING_OSXADAPTER", new Object[0]), e);
        }
    }

    @Override
    protected String getTrayIconPath() {
        return OSX_TRAY_PNG;
    }

    @Override
    protected String getTrayIconActivePath() {
        return OSX_TRAY_ACTIVE_PNG;
    }

    @Override
    protected String getTrayIconInactivePath() {
        return OSX_TRAY_INACTIVE_PNG;
    }

    @Override
    public void displayMessage(final String message, final Level level) {
        if (!GrowlUtils.isGrowlLoaded()) {
            super.displayMessage(message, level);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AwtGatewayTray.trayIcon != null) {
                        Icon icon = null;
                        if (level.equals((Object)Level.INFO)) {
                            icon = UIManager.getIcon("OptionPane.informationIcon");
                        } else if (level.equals((Object)Level.WARN)) {
                            icon = UIManager.getIcon("OptionPane.warningIcon");
                        } else if (level.equals((Object)Level.ERROR)) {
                            icon = UIManager.getIcon("OptionPane.errorIcon");
                        }
                        if (icon != null && message != null && message.length() > 0) {
                            try {
                                String title = BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]);
                                Growl growl = GrowlUtils.getGrowlInstance((String)"DavMail");
                                growl.addNotification(title, true);
                                growl.register();
                                growl.sendNotification(title, title, message, (RenderedImage)((Object)OSXAwtGatewayTray.this.getImageForIcon(icon)));
                            }
                            catch (GrowlException growlException) {
                                LOGGER.error((Object)growlException);
                            }
                        }
                        AwtGatewayTray.trayIcon.setToolTip(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\n' + message);
                    }
                }
            });
        }
    }

    protected Image getImageForIcon(Icon icon) {
        BufferedImage bufferedimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = bufferedimage.getGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return bufferedimage;
    }
}

