/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.ui.browser.DesktopBrowser;
import davmail.ui.tray.DavGatewayTray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NotificationDialog
extends JDialog {
    protected boolean sendNotification;
    protected JTextField toField;
    protected JTextField ccField;
    protected JTextField subjectField;
    protected JEditorPane bodyField;

    protected void addRecipientComponent(JPanel panel, String label, JTextField textField, String toolTipText) {
        JLabel fieldLabel = new JLabel(label);
        fieldLabel.setHorizontalAlignment(4);
        fieldLabel.setVerticalAlignment(0);
        textField.setMaximumSize(textField.getPreferredSize());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.setAlignmentX(1.0f);
        innerPanel.add(fieldLabel);
        innerPanel.add(textField);
        panel.add(innerPanel);
        if (toolTipText != null) {
            fieldLabel.setToolTipText(toolTipText);
            textField.setToolTipText(toolTipText);
        }
    }

    public NotificationDialog(String to, String cc, String subject, String description) {
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.setTitle(BundleMessage.format("UI_CALDAV_NOTIFICATION", new Object[0]));
        try {
            this.setIconImage(DavGatewayTray.getFrameIcon());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel mainPanel = new JPanel();
        mainPanel.getInputMap(1).put(KeyStroke.getKeyStroke("F1"), "help");
        mainPanel.getActionMap().put("help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopBrowser.browse("http://davmail.sourceforge.net");
            }
        });
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getRecipientsPanel());
        mainPanel.add(this.getBodyPanel(description));
        JPanel recipientsPanel = this.getRecipientsPanel();
        if (to != null) {
            this.toField.setText(to);
        }
        if (cc != null) {
            this.ccField.setText(cc);
        }
        if (subject != null) {
            this.subjectField.setText(subject);
        }
        this.add("North", recipientsPanel);
        JPanel bodyPanel = this.getBodyPanel(description);
        this.add("Center", bodyPanel);
        this.bodyField.setPreferredSize(recipientsPanel.getPreferredSize());
        JPanel buttonPanel = new JPanel();
        JButton cancel = new JButton(BundleMessage.format("UI_BUTTON_CANCEL", new Object[0]));
        JButton send = new JButton(BundleMessage.format("UI_BUTTON_SEND", new Object[0]));
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationDialog.this.sendNotification = true;
                NotificationDialog.this.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(send);
        buttonPanel.add(cancel);
        this.add("South", buttonPanel);
        this.pack();
        this.setResizable(true);
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    protected JPanel getRecipientsPanel() {
        JPanel recipientsPanel = new JPanel();
        recipientsPanel.setLayout(new BoxLayout(recipientsPanel, 1));
        recipientsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toField = new JTextField("", 40);
        this.ccField = new JTextField("", 40);
        this.subjectField = new JTextField("", 40);
        this.addRecipientComponent(recipientsPanel, BundleMessage.format("UI_TO", new Object[0]), this.toField, BundleMessage.format("UI_TO_HELP", new Object[0]));
        this.addRecipientComponent(recipientsPanel, BundleMessage.format("UI_CC", new Object[0]), this.ccField, BundleMessage.format("UI_CC_HELP", new Object[0]));
        this.addRecipientComponent(recipientsPanel, BundleMessage.format("UI_SUBJECT", new Object[0]), this.subjectField, BundleMessage.format("UI_SUBJECT_HELP", new Object[0]));
        return recipientsPanel;
    }

    protected JPanel getBodyPanel(String description) {
        JPanel bodyPanel = new JPanel();
        bodyPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_NOTIFICATION_BODY", new Object[0])));
        this.bodyField = new JEditorPane();
        this.bodyField.setText(description);
        bodyPanel.add(new JScrollPane(this.bodyField));
        return bodyPanel;
    }

    public boolean getSendNotification() {
        return this.sendNotification;
    }

    public String getTo() {
        return this.toField.getText();
    }

    public String getCc() {
        return this.ccField.getText();
    }

    public String getSubject() {
        return this.subjectField.getText();
    }

    public String getBody() {
        return this.bodyField.getText();
    }
}

