/*
 * Decompiled with CFR 0.152.
 */
package davmail.pop;

import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.exchange.DoubleDotOutputStream;
import davmail.exchange.ExchangeSession;
import davmail.exchange.ExchangeSessionFactory;
import davmail.exchange.MessageLoadThread;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.IOUtil;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PopConnection
extends AbstractConnection {
    private static final Logger LOGGER = Logger.getLogger(PopConnection.class);
    private List<ExchangeSession.Message> messages;

    public PopConnection(Socket clientSocket) {
        super(PopConnection.class.getSimpleName(), clientSocket, null);
    }

    protected long getTotalMessagesLength() {
        int result = 0;
        for (ExchangeSession.Message message : this.messages) {
            result += message.size;
        }
        return result;
    }

    protected void printCapabilities() throws IOException {
        this.sendClient("TOP");
        this.sendClient("USER");
        this.sendClient("UIDL");
        this.sendClient(".");
    }

    protected void printList() throws IOException {
        int i = 1;
        for (ExchangeSession.Message message : this.messages) {
            this.sendClient(i++ + " " + message.size);
        }
        this.sendClient(".");
    }

    protected void printUidList() throws IOException {
        int i = 1;
        for (ExchangeSession.Message message : this.messages) {
            this.sendClient(i++ + " " + message.getUid());
        }
        this.sendClient(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            ExchangeSessionFactory.checkConfig();
            this.sendOK("DavMail " + DavGateway.getCurrentVersion() + " POP ready at " + new Date());
            while ((line = this.readClient()) != null) {
                StringTokenizer tokens = new StringTokenizer(line);
                if (tokens.hasMoreTokens()) {
                    String command = tokens.nextToken();
                    if ("QUIT".equalsIgnoreCase(command)) {
                        if (this.session != null) {
                            this.session.purgeOldestTrashAndSentMessages();
                        }
                        this.sendOK("Bye");
                        break;
                    }
                    if ("USER".equalsIgnoreCase(command)) {
                        this.userName = null;
                        this.password = null;
                        this.session = null;
                        if (tokens.hasMoreTokens()) {
                            this.userName = line.substring("USER ".length());
                            this.sendOK("USER : " + this.userName);
                            this.state = AbstractConnection.State.USER;
                        } else {
                            this.sendERR("invalid syntax");
                            this.state = AbstractConnection.State.INITIAL;
                        }
                    } else if ("PASS".equalsIgnoreCase(command)) {
                        if (this.state != AbstractConnection.State.USER) {
                            this.sendERR("invalid state");
                            this.state = AbstractConnection.State.INITIAL;
                        } else if (!tokens.hasMoreTokens()) {
                            this.sendERR("invalid syntax");
                        } else {
                            this.password = line.substring("PASS".length() + 1);
                            try {
                                this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
                                this.sendOK("PASS");
                                this.state = AbstractConnection.State.AUTHENTICATED;
                            }
                            catch (SocketException e) {
                                LOGGER.warn((Object)BundleMessage.formatLog("LOG_CLIENT_CLOSED_CONNECTION", new Object[0]));
                            }
                            catch (Exception e) {
                                DavGatewayTray.error(e);
                                this.sendERR(e);
                            }
                        }
                    } else if ("CAPA".equalsIgnoreCase(command)) {
                        this.sendOK("Capability list follows");
                        this.printCapabilities();
                    } else if (this.state != AbstractConnection.State.AUTHENTICATED) {
                        this.sendERR("Invalid state not authenticated");
                    } else {
                        int messageNumber;
                        if (this.messages == null) {
                            this.messages = this.session.getAllMessageUidAndSize("INBOX");
                        }
                        if ("STAT".equalsIgnoreCase(command)) {
                            this.sendOK(this.messages.size() + " " + this.getTotalMessagesLength());
                        } else if ("NOOP".equalsIgnoreCase(command)) {
                            this.sendOK("");
                        } else if ("LIST".equalsIgnoreCase(command)) {
                            if (tokens.hasMoreTokens()) {
                                String token = tokens.nextToken();
                                try {
                                    messageNumber = Integer.valueOf(token);
                                    ExchangeSession.Message message = this.messages.get(messageNumber - 1);
                                    this.sendOK("" + messageNumber + ' ' + message.size);
                                }
                                catch (NumberFormatException e) {
                                    this.sendERR("Invalid message index: " + token);
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.sendERR("Invalid message index: " + token);
                                }
                            } else {
                                this.sendOK(this.messages.size() + " messages (" + this.getTotalMessagesLength() + " octets)");
                                this.printList();
                            }
                        } else if ("UIDL".equalsIgnoreCase(command)) {
                            if (tokens.hasMoreTokens()) {
                                String token = tokens.nextToken();
                                try {
                                    messageNumber = Integer.valueOf(token);
                                    this.sendOK(messageNumber + " " + this.messages.get(messageNumber - 1).getUid());
                                }
                                catch (NumberFormatException e) {
                                    this.sendERR("Invalid message index: " + token);
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.sendERR("Invalid message index: " + token);
                                }
                            } else {
                                this.sendOK(this.messages.size() + " messages (" + this.getTotalMessagesLength() + " octets)");
                                this.printUidList();
                            }
                        } else if ("RETR".equalsIgnoreCase(command)) {
                            if (tokens.hasMoreTokens()) {
                                try {
                                    int messageNumber2 = Integer.valueOf(tokens.nextToken()) - 1;
                                    ExchangeSession.Message message = this.messages.get(messageNumber2);
                                    this.os.write("+OK ".getBytes("ASCII"));
                                    this.os.flush();
                                    MessageLoadThread.loadMimeMessage(message, this.os);
                                    this.sendClient("");
                                    DoubleDotOutputStream doubleDotOutputStream = new DoubleDotOutputStream(this.os);
                                    IOUtil.write(message.getRawInputStream(), doubleDotOutputStream);
                                    doubleDotOutputStream.close();
                                    if (Settings.getBooleanProperty("davmail.popMarkReadOnRetr")) {
                                        message.markRead();
                                    }
                                }
                                catch (SocketException e) {
                                    LOGGER.warn((Object)BundleMessage.formatLog("LOG_CLIENT_CLOSED_CONNECTION", new Object[0]));
                                }
                                catch (Exception e) {
                                    DavGatewayTray.error(new BundleMessage("LOG_ERROR_RETRIEVING_MESSAGE", new Object[0]), e);
                                    this.sendERR("error retrieving message " + e + ' ' + e.getMessage());
                                }
                            } else {
                                this.sendERR("invalid message index");
                            }
                        } else if ("DELE".equalsIgnoreCase(command)) {
                            if (tokens.hasMoreTokens()) {
                                try {
                                    messageNumber = Integer.valueOf(tokens.nextToken()) - 1;
                                    ExchangeSession.Message message = this.messages.get(messageNumber);
                                    message.moveToTrash();
                                    this.sendOK("DELETE");
                                }
                                catch (NumberFormatException e) {
                                    this.sendERR("invalid message index");
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.sendERR("invalid message index");
                                }
                            } else {
                                this.sendERR("invalid message index");
                            }
                        } else if ("TOP".equalsIgnoreCase(command)) {
                            int message = 0;
                            try {
                                message = Integer.valueOf(tokens.nextToken());
                                int lines = Integer.valueOf(tokens.nextToken());
                                ExchangeSession.Message m = this.messages.get(message - 1);
                                this.sendOK("");
                                DoubleDotOutputStream doubleDotOutputStream = new DoubleDotOutputStream(this.os);
                                IOUtil.write(m.getRawInputStream(), new TopOutputStream(doubleDotOutputStream, lines));
                                doubleDotOutputStream.close();
                            }
                            catch (NumberFormatException e) {
                                this.sendERR("invalid command");
                            }
                            catch (IndexOutOfBoundsException e) {
                                this.sendERR("invalid message index: " + message);
                            }
                            catch (Exception e) {
                                this.sendERR("error retreiving top of messages");
                                DavGatewayTray.error(e);
                            }
                        } else if ("RSET".equalsIgnoreCase(command)) {
                            this.sendOK("RSET");
                        } else {
                            this.sendERR("unknown command");
                        }
                    }
                } else {
                    this.sendERR("unknown command");
                }
                this.os.flush();
            }
        }
        catch (SocketException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_CONNECTION_CLOSED", new Object[0]));
        }
        catch (Exception e) {
            DavGatewayTray.log(e);
            try {
                this.sendERR(e.getMessage());
            }
            catch (IOException e2) {
                DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
            }
        }
        finally {
            this.close();
        }
        DavGatewayTray.resetIcon();
    }

    protected void sendOK(String message) throws IOException {
        this.sendClient("+OK ", message);
    }

    protected void sendERR(Exception e) throws IOException {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        this.sendERR(message);
    }

    protected void sendERR(String message) throws IOException {
        this.sendClient("-ERR ", message.replaceAll("\\n", " "));
    }

    private static final class TopOutputStream
    extends FilterOutputStream {
        private int maxLines;
        private State state = State.START;

        private TopOutputStream(OutputStream os, int maxLines) {
            super(os);
            this.maxLines = maxLines;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.state != State.BODY || this.maxLines > 0) {
                super.write(b);
            }
            if (this.state == State.BODY) {
                if (b == 10) {
                    --this.maxLines;
                }
            } else if (this.state == State.START) {
                if (b == 13) {
                    this.state = State.CR;
                }
            } else if (this.state == State.CR) {
                this.state = b == 10 ? State.CRLF : State.START;
            } else if (this.state == State.CRLF) {
                this.state = b == 13 ? State.CRLFCR : State.START;
            } else if (this.state == State.CRLFCR) {
                this.state = b == 10 ? State.BODY : State.START;
            }
        }

        protected static enum State {
            START,
            CR,
            CRLF,
            CRLFCR,
            BODY;

        }
    }
}

