/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

public class ICSBufferedWriter {
    final StringBuilder buffer = new StringBuilder();

    public void write(String content) {
        if (content != null) {
            this.buffer.append(content);
        }
    }

    public void writeLine(String line) {
        this.writeLine(line, false);
    }

    public void writeLine(String line, boolean prefix) {
        int maxLength = 77;
        if (prefix) {
            --maxLength;
            this.buffer.append(' ');
        }
        if (line.length() > maxLength) {
            this.buffer.append(line.substring(0, maxLength));
            this.newLine();
            this.writeLine(line.substring(maxLength), true);
        } else {
            this.buffer.append(line);
            this.newLine();
        }
    }

    public void newLine() {
        this.buffer.append('\r').append('\n');
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void appendProperty(String propertyName, String propertyValue) {
        if (propertyValue != null && propertyValue.length() > 0) {
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(propertyName);
            lineBuffer.append(':');
            this.appendMultilineEncodedValue(lineBuffer, propertyValue);
            this.writeLine(lineBuffer.toString());
        }
    }

    protected void appendMultilineEncodedValue(StringBuilder buffer, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (c == '\r') continue;
            buffer.append(value.charAt(i));
        }
    }
}

