/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.AbstractServer;
import davmail.BundleMessage;
import davmail.Settings;
import davmail.caldav.CaldavServer;
import davmail.exception.DavMailException;
import davmail.exchange.ExchangeSessionFactory;
import davmail.http.DavGatewayHttpClientFacade;
import davmail.http.DavGatewaySSLProtocolSocketFactory;
import davmail.imap.ImapServer;
import davmail.ldap.LdapServer;
import davmail.pop.PopServer;
import davmail.smtp.SmtpServer;
import davmail.ui.tray.DavGatewayTray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public final class DavGateway {
    private static final Logger LOGGER = Logger.getLogger(DavGateway.class);
    private static final String HTTP_DAVMAIL_SOURCEFORGE_NET_VERSION_TXT = "http://davmail.sourceforge.net/version.txt";
    private static boolean stopped;
    private static final ArrayList<AbstractServer> SERVER_LIST;

    private DavGateway() {
    }

    public static void main(String[] args) {
        boolean notray = false;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (!"-notray".equals(arg)) continue;
                notray = true;
                continue;
            }
            Settings.setConfigFilePath(arg);
        }
        Settings.load();
        DavGatewayTray.init(notray);
        DavGateway.start();
        if (Settings.getBooleanProperty("davmail.server")) {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

                @Override
                public void run() {
                    DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_INTERRUPTED", new Object[0]));
                    DavGateway.stop();
                    stopped = true;
                }
            });
            try {
                while (!stopped) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_INTERRUPTED", new Object[0]));
                DavGateway.stop();
                DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_STOP", new Object[0]));
            }
        }
    }

    public static void start() {
        int ldapPort;
        int caldavPort;
        int imapPort;
        int popPort;
        DavGatewaySSLProtocolSocketFactory.register();
        DavGatewayHttpClientFacade.start();
        SERVER_LIST.clear();
        int smtpPort = Settings.getIntProperty("davmail.smtpPort");
        if (smtpPort != 0) {
            SERVER_LIST.add(new SmtpServer(smtpPort));
        }
        if ((popPort = Settings.getIntProperty("davmail.popPort")) != 0) {
            SERVER_LIST.add(new PopServer(popPort));
        }
        if ((imapPort = Settings.getIntProperty("davmail.imapPort")) != 0) {
            SERVER_LIST.add(new ImapServer(imapPort));
        }
        if ((caldavPort = Settings.getIntProperty("davmail.caldavPort")) != 0) {
            SERVER_LIST.add(new CaldavServer(caldavPort));
        }
        if ((ldapPort = Settings.getIntProperty("davmail.ldapPort")) != 0) {
            SERVER_LIST.add(new LdapServer(ldapPort));
        }
        BundleMessage.BundleMessageList messages = new BundleMessage.BundleMessageList();
        BundleMessage.BundleMessageList errorMessages = new BundleMessage.BundleMessageList();
        for (AbstractServer server : SERVER_LIST) {
            try {
                server.bind();
                server.start();
                messages.add(new BundleMessage("LOG_PROTOCOL_PORT", server.getProtocolName(), server.getPort()));
            }
            catch (DavMailException e) {
                errorMessages.add(e.getBundleMessage());
            }
        }
        final String currentVersion = DavGateway.getCurrentVersion();
        boolean showStartupBanner = Settings.getBooleanProperty("davmail.showStartupBanner", true);
        if (showStartupBanner) {
            DavGatewayTray.info(new BundleMessage("LOG_DAVMAIL_GATEWAY_LISTENING", currentVersion == null ? "" : currentVersion, messages));
        }
        if (!errorMessages.isEmpty()) {
            DavGatewayTray.error(new BundleMessage("LOG_MESSAGE", errorMessages));
        }
        new Thread("CheckRelease"){

            @Override
            public void run() {
                String releasedVersion = DavGateway.getReleasedVersion();
                if (currentVersion != null && currentVersion.length() > 0 && releasedVersion != null && currentVersion.compareTo(releasedVersion) < 0) {
                    DavGatewayTray.info(new BundleMessage("LOG_NEW_VERSION_AVAILABLE", releasedVersion));
                }
            }
        }.start();
    }

    public static void stop() {
        DavGateway.stopServers();
        DavGatewayHttpClientFacade.stop();
        ExchangeSessionFactory.reset();
        DavGatewayTray.info(new BundleMessage("LOG_GATEWAY_STOP", new Object[0]));
        DavGatewayTray.dispose();
    }

    public static void restart() {
        DavGateway.stopServers();
        ExchangeSessionFactory.reset();
        DavGateway.start();
    }

    private static void stopServers() {
        for (AbstractServer server : SERVER_LIST) {
            server.close();
            try {
                server.join();
            }
            catch (InterruptedException e) {
                DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_WAITING_SERVER_THREAD_DIE", new Object[0]), e);
            }
        }
    }

    public static String getCurrentVersion() {
        Package davmailPackage = DavGateway.class.getPackage();
        String currentVersion = davmailPackage.getImplementationVersion();
        if (currentVersion == null) {
            currentVersion = "";
        }
        return currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReleasedVersion() {
        String version = null;
        if (!Settings.getBooleanProperty("davmail.disableUpdateCheck")) {
            BufferedReader versionReader = null;
            GetMethod getMethod = new GetMethod(HTTP_DAVMAIL_SOURCEFORGE_NET_VERSION_TXT);
            try {
                HttpClient httpClient = DavGatewayHttpClientFacade.getInstance(HTTP_DAVMAIL_SOURCEFORGE_NET_VERSION_TXT);
                int status = httpClient.executeMethod((HttpMethod)getMethod);
                if (status == 200) {
                    versionReader = new BufferedReader(new InputStreamReader(getMethod.getResponseBodyAsStream(), "UTF-8"));
                    version = versionReader.readLine();
                    LOGGER.debug((Object)("DavMail released version: " + version));
                }
            }
            catch (IOException e) {
                DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_GET_RELEASED_VERSION", new Object[0]));
            }
            finally {
                if (versionReader != null) {
                    try {
                        versionReader.close();
                    }
                    catch (IOException iOException) {}
                }
                getMethod.releaseConnection();
            }
        }
        return version;
    }

    static {
        SERVER_LIST = new ArrayList();
    }
}

