/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AtomicFileOutputStreamTest
extends ZKTestCase {
    private static final String TEST_STRING = "hello world";
    private static final String TEST_STRING_2 = "goodbye world";
    private File testDir;
    private File dstFile;

    @Before
    public void setupTestDir() throws IOException {
        this.testDir = ClientBase.createTmpDir();
        this.dstFile = new File(this.testDir, "test.txt");
    }

    @After
    public void cleanupTestDir() throws IOException {
        ClientBase.recursiveDelete(this.testDir);
    }

    @Test
    public void testWriteNewFile() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        Assert.assertFalse((boolean)this.dstFile.exists());
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        Assert.assertFalse((boolean)this.dstFile.exists());
        fos.close();
        Assert.assertTrue((boolean)this.dstFile.exists());
        String readBackData = ClientBase.readFile(this.dstFile);
        Assert.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testOverwriteFile() throws IOException {
        Assert.assertTrue((String)"Creating empty dst file", (boolean)this.dstFile.createNewFile());
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        Assert.assertTrue((String)"Empty file still exists", (boolean)this.dstFile.exists());
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        Assert.assertEquals((Object)"", (Object)ClientBase.readFile(this.dstFile));
        fos.close();
        String readBackData = ClientBase.readFile(this.dstFile);
        Assert.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testFailToFlush() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.dstFile);
        fos.write(TEST_STRING_2.getBytes());
        fos.close();
        OutputStream failingStream = this.createFailingStream();
        failingStream.write(TEST_STRING.getBytes());
        try {
            failingStream.close();
            Assert.fail((String)"Close didn't throw exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)TEST_STRING_2, (Object)ClientBase.readFile(this.dstFile));
        Assert.assertEquals((String)"Temporary file should have been cleaned up", (Object)this.dstFile.getName(), (Object)ClientBase.join(",", this.testDir.list()));
    }

    private OutputStream createFailingStream() throws FileNotFoundException {
        return new AtomicFileOutputStream(this.dstFile){

            public void flush() throws IOException {
                throw new IOException("injected failure");
            }
        };
    }

    @Test
    public void testAbortNewFile() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        fos.abort();
        Assert.assertEquals((long)0L, (long)this.testDir.list().length);
    }

    @Test
    public void testAbortNewFileAfterFlush() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        fos.abort();
        Assert.assertEquals((long)0L, (long)this.testDir.list().length);
    }

    @Test
    public void testAbortExistingFile() throws IOException {
        FileOutputStream fos1 = new FileOutputStream(this.dstFile);
        fos1.write(TEST_STRING.getBytes());
        fos1.close();
        AtomicFileOutputStream fos2 = new AtomicFileOutputStream(this.dstFile);
        fos2.abort();
        Assert.assertEquals((Object)TEST_STRING, (Object)ClientBase.readFile(this.dstFile));
        Assert.assertEquals((long)1L, (long)this.testDir.list().length);
    }

    @Test
    public void testAbortExistingFileAfterFlush() throws IOException {
        FileOutputStream fos1 = new FileOutputStream(this.dstFile);
        fos1.write(TEST_STRING.getBytes());
        fos1.close();
        AtomicFileOutputStream fos2 = new AtomicFileOutputStream(this.dstFile);
        fos2.write(TEST_STRING_2.getBytes());
        fos2.flush();
        fos2.abort();
        Assert.assertEquals((Object)TEST_STRING, (Object)ClientBase.readFile(this.dstFile));
        Assert.assertEquals((long)1L, (long)this.testDir.list().length);
    }
}

