/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#define RODENT_POPUP_THREADS_C

#include "rodent.h"
#include "rfm_modules.h"
#include "rodent_popup_threads.i"

////////////////////////////////////////////////////////////////////////////////////////
//             rodent_create_popup_bythread guts (threaded functions) 
//
//              everything in this file *must* be gdk mutex protected
////////////////////////////////////////////////////////////////////////////////////////

// menu creation options:
// types: submenu, menuitem, separator
// options:
//        submenu: parent_id, id, icon_id, string, 
//        menuitem: parent_id, id, icon_id, string, RodentCallback
//        separator: parent_id, id

GtkWidget *
rodent_thread_add_menu_separator (GtkWidget * parent, gchar *text) {
    popup_controller();
    return thread_add_menu_separator (parent, text);
}

GtkWidget *
rodent_thread_add_submenu (GtkWidget * parent, const gchar * label, const gchar * name, const gchar * iconfile) 
{
    popup_controller();
    return thread_add_submenu (parent, label, name, iconfile);
}

GtkWidget *
rodent_thread_mk_pixmap_menu (const gchar * icon_id, GtkWidget * parent, gint caso) {
    popup_controller();
    return thread_mk_pixmap_menu (parent, icon_id, caso);
}

void
rodent_thread_multimenu_make(GtkAccelGroup * accel_group, RodentMenuDefinition *in_p){
    if (!in_p || !in_p->parent_id){
	g_error("thread_multimenu_make: incorrect function call.\n");
    }
    popup_controller();
    thread_multimenu_make(accel_group, in_p);
    return ;
}

static gpointer
rodent_create_popup_bythread_f(gpointer data){
    if (!popup_mutex || !popup_ready){
	g_error("rodent_popup_control has not been invoked\n");
    }
    rfm_rec_mutex_lock (&popup_create_mutex);
    GtkWidget *popup = mk_popup_menu();
    g_cond_broadcast(popup_ready);
    rfm_rec_mutex_unlock (&popup_create_mutex);
    return popup;
}

void
rodent_create_popup_bythread(void){
    static gsize initialized = 0;
    if (g_once_init_enter(&initialized)){
         //rodent_create_popup_bythread_f(NULL);
        rfm_view_thread_create(NULL, rodent_create_popup_bythread_f, NULL, "rodent_create_popup_bythread_f");
	g_once_init_leave(&initialized, 1);
    }
    return;
 }

void
rodent_popup_control(void){
    rfm_mutex_init(popup_mutex);
    rfm_cond_init(popup_ready);
    rfm_rec_mutex_init(&popup_create_mutex);
}
