#ifndef RODENT_ACTIONS_H
#define RODENT_ACTIONS_H

void rodent_init(void);

RodentButtonDefinition *
rodent_get_button_definitions(void);


///////////////////////   menu  /////////////////////////

#define TOGGLE_FLAG \
       ((1<<HIDDEN_TOGGLED)|(1<<PREVIEW_TOGGLED)|(1<<BACKUP_TOGGLED)|\
	(1<<CASESORT_TOGGLED)|(1<<NAME_SORT_ACTIVATE)|\
	(1<<TYPE_SORT_ACTIVATE)|(1<<DATE_SORT_ACTIVATE)|\
	(1<<SIZE_SORT_ACTIVATE)|(1<<OWNER_SORT_ACTIVATE)|\
	(1<<GROUP_SORT_ACTIVATE)|(1<<MODE_SORT_ACTIVATE)|\
	(1<<COMPACT_ICONSIZE_TOGGLED)|(1<<TINY_ICONSIZE_TOGGLED)|\
	(1<<NORMAL_ICONSIZE_TOGGLED)|(1<<BIG_ICONSIZE_TOGGLED)|\
	(1<<HUGE_ICONSIZE_TOGGLED))
#define IS_TOGGLE(x) ((x <= HUGE_ICONSIZE_TOGGLED) && ((1<<x) & TOGGLE_FLAG))
#define RADIO_FLAG \
       ((1<<NAME_SORT_ACTIVATE)|\
	(1<<TYPE_SORT_ACTIVATE)|(1<<DATE_SORT_ACTIVATE)|\
	(1<<SIZE_SORT_ACTIVATE)|(1<<OWNER_SORT_ACTIVATE)|\
	(1<<GROUP_SORT_ACTIVATE)|(1<<MODE_SORT_ACTIVATE)|\
	(1<<COMPACT_ICONSIZE_TOGGLED)|(1<<TINY_ICONSIZE_TOGGLED)|\
	(1<<NORMAL_ICONSIZE_TOGGLED)|(1<<BIG_ICONSIZE_TOGGLED)|\
	(1<<HUGE_ICONSIZE_TOGGLED))
#define IS_RADIO(x) ((x <= HUGE_ICONSIZE_TOGGLED) && ((1<<x) & RADIO_FLAG))

//
///////////////////////   buttons  /////////////////////////


#define ONE32 ((gint32) 0x01)
#define ONE64 (G_GINT64_CONSTANT(0x01))

#define DEFAULT_TOOLBAR_BUTTONS \
	((ONE64<<LS_CALLBACK_BUTTON_ID)| \
	(ONE64<<NEW_TAB_CALLBACK_B_BUTTON_ID)| \
	(ONE64<<NEW_WINDOW_CALLBACK_BUTTON_ID)| \
	(ONE64<<SORT_DESCENDING_CALLBACK_BUTTON_ID)| \
	(ONE64<<TYPE_SORT_CALLBACK_BUTTON_ID)| \
	(ONE64<<NAME_SORT_CALLBACK_BUTTON_ID)| \
	(ONE64<<DATE_SORT_CALLBACK_BUTTON_ID)| \
	(ONE64<<CASE_SORT_CALLBACK_BUTTON_ID)| \
	(ONE64<<SHOW_HIDDEN_CALLBACK_BUTTON_ID)| \
	(ONE64<<SHOW_BACKUP_CALLBACK_BUTTON_ID) \
	)


/**
 * Three types of actions: menu action, button action and keybind action.
**/

/**
 * Menu action is the basic action. All actions are done by menu actions
 * Button and keybind actions just front end for the menu action.
 **/

/**
 * Menu actions are defined with the RodentMenuType. The type defines
 * the kind of menu item, which can be an inactive item (NULL_TYPE), 
 * a submenu (SUBMENU_TYPE), 
 * a common menu action (MENUITEM_TYPE), a toggle menu item (CHECKITEM_TYPE),
 * a radio-button menu item (RADIOITEM_TYPE), 
 * or an inactive separator item (SEPARATOR_TYPE).
 **/

///////////////////////   buttons  /////////////////////////
// PLEASE NOTE:
// 
// If items in menu_enum_t are moved around, or items added or removed
// you must update KEYBINDINGS_FILE (files.h) to current build.
//
// You have been warned...
//
enum menu_enum_t {
    ACTIVATE, // This should be the first.
    // Toggles (value is use to set a bit flag with shift)
    // NOTE: Checkboxes and toggles should always follow ACTIVATE
    // and order important because of the shift flag defined
    // above.
    HIDDEN_TOGGLED,
    BACKUP_TOGGLED,
    PREVIEW_TOGGLED,
    CASESORT_TOGGLED,
    ASCENDING_ACTIVATE,
    DESCENDING_ACTIVATE,
    // Radio items: sort
    NAME_SORT_ACTIVATE,
    TYPE_SORT_ACTIVATE,
    DATE_SORT_ACTIVATE,
    SIZE_SORT_ACTIVATE,
    OWNER_SORT_ACTIVATE,
    GROUP_SORT_ACTIVATE,
    MODE_SORT_ACTIVATE,
    // Radio items: size
    COMPACT_ICONSIZE_TOGGLED,
    TINY_ICONSIZE_TOGGLED,
    NORMAL_ICONSIZE_TOGGLED,
    BIG_ICONSIZE_TOGGLED,
    HUGE_ICONSIZE_TOGGLED,
    //
    // These are all normal callbacks.
    // Ordering is now irrelevant from this point on.
    PLUS_ICONSIZE_ACTIVATE,
    MINUS_ICONSIZE_ACTIVATE,    
    DEFAULT_ICONSIZE_ACTIVATE,
    DEFAULT_ICONSIZE_ALL_ACTIVATE,

    MENU_ACTIVATE,
    GLOB_ACTIVATE,
    FIND_ACTIVATE,
    HELP_ACTIVATE,
    REMOVE_ACTIVATE,
    REFRESH_ACTIVATE,
    RELOAD_ACTIVATE,
    HOST_ACTIVATE,
    GOUP_ACTIVATE,
    FORWARD_ACTIVATE,
    BACK_ACTIVATE,
    HOME_ACTIVATE,
    JUMP_TO_ACTIVATE,
    PLUGIN_GOTO_ACTIVATE,
    LEVEL_GOTO_ACTIVATE,
    RUN_ACTIVATE,
    OPEN_WITH_ACTIVATE,
    ABOUT_ACTIVATE,
    NEW_WINDOW_ACTIVATE,
    NEW_TAB_ACTIVATE,
    OPEN_IN_TERMINAL_ACTIVATE,
    DIFFERENCES_ACTIVATE,
    SETTINGS_ACTIVATE,
    NEWDIR_ACTIVATE,
    NEWFILE_ACTIVATE,
    AUTOTYPE_ACTIVATE,
    AUTOTYPE_R_ACTIVATE,
    BCRYPT_ACTIVATE,
    RENAME_ACTIVATE,
    DUPLICATE_ACTIVATE,
    SYMLINK_ACTIVATE,
    DONE_WITH_RENAME,
    TOUCH_ACTIVATE,
    PROPERTIES_ACTIVATE,
    UNSELECT_ALL_ACTIVATE,
    SELECT_ALL_ACTIVATE,
    SELECT_INVERT_ACTIVATE,
    SELECT_BY_FILTER_ACTIVATE,
    UNSELECT_BY_FILTER_ACTIVATE,
    MOUNT_ACTIVATE,
    UNMOUNT_ACTIVATE,
    CUT_ACTIVATE,
    COPY_ACTIVATE,
    PASTE_ACTIVATE,
    CLOSE_ACTIVATE,
    QUIT_ACTIVATE,
    BOOKMARK_ADD_ACTIVATE,
    BOOKMARK_REMOVE_ACTIVATE,
    BOOKMARK_TOGGLED,
    KEYBINDINGS_ACTIVATE,
    LS_ACTIVATE,


    ENUM_CALLBACKS
};

///////////////////////   menu  /////////////////////////

// If order is changed or items added/removed, then
// you must bump-up configuration file build compatibility
enum button_callback_id_t {
    NEW_WINDOW_CALLBACK_BUTTON_ID,   	// 2
    LS_CALLBACK_BUTTON_ID,   	// 2
    NEW_FILE_CALLBACK_BUTTON_ID,   	// 0
    NEWDIR_CALLBACK_BUTTON_ID,   	// 1
    ABOUT_CALLBACK_BUTTON_ID,   	// 3 f
    JUMP_TO_CALLBACK_BUTTON_ID,   	// 4
    GOTO_HOST_CALLBACK_BUTTON_ID,   	// 5
    GOTO_HOME_CALLBACK_BUTTON_ID,   	// 6
    GO_UP_CALLBACK_BUTTON_ID,   	// 7 ff
    GO_FORWARD_CALLBACK_BUTTON_ID,   	// 8
    GO_BACK_CALLBACK_BUTTON_ID,   	// 8
    CUT_CALLBACK_BUTTON_ID,   		// 9
    COPY_CALLBACK_BUTTON_ID,   		// 10
    PASTE_CALLBACK_BUTTON_ID,   	// 11 fff
    REMOVE_CALLBACK_BUTTON_ID,   	// 12
    TOGGLE_BOOKMARK_CALLBACK_BUTTON_ID,	// 13
    HELP_CALLBACK_BUTTON_ID,   		// 14
    SETTINGS_CALLBACK_BUTTON_ID,   	// 15 ffff
    TERMINAL_CALLBACK_BUTTON_ID,   	// 16
    REFRESH_CALLBACK_BUTTON_ID,   	// 17
    RUN_CALLBACK_BUTTON_ID,   		// 18
    FIND_CALLBACK_BUTTON_ID,   		// 19 fffff
    DIFFERENCES_CALLBACK_BUTTON_ID,   	// 20
    SORT_ASCENDING_CALLBACK_BUTTON_ID,	// 21
    SORT_DESCENDING_CALLBACK_BUTTON_ID,	// 22
    KEYBINDINGS_CALLBACK_BUTTON_ID,   	// 23 ffffff
    SELECT_ALL_CALLBACK_BUTTON_ID,   	// 24
    SELECT_INVERT_CALLBACK_BUTTON_ID,   // 25
    UNSELECT_ALL_CALLBACK_BUTTON_ID,   	// 26
    SELECT_BYFILTER_CALLBACK_BUTTON_ID,	// 27 fffffff
    UNSELECT_BYFILTER_CALLBACK_BUTTON_ID,   // 28
    TYPE_SORT_CALLBACK_BUTTON_ID,   	//29 
    NAME_SORT_CALLBACK_BUTTON_ID,   	// 30
    DATE_SORT_CALLBACK_BUTTON_ID,   	// 31 ffffffff
    SIZE_SORT_CALLBACK_BUTTON_ID,   	// 32
    OWNER_SORT_CALLBACK_BUTTON_ID,   	// 33
    GROUP_SORT_CALLBACK_BUTTON_ID,   	// 34
    MODE_SORT_CALLBACK_BUTTON_ID,   	// 35 fffffffff
    DEFAULT_ICONSIZE_CALLBACK_BUTTON_ID,// 36
    DEFAULT_ICONSIZE_ALL_CALLBACK_BUTTON_ID,   // 37
    COMPACT_ICONSIZE_CALLBACK_BUTTON_ID,// 38
    TINY_ICONSIZE_CALLBACK_BUTTON_ID,   // 39 ffffffffff
    NORMAL_ICONSIZE_CALLBACK_BUTTON_ID, // 40
    BIG_ICONSIZE_CALLBACK_BUTTON_ID,   	// 41
    HUGE_ICONSIZE_CALLBACK_BUTTON_ID,   // 42
    PLUS_ICONSIZE_CALLBACK_BUTTON_ID,   // 43 fffffffffff
    MINUS_ICONSIZE_CALLBACK_BUTTON_ID,  // 44
    SHOW_HIDDEN_CALLBACK_BUTTON_ID,   	// 45
    SHOW_BACKUP_CALLBACK_BUTTON_ID,   	// 46
    PREVIEW_IMAGES_CALLBACK_BUTTON_ID,  // 47 
    CASE_SORT_CALLBACK_BUTTON_ID,   	// 48
    NEW_TAB_CALLBACK_BUTTON_ID,  	// 49
    NEW_TAB_CALLBACK_B_BUTTON_ID,  	// < 64
    BUTTON_OVERFLOW_ID
    };

/* Use as many different names for as many different
 * autotype menu entries for one file extension type. */
#define AUTO_C_NAME \
    "autotype-0",\
    "autotype-1",\
    "autotype-2",\
    "autotype-3",\
    "autotype-4",\
    "autotype-5",\
    "autotype-6",\
    "autotype-7",\
    "autotype-8",\
    "autotype-9",\
    NULL


#define NEW_FILE_CALLBACK \
    {NEWFILE_ACTIVATE, N_("Create new file in the given directory"),"xffm/stock_new", \
    NULL, NULL,		GDK_KEY_Insert,	GDK_CONTROL_MASK }

#define NEWDIR_CALLBACK \
    {NEWDIR_ACTIVATE, N_("Create a new empty folder inside this folder"),"xffm/stock_directory/compositeNW/emblem_star",\
    NULL, NULL,		GDK_KEY_N,	(GDK_CONTROL_MASK|GDK_SHIFT_MASK) }

#define BCRYPT_CALLBACK \
    {BCRYPT_ACTIVATE, N_("bcrypt"),"xffm/emblem_lock/compositeNE/emblem_greenball",\
    NULL, NULL,		GDK_KEY_B,	(GDK_CONTROL_MASK|GDK_SHIFT_MASK)}

#define RENAME_CALLBACK \
    {RENAME_ACTIVATE, N_("Rename"),"xffm/stock_save-as/compositeNE/emblem_greenball",\
    NULL, NULL,		GDK_KEY_R,	(GDK_CONTROL_MASK|GDK_SHIFT_MASK)}

#define DUPLICATE_CALLBACK \
    {DUPLICATE_ACTIVATE, N_("Duplicate"),"xffm/stock_copy/compositeNE/emblem_greenball",\
    NULL, NULL,	GDK_KEY_d,	GDK_CONTROL_MASK}

#define SYMLINK_CALLBACK \
    {SYMLINK_ACTIVATE, N_("Link"),"xffm/emblem_symbolic-link/compositeNE/emblem_greenball",\
    NULL, NULL,		GDK_KEY_s,	GDK_CONTROL_MASK}

#define TOUCH_CALLBACK \
    {TOUCH_ACTIVATE, N_("Touch"),"xffm/emblem_about/compositeNE/emblem_greenball",\
    NULL, NULL,		GDK_KEY_T,	(GDK_CONTROL_MASK|GDK_SHIFT_MASK)}
#define LS_CALLBACK \
    {LS_ACTIVATE, N_("File Information..."),"xffm/emblem_about",\
    NULL, NULL,		GDK_KEY_F10,	0}
#define PROPERTIES_CALLBACK \
    {PROPERTIES_ACTIVATE, N_("Properties"),"xffm/stock_properties",\
    NULL, NULL,		GDK_KEY_p,	GDK_CONTROL_MASK}

#define NEW_WINDOW_CALLBACK \
    {NEW_WINDOW_ACTIVATE, N_("Open in New Window"),"rodent",\
   NULL, NULL,	GDK_KEY_n,	GDK_CONTROL_MASK}
//Different button icon for the toolbar
#define NEW_TAB_CALLBACK_B \
    {NEW_TAB_ACTIVATE, N_("Open in New Tab"),"xffm/stock_add",\
   NULL, NULL,	0,	0}

#define NEW_TAB_CALLBACK \
    {NEW_TAB_ACTIVATE, N_("Open in New Tab"),"xffm/stock_directory",\
   NULL, NULL,	GDK_KEY_t,	GDK_CONTROL_MASK}

#define SHOW_HIDDEN_CALLBACK \
    {HIDDEN_TOGGLED, N_("Show hidden files"),"xffm/emblem_show-hidden",\
   NULL, NULL,		GDK_KEY_h,	GDK_CONTROL_MASK, CHECKITEM_TYPE}

#define SHOW_BACKUP_CALLBACK \
    {BACKUP_TOGGLED, N_("Show Backup Files"),"xffm/emblem_bak",\
   NULL, NULL,		GDK_KEY_b,	GDK_CONTROL_MASK, CHECKITEM_TYPE}

#define PREVIEW_IMAGES_CALLBACK \
    {PREVIEW_TOGGLED, N_("Show previews of files and directories."),"xffm/emblem_image",\
   NULL, NULL,		GDK_KEY_i,	GDK_CONTROL_MASK, CHECKITEM_TYPE}

#define ABOUT_CALLBACK \
    {ABOUT_ACTIVATE, N_("About"),"xffm/stock_about",\
   NULL, NULL,		GDK_KEY_A,	(GDK_CONTROL_MASK|GDK_SHIFT_MASK)}

#define JUMP_TO_CALLBACK \
    {JUMP_TO_ACTIVATE, N_("Choose Location"),"xffm/stock_jump",\
   NULL, NULL,		GDK_KEY_Down,	GDK_MOD5_MASK|GDK_MOD1_MASK}

#define GOTO_HOST_CALLBACK \
    {HOST_ACTIVATE, N_("System"), "xffm/emblem_computer",\
   NULL, NULL,		GDK_KEY_End,	GDK_MOD5_MASK|GDK_MOD1_MASK}

#define GOTO_HOME_CALLBACK \
    {HOME_ACTIVATE, N_("Home"),"xffm/stock_home",\
   NULL, NULL,		GDK_KEY_Home,	GDK_MOD5_MASK|GDK_MOD1_MASK}

#define GO_UP_CALLBACK \
    {GOUP_ACTIVATE, N_("Go up"),"xffm/stock_go-up",\
   NULL, NULL,		GDK_KEY_Up,	GDK_MOD5_MASK|GDK_MOD1_MASK}

#define GO_BACK_CALLBACK \
    {BACK_ACTIVATE, N_("Go back"),"xffm/stock_go-previous",\
    NULL, NULL,		GDK_KEY_Left,	GDK_MOD5_MASK|GDK_MOD1_MASK}

#define GO_FORWARD_CALLBACK \
    {FORWARD_ACTIVATE, N_("Go forward"),"xffm/stock_go-next",\
    NULL, NULL,		GDK_KEY_Right,	GDK_MOD5_MASK|GDK_MOD1_MASK}

#define CUT_CALLBACK \
    {CUT_ACTIVATE, N_("Cut"),"xffm/stock_cut",\
   NULL, NULL,		GDK_KEY_x,	GDK_CONTROL_MASK}

#define COPY_CALLBACK \
    {COPY_ACTIVATE, N_("Copy"),"xffm/stock_copy",\
   NULL, NULL,		GDK_KEY_c,	GDK_CONTROL_MASK}

#define PASTE_CALLBACK \
    {PASTE_ACTIVATE, N_("Paste"),"xffm/stock_paste",\
   NULL, NULL,		GDK_KEY_v,	GDK_CONTROL_MASK}

#define REMOVE_CALLBACK \
    {REMOVE_ACTIVATE, N_("Delete"),"xffm/stock_delete",\
   NULL, NULL,		GDK_KEY_Delete,	0}

#define AUTOTYPE_CALLBACK \
    {AUTOTYPE_ACTIVATE, "Mimetype command","xffm/stock_execute",\
   NULL, NULL,		0,	0}

#define AUTOTYPE_R_CALLBACK \
    {AUTOTYPE_R_ACTIVATE, "autotype_Prun","xffm/stock_execute",\
   NULL, NULL,	0,	0}

#define OPEN_WITH_CALLBACK \
    {OPEN_WITH_ACTIVATE, N_("Open with"),"xffm/stock_open",\
   NULL, NULL,	GDK_KEY_o,	GDK_CONTROL_MASK}

#define ADD_BOOKMARK_CALLBACK \
    {BOOKMARK_ADD_ACTIVATE, N_("Add bookmark"),"xffm/emblem_bookmark/compositeNE/emblem_greenball",\
   NULL, NULL,	0,	0}

#define REMOVE_BOOKMARK_CALLBACK \
    {BOOKMARK_REMOVE_ACTIVATE, N_("Remove bookmark"),"xffm/emblem_bookmark/compositeNE/emblem_redball",\
   NULL, NULL,	0,	0}

#define TOGGLE_BOOKMARK_CALLBACK \
    {BOOKMARK_TOGGLED, N_("Toggle Bookmark"),"xffm/emblem_bookmark",\
   NULL, NULL,	GDK_KEY_F12,	0, CHECKITEM_TYPE}

#define MOUNT_CALLBACK \
    {MOUNT_ACTIVATE, N_("Mount the volume associated with this folder"),"xffm/emblem_greenball",\
   NULL, NULL,		GDK_KEY_m,	GDK_CONTROL_MASK}

#define UNMOUNT_CALLBACK \
    {UNMOUNT_ACTIVATE, N_("Unmount the volume associated with this folder"),"xffm/emblem_redball",\
   NULL, NULL,		GDK_KEY_M,	(GDK_CONTROL_MASK|GDK_SHIFT_MASK)}

#define CLOSE_CALLBACK \
    {CLOSE_ACTIVATE, N_("Close"),"xffm/stock_close",\
   NULL, NULL,		GDK_KEY_q,	GDK_CONTROL_MASK}

#define HELP_CALLBACK \
    {HELP_ACTIVATE, N_("Help"),"xffm/stock_help",\
   NULL, NULL,		GDK_KEY_F1,	0}

#define SETTINGS_CALLBACK \
    {SETTINGS_ACTIVATE, N_("Personal settings"),"xffm/stock_preferences",\
   NULL, NULL,		GDK_KEY_F2,	0}

#define TERMINAL_CALLBACK \
    {OPEN_IN_TERMINAL_ACTIVATE, N_("Open terminal"),"xffm/emblem_terminal",\
   NULL, NULL,	GDK_KEY_F4,	0}

// This is the same as REFRESH_CALLBACK, except that this one gets displayed in menu:
#define RELOAD_CALLBACK \
    {RELOAD_ACTIVATE, N_("Reload"),"xffm/stock_refresh",\
   NULL, NULL,		GDK_KEY_F5,	0}

#define REFRESH_CALLBACK \
    {REFRESH_ACTIVATE, N_("Reload"),"xffm/stock_refresh",\
   NULL, NULL,		GDK_KEY_r,	GDK_CONTROL_MASK}

#define RUN_CALLBACK \
    {RUN_ACTIVATE, N_("Execute Shell Command"),"xffm/stock_execute",\
    NULL, NULL,		GDK_KEY_F6,	0}

// This is the same as FIND_CALLBACK, except that this one gets displayed in menu:
#define SEARCH_CALLBACK \
    {GLOB_ACTIVATE, N_("Search"),"xffm/stock_find",\
   NULL, NULL,		GDK_KEY_F7,	0}

#define FIND_CALLBACK \
    {FIND_ACTIVATE, N_("Search"),"xffm/stock_find",\
   NULL, NULL,		GDK_KEY_f,	GDK_CONTROL_MASK}

#define DIFFERENCES_CALLBACK \
    {DIFFERENCES_ACTIVATE, N_("Compare Files or Folders"),"xffm/emblem_diff-tool",\
   NULL, NULL,	GDK_KEY_F8,	0}

#define CASE_SORT_CALLBACK \
    {CASESORT_TOGGLED, N_("Sort case insensitive"),"xffm/stock_bold",\
   NULL, NULL,		GDK_KEY_F11,	0, CHECKITEM_TYPE}

#define SORT_ASCENDING_CALLBACK \
    {ASCENDING_ACTIVATE, N_("Sort data in ascending order"),"xffm/stock_sort-ascending",\
   NULL, NULL,		GDK_KEY_F2,	GDK_CONTROL_MASK}

#define SORT_DESCENDING_CALLBACK \
    {DESCENDING_ACTIVATE, N_("Sort data in descending order"),"xffm/stock_sort-descending",\
   NULL, NULL,		GDK_KEY_F3,	GDK_CONTROL_MASK}


#define KEYBINDINGS_CALLBACK \
    {KEYBINDINGS_ACTIVATE, N_("Global keybindings support"),"xffm/emblem_keyboard",\
   NULL, NULL,		GDK_KEY_F1,	GDK_CONTROL_MASK}

#define SELECT_ALL_CALLBACK \
    {SELECT_ALL_ACTIVATE, N_("Select All"),"xffm/stock_select-all",\
    NULL, NULL,	GDK_KEY_a, 	GDK_CONTROL_MASK}

#define SELECT_INVERT_CALLBACK \
    {SELECT_INVERT_ACTIVATE, N_("Invert Selection"),"xffm/stock_select-all/compositeSE/emblem_invert",\
    NULL, \
		NULL,			GDK_KEY_equal, 	GDK_CONTROL_MASK}

#define UNSELECT_ALL_CALLBACK \
    {UNSELECT_ALL_ACTIVATE, N_("Unselect"),"xffm/stock_select-all/compositeSE/emblem_grayball",\
    NULL, NULL,	GDK_KEY_u, 	GDK_CONTROL_MASK}

#define SELECT_BYFILTER_CALLBACK \
    {SELECT_BY_FILTER_ACTIVATE, N_("Select Items Matching..."),"xffm/stock_select-all/compositeSE/emblem_greenball",\
   NULL, \
	NULL,				GDK_KEY_plus, 	GDK_CONTROL_MASK}

#define UNSELECT_BYFILTER_CALLBACK \
    {UNSELECT_BY_FILTER_ACTIVATE, N_("Unselect Items Matching..."),"xffm/stock_select-all/compositeSE/emblem_redball",\
    NULL, \
	NULL,				GDK_KEY_minus, 	GDK_CONTROL_MASK}


#define NAME_SORT_CALLBACK \
    {NAME_SORT_ACTIVATE, N_("Sort by name"),NULL,\
   NULL, NULL,	GDK_KEY_F4,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define TYPE_SORT_CALLBACK \
    {TYPE_SORT_ACTIVATE, N_("Default sort order"),NULL,\
   NULL, NULL,		GDK_KEY_F5,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define DATE_SORT_CALLBACK \
    {DATE_SORT_ACTIVATE, N_("Sort by date"),NULL,\
   NULL, NULL,		GDK_KEY_F6,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define SIZE_SORT_CALLBACK \
    {SIZE_SORT_ACTIVATE, N_("Sort by size"),NULL,\
   NULL, NULL,		GDK_KEY_F7,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define OWNER_SORT_CALLBACK \
    {OWNER_SORT_ACTIVATE, N_("User"),NULL,\
   NULL, NULL,		GDK_KEY_F8,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define GROUP_SORT_CALLBACK \
    {GROUP_SORT_ACTIVATE, N_("Group"),NULL,\
   NULL, NULL,		GDK_KEY_F9,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define MODE_SORT_CALLBACK \
    {MODE_SORT_ACTIVATE, N_("By Permissions"),NULL,\
   NULL, NULL,		GDK_KEY_F10,	GDK_CONTROL_MASK, RADIOITEM_TYPE}


#define MENU_CALLBACK \
    {MENU_ACTIVATE, N_("Opens the main menu."),"xffm/emblem_applications",\
    NULL, NULL,		GDK_KEY_F3,	0}

#define NULL_CALLBACK  {-1, NULL,NULL, NULL, NULL, 0,0}

////////////////////////////////////////////////////////////////////////////////////


#define PLUS_ICONSIZE_CALLBACK \
    {PLUS_ICONSIZE_ACTIVATE, N_("Enlarge Icons"),"xffm/stock_zoom-in",\
   NULL, NULL, GDK_KEY_KP_Add,	GDK_CONTROL_MASK}

#define MINUS_ICONSIZE_CALLBACK \
    {MINUS_ICONSIZE_ACTIVATE, N_("Shrink Icons"),"xffm/stock_zoom-out",\
   NULL, NULL, GDK_KEY_KP_Subtract,GDK_CONTROL_MASK}

#define DEFAULT_ICONSIZE_CALLBACK \
    {DEFAULT_ICONSIZE_ACTIVATE, N_("Default icon zoom level"),"xffm/stock_zoom-100/compositeNE/emblem_grayball",\
   NULL, NULL, GDK_KEY_0,	GDK_CONTROL_MASK}

#define DEFAULT_ICONSIZE_ALL_CALLBACK \
    {DEFAULT_ICONSIZE_ALL_ACTIVATE, "Default icon zoom level (all)","xffm/stock_zoom-100/compositeNE/emblem_greenball",\
   NULL, NULL, GDK_KEY_9,	GDK_CONTROL_MASK}

#define COMPACT_ICONSIZE_CALLBACK \
    {COMPACT_ICONSIZE_TOGGLED, N_("View as list"),NULL,\
   NULL, NULL, GDK_KEY_1,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define TINY_ICONSIZE_CALLBACK \
    {TINY_ICONSIZE_TOGGLED, N_("Small Icons"),NULL,\
   NULL, NULL, GDK_KEY_2,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define NORMAL_ICONSIZE_CALLBACK \
    {NORMAL_ICONSIZE_TOGGLED, N_("Normal Icons"),NULL,\
   NULL, NULL, GDK_KEY_3,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define BIG_ICONSIZE_CALLBACK \
    {BIG_ICONSIZE_TOGGLED, N_("Large Icons"),NULL,\
   NULL, NULL, GDK_KEY_4,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#define HUGE_ICONSIZE_CALLBACK \
    {HUGE_ICONSIZE_TOGGLED, N_("Very large"),NULL,\
   NULL, NULL, GDK_KEY_5,	GDK_CONTROL_MASK, RADIOITEM_TYPE}

#endif
