#ifndef RFM_PRIMARY_H
# define RFM_PRIMARY_H
void rodent_main_loop(void);


gchar *
rfm_default_url_mount_point(const gchar *url);

void
rfm_add_view(view_t *view_p);

void
rfm_rm_view(view_t *view_p);

GSList ** 
rfm_view_list_lock(view_t *view_p, const gchar *source);

void 
rfm_view_list_unlock(const gchar *source);

void *
rfm_context_function(void * (*function)(gpointer), void * function_data);

gboolean 
rfm_main_context_check(view_t *view_p, gboolean view_entry);

void rfm_enter_fn(void);
void rfm_leave_fn(void);

#ifdef DEBUG_TRACE
void
rfm_thread_unreference_quiet(
	view_t *view_p, 
	GThread *thread);
#endif

void
rfm_thread_unreference(
	view_t *view_p, 
	GThread *thread);

void
rfm_thread_reference(
	view_t *view_p, 
	GThread *thread, 
	const gchar *dbg_text);

GThread *
rfm_view_thread_create(
	view_t *view_p,
	gpointer(*thread_f)(gpointer), 
	gpointer data, 
	const gchar *dbg_text);

GThreadPool *
rfm_thread_queue_new(
	void (*signal_pool_f)(void *, void *),
	void *pool_data,
	gint max_threads);


gboolean
rfm_threadqueue_push(GThreadPool *thread_pool, 
	gint signal_enum, 
	view_t *view_p, 
	void *data);

gchar *
rfm_get_hash_key (const gchar * key, gint size);

population_t *
rfm_locate_path(view_t *view_p, const gchar *pathname);

gboolean
rfm_g_file_test(const gchar *path, GFileTest test);

gboolean
rfm_g_file_test_with_wait(const gchar *path, GFileTest test);

gchar *
rfm_get_paste_buffer (void );

void
rfm_clear_paste_buffer(void);

void
rfm_store_paste_buffer(gchar *buffer, gint len);

void
rfm_expose_item (view_t * view_p, const population_t * population_p);

void
rfm_expose_icon (view_t * view_p, const population_t * population_p);

void
rfm_expose_label (view_t * view_p, const population_t * population_p);

void
rfm_expose_rect (view_t * view_p, const GdkRectangle * rect_p);

void
  smc_connect (gint argc, gchar ** argv, CARD8 style_hint);

void *
rfm_get_widget (const gchar * name);

void
rfm_set_widget (void *widget, const gchar * name);

void
rfm_unlock (void);

void
rfm_lock (void);


int
  rfm_mkdir (const gchar * dir);

void
  rfm_save_to_go_history (char *p);

void
  rfm_threadwait (void);

void
  rfm_init_env (void);

void
  rfm_setenv (const char *name, char *value, gboolean verbose);

gchar *
  rfm_esc_string (const gchar * string);

const gchar *
  rfm_chop_excess (gchar * b);

gchar *
  rfm_time_to_string (time_t when);

gchar *
  rfm_mode_string (mode_t mode);

gchar *
rfm_user_string (struct stat *st);

gchar *
rfm_group_string (struct stat *st);

gchar *
rfm_date_string (time_t the_time);

gchar *
rfm_date_access_string (struct stat *st);

gchar *
rfm_date_status_string (struct stat *st);


gchar *
  rfm_utf_string (const gchar * t);

gchar *
  rfm_sizetag (off_t tama, gint count);

gchar *
  rfm_host_name (Window xid);

pthread_rwlock_t *new_rwlock(void);

gboolean 
  rfm_population_write_lock (view_t * view_p, const gchar *source);

void
  rfm_population_write_unlock (view_t * view_p, const gchar *source);

gboolean 
  rfm_population_read_lock (view_t * view_p, const gchar *source);

gboolean 
  rfm_population_try_read_lock (view_t * view_p, const gchar *source);

void
  rfm_population_read_unlock (view_t * view_p, const gchar *source);

gchar **
  rfm_pasteboard_v (view_t * view_p);
int
  rfm_pasteboard_status (view_t * view_p);

int
  rfm_in_pasteboard (view_t * view_p, record_entry_t * en);

gboolean 
  rfm_update_pasteboard (view_t * view_p);

void
  rfm_soft_reload (view_t * view_p);

    void
rfm_save_view_preferences (view_t * view_p, record_entry_t *target_en);


view_preferences_t *
rfm_get_view_preferences (gint type, record_entry_t *target_en);

void
rfm_set_view_preferences (view_t * view_p, view_preferences_t *view_preferences_p);

gboolean
rfm_write_ok_path(const gchar *path);

gboolean
rfm_read_ok_path(const gchar *target_path);

gchar *
rfm_shell(void);

gchar *
rfm_xterm_shell(void);
#endif
