#ifndef PRIMARY_ICONS_H
# define PRIMARY_ICONS_H

typedef struct preview_manager_t{
    view_t *view_p;
    gint population_serial;
    GtkWidget *diagnostics;
    GtkWidget *diagnostics_window;
} preview_manager_t;

#if 0
typedef struct fireup_thread_manager_t {
     population_t *population_p;
     gint flags;
     gchar *path;
     gint type;
     preview_manager_t preview_manager_v;
} fireup_thread_manager_t;
#endif

gchar **rfm_get_iconthemes(void);


gboolean
rfm_save_icon_id_to_cache(record_entry_t *en, const gchar *id);

gchar *
rfm_get_icon_id_from_cache(record_entry_t *en);

Pixmap
rfm_create_background_pixmap (char *file);

const gchar *
rfm_get_mask_color(const gchar *id, guchar *red, guchar *green, guchar *blue, gchar **tpath);

void
rfm_change_icontheme(void);

gboolean
rfm_is_dark_background(view_t *view_p);

#if GTK_MAJOR_VERSION==3
GdkRGBA *
rfm_get_gdk_color (view_t *view_p, int p);
#else
GdkColor *
rfm_get_gdk_color (view_t *view_p, int p);
#endif

GdkPixbuf *
rfm_create_background_pixbuf (const char *file, int width, int height);

gchar *
  rfm_get_thumbnail_path (const gchar * file, gint size);

GdkPixbuf *
  rfm_get_pixbuf (const gchar * key, int size);

gchar *
rfm_get_entry_icon_id(view_t *view_p, record_entry_t *en, gboolean magic_icon);
void 
rfm_pixbuf_save(GdkPixbuf *tgt, const gchar *path);
gboolean
rfm_insert_pixbuf_tag (GdkPixbuf *tag, GdkPixbuf *composite_pixbuf,
	const gchar *where, gdouble scale_factor, gint overall_alpha);
GdkPixbuf *
rfm_pixbuf_duplicate(GdkPixbuf *pixbuf);
//////   module wraparounds:
gint 
  rfm_svg_supported (void);

GdkPixbuf *
rfm_pixbuf_scale_simple (GdkPixbuf *in_pixbuf, gint size, gint type);
GdkPixbuf *
rfm_pixbuf_scale_stretch (GdkPixbuf *in_pixbuf,  gint width, gint height, gint type);
GdkPixbuf *
rfm_pixbuf_new_from_file (const gchar *path, gint width, gint height);

void rfm_free_lite_hash(void);

void
rfm_replace_pixbuf_hash (void);

void 
rfm_put_in_pixbuf_hash(const gchar *path, gint size, const GdkPixbuf *pixbuf);

GdkPixbuf 
*rfm_find_in_pixbuf_hash(const gchar *path, gint size);

void 
rfm_rm_from_pixbuf_hash (const gchar * key, gint size);

cairo_t   *pixbuf_cairo_create ( GdkPixbuf *pixbuf);
GdkPixbuf *pixbuf_cairo_destroy( cairo_t   *cr, GdkPixbuf *pixbuf);

#endif
