#ifndef RFM_PRIMARY_COMPAT_H
# define RFM_PRIMARY_COMPAT_H
/// gtk+-3.10 compatibility section 
void rfm_replace_menu_label(GtkWidget *parent, const gchar *text);
void rfm_replace_menu_image(GtkWidget *parent, const gchar *icon_id);
void rfm_set_menu_image(GtkWidget *parent, GtkWidget *image);
GtkWidget * rfm_menu_item_new(const gchar *icon_id, const gchar *text);
#if GTK_MAJOR_VERSION==2
#define GtkGrid GtkTable
#define gtk_grid_attach(X,Y,Z,W,V,U) gtk_table_attach(X,Y,Z,Z+V,W,W+U,GTK_FILL,GTK_FILL,0,0)
#endif
/// glib compatibility section 
#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<28
#define g_main_context_invoke(X,Y,Z) g_timeout_add(1,Y,Z)
#endif

#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<32
#define rfm_cond_init(X) X=g_cond_new()
#define rfm_cond_free(X) g_cond_free(X)
#define rfm_mutex_init(X) X=g_mutex_new()
#define rfm_mutex_free(X) g_mutex_free(X)
#define rfm_rec_mutex_init(X) g_static_rec_mutex_init(X)
#define rfm_rec_mutex_free(X) g_static_rec_mutex_free(X)
#define rfm_rec_mutex_lock(X) g_static_rec_mutex_lock(X)
#define rfm_rec_mutex_unlock(X) g_static_rec_mutex_unlock(X)
#define rfm_rec_mutex_trylock(X) g_static_rec_mutex_trylock(X)
#define RfmRecMutex GStaticRecMutex
#define rfm_thread_init(X) g_thread_init(X)
#else
#define rfm_cond_init(X) X=(GCond *)malloc(sizeof(GCond));g_cond_init(X)
#define rfm_cond_free(X) g_cond_clear(X);g_free(X)
#define rfm_mutex_init(X) X=(GMutex *)malloc(sizeof(GMutex));g_mutex_init(X)
#define rfm_mutex_free(X) g_mutex_clear(X);g_free(X)
#define rfm_rec_mutex_init(X) g_rec_mutex_init(X)
#define rfm_rec_mutex_free(X) g_rec_mutex_clear(X)
#define rfm_rec_mutex_lock(X) g_rec_mutex_lock(X)
#define rfm_rec_mutex_unlock(X) g_rec_mutex_unlock(X)
#define rfm_rec_mutex_trylock(X) g_rec_mutex_trylock(X)
#define RfmRecMutex GRecMutex
#define rfm_thread_init(X)
#endif

gint
rfm_gtk_version(void);

GThread * rfm_thread_create(const gchar *name, GThreadFunc func, gpointer data, gboolean joinable);

void rfm_rw_lock_init(RfmRWLock *rw_lock);
void rfm_rw_lock_clear(RfmRWLock *rw_lock);

void rfm_rw_lock_writer_lock (RfmRWLock *rw_lock);             
gboolean rfm_rw_lock_writer_trylock (RfmRWLock *rw_lock);             
void rfm_rw_lock_writer_unlock (RfmRWLock *rw_lock);  

void rfm_rw_lock_reader_lock (RfmRWLock *rw_lock);             
gboolean rfm_rw_lock_reader_trylock (RfmRWLock *rw_lock);             
void rfm_rw_lock_reader_unlock (RfmRWLock *rw_lock);  

gboolean rfm_cond_timed_wait(GCond *signal, GMutex *mutex, gint seconds);

/// gtk+ compatibility section 

void rfm_combo_box_text_remove_all(GtkWidget *comboentry);
GtkWidget *rfm_combo_box_new_with_entry (void);
void rfm_combo_box_text_prepend(GtkWidget *comboentry, const gchar *text);
void rfm_text_view_set_wrap_mode(GtkTextView *text_view, gint mode);

// gtk_box
GtkWidget *
rfm_hbox_new(gboolean homogeneous, gint spacing);

GtkWidget *
rfm_vbox_new(gboolean homogeneous, gint spacing);
// gtk paned
GtkWidget *
rfm_vpaned_new(void);

GtkWidget *
rfm_hpaned_new(void);
GtkWidget *
rfm_vbutton_box_new(void);

GtkWidget *
rfm_hbutton_box_new(void);

GtkWidget *
rfm_hscale_new_with_range(gdouble min, gdouble max, gdouble step);
#endif

