#ifndef _H_PSTHREAD_
#define _H_PSTHREAD_

#include <glib.h>

#include "pseudo.h"
#include "ps_task.h"

struct _ps_runq_s
{
	ps_task_t			root_task;
	GStaticRecMutex	lock;
	guint					task_count;
};

#define PS_RUNQ(x)		((ps_runq_t*)x)

#define RUNQ_LOCK(x)		(g_static_rec_mutex_lock(&x->lock))
#define RUNQ_UNLOCK(x)	(g_static_rec_mutex_unlock(&x->lock))

#endif
