/***************************************************************************
 *                                                                         *
 *    LIBDSK: General floppy and diskimage access library                  *
 *    Copyright (C) 2003  John Elliott <jce@seasip.demon.co.uk>            *
 *                                                                         *
 *    This library is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU Library General Public          *
 *    License as published by the Free Software Foundation; either         *
 *    version 2 of the License, or (at your option) any later version.     *
 *                                                                         *
 *    This library is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *    Library General Public License for more details.                     *
 *                                                                         *
 *    You should have received a copy of the GNU Library General Public    *
 *    License along with this library; if not, write to the Free           *
 *    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      *
 *    MA 02111-1307, USA                                                   *
 *                                                                         *
 ***************************************************************************/

/* This is a reconstructed header for the Win16 DLL, NETAPI.DLL. It only 
 * includes the mailslot functions that LibDsk uses. 
 *
 * The matching import library should be generated by using your compiler's
 * IMPLIB tool.
 */

#ifdef __cplusplus
extern "C" {
#endif

unsigned WINAPI DosMakeMailslot (const char far *pszName, WORD cbMessageSize, WORD cbMailslotSize, WORD far *phMailslot);
unsigned WINAPI DosDeleteMailslot(unsigned hMailslot);
unsigned WINAPI DosPeekMailslot (unsigned hMailslot, char far *pbBuffer, unsigned short far *pcbReturned, 
								 unsigned short far *pcbNextSize, unsigned short far *pusNextPriority);
unsigned WINAPI DosMailslotInfo (unsigned hMailslot, unsigned short far *pcbMessageSize, 
								 unsigned short far *pcbMailslotSize, unsigned short far *pcbNextSize, 
								 unsigned short far *pusNextPriority, unsigned short far *pcMessages);
unsigned WINAPI DosReadMailslot (unsigned hMailslot, char far *pbBuffer, unsigned short far *pcbReturned, 
								 unsigned short far *pcbNextSize, unsigned short far *pusNextPriority, long cTimeout);
unsigned WINAPI DosWriteMailslot(const char far *pszName, const char far *pbBuffer, unsigned short cbBuffer, 
								 unsigned short usPriority, unsigned short usClass, long cTimeout);
								 

#define MAILSLOT_NO_TIMEOUT	(-1L)

#define NERR_Success             0
#define ERROR_PATH_NOT_FOUND     3
#define ERROR_INVALID_PARAMETER 87
#define ERROR_BUFFER_OVERFLOW  111                                                                                          
#define ERROR_ALREADY_EXISTS   183
#define NERR_NetNotStarted    2103


#ifdef __cplusplus
}
#endif
