#ifndef XMMS_REQUANT_H
#define XMMS_REQUANT_H

extern int                 Max_Band;
extern unsigned char       Q_bit [32];          // Anzahl bits Kodierung der Aufloesung (SV6)
extern unsigned char       Q_res [32] [16];     // Index -> Aufloesung (SV6)
extern float               __SCF [6 + 128];     // tabellierte Skalenfaktoren
extern const float         __Cc  [1 +  18];     // Requantisierungs-Koeffizienten
extern const int           __Dc  [1 +  18];     // Requantisierungs-Offset

#define Cc      (__Cc  + 1)
#define Dc      (__Dc  + 1)
#define SCF     (__SCF + 6)

void  Init_QuantTab ( void );
void  ClipPrev      ( const float fac );

#endif /* XMMS_REQUANT_H */
