#include <math.h>
#include "requant.h"

int            Max_Band;
unsigned char  Q_bit  [32];       // Anzahl bits für die Kodierung der Aufloesung (SV6)
unsigned char  Q_res  [32] [16];  // Index -> Aufloesung (SV6)
float          __SCF  [6 + 128];  // tabellierte Skalenfaktoren nach Clipping Prevention


// Requantisierungs-Koeffizienten: 65536/step bzw. 65536/(2*D+1)
const float  __Cc [1 + 18] = {
      111.285962475327f,                                        // 32768/2/255*sqrt(3)
    65536.000000000000f, 21845.333333333332f, 13107.200000000001f, 9362.285714285713f,
     7281.777777777777f,  4369.066666666666f,  2114.064516129032f, 1040.253968253968f,
      516.031496062992f,   257.003921568627f,   128.250489236790f,   64.062561094819f,
       32.015632633121f,    16.003907203907f,     8.000976681723f,    4.000244155527f,
        2.000061037018f,     1.000015259021f
};

// Requantisierungs-Offset: 2*D+1 = steps of quantizer
const int  __Dc [1 + 18] = {
      2,
      0,     1,     2,     3,     4,     7,    15,    31,    63,
    127,   255,   511,  1023,  2047,  4095,  8191, 16383, 32767
};


/* F U N K T I O N E N */
static void
Calc_ScaleFactors ( double start, double mult )
{
    int  i;

    for ( i = 0; i < sizeof(__SCF)/sizeof(*__SCF); i++ ) {
        __SCF [i] = (float) start;
        start    *= mult;
    }
}

#define C1  1.20050805774840750476L
#define C2  0.83298066476582673961L
#define C3  0.501187233627272285285L
#define C4  1.122018454301963435591L


void
ClipPrev ( const float amplification )
{
    Calc_ScaleFactors ( amplification * C1/(C2*C2*C2*C2*C2*C2), C2 );
}


void
Quantisierungsmodes ( void )
{
    int n;

    for ( n = 0; n < 11; n++ ) {
        Q_bit[n]     =  4;
        Q_res[n][ 0] =  0;
        Q_res[n][ 1] =  1;
        Q_res[n][ 2] =  2;
        Q_res[n][ 3] =  3;
        Q_res[n][ 4] =  4;
        Q_res[n][ 5] =  5;
        Q_res[n][ 6] =  6;
        Q_res[n][ 7] =  7;
        Q_res[n][ 8] =  8;
        Q_res[n][ 9] =  9;
        Q_res[n][10] = 10;
        Q_res[n][11] = 11;
        Q_res[n][12] = 12;
        Q_res[n][13] = 13;
        Q_res[n][14] = 14;
        Q_res[n][15] = 17;
    }
    for ( n = 11; n < 23; n++ ) {
        Q_bit[n]     =  3;
        Q_res[n][ 0] =  0;
        Q_res[n][ 1] =  1;
        Q_res[n][ 2] =  2;
        Q_res[n][ 3] =  3;
        Q_res[n][ 4] =  4;
        Q_res[n][ 5] =  5;
        Q_res[n][ 6] =  6;
        Q_res[n][ 7] = 17;
    }
    for ( n = 23; n < 32; n++ ) {
        Q_bit[n]     =  2;
        Q_res[n][ 0] =  0;
        Q_res[n][ 1] =  1;
        Q_res[n][ 2] =  2;
        Q_res[n][ 3] = 17;
    }
}

void
Init_QuantTab ( void )
{
    Quantisierungsmodes ();
    ClipPrev (1.);
}
