#define SYNTH_DELAY     481
#define NCH             2

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "in_mpc.h"
#include "mpc_dec.h"
#include "requant.h"
#include "huffsv46.h"
#include "huffsv7.h"
#include "synth_filter.h"
#include "bitstream.h"
#include "equalizer.h"

/* V A R I A B L E S */
static int    SCF_Index [2] [32] [ 3];   // Skalenfaktor-Indices fuer Speicherung
static int    QQ        [2] [32] [36];   // quantisierte Samples
static int    Res       [2] [32];        // Aufloesungsstufen der Teilbaender
static int    MS_Flag       [32];        // subbandweiser Flag fuer M/S-Signalfuehrung

// weitere globale Flags
unsigned int  MS_used;
unsigned int  StreamVersion;
unsigned int  OverallFrames;
unsigned int  DecodedFrames;
unsigned int  RecommendedResyncPos;

extern   int  TrueGapless;


int Read_Bitstream ( int SV );


/* F U N C T I O N S */
void
RESET_Synthesis ( void )
{
    Reset_VV ();
}


void
RESET_Globals ( void )
{
    Reset_BitstreamDecode ();

    DecodedFrames = 0;
    StreamVersion = 0;
    MS_used       = 0;

    Reset_YY ();
    memset ( SCF_Index, 0, sizeof SCF_Index );
    memset ( Res      , 0, sizeof Res       );
    memset ( QQ       , 0, sizeof QQ        );
    memset ( MS_Flag  , 0, sizeof MS_Flag   );
}


extern unsigned short*  SeekTable;



static void
Requantisierung ( const int Last_Band, float Y [2] [36] [32] )
{
    int     Band;
    int     n;
    float   facL;
    float   facR;
    float   templ;
    float   tempr;
    float*  YL;
    float*  YR;
    int*    L;
    int*    R;

    // Requantisierung und Skalierung der Subband- und Subframesamples
    for ( Band = 0; Band <= Last_Band; Band++ ) {
        YL = Y  [0] [0] + Band;
        YR = Y  [1] [0] + Band;
        L  = QQ [0] [Band];
        R  = QQ [1] [Band];
        /************************** MS-coded **************************/
        if ( MS_Flag [Band] ) {
            if ( Res [0] [Band] ) {
                if ( Res [1] [Band] ) {    // M!=0, S!=0
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][0]];
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][0]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = (templ = *L++ * facL) + (tempr = *R++ * facR);
                        *YR = templ - tempr;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][1]];
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][1]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = (templ = *L++ * facL) + (tempr = *R++ * facR);
                        *YR = templ - tempr;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][2]];
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][2]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = (templ = *L++ * facL) + (tempr = *R++ * facR);
                        *YR = templ - tempr;
                    }
                }
                else {    // M!=0, S==0
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][0]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YR = *YL = *L++ * facL;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][1]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YR = *YL = *L++ * facL;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][2]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YR = *YL = *L++ * facL;
                    }
                }
            }
            else {
                if ( Res [1] [Band] ) {  // M==0, S!=0
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][0]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YR = -(*YL = *R++ * facR);
                    }
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][1]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YR = -(*YL = *R++ * facR);
                    }
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][2]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YR = -(*YL = *R++ * facR);
                    }
                }
                else {    // M==0, S==0
                    for ( n = 0; n < 36; n++, YL += 32, YR += 32 ) {
                        *YL = *YR = 0.f;
                    }
                }
            }
        }
        /************************** LR-coded **************************/
        else {
            if ( Res [0] [Band] ) {
                if ( Res [1] [Band] ) {    // L!=0, R!=0
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][0]];
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][0]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = *L++ * facL;
                        *YR = *R++ * facR;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][1]];
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][1]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = *L++ * facL;
                        *YR = *R++ * facR;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][2]];
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][2]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = *L++ * facL;
                        *YR = *R++ * facR;
                    }
                }
                else {     // L!=0, R==0
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][0]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = *L++ * facL;
                        *YR = 0.f;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][1]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = *L++ * facL;
                        *YR = 0.f;
                    }
                    facL = Cc[Res [0][Band]] * SCF[SCF_Index [0][Band][2]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = *L++ * facL;
                        *YR = 0.f;
                    }
                }
            }
            else {
                if ( Res [1] [Band] ) {    // L==0, R!=0
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][0]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = 0.f;
                        *YR = *R++ * facR;
                    }
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][1]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = 0.f;
                        *YR = *R++ * facR;
                    }
                    facR = Cc[Res [1][Band]] * SCF[SCF_Index [1][Band][2]];
                    for ( n = 0; n < 12; n++, YL += 32, YR += 32 ) {
                        *YL = 0.f;
                        *YR = *R++ * facR;
                    }
                }
                else {    // L==0, R==0
                    for ( n = 0; n < 36; n++, YL += 32, YR += 32 ) {
                        *YL = *YR = 0.f;
                    }
                }
            }
        }
    }
}


int
DECODE ( char*  buffer,
         int*   FrameWasValid,
         float  V [2] [V_MEM + 960],
         float  Y [2] [36] [32] )
{
    static float  SAVE [2] [3*36] [32];
    int           tmp;
    int           last_samples;
    unsigned int  EQ    = is_EQ_Activated ();
    unsigned int  frame = DecodedFrames;

    *FrameWasValid = 1;

    if ( frame >= OverallFrames )
        return -1;                      // EOF: return -1

    // decode data and check for validity of frame
    tmp = Read_Bitstream (StreamVersion);
    SeekTable [DecodedFrames++] = (unsigned short)tmp == tmp  ?  tmp  :  0;
    *FrameWasValid &= tmp >= 0;

    // synthesize signal
    Requantisierung     ( Max_Band, Y );
    Do_Perform_Equalizer( Y, SAVE, Max_Band, 2 );
    Synthese_Filter_opt ( (short*)buffer + 0*2*1152 + 0, V[0], Y[0], NCH );
    Synthese_Filter_opt ( (short*)buffer + 0*2*1152 + 1, V[1], Y[1], NCH );

    // cut off first SYNTH_DELAY zero-samples
    if ( frame <  EQ )                                                          // frame 0 + EQ on
        return 0;

    if ( frame == EQ ) {                                                        // frame 0 + EQ off  OR  frame 1 + EQ on
        memmove ( buffer, buffer + 2*2*SYNTH_DELAY, 2*2*(1152-SYNTH_DELAY) );
        return 1152 - SYNTH_DELAY;
    }

    if ( frame == OverallFrames-1  &&  StreamVersion >= 7 ) {                   // last frame, only exactly handled with SV 7

        last_samples = Bitstream_read (11);
        if ( last_samples == 0 )
            last_samples = 1152;        // encoder bugfix
        last_samples += SYNTH_DELAY;

        if ( TrueGapless  &&  last_samples > 1152 ) {
            tmp = Read_Bitstream (StreamVersion);
            SeekTable [DecodedFrames++] = (unsigned short)tmp == tmp  ?  tmp  :  0;
            *FrameWasValid &= tmp >= 0;
        }
        else {
             Reset_YY ();                // better ???
        }

        Requantisierung     ( Max_Band, Y );
        Do_Perform_Equalizer( Y, SAVE, Max_Band, 2 );
        Synthese_Filter_opt ( (short*)buffer + 1*2*1152 + 0, V[0], Y[0], NCH );
        Synthese_Filter_opt ( (short*)buffer + 1*2*1152 + 1, V[1], Y[1], NCH );

        if ( EQ ) {
            Reset_YY ();                // better ???
            Requantisierung     ( Max_Band, Y );
            Do_Perform_Equalizer( Y, SAVE, Max_Band, 2 );
            Synthese_Filter_opt ( (short*)buffer + 2*2*1152 + 0, V[0], Y[0], NCH );
            Synthese_Filter_opt ( (short*)buffer + 2*2*1152 + 1, V[1], Y[1], NCH );
            last_samples += 1152;
        }

        return last_samples;
    }

    return 1152;
}



/****************************************** SV 6 ******************************************/
static void
Lese_Bitstrom_SV6 ( void )
{
    char               SCFI [2] [32];
    const HuffmanTyp*  x1;
    const HuffmanTyp*  x2;
    int*               p;
    int                Max_used_Band = 0;
    int                n;
    int                k;

    /************************ HEADER **************************/
    for ( n = 0; n <= Max_Band; n++ ) {
        Res [0] [n] = Q_res [n] [Huffman_Decode (Region [n])];
        if ( MS_used )
            MS_Flag[n] = Bitstream_read1 ();
        Res [1] [n] = Q_res [n] [Huffman_Decode (Region [n])];

        if ( Res [0] [n] != 0  ||  Res [1] [n] != 0 )
            Max_used_Band = n;
    }

    /************************* SCFI-Bundle *****************************/
    for ( n = 0; n <= Max_used_Band; n++ ) {
        if ( Res [0] [n] > 0 ) SCFI [0] [n] = Huffman_Decode_fast ( SCFI_Bundle );
        if ( Res [1] [n] > 0 ) SCFI [1] [n] = Huffman_Decode_fast ( SCFI_Bundle );
    }

    /***************************** SCFI ********************************/
    for ( n = 0; n <= Max_used_Band; n++ ) {

        if ( Res [0] [n] != 0 ) {
            p = SCF_Index [0] [n];
            switch ( SCFI [0] [n] ) {
            case 7:
                p[0] =
                p[1] =
                p[2] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 3:
                p[0] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                p[1] =
                p[2] = p[0] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 5:
                p[0] =
                p[1] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                p[2] = p[1] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 1:
                p[0] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                p[1] = p[0] + Huffman_Decode_fast (DSCF_Entropie);
                p[2] = p[1] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 6:
                p[0] =
                p[1] =
                p[2] = Bitstream_read (6);
                break;
            case 2:
                p[0] = Bitstream_read (6);
                p[1] =
                p[2] = Bitstream_read (6);
                break;
            case 4:
                p[0] =
                p[1] = Bitstream_read (6);
                p[2] = Bitstream_read (6);
                break;
            default:
                p[0] = Bitstream_read (6);
                p[1] = Bitstream_read (6);
                p[2] = Bitstream_read (6);
                break;
            }
        }

        if ( Res [1] [n] != 0 ) {
            p = SCF_Index [1] [n];
            switch ( SCFI [1] [n] ) {
            case 7:
                p[0] =
                p[1] =
                p[2] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 3:
                p[0] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                p[1] =
                p[2] = p[0] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 5:
                p[0] =
                p[1] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                p[2] = p[1] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 1:
                p[0] = p[2] + Huffman_Decode_fast (DSCF_Entropie);
                p[1] = p[0] + Huffman_Decode_fast (DSCF_Entropie);
                p[2] = p[1] + Huffman_Decode_fast (DSCF_Entropie);
                break;
            case 6:
                p[0] =
                p[1] =
                p[2] = Bitstream_read (6);
                break;
            case 2:
                p[0] = Bitstream_read (6);
                p[1] =
                p[2] = Bitstream_read (6);
                break;
            case 4:
                p[0] =
                p[1] = Bitstream_read (6);
                p[2] = Bitstream_read (6);
                break;
            default:
                p[0] = Bitstream_read (6);
                p[1] = Bitstream_read (6);
                p[2] = Bitstream_read (6);
                break;
            }
        }
    }

    /**************************** Samples ****************************/
    for ( n = 0; n <= Max_used_Band; n++ ) {
        int*  L = QQ [0] [n];
        int*  R = QQ [1] [n];
        x1 = SampleHuff [ Res [0][n] ];
        x2 = SampleHuff [ Res [1][n] ];

        if ( x1 != NULL  ||  x2 != NULL )
            for ( k = 0; k < 36; k++ ) {
                if ( x1 != NULL ) *L++ = Huffman_Decode_fast (x1);
                if ( x2 != NULL ) *R++ = Huffman_Decode_fast (x2);
            }

        if ( Res [0] [n] > 7  ||  Res [1] [n] > 7 )
            for ( k = 0; k < 36; k++ ) {
                if ( Res[0][n] > 7 ) *L++ = (int) Bitstream_read ( Res[0][n] - 1 ) - Dc[Res[0][n]];
                if ( Res[1][n] > 7 ) *R++ = (int) Bitstream_read ( Res[1][n] - 1 ) - Dc[Res[1][n]];
            }
    }
}



static const unsigned char    Parity [256] = {  // parity
    0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,
    1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,
    1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,
    0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,
    1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,
    0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,
    0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,
    1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0
};

static unsigned int  __r1 = 1;
static unsigned int  __r2 = 1;


unsigned int
random_int ( void )
{
#if 1
    unsigned int  t1, t2, t3, t4;

    t3   = t1 = __r1;   t4   = t2 = __r2;       // Parity calculation is done via table lookup, this is also available
    t1  &= 0xF5;        t2 >>= 25;              // on CPUs without parity, can be implemented in C and avoid unpredictable
    t1   = Parity [t1]; t2  &= 0x63;            // jumps and slow rotate through the carry flag operations.
    t1 <<= 31;          t2   = Parity [t2];

    return (__r1 = (t3 >> 1) | t1 ) ^ (__r2 = (t4 + t4) | t2 );
#else
    return (__r1 = (__r1 >> 1) | ((unsigned int)Parity [__r1 & 0xF5] << 31) ) ^
           (__r2 = (__r2 << 1) |  (unsigned int)Parity [(__r2 >> 25) & 0x63] );
#endif
}


/****************************************** SV 7 ******************************************/
static void
Lese_Bitstrom_SV7 ( void )
{
    static int         idx30 [] = { -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1 };
    static int         idx31 [] = { -1,-1,-1, 0, 0, 0, 1, 1, 1,-1,-1,-1, 0, 0, 0, 1, 1, 1,-1,-1,-1, 0, 0, 0, 1, 1, 1 };
    static int         idx32 [] = { -1,-1,-1,-1,-1,-1,-1,-1,-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
    static int         idx50 [] = { -2,-1, 0, 1, 2,-2,-1, 0, 1, 2,-2,-1, 0, 1, 2,-2,-1, 0, 1, 2,-2,-1, 0, 1, 2 };
    static int         idx51 [] = { -2,-2,-2,-2,-2,-1,-1,-1,-1,-1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2 };

    char               SCFI [2] [32];
    const HuffmanTyp*  Table;
    int                Max_used_Band = 0;
    unsigned int       tmp;
    int                idx;
    int*               p;
    int                n;
    int                k;

    /***************************** Header *****************************/
    Res [0] [0] = Bitstream_read (4);
    Res [1] [0] = Bitstream_read (4);
    if ( Res [0][0]  ||  Res [1][0] )
        if ( MS_used )
            MS_Flag[0] = Bitstream_read1 ();

    for ( n = 1; n <= Max_Band; n++ ) {
        idx       = Huffman_Decode_fast (HuffHdr);
        Res [0] [n] = idx != 4  ?  Res [0][n-1] + idx  :  Bitstream_read (4);

        idx       = Huffman_Decode_fast (HuffHdr);
        Res [1] [n] = idx != 4  ?  Res [1][n-1] + idx  :  Bitstream_read (4);

        if ( Res [0][n]  ||  Res [1][n] ) {
            Max_used_Band = n;
            if ( MS_used )
                MS_Flag[n] = Bitstream_read1 ();
        }
    }

    /****************************** SCFI ******************************/
    for ( n = 0; n <= Max_used_Band; n++ ) {
        if ( Res [0][n] != 0 ) SCFI [0] [n] = Huffman_Decode_faster (HuffSCFI);
        if ( Res [1][n] != 0 ) SCFI [1] [n] = Huffman_Decode_faster (HuffSCFI);
    }

    /**************************** SCF/DSCF ****************************/
    for ( n = 0; n <= Max_used_Band; n++ ) {
        if ( Res [0][n] != 0 ) {
            p = SCF_Index [0] [n];
            switch ( SCFI [0] [n] ) {
            case 1:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[1] =
                p[2] = idx != 8  ?  p[0] + idx  :  Bitstream_read (6);
                break;
            case 3:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] =
                p[1] =
                p[2] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                break;
            case 2:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] =
                p[1] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[2] = idx != 8  ?  p[1] + idx  :  Bitstream_read (6);
                break;
            default:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[1] = idx != 8  ?  p[0] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[2] = idx != 8  ?  p[1] + idx  :  Bitstream_read (6);
                break;
            }
        }

        if ( Res [1][n] != 0 ) {
            p = SCF_Index [1] [n];
            switch ( SCFI [1] [n] ) {
            case 1:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[1] =
                p[2] = idx != 8  ?  p[0] + idx  :  Bitstream_read (6);
                break;
            case 3:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] =
                p[1] =
                p[2] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                break;
            case 2:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] =
                p[1] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[2] = idx != 8  ?  p[1] + idx  :  Bitstream_read (6);
                break;
            default:
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[0] = idx != 8  ?  p[2] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[1] = idx != 8  ?  p[0] + idx  :  Bitstream_read (6);
                idx  = Huffman_Decode_fast (HuffDSCF);
                p[2] = idx != 8  ?  p[1] + idx  :  Bitstream_read (6);
                break;
            }
        }
    }

    /***************************** Samples ****************************/

    for ( n = 0; n <= Max_used_Band; n++ ) {
        p = QQ [0] [n];

        switch  ( idx = Res[0][n] ) {
            case -1:
                for ( k = 0; k < 36; k++ ) {
                    tmp  = random_int ();
                    *p++ = ((tmp >> 24) & 0xFF) + ((tmp >> 16) & 0xFF) + ((tmp >>  8) & 0xFF) + ((tmp >>  0) & 0xFF) - 510;
                }
                break;
            case 0:
                break;
            case 1:
                Table = HuffQ [Bitstream_read1()] [1];
                for ( k = 0; k < 36/3; k++ ) {
                    idx  = Huffman_Decode_fast (Table);
                    *p++ = idx30 [idx];
                    *p++ = idx31 [idx];
                    *p++ = idx32 [idx];
                }
                break;
            case 2:
                Table = HuffQ [Bitstream_read1()] [2];
                for ( k = 0; k < 36/2; k++ ) {
                    idx  = Huffman_Decode_fast (Table);
                    *p++ = idx50 [idx];
                    *p++ = idx51 [idx];
                }
                break;
            case 3:
            case 4:
                Table = HuffQ [Bitstream_read1()] [idx];
                for ( k = 0; k < 36; k++ )
                    *p++ = Huffman_Decode_faster (Table);
                break;
            case 5:
                Table = HuffQ [Bitstream_read1()] [idx];
                for ( k = 0; k < 36; k++ )
                    *p++ = Huffman_Decode_fast (Table);
                break;
            case 6:
            case 7:
                Table = HuffQ [Bitstream_read1()] [idx];
                for ( k = 0; k < 36; k++ )
                    *p++ = Huffman_Decode (Table);
                break;
            case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 15: case 16: case 17:
                for ( k = 0; k < 36; k++ )
                    *p++ = (int) Bitstream_read (idx-1) - Dc [idx];
                break;
            default:
                return;
        }

        p = QQ [1] [n];
        switch ( idx = Res[1][n] ) {
            case -2:
                for ( k = 0; k < 36; k++ ) {
                    *p = p [-1152];
		    p++;
                }
                break;
            case -1:
                for ( k = 0; k < 36; k++ ) {
                    tmp  = random_int ();
                    *p++ = ((tmp >> 24) & 0xFF) + ((tmp >> 16) & 0xFF) + ((tmp >>  8) & 0xFF) + ((tmp >>  0) & 0xFF) - 510;
                }
                break;
            case 0:
                break;
            case 1:
                Table = HuffQ [Bitstream_read1()] [1];
                for ( k = 0; k < 36/3; k++ ) {
                    idx  = Huffman_Decode_fast (Table);
                    *p++ = idx30 [idx];
                    *p++ = idx31 [idx];
                    *p++ = idx32 [idx];
                }
                break;
            case 2:
                Table = HuffQ [Bitstream_read1()] [2];
                for ( k = 0; k < 36/2; k++ ) {
                    idx  = Huffman_Decode_fast (Table);
                    *p++ = idx50 [idx];
                    *p++ = idx51 [idx];
                }
                break;
            case 3:
            case 4:
                Table = HuffQ [Bitstream_read1()] [idx];
                for ( k = 0; k < 36; k++ )
                    *p++ = Huffman_Decode_faster (Table);
                break;
            case 5:
                Table = HuffQ [Bitstream_read1()] [idx];
                for ( k = 0; k < 36; k++ )
                    *p++ = Huffman_Decode_fast (Table);
                break;
            case 6:
            case 7:
                Table = HuffQ [Bitstream_read1()] [idx];
                for ( k = 0; k < 36; k++ )
                    *p++ = Huffman_Decode (Table);
                break;
            case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 15: case 16: case 17:
                for ( k = 0; k < 36; k++ )
                    *p++ = (int) Bitstream_read (idx-1) - Dc [idx];
                break;
            default:
                return;
        }
    }
}


int
Read_Bitstream ( int SV )
{
    long           EncodedBlockLength;          // in bits
    unsigned long  CurrentDecoderPosition;      // in bits

    CurrentDecoderPosition = BitsRead ();
    RecommendedResyncPos   = ( Zaehler << 5 ) + pos;

    if ( SV & 0x08 )
        EncodedBlockLength = 16 + Bitstream_read (16) * 8;
    else
        EncodedBlockLength = 20 + Bitstream_read (20);

    RecommendedResyncPos  += EncodedBlockLength;  // ActDecodePos + FwdJmpInfo: New decoder pos after minor Sync errors with intact framing but defect frames

    switch ( SV ) {
    case 0x04:
    case 0x05:
    case 0x06:
        Lese_Bitstrom_SV6 ();
        break;
    case 0x07:
    case 0x17:
    case 0x27:
        Lese_Bitstrom_SV7 ();
        break;
    case 0x08:
        // Lese_Bitstrom_SV8 ();
        break;
    }

    // printf ( "%5lu / %5lu\n", BitsRead () - CurrentDecoderPosition, EncodedBlockLength );

    return  BitsRead () - CurrentDecoderPosition == (unsigned long)EncodedBlockLength  ?
            +EncodedBlockLength  :
            -EncodedBlockLength ;
}


int
Read_Bitstream_Jumper ( int SV )
{
    if ( SV & 0x08 )
        return 16 + Bitstream_read (16) * 8;
    else
        return 20 + Bitstream_read (20);
}

/* end of mpc_dec.c */
