#ifndef XMMS_BITSTREAM_H
#define XMMS_BITSTREAM_H

typedef struct Huffmancode {
    unsigned int  Code;
    unsigned int  Length;
    int           Value;
} HuffmanTyp;

#define MEMSIZE    8192                     // Buffer size in 32 bit units of both butterfly buffers together, must be power of 2
#define MEMSIZE2   (MEMSIZE/2)              // Buffer size in 32 bit units of one butterfly buffers
#define MEMMASK    (MEMSIZE-1)              // Mask for wrap around at the end of the buffer

extern unsigned int  Speicher [MEMSIZE];    // enthaelt den Lese-Puffer
extern unsigned int  dword;                 // 32Bit-Wort fuer Bitstrom-I/O
extern unsigned int  pos;                   // Position im aktuell decodierten 32Bit-Wort
extern unsigned int  Zaehler;               // aktuelle Position im Lese-Puffer

void          Reset_BitstreamDecode ( void );
unsigned int  BitsRead              ( void );
unsigned int  Bitstream_read        ( const unsigned int );
unsigned int  Bitstream_read1       ( void );
int           Huffman_Decode        ( const HuffmanTyp* );   // works with maximum lengths up to 14
int           Huffman_Decode_fast   ( const HuffmanTyp* );   // works with maximum lengths up to 10
int           Huffman_Decode_faster ( const HuffmanTyp* );   // works with maximum lengths up to  5
size_t        ReadLE32 ( FILE* fp, unsigned int* buff, size_t words );
void          Resort_HuffTables     ( const unsigned int elements, HuffmanTyp* Table, const int offset );

#endif /* XMMS_BITSTREAM_H */
