-- Zelda Mystery of Solarus DX:
-- Spanish dialogs

-- ****** Please respect the limit of each line! ******
-- 23 chars for normal lines,
-- 20 chars for dialogs with an icon or lines that are answers to a question,
-- 17 chars for lines with both an icon and an answer.
-- Each dialog ends with a comment with dashes indicating the maximum line size.
-- Please don't exceed the maximum size of lines,
-- and don't break lines too early either.
-- Don't try to reproduce the exact same lines: it's normal for dialogs to be
-- shorter or longer than in the language you are translating from.
-- It's also normal for lines to end on different words.

-- ****** Typo warning! ******
-- Remember that ponctuation characters like ! ? : ; are preceeded by a space
-- character in French and NOT in English.

-- ****** More documentation ******
-- If you have a doubt, please refer to the doc:
-- http://www.solarus-games.org/doc/latest/dialog_syntax.html
-- or just ask on IRC (see below).
--
-- ****** Team work *******
-- Please join our IRC channel to organize the work with us:
-- irc.zelda-solarus.com #solarus
-- Before translating any dialog, please tell us on IRC to avoid
-- conflicts.

-- Thanks for your contribution!


-- --------------------
-- 1. Item descriptions
-- --------------------
--
-- The following dialogs are seen when the player
-- shows information about an item in the inventory menu.
--------------------

-- Feather
dialog{
  id = "_item_description.feather.1",
  icon = 0,
  skip = "all",
  text = [[
Usa la Pluma para
saltar los
obstáculos.
]]
}
--------------------

-- Bombs
dialog{
  id = "_item_description.bombs_counter.1",
  icon = 1,
  skip = "all",
  text = [[
Usa las Bombas
contra los enemigos
y para destruir
obstáculos.
]]
}
--------------------

-- Bow
dialog{
  id = "_item_description.bow.1",
  icon = 2,
  skip = "all",
  text = [[
¡No te queda ninguna
Flecha!
]]
}
--------------------

-- Bow & Arrows
dialog{
  id = "_item_description.bow.2",
  icon = 3,
  skip = "all",
  text = [[
Dispara Flechas para
derrotar enemigos
a distancia.
]]
}
--------------------

-- Boomerang
dialog{
  id = "_item_description.boomerang.1",
  icon = 4,
  skip = "all",
  text = [[
Usa el Bumerán para
inmovilizar a los 
enemigos y recoger
objetos lejanos.
]]
}
--------------------

-- Super Boomerang
dialog{
  id = "_item_description.boomerang.2",
  icon = 35,
  skip = "all",
  text = [[
Usa el Súper
Bumerán para
inmovilizar a los 
enemigos y recoger
objetos lejanos.
]]
}
--------------------

-- Lamp
dialog{
  id = "_item_description.lamp.1",
  icon = 5,
  skip = "all",
  text = [[
Ilumina los lugares 
oscuros y enciende
las antorchas con
ella, ¡Vigila el
consumo de Magia!
]]
}
--------------------

-- Hookshot
dialog{
  id = "_item_description.hookshot.1",
  icon = 6,
  skip = "all",
  text = [[
Elévate hasta
lugares inaccesibles
con ayuda de la
Zarpa.
]]
}
--------------------

-- Empty bottle
dialog{
  id = "_item_description.bottle_1.1",
  icon = 7,
  skip = "all",
  text = [[
Botella Mágica que
puede contener
varias sustancias.
]]
}
--------------------

-- Water in Bottle
dialog{
  id = "_item_description.bottle_1.2",
  icon = 8,
  skip = "all",
  text = [[
Tu Botella Mágica
está llena de agua.

Úsala en un lugar
adecuado...
]]
}
--------------------

-- Red potion
dialog{
  id = "_item_description.bottle_1.3",
  icon = 9,
  skip = "all",
  text = [[
Bebe la Poción Roja
para recuperar tu
vida.
]]
}
--------------------

-- Green potion
dialog{
  id = "_item_description.bottle_1.4",
  icon = 10,
  skip = "all",
  text = [[
Bebe la Poción Verde
para recuperar tu
magia.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_item_description.bottle_1.5",
  icon = 11,
  skip = "all",
  text = [[
Bebe la Poción Azul
para recuperar tu
vida y magia.
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_item_description.bottle_1.6",
  icon = 12,
  skip = "all",
  text = [[
Esta Hada te ayudará
cuando lo necesites.
¡También la puedes
usar cuando quieras
para recuperar tus
corazones!
]]
}
--------------------

-- Empty bottle
dialog{
  id = "_item_description.bottle_2.1",
  icon = 7,
  skip = "all",
  text = [[
Botella Mágica que
puede contener
varias sustancias.
]]
}
--------------------

-- Water in Bottle
dialog{
  id = "_item_description.bottle_2.2",
  icon = 8,
  skip = "all",
  text = [[
Tu Botella Mágica
está llena de agua.

Úsala en un lugar
adecuado...
]]
}
--------------------

-- Red potion
dialog{
  id = "_item_description.bottle_2.3",
  icon = 9,
  skip = "all",
  text = [[
Bebe la Poción Roja
para recuperar tu
vida.
]]
}
--------------------

-- Green potion
dialog{
  id = "_item_description.bottle_2.4",
  icon = 10,
  skip = "all",
  text = [[
Bebe la Poción Verde
para recuperar tu
magia.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_item_description.bottle_2.5",
  icon = 11,
  skip = "all",
  text = [[
Bebe la Poción Azul
para recuperar tu
vida y magia.
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_item_description.bottle_2.6",
  icon = 12,
  skip = "all",
  text = [[
Esta Hada te ayudará
cuando lo necesites.
¡También la puedes
usar cuando quieras
para recuperar tus
corazones!
]]
}
--------------------

-- Empty bottle
dialog{
  id = "_item_description.bottle_3.1",
  icon = 7,
  skip = "all",
  text = [[
Botella Mágica que
puede contener
varias sustancias.
]]
}
--------------------

-- Water in Bottle
dialog{
  id = "_item_description.bottle_3.2",
  icon = 8,
  skip = "all",
  text = [[
Tu Botella Mágica
está llena de agua.

Úsala en un lugar
adecuado...
]]
}
--------------------

-- Red potion
dialog{
  id = "_item_description.bottle_3.3",
  icon = 9,
  skip = "all",
  text = [[
Bebe la Poción Roja
para recuperar tu
vida.
]]
}
--------------------

-- Green potion
dialog{
  id = "_item_description.bottle_3.4",
  icon = 10,
  skip = "all",
  text = [[
Bebe la Poción Verde
para recuperar tu
magia.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_item_description.bottle_3.5",
  icon = 11,
  skip = "all",
  text = [[
Bebe la Poción Azul
para recuperar tu
vida y magia.
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_item_description.bottle_3.6",
  icon = 12,
  skip = "all",
  text = [[
Esta Hada te ayudará
cuando lo necesites.
¡También la puedes
usar cuando quieras
para recuperar tus
corazones!
]]
}
--------------------

-- Empty bottle
dialog{
  id = "_item_description.bottle_4.1",
  icon = 7,
  skip = "all",
  text = [[
Botella Mágica que
puede contener
varias sustancias.
]]
}
--------------------

-- Water in Bottle
dialog{
  id = "_item_description.bottle_4.2",
  icon = 8,
  skip = "all",
  text = [[
Tu Botella Mágica
está llena de agua.

Úsala en un lugar
adecuado...
]]
}
--------------------

-- Red potion
dialog{
  id = "_item_description.bottle_4.3",
  icon = 9,
  skip = "all",
  text = [[
Bebe la Poción Roja
para recuperar tu
vida.
]]
}
--------------------

-- Green potion
dialog{
  id = "_item_description.bottle_4.4",
  icon = 10,
  skip = "all",
  text = [[
Bebe la Poción Verde
para recuperar tu
magia.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_item_description.bottle_4.5",
  icon = 11,
  skip = "all",
  text = [[
Bebe la Poción Azul
para recuperar tu
vida y magia.
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_item_description.bottle_4.6",
  icon = 12,
  skip = "all",
  text = [[
Esta Hada te ayudará
cuando lo necesites.
¡También la puedes
usar cuando quieras
para recuperar tus
corazones!
]]
}
--------------------

-- Pegasus Shoes
dialog{
  id = "_item_description.pegasus_shoes.1",
  icon = 13,
  skip = "all",
  text = [[
Corre tan rápido
como el rayo usando
las Botas de Pegaso.
Mantén pulsada la
tecla Acción para
correr.
]]
}
--------------------

-- Mystic Mirror
dialog{
  id = "_item_description.mystic_mirror.1",
  icon = 14,
  skip = "all",
  text = [[
El Espejo Místico
tiene extraños
poderes...
]]
}
--------------------

-- Cane of Somaria
dialog{
  id = "_item_description.cane_of_somaria.1",
  icon = 15,
  skip = "all",
  next = "_warning_magic",
  text = [[
Crea un bloque y
engánchate a el
usando la Zarpa.
]]
}
--------------------

-- Apples
dialog{
  id = "_item_description.apples_counter.1",
  icon = 16,
  skip = "all",
  text = [[
Come Manzanas para
recuperar Corazones.
]]
}
--------------------

-- PPains au Chocolat
dialog{
  id = "_item_description.pains_au_chocolat_counter.1",
  icon = 17,
  skip = "all",
  text = [[
Come un Pan de
Chocolate para
recuperar tres
Corazones.
]]
}
--------------------

-- Croissants
dialog{
  id = "_item_description.croissants_counter.1",
  icon = 18,
  skip = "all",
  text = [[
Come un Cruasán para
recuperar siete
Corazones.
]]
}
--------------------

-- Rock Key
dialog{
  id = "_item_description.rock_key.1",
  icon = 19,
  skip = "all",
  text = [[
¡La Llave del Roc!
¿Pero dónde está la
cerradura correcta?
]]
}
--------------------

-- Bone Key
dialog{
  id = "_item_description.bone_key.1",
  icon = 20,
  skip = "all",
  text = [[
¿Para que se podrá
utilizar la Llave de
Hueso?
]]
}
--------------------

-- Earth Key
dialog{
  id = "_item_description.clay_key.1",
  icon = 21,
  skip = "all",
  text = [[
La Llave de la
Tierra. Permite
acceso a la caverna
de la aldea.
]]
}
--------------------

-- Apple Pie
dialog{
  id = "_item_description.level_4_way.1",
  icon = 22,
  skip = "all",
  text = [[
Este Pastel de
Manzana se ve
extraño...
]]
}
--------------------

-- Gold bars
dialog{
  id = "_item_description.level_4_way.2",
  icon = 23,
  skip = "all",
  text = [[
¡Tres Barras de Oro
auténticas!
]]
}
--------------------

-- Edelweiss
dialog{
  id = "_item_description.level_4_way.3",
  icon = 24,
  skip = "all",
  text = [[
La Edelweiss es una
flor muy rara en el
Reino de Hyrule.
]]
}
--------------------

-- Tiger scrolls
dialog{
  id = "_item_description.level_4_way.4",
  icon = 25,
  skip = "all",
  text = [[
Estos Pergaminos del
Tigre te permitirán
dominar técnicas
avanzadas con la
espada.
]]
}
--------------------

-- Flippers
dialog{
  id = "_item_description.flippers.1",
  icon = 26,
  skip = "all",
  text = [[
Nada en aguas
profundas con estas
aletas.
]]
}
--------------------

-- Magic Cape
dialog{
  id = "_item_description.magic_cape.1",
  icon = 27,
  skip = "all",
  text = [[
La Capa Mágica te
avisa cuando estás
cerca de una pared
débil.
]]
}
--------------------

-- Iron Key
dialog{
  id = "_item_description.iron_key.1",
  icon = 28,
  skip = "all",
  text = [[
La Llave de Hierro.
¡Asegúrate de usarla
en la cerradura
correcta!
]]
}
--------------------

-- Stone Key
dialog{
  id = "_item_description.stone_key.1",
  icon = 29,
  skip = "all",
  text = [[
¡La Llave de Piedra!
¡Encontremos la
cerradura correcta!
]]
}
--------------------

-- Wooden Key
dialog{
  id = "_item_description.wooden_key.1",
  icon = 30,
  skip = "all",
  text = [[
La Llave de Madera.
¡Sólo hay una
cerradura para esta
llave!
]]
}
--------------------

-- Ice Key
dialog{
  id = "_item_description.ice_key.1",
  icon = 31,
  skip = "all",
  text = [[
La Llave de Hielo.
¡Debes encontrar un
lugar congelado para
que funcione!
]]
}
--------------------

-- Iron Gloves
dialog{
  id = "_item_description.glove.1",
  icon = 32,
  skip = "all",
  text = [[
Estos Guantes de
Hierro te permiten
levantar rocas.
]]
}
--------------------

-- Golden Gloves
dialog{
  id = "_item_description.glove.2",
  icon = 33,
  skip = "all",
  text = [[
Levanta rocas negras
con estos Guantes de
Oro.
]]
}
--------------------

-- Fire Stones
dialog{
  id = "_item_description.fire_stones_counter.1",
  icon = 34,
  skip = "all",
  text = [[
Encuentra las tres
Piedras de Fuego y 
llévaselas a
Inferno.
]]
}
--------------------

-- --------------------
-- 2. Finding treasures
-- --------------------
--
-- The following dialogs are below are shown when the player
-- obtains a treasure, usually by opening a chest or by buying it from a
-- merchant in a shop.
--------------------

-- Feather
dialog{
  id = "_treasure.feather.1",
  icon = 0,
  skip = "all",
  text = [[
¡Encontraste la
Pluma!$0

¡Úsala para saltar
en un lugar y sobre
obstáculos!
]]
}
--------------------

-- Bow alone
dialog{
  id = "_treasure.bow.1",
  icon = 2,
  text = [[
¡Encontraste el
Arco!$0

¡Encuenta algunas
Flechas y podrás
vencer enemigos
difíciles a
distancia!
]]
}
--------------------

-- Bow & Arrows
dialog{
  id = "_treasure.bow.2",
  icon = 3,
  text = [[
¡Encontraste el 
Arco!$0

¡Puedes enfrentar
enemigos difíciles
a distancia!
]]
}
--------------------

-- Boomerang
dialog{
  id = "_treasure.boomerang.1",
  icon = 4,
  text = [[
¡Encontraste el
Bumerán!$0 

Puedes inmovilizar
enemigos y recoger
objetos lejanos.
Hay varias formas de
usarlo, ¡depende de
ti descubrirlas
todas!
]]
}
--------------------

-- Super Boomerang
dialog{
  id = "_treasure.boomerang.2",
  icon = 35,
  text = [[
¡Encontraste el 
Súper Bumerán!$0

¡Es mas rápido y
poderoso que el
original!
]]
}
--------------------

-- Lamp
dialog{
  id = "_treasure.lamp.1",
  icon = 5,
  next = "_warning_magic",
  text = [[
¡Encontraste la
Lámpara!$0

¡Úsala para iluminar
lugares oscuros y
encender antorchas!
]]
}
--------------------

-- Hookshot
dialog{
  id = "_treasure.hookshot.1",
  icon = 6,
  text = [[
¡Encontraste la
Zarpa!$0

¡Inmoviliza a tus
enemigos y alcanza
sitios inaccesibles!
]]
}
--------------------

-- Empty Bottle
dialog{
  id = "_treasure.bottle_1.1",
  icon = 7,
  text = [[
¡Encontraste una
Botella Mágica!$0

Llénala con diversas
sustancias.
]]
}
--------------------

-- Water
dialog{
  id = "_treasure.bottle_1.2",
  icon = 8,
  text = [[
¡Llenaste tu Botella
Mágica con agua!
]]
}
--------------------

-- Red potion
dialog{
  id = "_treasure.bottle_1.3",
  icon = 9,
  text = [[
¡Encontraste un poco
de Poción Roja!$0

Bébela para
recuperar tu salud.
]]
}
--------------------

-- Green potion
dialog{
  id = "_treasure.bottle_1.4",
  icon = 10,
  text = [[
¡Encontraste un poco
de Poción Verde!$0

Bébela para
recuperar tu energía
mágica.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_treasure.bottle_1.5",
  icon = 11,
  text = [[
¡Encontraste un poco
de Poción Azul!$0

¡Bébela para
restaurar por
completo tu salud y
energía mágica!
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_treasure.bottle_1.6",
  icon = 12,
  skip = "all",
  text = [[
¡Capturaste un Hada!
Te ayudará cuando lo
necesites. ¡También
puedes usarla cuando
quieras para
recuperar corazones!
]]
}
--------------------

-- Empty Bottle
dialog{
  id = "_treasure.bottle_2.1",
  icon = 7,
  text = [[
¡Encontraste una
Botella Mágica!$0

Llénala con diversas
sustancias.
]]
}
--------------------

-- Water
dialog{
  id = "_treasure.bottle_2.2",
  icon = 8,
  text = [[
¡Llenaste tu Botella
Mágica con agua!
]]
}
--------------------

-- Red potion
dialog{
  id = "_treasure.bottle_2.3",
  icon = 9,
  text = [[
¡Encontraste un poco
de Poción Roja!$0

Bébela para
recuperar tu salud.
]]
}
--------------------

-- Green potion
dialog{
  id = "_treasure.bottle_2.4",
  icon = 10,
  text = [[
¡Encontraste un poco
de Poción Verde!$0

Bébela para
recuperar tu energía
mágica.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_treasure.bottle_2.5",
  icon = 11,
  text = [[
¡Encontraste un poco
de Poción Azul!$0

¡Bébela para
restaurar por
completo tu salud y
energía mágica!
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_treasure.bottle_2.6",
  icon = 12,
  skip = "all",
  text = [[
¡Capturaste un Hada!
Te ayudará cuando lo
necesites. ¡También
puedes usarla cuando
quieras para
recuperar corazones!
]]
}
--------------------

-- Empty Bottle
dialog{
  id = "_treasure.bottle_3.1",
  icon = 7,
  text = [[
¡Encontraste una
Botella Mágica!$0

Llénala con diversas
sustancias.
]]
}
--------------------

-- Water
dialog{
  id = "_treasure.bottle_3.2",
  icon = 8,
  text = [[
¡Llenaste tu Botella
Mágica con agua!
]]
}
--------------------

-- Red potion
dialog{
  id = "_treasure.bottle_3.3",
  icon = 9,
  text = [[
¡Encontraste un poco
de Poción Roja!$0

Bébela para
recuperar tu salud.
]]
}
--------------------

-- Green potion
dialog{
  id = "_treasure.bottle_3.4",
  icon = 10,
  text = [[
¡Encontraste un poco
de Poción Verde!$0

Bébela para
recuperar tu energía
mágica.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_treasure.bottle_3.5",
  icon = 11,
  text = [[
¡Encontraste un poco
de Poción Azul!$0

¡Bébela para
restaurar por
completo tu salud y
energía mágica!
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_treasure.bottle_3.6",
  icon = 12,
  skip = "all",
  text = [[
¡Capturaste un Hada!
Te ayudará cuando lo
necesites. ¡También
puedes usarla cuando
quieras para
recuperar corazones!
]]
}
--------------------

-- Empty Bottle
dialog{
  id = "_treasure.bottle_4.1",
  icon = 7,
  text = [[
¡Encontraste una
Botella Mágica!$0

Llénala con diversas
sustancias.
]]
}
--------------------

-- Water
dialog{
  id = "_treasure.bottle_4.2",
  icon = 8,
  text = [[
¡Llenaste tu Botella
Mágica con agua!
]]
}
--------------------

-- Red potion
dialog{
  id = "_treasure.bottle_4.3",
  icon = 9,
  text = [[
¡Encontraste un poco
de Poción Roja!$0

Bébela para
recuperar tu salud.
]]
}
--------------------

-- Green potion
dialog{
  id = "_treasure.bottle_4.4",
  icon = 10,
  text = [[
¡Encontraste un poco
de Poción Verde!$0

Bébela para
recuperar tu energía
mágica.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_treasure.bottle_4.5",
  icon = 11,
  text = [[
¡Encontraste un poco
de Poción Azul!$0

¡Bébela para
restaurar por
completo tu salud y
energía mágica!
]]
}
--------------------

-- Fairy in Bottle
dialog{
  id = "_treasure.bottle_4.6",
  icon = 12,
  skip = "all",
  text = [[
¡Capturaste un Hada!
Te ayudará cuando lo
necesites. ¡También
puedes usarla cuando
quieras para
recuperar corazones!
]]
}
--------------------

-- Pegasus Boots
dialog{
  id = "_treasure.pegasus_shoes.1",
  icon = 13,
  text = [[
¡Encontraste las
Botas de Pegaso!$0

¡Corre y carga a
través de los
enemigos mas
difíciles!  Pulsa y
mantén pulsada la
tecla Acción para
usarlas.
]]
}
--------------------

-- Mystic Mirror
dialog{
  id = "_treasure.mystic_mirror.1",
  icon = 14,
  text = [[
¡Encontraste el
Espejo Místico!$0

Sus extraños poderes
de seguro te serán
útiles en tu
aventura.
]]
}
--------------------

-- Cane of Somaria
dialog{
  id = "_treasure.cane_of_somaria.1",
  icon = 15,
  next = "_warning_magic",
  text = [[
¡Encontraste la Vara
de Somaria!$0

Puedes crear un
bloque y sujetarte a
el con la Zarpa.
]]
}
--------------------

-- 3 Apples
dialog{
  id = "_treasure.apple.1",
  icon = 16,
  text = [[
¡Encontraste 3
Manzanas!$0

¡Cómetelas mas tarde
para recuperar
corazones!
]]
}
--------------------

-- 1 Pain au Chocolat
dialog{
  id = "_treasure.pain_au_chocolat.1",
  icon = 17,
  text = [[
¡Encontraste un Pan
de Chocolate!$0

Come un Pan de
Chocolate para
recuperar un poco de
vida.
]]
}
--------------------

-- 1 Croissant
dialog{
  id = "_treasure.croissant.1",
  icon = 18,
  text = [[
¡Encontraste un 
Cruasán!$0 

¡Es crujiente! Come
un Cruasán para
recuperar corazones.
]]
}
--------------------

-- Rock Key
dialog{
  id = "_treasure.rock_key.1",
  icon = 19,
  text = [[
¡Encontraste la
Llave del Roc!$0
]]
}
--------------------

-- Bone Key
dialog{
  id = "_treasure.bone_key.1",
  icon = 20,
  text = [[
¡Encontraste la
Llave de Hueso!$0

¿Pero para qué
podría ser usada?
]]
}
--------------------

-- Earth Key
dialog{
  id = "_treasure.clay_key.1",
  icon = 21,
  text = [[
¡Encontraste la
Llave de la Tierra!$0

¡Ahora puedes
acceder a la caverna
de la aldea!
]]
}
--------------------

-- Apple Pie
dialog{
  id = "_treasure.level_4_way.1",
  icon = 22,
  text = [[
¡Encontraste un
Pastel de Manzana!$0
$1...$3 Hmmm, Yo no lo
probaría si fuera
tú, se ve extraño...
]]
}
--------------------

-- Gold Bars
dialog{
  id = "_treasure.level_4_way.2",
  icon = 23,
  text = [[
¡¡¡Encontraste unas
Barras de Oro!!!$0

¡Brillan y son muy
valiosas!
]]
}
--------------------

-- Edelweiss
dialog{
  id = "_treasure.level_4_way.3",
  icon = 24,
  text = [[
¡Encontraste una
Edelweiss!$0

¡Esta bonita flor de
las montañas de
Hyrule es
extremadamente rara!
]]
}
--------------------

-- Tiger Scrolls
dialog{
  id = "_treasure.level_4_way.4",
  icon = 25,
  text = [[
¡Encontraste los
Pergaminos del 
Tigre!$0
¡Ahora dominas el
hace mucho tiempo
olvidado Ataque
Torbellino!
]]
}
--------------------

-- Flippers
dialog{
  id = "_treasure.flippers.1",
  icon = 26,
  text = [[
¡Encontraste las
Aletas!$0

¡Ahora puedes nadar
en aguas profundas!
]]
}
--------------------

-- Magic Cape
dialog{
  id = "_treasure.magic_cape.1",
  icon = 27,
  text = [[
¡Encontraste la Capa
Mágica!$0

Te avisará cuando
estés cerca a una
pared débil.
]]
}
--------------------

-- Iron Key
dialog{
  id = "_treasure.iron_key.1",
  icon = 28,
  text = [[
¡Encontraste la
Llave de Hierro!$0

¡Seguramente debe
abrir alguna puerta!
]]
}
--------------------

-- Stone Key
dialog{
  id = "_treasure.stone_key.1",
  icon = 29,
  text = [[
¡Encontraste la
Llave de Piedra!$0

¿Pero dónde está la
cerradura que abre?
]]
}
--------------------

-- Wooden Key
dialog{
  id = "_treasure.wooden_key.1",
  icon = 30,
  text = [[
¡Encontraste la
Llave de Madera!$0

¡Debes encontrar
donde usarla!
]]
}
--------------------

-- Ice Key
dialog{
  id = "_treasure.ice_key.1",
  icon = 31,
  text = [[
¡Encontraste la
Llave de Hielo!$0

Debe abrir el camino
a un lugar
congelado...
]]
}
--------------------

-- Iron Gloves
dialog{
  id = "_treasure.glove.1",
  icon = 32,
  text = [[
¡Encontraste los
Guantes de Hierro!$0

Con ellos puedes
levantar rocas.
]]
}
--------------------

-- Golden Gloves
dialog{
  id = "_treasure.glove.2",
  icon = 33,
  text = [[
¡Encontraste los
Guantes de Oro!$0

¡Ahora puedes
levantar rocas
negras!
]]
}
--------------------

-- Fire Stone
dialog{
  id = "_treasure.fire_stone.1",
  icon = 34,
  text = [[
¡Encontraste una
Piedra de Fuego!
]]
}
--------------------

-- World Map
dialog{
  id = "_treasure.world_map.1",
  icon = 50,
  text = [[
¡Encontraste el Mapa
del Mundo!$0

Míralo en la
pantalla del Mapa.
]]
}
--------------------

-- Big Wallet
dialog{
  id = "_treasure.rupee_bag.2",
  icon = 52,
  text = [[
¡Encontraste la
Bolsa Grande!$0

¡Puede contener
hasta 300 Rupias!
]]
}
--------------------

-- Giant Wallet
dialog{
  id = "_treasure.rupee_bag.3",
  icon = 53,
  text = [[
¡Encontraste la
Bolsa Gigante!$0

¡Puede contener
hasta 999 Rupias!
]]
}
--------------------

-- Small Bomb Bag
dialog{
  id = "_treasure.bomb_bag.1",
  icon = 54,
  text = [[
¡Encontraste el Saco
de Bombas!$0 Contiene
10 Bombas.
¡Asígnalas a una
tecla y Bombas
fuera!
]]
}
--------------------

-- Large Bomb Bag
dialog{
  id = "_treasure.bomb_bag.2",
  icon = 55,
  text = [[
¡Encontraste el Saco
de Bombas Grande!$0

¡Puede contener
hasta 30 Bombas en
vez de 10!
]]
}
--------------------

-- Giant Bomb Bag
dialog{
  id = "_treasure.bomb_bag.3",
  icon = 56,
  text = [[
¡Encontraste el saco
de Bombas Gigante!$0

¡Puede contener
hasta 99 Bombas en
vez de 30!
]]
}
--------------------

-- Large Quiver
dialog{
  id = "_treasure.quiver.2",
  icon = 58,
  text = [[
¡Encontraste el
Carcaj Grande!$0

¡Puede contener
hasta 30 Flechas en
vez de 10!
]]
}
--------------------

-- Giant Quiver
dialog{
  id = "_treasure.quiver.3",
  icon = 59,
  text = [[
¡Encontraste el
Carcaj Gigante!$0

¡Puede contener
hasta 99 Flechas en
vez de 30!
]]
}
--------------------

-- Blue Mail
dialog{
  id = "_treasure.tunic.2",
  icon = 61,
  text = [[
¡Encontraste la
Túnica Azul!$0

Reduce el daño
recibido de los
enemigos y resiste
temperaturas bajo
cero...
]]
}
--------------------

-- Red Mail
dialog{
  id = "_treasure.tunic.3",
  icon = 62,
  text = [[
¡Encontraste la
Túnica Roja!$0

¡Provee incluso
mejor protección que
la Túnica Azul!
]]
}
--------------------

-- Shield
dialog{
  id = "_treasure.shield.1",
  icon = 63,
  text = [[
¡Encontraste el
Escudo!$0

¡Te puedes defender
de ataques enemigos!
]]
}
--------------------

-- Fire Shield
dialog{
  id = "_treasure.shield.2",
  icon = 64,
  text = [[
¡Encontraste el
Escudo de Fuego!$0

¡Ahora estás
protegido de ataques
de fuego!
]]
}
--------------------

-- Mirror Shield
dialog{
  id = "_treasure.shield.3",
  icon = 65,
  text = [[
¡Encontraste el
Escudo Espejo!$0

¡Ahora puedes
reflejar los rayos!
]]
}
--------------------

-- First Sword
dialog{
  id = "_treasure.sword.1",
  icon = 66,
  text = [[
¡Encontraste la
Espada del Coraje!$0

¡Puedes cruzar
espadas y enfrentar
a tus enemigos!
]]
}
--------------------

-- Hylian Blade
dialog{
  id = "_treasure.sword.2",
  icon = 67,
  next = "_treasure.sword.2.1",
  text = [[
$1¡Encontraste la
Espada Hyliana!$0$0$0
¡Esta nueva espada
]]
}
--------------------

dialog{
  id = "_treasure.sword.2.1",
  text = [[
es el doble de
poderosa que la
anterior!
]]
}
-----------------------

-- Hero's Sword
dialog{
  id = "_treasure.sword.3",
  icon = 68,
  next = "_treasure.sword.2.1",
  text = [[
$1¡Encontraste la
Espada del Héroe!$0$0$0
¡Esta nueva espada
]]
}
--------------------

-- Master Sword
dialog{
  id = "_treasure.sword.4",
  icon = 69,
  text = [[
¡Encontraste la
Espada Maestra!$0

El poder de esta
espada final esta
mas allá de todo...
]]
}
--------------------

-- Half Magic Meter
dialog{
  id = "_treasure.magic_bar.2",
  icon = 99,
  text = [[
¡Encontraste el
Medio Medidor de
Magia!$0
¡Tu Medidor de Magia
se ha duplicado!
]]
}
--------------------

-- Map
dialog{
  id = "_treasure.map.1",
  icon = 70,
  text = [[
¡Encontraste el
Mapa! Úsalo para ver
el plano de la
mazmorra.
]]
}
--------------------

-- Compass
dialog{
  id = "_treasure.compass.1",
  icon = 71,
  text = [[
¡Encontraste la
Brújula! ¡Ya puedes
ver tu posición en
el Mapa, la
ubicación de los
cofres y la guarida
del Jefe! ¡Ahora si
estamos llegando a
alguna parte!
]]
}
--------------------

-- Small key
dialog{
  id = "_treasure.small_key.1",
  icon = 72,
  text = [[
¡Encontraste una
Llave Pequeña!

Esta llave abrirá
una puerta cerrada
en esta mazmorra.
]]
}
--------------------

-- Large Key
dialog{
  id = "_treasure.big_key.1",
  icon = 73,
  text = [[
¡Encontraste la
Llave Grande!

¡Ahora puedes abrir
puertas especiales y
encontrar nuevos
tesoros!
]]
}
--------------------

-- Boss Key
dialog{
  id = "_treasure.boss_key.1",
  icon = 74,
  text = [[
¡Encontraste la
Llave del Jefe!

¡Ahora puedes entrar
a la guarida del
Jefe!
]]
}
--------------------

-- Piece of Heart
dialog{
  id = "_treasure.piece_of_heart.1",
  icon = 79,
  text = [[
¡Encontraste una
Pieza de Corazón!
]]
}
--------------------

-- Heart Container
dialog{
  id = "_treasure.heart_container.1",
  icon = 80,
  text = [[
¡Encontraste un
Contenedor de
Corazón!

¡Tu medidor de
corazones se ha
incrementado por
uno!
]]
}
--------------------

-- 1 Bomb
dialog{
  id = "_treasure.bomb.1",
  icon = 82,
  next = "_treasure.bomb.1.1",
  text = [[
¡Encontraste una
Bomba!$0
]]
}
--------------------

dialog{
  id = "_treasure.bomb.1.1",
  text = [[
Usa una Bomba para
hacer explotar a un
enemigo u obstáculo.
]]
}
--------------------

-- 3 Bombs
dialog{
  id = "_treasure.bomb.2",
  icon = 82,
  next = "_treasure.bomb.1.1",
  text = [[
¡Encontraste tres
Bombas!$0
]]
}
--------------------

-- 8 Bombs
dialog{
  id = "_treasure.bomb.3",
  icon = 82,
  next = "_treasure.bomb.1.1",
  text = [[
¡Encontraste ocho
Bombas!$0
]]
}
--------------------

-- 1 Arrow
dialog{
  id = "_treasure.arrow.1",
  icon = 83,
  next = "_treasure.arrow.1.1",
  text = [[
¡Encontraste una
Flecha!$0 Usa el Arco
y Flechas para
]]
}
--------------------

dialog{
  id = "_treasure.arrow.1.1",
  text = [[
vencer enemigos
difíciles a
distancia.
]]
}
--------------------

-- 5 Arrows
dialog{
  id = "_treasure.arrow.2",
  icon = 83,
  next = "_treasure.arrow.1.1",
  text = [[
¡Encontraste cinco
Flechas!$0 Usa el Arco
y Flechas para
]]
}
--------------------

-- 10 Arrows
dialog{
  id = "_treasure.arrow.3",
  icon = 83,
  next = "_treasure.arrow.1.1",
  text = [[
¡Encontraste diez
Flechas!$0 Usa el Arco
y Flechas para
]]
}
--------------------

-- 1 Heart
dialog{
  id = "_treasure.heart.1",
  icon = 84,
  text = [[
¡Encontraste un
Corazón!
]]
}
--------------------

-- Small Magic Jar
dialog{
  id = "_treasure.magic_flask.1",
  icon = 85,
  text = [[
¡Encontraste una
Jarra Mágica
Pequeña!
Tu Medidor Mágico se
ha llenado un poco.
]]
}
--------------------

-- Large Magic Jar
dialog{
  id = "_treasure.magic_flask.2",
  icon = 86,
  text = [[
¡Encontraste una
Jarra Mágica Grande!
Tu Medidor Mágico se
ha llenado bastante.
]]
}
--------------------

-- 1 green rupee
dialog{
  id = "_treasure.rupee.1",
  icon = 90,
  text = [[
¡Encontraste una
Rupia Verde!
¡Es una Rupia!
]]
}
--------------------

-- 1 blue rupee
dialog{
  id = "_treasure.rupee.2",
  icon = 91,
  text = [[
¡Encontraste una
Rupia Azul!
¡Son 5 Rupias!
]]
}
--------------------

-- 1 red rupee
dialog{
  id = "_treasure.rupee.3",
  icon = 92,
  text = [[
¡Encontraste una
Rupia Roja!
¡Son 20 Rupias!
]]
}
--------------------

-- 50 rupees
-- Note: reference to Link's Awakening
dialog{
  id = "_treasure.rupee.4",
  icon = 90,
  text = [[
¡Encontraste 50
Rupias! ¡Estupendo!
]]
}
--------------------

-- 100 rupees
-- Note: reference to Link's Awakening
dialog{
  id = "_treasure.rupee.5",
  icon = 90,
  text = [[
¡Encontraste 100
Rupias! ¡Fantástico!
]]
}
--------------------

-- 300 rupees
-- Note: reference to Link's Awakening
dialog{
  id = "_treasure.rupee.6",
  icon = 90,
  text = [[
¡Encontraste 300
Rupias! ¡Qué 
maravilloso!
]]
}
--------------------

-- Red potion
dialog{
  id = "_treasure.red_potion.1",
  icon = 96,
  text = [[
¡Encontraste un poco
de Poción Roja!$0

Bébela para
recuperar por
completo tu energía
vital.
]]
}
--------------------

-- Green potion
dialog{
  id = "_treasure.green_potion.1",
  icon = 97,
  text = [[
¡Encontraste un poco
de Poción Verde!$0

Bébela para
recuperar por
completo tu energía
mágica.
]]
}
--------------------

-- Blue potion
dialog{
  id = "_treasure.blue_potion.1",
  icon = 98,
  text = [[
¡Encontraste un poco
de Poción Azul!$0

Bébela para
recuperar por
completo tu energía
vital y mágica.
]]
}
--------------------

-- -------------------------------
-- 3. Miscellaneous engine dialogs
-- -------------------------------
--
-- The following dialogs are various dialogs shown by the engine.

-- End of a dialog of obtaining a treasure
-- that consumes magic (same message as ALTTP).
dialog{
  id = "_warning_magic",
  text = [[
¡Vigila tu Medidor
Mágico!
]]
}
--------------------

-- Opening an empty chest.
dialog{
  id = "_empty_chest",
  text = [[
¡El cofre esta
vacío! ¡Qué mal!
]]
}
-----------------------

-- Looking at a locked door without small key.
dialog{
  id = "_small_key_required",
  icon = 72,
  skip = "all",
  text = [[
¡Está cerrada!
]]
}
--------------------

-- Looking at a large chest or a large key door without the large key.
dialog{
  id = "_big_key_required",
  icon = 73,
  skip = "all",
  text = [[
¿Eh? ¡Está cerrado!
¡Si tuvieras la
Llave Grande podrías
abrirlo! 
]]
}
--------------------

-- Looking at the boss door without the boss key.
dialog{
  id = "_boss_key_required",
  icon = 74,
  skip = "all",
  text = [[
¡Esta puerta conduce
a la guarida del
Jefe! Necesitarás la
Llave del Jefe para
abrirla.
]]
}
--------------------

-- Trying to lift a bush instead of using the sword.
dialog{
  id = "_cannot_lift_should_cut",
  skip = "all",
  text = [[
Necesitas algo afilado
para abrirte paso a
través de éstos
arbustos.
]]
}
-----------------------

-- Trying to lift a stone without the Iron Gloves
-- (reference to Link's Awakening).
dialog{
  id = "_cannot_lift_too_heavy",
  skip = "all",
  text = [[
¡Rayos, esto es muy
pesado!

¡Nunca lo lograrás con
tus manos desnudas!
]]
}
-----------------------

-- Trying to lift a black stone without the Golden Gloves
-- but with the Iron Gloves.
dialog{
  id = "_cannot_lift_still_too_heavy",
  skip = "all",
  text = [[
¡Aún es demasiado
pesado para ti!
]]
}
-----------------------

-- After watching a shop item.
dialog{
  id = "_shop.question",
  question = true,
  text = [[
Precio: $v Rupias.
Comprar
No Comprar
]]
}
-----------------------

-- Trying to buy a shop item, but not enough rupees.
dialog{
  id = "_shop.not_enough_money",
  skip = "all",
  text = [[
¡Lo siento, no tienes
suficientes Rupias!
]]
}
-----------------------

-- Trying to buy a shop item, but this item is already at its maximum amount
-- (for items like bombs, arrows, etc.).
dialog{
  id = "_shop.amount_full",
  text = [[
¡No puedes llevar más!
]]
}
-----------------------

-- Watching a crystal.
dialog{
  id = "_crystal",
  skip = "all",
  text = [[
Es un cristal 
interruptor. Trata de
golpearlo con algo...
]]
}
-----------------------

-- Entering dungeon 1.
dialog{
  id = "dungeon_1",
  skip = "current",
  text = [[
         Nivel 1
  Mazmorra del Bosque
]]
}
-----------------------

-- Entering dungeon 2.
dialog{
  id = "dungeon_2",
  skip = "current",
  text = [[
         Nivel 2
    Caverna del Roc
]]
}
-----------------------

-- Entering dungeon 3.
dialog{
  id = "dungeon_3",
  skip = "current",
  text = [[
         Nivel 3
  Guarida del Maestro
            Arbror
]]
}
-----------------------

dialog{
  id = "found_piece_of_heart.first",
  icon = 75,
  text = [[
Recoge cuatro Piezas
para obtener un
nuevo Corazón.
]]
}
--------------------

dialog{
  id = "found_piece_of_heart.second",
  icon = 76,
  text = [[
Dos más y tendrás
otro Corazón.
]]
}
--------------------

dialog{
  id = "found_piece_of_heart.third",
  icon = 77,
  text = [[
¡Encuentra una más y
tendrás otro
Corazón!
]]
}
--------------------

dialog{
  id = "found_piece_of_heart.fourth",
  icon = 78,
  text = [[
Encontraste cuatro
Piezas de Corazón.
¡Obtienes un Corazón
extra!
]]
}
--------------------

-- Finding a Fairy while having at least a Bottle
-- (same dialog as ALTTP).
dialog{
  id = "found_fairy",
  icon = 81,
  skip = "current",
  next = "found_fairy.1",
  text = [[
¡Encontraste un
Hada!
¡Es maravillosa!
]]
}
--------------------

-- |--------------------___|
dialog{
  id = "found_fairy.1",
  icon = -1,
  question = true,
  text = [[
¿Qué quieres hacer?
Recuperar tu salud
Conservarla
]]
}
--------------------

-- Trying to keep a Fairy, but no empty Bottle.
dialog{
  id = "found_fairy.no_empty_bottle",
  skip = "current",
  text = [[
¡No tienes una Botella
vacía!
]]
}
-----------------------

-- Finding water while having an empty Bottle.
dialog{
  id = "found_water",
  icon = 8,
  question = true,
  text = [[
¿Quieres poner algo
de agua en tu

Botella Mágica?
Sí
No
]]
}
--------------------

-- Finding water while having no empty Bottle.
dialog{
  id = "found_water.no_bottle",
  skip = "all",
  text = [[
Aquí hay algo de agua
pero no tienes forma de
almacenarla...
]]
}
-----------------------

-- Finding water while having at least one Bottle, but no empty one.
dialog{
  id = "found_water.no_empty_bottle",
  icon = 8,
  skip = "all",
  text = [[
Aquí hay algo de
agua, pero necesitas
una Botella Mágica
vacía para
almacenarla...
]]
}
--------------------

-- Using a bottle with water.
dialog{
  id = "use_bottle_with_water",
  icon = 8,
  question = true,
  text = [[
Tu Botella Mágica
está llena de agua.

¿Qué deseas hacer?
Verter el agua
Conservarla
]]
}
--------------------

-- Using an apple.
dialog{
  id = "use_apples",
  icon = 16,
  question = true,
  text = [[
Comer una manzana
recupera un corazón.

¿Qué deseas hacer?
Comer una manzana
Nada
]]
}
--------------------

-- Using a chocolate bread.
dialog{
  id = "use_pains_au_chocolat",
  icon = 17,
  question = true,
  text = [[
Un pan de Chocolate
recupera tres
corazones.
¿Qué deseas hacer?
Comer uno
Nada
]]
}
--------------------

-- Using a Croissant.
dialog{
  id = "use_croissants",
  icon = 18,
  question = true,
  text = [[
Un Cruasán recupera
siete corazones.

¿Qué deseas hacer?
Comer uno
Nada
]]
}
--------------------

dialog{
  id = "torch.need_lamp",
  skip = "all",
  text = [[
Debe haber una forma de
encender esta
antorcha...
]]
}
-----------------------

-- ----------------
-- 4. Quest dialogs
-- ----------------
--
-- The remaining dialogs are all dialogs of the quest itself:
-- NPCs, hints, cutscenes, etc.


-- Intro: black screen
dialog{
  id = "intro0",
  skip = "current",
  text = [[
$2Cuenta la leyenda que
hace mucho tiempo
existía un prospero
reino llamado Hyrule
surgido de la bendición
de tres diosas.
Su poder en la tierra
se representó con la
Trifuerza.
Tras el intento por
parte del rey de los
ladrones, Ganondorf,
de conseguir su poder,
siete sabios rompieron
en 7 fragmentos ese
poder, ocultándolos en
la Tierra Dorada y
desterrando a Ganon
para siempre.
Y los siglos pasaron..
]]
}
-----------------------
-- Intro : fresco 1
dialog{
  id = "intro1",
  skip = "current",
  text = [[
$2Siglos más tarde, una
extraña oscuridad se
cernió sobre Hyrule, y
con ella apareció
un misterioso 
hechicero, Agahnim.
Este hechicero disipó
la misteriosa oscuridad
y consiguió el favor
del pueblo y también
del mismo Rey, que lo
nombró consejero real.
Pero el plan de Agahnim
pasaba por traicionar a
la familia real y traer
de vuelta a Ganondorf,
olvidado ya en el
tiempo.
]]
}
-----------------------

-- Intro : fresco 2
dialog{
  id = "intro2",
  skip = "current",
  text = [[
$2Dicen que
surgió un joven
vestido de verde
nacido de una
familia de antiguos
protectores de la
familia real. Se
enfrentó a numerosos
peligros, atravesando
valles, montañas y 
explorando templos
perdidos.
]]
}
-----------------------

-- Intro : fresco 3
dialog{
  id = "intro3",
  skip = "current",
  text = [[
$2Con el tiempo fue 
conocido como el Héroe
que venció al mal.
Gracias a su valentía,
rescató a las 7 
descendientes de los
sabios, incluyendo a 
la princesa Zelda y...
]]
}
-----------------------

-- Intro : fresco 4
dialog{
  id = "intro4",
  skip = "current",
  text = [[
$2...reunió el poder que
necesitaba para
derrotar a Ganondorf en
la pirámide que habÌa
construido para dominar
Hyrule, desterrándolo
de nuevo con el poder
del sello mágico.
]]
}
-----------------------

-- Intro : fresco 5
dialog{
  id = "intro5",
  skip = "current",
  text = [[
$2Años después, el rey de
Hyrule, que ayudó en el
destierro de Ganondorf,
cayó enfermo y ni los
médicos de todo el
reino lograron curarlo.
Se perdió al rey y con
él, parte del poder que
tenía el sello, 
debilitándose una vez
más.
]]
}
-----------------------

-- Intro : fresco 6
dialog{
  id = "intro6",
  skip = "current",
  text = [[
$2El Héroe, bajo el sabio
consejo de su maestro
Sahasrahla, confió en
la heredera de los 
poderes reales, la 
princesa Zelda, que
junto a ocho jóvenes
misteriosos, hicieron
de la Trifuerza ocho
fragmentos para poder
ocultarlos por todo el
reino y restaurar la
paz.
Y aquí comienza nuestro
viaje...
]]
}
-----------------------

-- Village sign.
dialog{
  id = "outside_world.village.welcome_sign",
  text = [[
       Bienvenido
       a Lyriann
]]
}
-----------------------

-- Dialog with the monkey at the beginning.
-- "_unknown" means that we know there will be a next dialog but we don't know which one yet.
-- This makes the engine show an arrow in the bottom part of the dialog box instead of a square.
dialog{
  id = "outside_world.village.monkey",
  next = "_unknown",
  text = [[
¡Ayuda! ¡Esta noche
la gente ha pasado
mucho miedo!
¡El pueblo ha sido
rodeado por
monstruos!
]]
}
-----------------------

-- Next part of the monkey dialog, not having the shield.
dialog{
  id = "outside_world.village.monkey.without_shield",
  text = [[
No deber dejarte
pasar, no dejar
que nadie ande
por ahí sin protección.
]]
}
-----------------------

-- Next part of the monkey dialog, having the shield.
dialog{
  id = "outside_world.village.monkey.with_shield",
  text = [[
No deberia dejarte
pasar, pero bueno, 
al menos tienes un 
Escudo contigo...
¡Ten cuidado!
]]
}
-----------------------

dialog{
  id = "outside_world.village.grand_son_npc",
  skip = "current",
  text = [[
Si no sabes qué
hacer en algún
momento de tu viaje
deberías ir a ver a la
Abuela Lyly, le
gusta dar consejo
y guiar a los
aventureros.
Ella vive cerca de
la Casa de las Rupias
Pero yo no sé
mucho más, ¡solo
soy un niño!
]]
}
-----------------------

dialog{
  id = "outside_world.village.chignon_woman",
  skip = "all",
  text = [[
Cuando el icono azul
aparece, esto te indica qué
puedes hacer pulsando
la tecla de acción (espacio).
Dependiendo de lo que estés
examinando, te indicará
diferentes acciones tales
como mirar,
hablar, leer un cartel,
levantar una vasija...
¡Échale un ojo al icono
para saber cuándo puedes
interactuar con el
entorno!
]]
}
-----------------------

dialog{
  id = "outside_world.village.chignon_woman_dungeons",
  skip = "all",
  text = [[
Dicen que en cada
mazmorra se escondé una Pieza
de Corazón
Divertido, ¿no crees?
]]
}
-----------------------

dialog{
  id = "outside_world.village.cliff_man_npc",
  skip = "all",
  text = [[
¿Sabías que
puedes saltar
ciertos acantilados?
Esto te podría permitir
alcanzar ciertos
lugares.
]]
}
-----------------------

dialog{
  id = "outside_world.village.hat_man_npc",
  skip = "all",
  text = [[
Si vas en búsqueda de
Rupias, no te recomiendo
ir a la casa de las
Rupias, ¡podrías
acabar necesitando
todavía más Rupias!
Aunque tú pareces
más listo que yo.

¡Tal vez tú lo hagas
mejor que yo!
]]
}
-----------------------

dialog{
  id = "outside_world.village.hat_man_npc_waterfall",
  skip = "all",
  text = [[ 
Se supone que hay
un tesoro oculto
detrás de la cascada
del castillo antiguo.
¿Crees que será
verdad?
]]
}
-----------------------

dialog{
  id = "outside_world.village.rupee_house_sign",
  text = [[
   - Rupees' House -
¡Gana unas cuantas rupias
mientras te diviertes!
]]
}
-----------------------

-- Sign near the village waterfall.
-- Reference to Majora's Mask in the southern swamp
-- where there is the same kind of signs.
dialog{
  id = "outside_world.village.waterfall_sign",
  text = [[
Por favor, siéntete libre
de coger nuestra agua de
manantial.
        Lyriann
    Centro turístico
]]
}
-----------------------

dialog{
  id = "outside_world.village.cake_shop_sign",
  text = [[

         Panadería
]]
}
-----------------------

dialog{
  id = "outside_world.village.shop_sign",
  text = [[

          Tienda
]]
}
-----------------------

-- Watching a mail box.
dialog{
  id = "outside_world.village.letter_box",
  skip = "all",
  text = [[
¡No mires dentro
de lo que no es tuyo!
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman",
  skip = "all",
  next = "outside_world.village.tree_woman.long_text",
  text = [[
¿Perdido con la pantalla?
Deja que te explique.
Los iconos de arriba a la
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman.long_text",
  question = true,
  next = "outside_world.village.tree_woman.thank_you",
  next2 = "outside_world.village.tree_woman.again",
  text = [[
izquierda están alineados
como las teclas de un
teclado. La tecla C es
el icono verde, usas
la espada pulsándola.
¡Pero cuando el juego
está en pausa, el icono
cambia y significa que
la tecla C se usa para
guardar la partida!
Y cuando estás hablando
con alguien, te permite
finalizar la conversación.
Tan solo mantén la vista
en el icono verde para
saber qué hace la tecla C.
Los otros iconos son
las teclas que rodean a la
tecla C: el icono naranja
(tecla D) pausa el juego,
el icono azul (barra
espaciadora) es la tecla
Acción, y los dos iconos
grises son los objetos
asignados a las teclas
X y V. Así que vigila
siempre lo que dicen los
iconos. ¡No olvides que
puedes redefinir los
controles en la pantalla
de opciones, y que puedes
incluso jugar con un
gamepad!
¿Lo has entendido todo?
Sí
No, no lo hice
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman.again",
  next = "outside_world.village.tree_woman.long_text",
  text = [[
Bien, deja que te lo explique
otra vez, pero escucha
con atención esta vez.
Los iconos de arriba a la
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman.thank_you",
  text = [[
¡Gracias por escuchar
la explicación completa!
¡Me siento realmente
agradecida!
Te mereces un
pequeño obsequio.
]]
}
-----------------------

-- Trying to open the village cave without the Earth Key.
dialog{
  id = "outside_world.village.clay_key_required",
  text = [[
¡Está cerrada!
]]
}
-----------------------

-- Sign above the cliff of the village.
dialog{
  id = "outside_world.warning_holes_sign",
  text = [[
¡Cuidado con los
agujeros!
]]
}
-----------------------

dialog{
  id = "outside_world.how_to_save_npc",
  skip = "all",
  text = [[
Para guardar tus progresos,
pulsa D para pausar el
juego y, después, pulsa
C. ¡Fíjate en el icono verde!
]]
}
-----------------------

-- Sign in the eastern forest.
dialog{
  id = "outside_world.flower_hole_sign",
  text = [[
El agujero cercano a
las flores no es tan
peligroso como parece...
]]
}
-----------------------

dialog{
  id = "outside_world.telepathic_booth_sign",
  text = [[
Cabina Telepática
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_sign",
  text = [[
 - Muro de Sorpresas -
 ¡Ven y tienta a la suerte
 para ganar el tesoro
 escondido!
]]
}
-----------------------

dialog{
  id = "outside_world.billy_cavern_sign",
  text = [[
Cueva de Billy el
Temerario.
¡Entrada Prohibida!
]]
}
-----------------------

dialog{
  id = "outside_world.beaumont_hill_sign",
  text = [[
Aquel que plante un
edeweiss en la cima de
la Colina Beaumont Hill,
tendrá un buen día.
]]
}
-----------------------

-- Planting an edelweiss at the top of Beaumont Hill.
dialog{
  id = "outside_world.beaumont_hill_put_edelweiss",
  text = [[
Estás plantando tu
edelweiss...
]]
}
-----------------------

dialog{
  id = "outside_world.stone_key_required",
  text = [[
   - Cerradura de Piedra -
¡Está cerrada!
]]
}
-----------------------

dialog{
  id = "outside_world.iron_key_required",
  text = [[
    - Cerradura de Hierro -
¡Está cerrada!
]]
}
-----------------------

dialog{
  id = "outside_world.wooden_key_required",
  text = [[
    - Cerradura de Madera -
¡Está cerrada!
]]
}
-----------------------

dialog{
  id = "outside_world.ice_key_required",
  text = [[

   - Cerradura de Hielo -
¡Está cerrada!
]]
}
-----------------------

-- Waterfall, north-east of mountains.
dialog{
  id = "outside_world.mountain_riverfall",
  skip = "all",
  text = [[
Tiene que haber una
forma de cruzar esta
cascada...
]]
}
-----------------------

-- Link hearing Sahasrahla in a dream, sleeping in his bed after the intro.
dialog{
  id = "link_house.dream",
  text = [[
... $v...
Soy yo...
... Sahasrahla...
Tengo que... hablar...
Ven deprisa, $v...
]]
}
-----------------------

-- Mystery chest game in the rupee house.
dialog{
  id = "rupee_house.game_1.intro",
  question = true,
  text = [[
Bienvenido al juego de
los cofres misteriosos.
¡Paga 20 Rupias para
abrir uno de los tres
cofres y ten la
posibilidad de ganar
más rupias!


¿Quieres jugar?
Sí
No
]]
}
-----------------------

-- Mystery chest game: talking to the guy after the payment.
dialog{
  id = "rupee_house.game_1.choose_chest",
  text = [[
¡Vamos allá, escoge un
cofre!

¡Deja de mirarme, no te 
pienso decir cuál escoger!
]]
}
-----------------------

-- Mystery chest game: accepted to play.
dialog{
  id = "rupee_house.game_1.good_luck",
  text = [[
¡Buena suerte!
]]
}
-----------------------

-- Mystery chest game: won too much, cannot play anymore.
dialog{
  id = "rupee_house.game_1.not_allowed_to_play",
  text = [[
Ya has ganado antes,
¿no? ¡Nos hemos
arruinado por tu culpa!
]]
}
-----------------------

-- Mystery chest game: play again?
dialog{
  id = "rupee_house.game_1.play_again_question",
  question = true,
  text = [[
¿Quieres jugar otra vez?


¡Son 20 Rupias!
Sí
No
]]
}
-----------------------

-- Mystery chest game: refusing to play again.
-- Reference to Link's Awakening in the fishing game.
dialog{
  id = "rupee_house.game_1.not_playing",
  text = [[
¡Debes tener más pasión!
¡Vive un poco!
]]
}
-----------------------

-- Slot machine in the rupee house.
dialog{
  id = "rupee_house.game_2.intro",
  question = true,
  text = [[
¡Bienvenido a la 
nueva máquina
tragaperras!
Apuesta 5 ó 20 rupias
y trata de alinear
tres símbolos
iguales para
multiplicar tu
apuesta.
¿Quieres jugar?
Sí
No
]]
}
-----------------------

-- Slot machine: refused to play.
dialog{
  id = "rupee_house.game_2.not_playing",
  text = [[
Será la próxima
vez...
]]
}
-----------------------

-- Slot machine: accepted to play.
dialog{
  id = "rupee_house.game_2.choose_bet",
  question = true,
  text = [[
¿Cuánto apuestas?
5 Rupias
20 Rupias
]]
}
-----------------------

-- Slot machine: choosed a bet, having enough money.
dialog{
  id = "rupee_house.game_2.just_paid",
  next = "rupee_house.game_2.playing",
  text = [[
¡Gracias!
]]
}
-----------------------

-- Slot machine: talking to the NPC again while playing.
dialog{
  id = "rupee_house.game_2.playing",
  text = [[
Mantente al lado de
las ruletas y pulsa
el botón Acción para
detenerlas.
¡Buena suerte!
]]
}
-----------------------

-- Slot machine: obtained 3 identical symbols, nothing incredible though.
dialog{
  id = "rupee_house.game_2.reward.same_any",
  text = [[
Tres símbolos
idénticos. ¡No está
mal!
Ganas 4 veces tu
apuesta.
]]
}
-----------------------

-- Slot machine: obtained 3 green rupee symbols.
dialog{
  id = "rupee_house.game_2.reward.green_rupees",
  text = [[
Tres Rupias verdes.
¡Bien! Ganas 5 veces
tu apuesta.
]]
}
-----------------------

-- Slot machine: obtained 3 blue rupee symbols.
dialog{
  id = "rupee_house.game_2.reward.blue_rupees",
  text = [[
¡Tres Rupias azules!
¡Enhorabuena, has
ganado 7 veces tu
apuesta inicial!
]]
}
-----------------------

-- Slot machine: obtained 3 red rupee symbols.
dialog{
  id = "rupee_house.game_2.reward.red_rupees",
  text = [[
¡¡¡Tres Rupias rojas!!!
¡Asombroso!
¡Ganas nada menos
que 10 veces tu apuesta!
]]
}
-----------------------

-- Slot machine: obtained 3 different rupee symbols.
dialog{
  id = "rupee_house.game_2.reward.different_rupees",
  text = [[
¡Guau! Tienes tres
Rupias de diferente
color, ¡eso no ocurre
todos los días!
La recompensa es
15 veces tu apuesta.
]]
}
-----------------------

-- Slot machine: obtained 3 Yoshi symbols (maximum reward).
dialog{
  id = "rupee_house.game_2.reward.yoshi",
  text = [[
$1...$3¡¿Tres Yoshis?!
¡I-n-c-r-e-i-b-l-e!
Es la mejor
combinación posible...
Tu apuesta inicial se
multiplica por 20.
]]
}
-----------------------

-- Slot machine: not obtained anything.
dialog{
  id = "rupee_house.game_2.reward.none",
  question = true,
  text = [[
Mala suerte, no
conseguiste hacer
ninguna combinación.
¿Quieres probar

de nuevo?
Sí
No
]]
}
-----------------------

-- Maze game in the rupee house.
dialog{
  id = "rupee_house.game_3.intro",
  question = true,
  text = [[
Navega por el
laberinto antes de que
el tiempo se agote.
Puede ser que tengas
que empujar bloques
para abrir pasadizos.
Puedes ganar una
Pieza de Corazón, y
oí que son muy
raras...
Son sólo 10 Rupias.

¿Quieres jugar?
Sí
No
]]
}
-----------------------

-- Maze game: accepted to play, having enough money.
dialog{
  id = "rupee_house.game_3.go",
  text = [[
¡Allá vamos!
¡Buena suerte!
]]
}
-----------------------

-- Maze game: refused to play.
dialog{
  id = "rupee_house.game_3.not_playing",
  text = [[
Es tu elección...
]]
}
-----------------------

-- Maze game: talking to the NPC but the piece of heart was already found.
dialog{
  id = "rupee_house.game_3.not_allowed_to_play",
  text = [[
¡Perdona, pero ya
completaste este juego!
]]
}
-----------------------

-- Maze game: talking to the NPC when the game is already started.
dialog{
  id = "rupee_house.game_3.restart_question",
  question = true,
  text = [[
¿Quieres volver a
empezar?

Serán 10 rupias.
Sí
No
]]
}
-----------------------

-- Rupee house: not having enough money (for all three games).
dialog{
  id = "rupee_house.not_enough_money",
  text = [[
¡No tienes suficiente
dinero!
]]
}
-----------------------

-- Rupee house: interacting with a game without paying.
dialog{
  id = "rupee_house.pay_first",
  text = [[
¡Hey! ¡Tienes que pagar
si quieres jugar aquí!
]]
}
-----------------------

-- Broken rupee house (left NPC).
dialog{
  id = "rupee_house_broken.help_us_left",
  text = [[
¡Ayuda!
¡Ayuda!

¡Han robado en
la casa!
]]
}
-----------------------

-- Broken rupee house (middle NPC).
dialog{
  id = "rupee_house_broken.help_us_middle",
  text = [[
¡Los bandidos robaron
las Rupias destinadas
a pagar los sueldos!
]]
}
-----------------------

-- Broken rupee house (right NPC).
dialog{
  id = "rupee_house_broken.help_us_right",
  text = [[
¡Los delincuentes se
dirigieron hacia la
cueva del herrero!
]]
}
-----------------------

-- Broken rupee house: solved the problem.
dialog{
  id = "rupee_house_broken.thanks",
  text = [[
¡Encontraste nuestras
Rupias! Gracias a ti
vamos a recuperar
nuestro negocio. No
sé cómo 
compensarte...
]]
}
-----------------------

dialog{
  id = "rupee_house_broken.thanks_again",
  text = [[
¡Gracias de nuevo!
]]
}
-----------------------

-- Thanks for your contribution!

dialog{
  id = "dungeon_1.solarus_child",
  text = [[
$2$v... Gracias. Me has
salvado la vida. Soy
uno de los ocho 
protectores llamados
por la Princesa Zelda.
Nos dedicamos a velar
por los restos de la
santa reliquia, la
Trifuerza, creada por
tres diosas antes de la
creación de tu mundo.
A lo largo de los
milenios, a pesar de
ser fuente de vida y 
prosperidad, fue
también gran fuente
de la codicia y de las
constantes luchas entre
las fuerzas del bien
y el mal. Incluso hoy
en día, la sagrada 
reliquia está en 
peligro. Sin embargo,
la historia se repite.
Donde quiera que haya
peligro, hay un héroe
cuyo valor conduce a 
la oscuridad lejos.
Busca a mis hermanos
y descubre quién está
detrás de todo esto, 
antes que las fuerzas
de la oscuridad hagan
caer a Hyrule en
el caos ...
¡Puede que el héroe
traiga paz y 
prosperidad al Reino!
]]
}
-----------------------

dialog{
  id = "outside_world.rock_key_required",
  text = [[
¡Está cerrado!
]]
}
-----------------------

dialog{
  id = "dungeon_2.eye_hint",
  skip = "all",
  text = [[
Ambos ojos deben ser
perforados.
]]
}
-----------------------

dialog{
  id = "dungeon_2.eye_2_hint",
  skip = "all",
  text = [[
Ambos ojos deben ser
perforados con
perseverancia.
]]
}
-----------------------

dialog{
  id = "dungeon_2.code_hint",
  skip = "all",
  text = [[
       F | B | E 
      ---|---|---
       C | D | A 
]]
}
-----------------------

dialog{
  id = "fairy_cave.first_time",
  text = [[
Bienvenido, joven
lleno de sabiduría. He
estado esperando tu
llegada.Soy el Hada
Encantada. Tú, que
velas por la justicia,
me permito darte
este regalo...

Has demostrado en
el pasado que te lo
mereces.
]]
}
-----------------------

dialog{
  id = "fairy_cave.restore_health",
  text = [[
Bienvenido, joven
lleno de sabiduría.

Soy el Hada Encantada.
Cierra tus ojos
y relájate.
]]
}
-----------------------

dialog{
  id = "north_fairy_fountain.first_time",
  text = [[
Bienvenido, joven
lleno de coraje. He
estado esperando tu
llegada. Soy el Hada
Viajera. Tú, que
recorres el mundo
luchando contra el mal
sin descanso me permito
transmitirte una
antigua técnica...
]]
}
-----------------------

dialog{
  id = "north_fairy_fountain.restore_health",
  text = [[
Bienvenido, joven
lleno de coraje.

Soy el Hada Viajera.
Cierra tus ojos
y relájate.
]]
}
-----------------------

dialog{
  id = "mountain_cave.mountain_sign",
  skip = "all",
  text = [[
    Monte Terror
        --->
]]
}
-----------------------

dialog{
  id = "mountain_cave.not_much_done",
  skip = "all",
  text = [[
Si estás leyendo esto,
entonces no has llegado
muy lejos.
]]
}
-----------------------

dialog{
  id = "mountain_cave.patience",
  skip = "all",
  text = [[
La paciencia es la virtud
del verdadero héroe

 - Autor Desconocido -
]]
}
-----------------------

dialog{
  id = "mountain_cave.almost_done",
  skip = "all",
  text = [[
Lo peor está
por venir.
]]
}
-----------------------

dialog{
  id = "outside_world.old_castle_sign",
  skip = "all",
  text = [[

     Castillo Antiguo
         <---
]]
}
-----------------------

dialog{
  id = "billy_cave.hello",
  skip = "current",
  text = [[
Espero que hayas venido
con algo que valga la
pena hacer si te
atreves a entrar en mi
caverna. Soy Billy el
Temerario, el mejor
aventurero de todos los
tiempos.

De mi expedición al
Monte Terror, traje un
tesoro de valor
incalculable. Incluso
la Princesa Zelda no
hubiera podido
encontrarlo. Es una
planta extremadamente
rara.
Soy la única persona
viva que posee una.
Superé los obstáculos
del Monte Terror,
afronté cada peligro
y salí completamente
ileso.


De esta forma tan
heroica encontré
esta flor de extremo
valor: ¡Una edelweiss!
]]
}
-----------------------

dialog{
  id = "billy_cave.what_do_you_have",
  skip = "current",
  next = "_unknown",
  text = [[
No esperes que te dé mi
edelweiss gratis.
Afronté los peligros
del Monte Terror para
encontrarla. Si no
tienes nada valioso
para darme, entonces
pasa de largo.
]]
}
-----------------------

dialog{
  id = "billy_cave.without_golden_bars",
  question = true,
  text = [[
¿Qué me darás?
Un Cruasán
Un Pastel de Manzana
]]
}
-----------------------

dialog{
  id = "billy_cave.with_golden_bars",
  question = true,
  text = [[
¿Qué me darás?
Barras de Oro
Un Pastel de Manzana
]]
}
-----------------------

dialog{
  id = "billy_cave.give_croissant_without",
  text = [[
¡Ni siquiera tienes un
Cruasán! ¡Ladrón!
]]
}
-----------------------

dialog{
  id = "billy_cave.give_croissant",
  text = [[
¿Un Cruasán?
¿Acaso estás bromeando?
]]
}
-----------------------

dialog{
  id = "billy_cave.give_apple_pie_without",
  text = [[
¡Pfft! ¡Ni siquiera
tienes un Pastel de
Manzana!
]]
}
-----------------------

dialog{
  id = "billy_cave.give_apple_pie",
  text = [[
No gracias, Eso está
lejos de ser justo...
]]
}
-----------------------

dialog{
  id = "billy_cave.give_golden_bars",
  text = [[
¿Qué? Tienes barras de
oro?$1...
$0...$0....................
$3¡Trato hecho!
Toma tu estúpida flor..
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.closed",
  text = [[
Si me das algo para
comer, te dejaré pasar
al otro lado de esta
pared.
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.give_me_apple_pie",
  question = true,
  text = [[
¡Dame ese Pastel de
Manzana!

¿Y bien?
De acuerdo
De ninguna manera
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.open",
  text = [[
Algunas personas creen
que hay tesoros detrás
de esta pared, pero
nunca he encontrado
nada.
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.thanks",
  next = "outside_world.surprise_wall_guy.open",
  text = [[
¡Súper! Disfrutaré
mucho comiéndome el
pastel.
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_closed",
  text = [[
¡Está cerrado!
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_0",
  text = [[

        Derecha
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_1",
  text = [[

         Arriba
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_2",
  text = [[

       Izquierda
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_3",
  text = [[

         Abajo
]]
}
-----------------------

dialog{
  id = "lake_shop.seller",
  text = [[
¡Bienvenido a la Tienda
del Lago! Nuestros
artículos son los más
baratos de la zona.¿Qué
puedo hacer por tí?
]]
}
-----------------------

dialog{
  id = "lake_shop.apples",
  text = [[
Tres manzanas a precio
de descuento.
]]
}
-----------------------

dialog{
  id = "lake_shop.bombs",
  text = [[
Ocho Bombas. ¡Te las
daré a precio de costo!
]]
}
-----------------------

dialog{
  id = "lake_shop.arrows",
  text = [[
Diez flechas, excelente
calidad y precio.
]]
}
-----------------------

dialog{
  id = "lake_shop.big_magic_flask",
  text = [[
Oferta especial:
Una jarra de energía
mágica.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.first_time",
  next = "chests_game_cave.play_question",
  text = [[
¿¿Cómo llegaste hasta
aquí??

... Ya que estás aquí,
¿Te gustaría ser el
primero en probar mi
nuevo juego? Una
partida cuesta 30
Rupias.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.not_first_time",
  skip = "current",
  next = "chests_game_cave.play_question",
  text = [[
¡Hola! Una partida
cuesta 30 Rupias.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.play_question",
  question = true,
  text = [[
¿Quieres jugar?
Sí
No
]]
}
-----------------------

dialog{
  id = "chests_game_cave.not_enough_money",
  skip = "all",
  text = [[
¡No tienes suficientes
Rupias!
]]
}
-----------------------

dialog{
  id = "chests_game_cave.start_game_wooden_key",
  skip = "all",
  text = [[
¡Gracias! Para jugar,
simplemente abre uno de
los cofres y podrás
conservar su contenido.
El gran premio del día
es una magnífica llave
de madera.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.start_game_piece_of_heart",
  skip = "all",
  text = [[
¡Gracias! Para jugar,
simplemente abre uno de
los cofres y podrás
conservar su contenido.
El gran premio del día
es una Pieza de 
Corazón.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.start_game",
  skip = "all",
  text = [[
¡Gracias! Puedes abrir
uno de los cofres y
conservar su contenido.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.already_playing",
  skip = "all",
  text = [[
¡Elige un cofre!
]]
}
-----------------------

dialog{
  id = "outside_world.junk_shop_sign",
  skip = "all",
  text = [[

  Tienda de Chatarra

¡La selección más
grande a precios
excepcionales!
]]
}
-----------------------

dialog{
  id = "junk_shop.seller",
  skip = "all",
  text = [[
¡Bienvenido a la Tienda
de Chatarra! ¡Artículos
de la mejor calidad a
precios
extraordinarios!
]]
}
-----------------------

dialog{
  id = "junk_shop.croissant",
  text = [[
Un Cruasán. Para llenar
tus Corazones.
]]
}
-----------------------

dialog{
  id = "junk_shop.arrows",
  text = [[
Flechas estándar.
]]
}
-----------------------

dialog{
  id = "junk_shop.red_rupee",
  text = [[
Una Rupia Roja de
oferta especial, pero
es el modelo de pie.
]]
}
-----------------------

dialog{
  id = "junk_shop.mystic_mirror",
  text = [[
El Espejo Místico.
¡Dicen que puede
invertir el flujo del
agua!
]]
}
-----------------------

dialog{
  id = "junk_shop.heart",
  text = [[
Un Corazón. Útil si
necesitas energía.
]]
}
-----------------------

dialog{
  id = "junk_shop.bombs",
  text = [[
Ocho Bombas a precio
reducido.
]]
}
-----------------------

dialog{
  id = "junk_shop.piece_of_heart",
  text = [[
Una Pieza de Corazón
auténtica.
]]
}
-----------------------

dialog{
  id = "junk_shop.pain_au_chocolat",
  text = [[
Un Pan de Chocolate
para recuperar
Corazones.
]]
}
-----------------------

dialog{
  id = "castle.welcome",
  skip = "all",
  text = [[
Bienvenido al antiguo
castillo real,
catalogado como
monumento histórico.
Por favor, no molestar
en los alrededores.
]]
}
-----------------------

dialog{
  id = "castle.forbidden_stairs",
  skip = "all",
  text = [[
Esta escalera lleva 
hasta el nivel superior 
y al balcón.
Sin embargo el acceso
está prohibido para el
público.
]]
}
-----------------------

dialog{
  id = "castle.forbidden_door",
  skip = "all",
  text = [[
Lo siento señor, pero 
no tiene permiso para
acceder a los 
calabozos.
]]
}
-----------------------

dialog{
  id = "castle.forbidden_door_wtf",
  text = [[
........$0....?!$#!@&=!??
.....$0..................

¿Cómo has llegado hasta 
aquí? ¡Estás en un área 
restringida!
]]
}
-----------------------

dialog{
  id = "castle.npc_1",
  skip = "all",
  text = [[
Este castillo en su día
perteneció a la
familia real.
¡Hoy en día, turistas
de todo Hyrule viajan
para contemplarlo!
]]
}
-----------------------

dialog{
  id = "castle.npc_2",
  skip = "all",
  text = [[
¿Te imaginas cuanto
esfuerzo costó el
construir este 
castillo?
¿Cómo consiguieron
hacerlo con los medios
que tenian en aquel
momento? ¡Es increíble!
]]
}
-----------------------

dialog{
  id = "castle.where_is_tom",
  skip = "all",
  text = [[
Tom, uno de nuestros
mejores soldados,
desapareció cuando fue
a explorar una cueva.
]]
}
-----------------------

dialog{
  id = "castle.npc_3",
  skip = "all",
  text = [[
¡Cuánto lujo!
¡Es una casa
maravillosa!
]]
}
-----------------------

dialog{
  id = "castle.prison",
  skip = "all",
  text = [[
Los prisioneros del rey
estuvieron encerrados
dentro de estas oscuras
celdas.
]]
}
-----------------------

dialog{
  id = "castle.cannon",
  skip = "all",
  text = [[
¡Qué increíble cañón!
¡Es mejor no ser
enemigo del rey!
]]
}
-----------------------

dialog{
  id = "inferno.first_time",
  next = "inferno.find_fire_stones",
  text = [[
¿Quién osa caminar por
mis tierras?
¡Chico! ¿Sabes la
estupidez que has
cometido al molestar
a Inferno, señor de
las llamas?
Serás castigado por
tal comportamiento.
Si quieres redimirte
trata de encontrar las
tres Piedras de Fuego
escondidas en mi 
sombrio laberinto
]]
}
-----------------------

dialog{
  id = "inferno.find_fire_stones",
  skip = "current",
  text = [[
Tendrás que superar
las tres duras pruebas

Río.
$0Montaña.
$0Beaumont.
¡Supera los retos que
te esperan, trae de
vuelta las tres piedras
de fuego y sólo
entonces calmarás
la furia de Inferno.
]]
}
-----------------------

dialog{
  id = "inferno.found_fire_stones",
  question = true,
  text = [[
¡Has superado
las tres pruebas con
éxito! Tu valentía es
en verdad única, he
de inclinarme ante 
ella. Te concederé
lo que desees.


¿Qué quieres?
Las piedras negras...
¿100 Rupias?
]]
}
-----------------------

dialog{
  id = "inferno.want_rupees",
  text = [[
Que así sea.
]]
}
-----------------------

dialog{
  id = "inferno.want_rupees_again",
  text = [[
Ya te he dado
ese premio.
]]
}
-----------------------

dialog{
  id = "inferno.want_black_stones",
  text = [[
Antes de poder 
cargar con estas
piedras negras, habrás 
de sobrevivir en una 
tierra infernal, y 
superar muchos 
peligros.
Permíteme guiarte hacia
un infierno de llamas..
]]
}
-----------------------

dialog{
  id = "potion_shop.witch",
  text = [[
¡Bienvenido a la tienda
de pociones!
Hehehe...
La Roja da vida, la
verde da magia, la azul
da ¡vida y magia!
]]
}
-----------------------

dialog{
  id = "potion_shop.witch_bottle_offered",
  text = [[
¡Bienvenido a la tienda
de pociones!
Hehehe...
¡Una Botella Mágica por
cada nuevo cliente
gratis! Hehehe...
La Roja da vida, la
verde da magia, la azul
da ¡vida y magia!
]]
}
-----------------------

dialog{
  id = "potion_shop.no_empty_bottle",
  text = [[
¡No puedes comprar esta
Poción sin una Botella
vacía! Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.red_potion",
  text = [[
Poción Roja:
¡restaura vida!
Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.green_potion",
  text = [[
Poción Verde:
¡restaura tu barra de
magia! Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.blue_potion",
  text = [[
Poción Azul:
¡restaura vida y magia!
Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.give_bottle",
  text = [[
Como nuevo cliente,
te llevas una Botella
Mágica de regalo.
Hehehe...
]]
}
-----------------------

dialog{
  id = "outside_world.vine_start",
  skip = "all",
  text = [[
La tierra parece muy
fértil por aquí,
pero carece de
humedad...
]]
}
-----------------------

dialog{
  id = "cave_to_dungeon_8.hint",
  skip = "all",
  text = [[
Sólo un observador
atento podrá seguir
el camino.
]]
}
-----------------------

dialog{
  id = "bone_key_cave.hint",
  skip = "all",
  text = [[
Sólo al repeler la luz
hará brillar la luz
de nuevo.
]]
}
-----------------------

dialog{
  id = "hidden_palace.door_closed",
  skip = "all",
  text = [[
Esta puerta no se abre...
]]
}
-----------------------

dialog{
  id = "hidden_palace.using_bone_key",
  icon = 20,
  text = [[
$1Usas la Llave
de Hueso...
]]
}
--------------------

dialog{
  id = "dungeon_2.solarus_child",
  text = [[
$2$v... Gracias. Me has
salvado la vida. Soy
uno de los ocho 
protectores llamados
por la Princesa Zelda.
Nos dedicamos a velar
por la Trifuerza
Usando el poder del
amuleto Solarus, una
reliquia usada por la
Princesa Zelda, es la
única manera de 
restaurar la Trifuerza.
Lo hemos roto en ocho
pedazos ocultos por 
todo el reino.
Estamos aquí para
proteger los ocho
fragmentos, como Zelda
vela por el amuleto
Solarus.
No debe caer en manos
equivocadas.
Confiamos en tu valor.
¡Puede que el héroe
traiga paz y 
prosperidad al Reino!
]]
}
-----------------------

dialog{
  id = "dungeon_3.arbror_direction_hint",
  text = [[

  Norte: Maestro Arbror
]]
}
-----------------------

dialog{
  id = "dungeon_3.water_drained_somewhere",
  text = [[
A lo lejos ... un ruido ...
]]
}
-----------------------

dialog{
  id = "dungeon_3.arbror_hello",
  text = [[
¡¡¡Haa!!! ¡Nunca me
vencerás, Maestro
Arbror!
]]
}
-----------------------

dialog{
  id = "dungeon_3.arbror_killed",
  text = [[
¡¡¡KARGHHH!!! He sido
derrotado, pero no
llegarás muy lejos...
Tú jamás
lo lograrás...
]]
}
-----------------------

dialog{
  id = "dungeon_3.solarus_child",
  text = [[
$2$v... Gracias. Me has
salvado la vida.
Gracias a ti, esta 
horrible criatura nunca
volverá a molestar al
Reino.
Soy uno de los ocho
protectores llamados
por la Princesa Zelda.
La Trifuerza sigue en
peligro siempre que 
uno de mis hermanos
esté preso.
El final de tu viaje 
está cerca.
Sálvales y devuelve 
la paz a estas tierras.
¡Que el héroe traiga
la paz y la prosperidad
al Reino!
]]
}
-----------------------

dialog{
  id = "dungeon_4.welcome",
  skip = "current",
  text = [[
         Nivel 4
    Palacio de Beaumont
]]
}
-----------------------

dialog{
  id = "dungeon_4.hint_use_map",
  text = [[
Cuando la salida no
aparezca ante ti, usa
el mapa.
]]
}
-----------------------

dialog{
  id = "dungeon_4.hint_chests",
  text = [[
El camino se muestra 
por el cruce de los 
cuatro cofres.
]]
}
-----------------------

-- The hero attemps to enter the frozen room in dungeon 4
-- but doesn't have the blue mail.
dialog{
  id = "dungeon_4.too_cold",
  text = [[
Hace mucho frío aquí...
¡Tienes que irte!
]]
}
-----------------------

dialog{
  id = "dungeon_4.solarus_child",
  text = [[
$2$v... Thank you.
Me has salvado la vida.
Soy uno de los ocho
protectores nombrados
por la Princesa Zelda.
Has mostrado tener
un gran coraje.
Gracias a ti volvemos
a estar todos juntos de
nuevo, y la Trifuerza
está a salvo.
¡Que el héroe traiga
la paz y la prosperidad
al Reino!
]]
}
-----------------------

dialog{
  id = "dungeon_4.agahnim",
  text = [[
$1A G A H N I M !
$3¡Sí, el mismo!

¡¡El hechicero ha
vuelto de la tierra
de la muerte!!
¡¡Ja ja ja ja ja!!
Así que te las has
arreglado para reunir
a los cuatro chicos.
Este crío no tiene ni
idea de lo que le 
espera ahí fuera al
decir que la Trifuerza
está a salvo...
¡¡Ja ja ja ja ja!!
Reconozco, hombrecito,
que no he vuelto para
liberar al despreciable
Ganon, aquel que una
vez se atrevió a
llamarme su alter
ego...
¡Prefiero dejar a ese
delincuente inmundo
en el Dark World!
Así, yo guardaré la
Trifuerza y gobernaré
como único maestro...
¡¡¡Ja ja ja ja ja!!!
Cuando salgas de esta
sala, serás testigo de
mi control sobre el 
reino...
¡¡¡Ja ja ja ja ja!!!
¡De momento me vuelvo
al castillo!
Eso sí, joven e 
impetuoso aventurero,
volveremos a vernos
las caras de nuevo.
¡Y cuando eso ocurra,
yo y mis poderes
pondremos fin a tu
historia!
¡¡¡Ja ja ja ja!!!
]]
}
-----------------------

dialog{
  id = "dungeon_5.welcome",
  skip = "current",
  text = [[
         Nivel 5
     Castillo antiguo
]]
}
-----------------------

dialog{
  id = "dungeon_5.pots_hint",
  skip = "all",
  text = [[
La clave para el
puzzle consiste en
girar las jarras en la
dirección correcta.
]]
}
-----------------------

dialog{
  id = "dungeon_5.hero_seen_by_guard",
  text = [[
¡ALTO!
¡No te muevas!
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_1_locked",
  text = [[
     - Cerradura de Hierro -
Ninguna de tus llaves
parece encajar...
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_1_use_iron_key",
  icon = 28,
  text = [[
$1Usas la Llave de
Hierro
]]
}
--------------------

dialog{
  id = "dungeon_5.prison_2_locked_1",
  text = [[
¡Está cerrado!
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_2_locked_2",
  text = [[
Está tan oxidado que
ni siquiera la llave
grande funcionaría.
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_2_locked_3",
  text = [[
Puede que haya una
manera de forzar esta
vieja cerradura...
]]
}
-----------------------

dialog{
  id = "dungeon_5.puzzle_solved",
  text = [[
En algún lugar de las
profundidades del
castillo, un mecanismo
se ha activado...
]]
}
-----------------------

dialog{
  id = "dungeon_5.agahnim_beginning",
  text = [[
Fuiste capaz de pasar
mis guardias y evitar
las trampas instaladas
en el castillo.
¡Pero no importa, tu
viaje termina aquí!
]]
}
-----------------------

dialog{
  id = "dungeon_5.agahnim_end",
  text = [[
...$0...........$0
Me has vencido esta
vez...
¡Pero volveremos a
encontrarnos!

Tu pequeño viaje
no cambiará
nada...
Sahasrahla está bajo
mi control y me 
dirá dónde están
Zelda y los ocho
Hijos de Solarus...
¡Ha ha ha ha ha!
Ahora he de irme.
¡Nos volveremos
a ver muy pronto!
]]
}
-----------------------

dialog{
  id = "dungeon_6.welcome",
  skip = "current",
  text = [[
         Nivel 6
     Laberinto de Inferno
]]
}
-----------------------

-- Hint for the weak floor
dialog{
  id = "dungeon_6.torches_hint",
  text = [[
Las tres antorchas
te mostrarán la 
manera de caer.
]]
}
-----------------------

dialog{
  id = "dungeon_6.dont_fall_hint",
  text = [[
No caigas; salta.
]]
}
-----------------------

dialog{
  id = "dungeon_6.close_way_hint",
  text = [[
Después cierra el
camino tras de ti.
]]
}
-----------------------

dialog{
  id = "dungeon_6.tom",
  text = [[
$2$v... Gracias.
Me has salvado la vida.
Has recorrido un largo
camino y superado
numerosas y duras
pruebas desde
la última vez que 
nos vimos.
]]
}
-----------------------

dialog{
  id = "dungeon_6.tom_revelation",
  text = [[
$2Necesito confesarte
algunos hechos graves.
La muerte de nuestro
Rey no fue casualidad.
Yo lo envenené, estaba
bajo el control de
Agahnim...
Él me lanzó un hechizo
y perdí el control 
sobre mí mismo... No
hubo nada que pudiera
hacer...
Cuando el hechizo se
rompió, me di cuenta
de lo que había pasado.
Cuando eso ocurrió,
decidí retirarme
a la cueva donde nos
vimos por primera vez.
Entonces me encerraron
en la cárcel al oponer
resistencia cuando 
Agahnim tomó el control
del castillo...
$v...Ahora debes viajar
a la Montaña del
Terror.
Agahnim fue allí en
busca de Zelda.
Primero debes liberar a
Sahasrahla antes de que
el hechicero se las
arregle para conseguir
la información que él
necesita...
Por favor, toma esto,
es una pequeña ayuda
para tu aventura...
]]
}
-----------------------

dialog{
  id = "dungeon_7.welcome",
  skip = "current",
  text = [[
         Nivel 7
     Templo de Cristal
]]
}
-----------------------

dialog{
  id = "dungeon_7.code",
  skip = "all",
  text = [[
        4  7  2        
        6  1  8        
           3  5        
]]
}
-----------------------

-- The original dialog was a reference
-- to Link's Awakening.
dialog{
  id = "dungeon_7.2f_weak_floor_hint",
  text = [[
En el suelo duermen
secretos, bajo tus
pies...
]]
}
-----------------------

dialog{
  id = "dungeon_7.2f_dont_fall_alone_hint",
  text = [[
La solución era
no caer solo.
]]
}
-----------------------

dialog{
  id = "dungeon_7.sahasrahla",
  text = [[
$2$v... Gracias.
Me has salvado la vida.

Si pudiera haber
resistido sólo un
poco más...
Aquellos delincuentes
me persuadieron para
que les revelase la
ubicación de Zelda y
los Jóvenes Solarus.
Protégelos de cualquier
peligro, antes de que
algo les ocurra...
Ellos están ocultos en
en un palacio situado
al este de las
montañas. Los ocho
Solarus no deben caer
en manos de Agahnim,
de lo contrario
el hechicero podría
romper el sello creado
por el amuleto de 
Solarus, la reliquia
que porta Zelda, y 
que se necesita 
para  conseguir 
los fragmentos de
la Trifuerza.
El misterio de Solarus
se mantiene a salvo en
el interior de la 
reliquia.
El portador de esta
reliquia, tiene la 
habilidad de invocar
el poder de Solarus
para mantener encerrado
en su interior un
objeto, un lugar o 
incluso un mundo, como
los siete sabios
hicieron cuando 
encerraron la Tierra
Dorada.
Zelda es la heredera
de ese poder. Ella lo
usa para encerrar los
fragmentos de la
trifuerza, a través de
los ocho seres creados
por Solarus.
Así, mientras sólo ella
sepa el secreto de la
reliquia, sólo ella
será quien controle el
sello de la Trifuerza.
Esta es la razón por
la que debes proteger
el sello.
]]
}
-----------------------

dialog{
  id = "dungeon_8.welcome",
  skip = "current",
  text = [[
         Nivel 8
   Mazmorra de los Picos Rocosos
]]
}
-----------------------

dialog{
  id = "dungeon_8.hint_1F",
  skip = "current",
  text = [[
Lánzate a las
profundidades de la
mazmorra y continúa
con tu aventura. 
]]
}
-----------------------

dialog{
  id = "dungeon_8.hint_B1",
  skip = "current",
  text = [[
Si te ves encallado,
combate las palas con
más palas.
]]
}
-----------------------

dialog{
  id = "dungeon_8.billy",
  text = [[
¿¡No se te ocurrió que
podrías encontrarte
con tu viejo amigo
Billy el Temerario,
el héroe más grande
de todos los tiempos?!
La Princesa y los
niños no están aquí.
Encontraron refugio
en mi palacio, pero mi
misión era la de
entregarlos a
Agahnim...


¡Ahora, prepárate para
morir!
]]
}
-----------------------

dialog{
  id = "dungeon_8.agahnim",
  text = [[
$1Finalmente Billy no
ha sido capaz de nada.
Viendo que ni él ni
mis otros acólitos han
podido contigo, pequeño
parásito, va a ser 
hora que me encargue
personalmente de ti.
Te haré desaparecer
para siempre. Y será
entonces cuando ponga
mis manos sobre la
Trifuerza y extienda
mi poder por el mundo.
¡Mua ja ja ja ja!
]]
}
-----------------------

dialog{
  id = "dungeon_8.agahnim_middle",
  text = [[
$1$0...$0.............$0
Eres bastante duro,
la verdad. Pero,
¿qué te parece
esto?
]]
}
-----------------------

dialog{
  id = "dungeon_8.agahnim_end",
  text = [[
$1$0...$0 .........$0
He sido derrotado...$0
esto es el fin...$0
No he estado a la 
altura...


Me arrodillo ante tu
valentía.$0

Ya que no he sido
capaz de derrotarte,
es hora de que libere
a mi Maestro...
¡¡¡Ah ah ah ah ah ah!!!
]]
}
-----------------------

dialog{
  id = "dungeon_8.ganon",
  text = [[
$1Así que has conseguido
derrotar a mi alter
ego, el oscuro
hechicero Agahnim...
Algo bastante inútil,
puesto que ello me ha
liberado, ¡los tiempos
de oscuridad no han
acabado! Como 
recompensa por tu
trabajo, tú, la 
Princesa y también los
ocho niños, estáis
invitados a mi
palacio.
Allí recuperaré la
Trifuerza y seréis los
primeros testigos de
tal maravilla.
Deja que tu espíritu
viaje libre...
]]
}
-----------------------

dialog{
  id = "dungeon_9.welcome",
  skip = "current",
  text = [[
         Nivel 9
   Templo de los Recuerdos
]]
}
-----------------------

dialog{
  id = "dungeon_9.clockwise_switches_hint",
  skip = "all",
  text = [[
Ve en sentido horario.
]]
}
-----------------------

dialog{
  id = "dungeon_9.3f_door_b_hint_0",
  skip = "all",
  text = [[
Ve a la derecha.
]]
}
-----------------------

dialog{
  id = "dungeon_9.3f_door_b_hint_2",
  skip = "all",
  text = [[
Hacia la izquierda.
]]
}
-----------------------

dialog{
  id = "dungeon_9.3f_door_b_hint_3",
  skip = "all",
  text = [[
Abajo.
]]
}
-----------------------

dialog{
  id = "dungeon_9.5f_childs_hint",
  skip = "all",
  text = [[
$1Para vencer a Ganon,
las antorchas deben
encenderse en el
sentido horario.
]]
}
-----------------------

dialog{
  id = "dungeon_9.boss",
  text = [[
Aquí estás, joven
enclenque.

He estado esperándote
durante mucho tiempo.
¡Al fin ha llegado la
hora de mi venganza!

Prepárate para morir.
]]
}
-----------------------

dialog{
  id = "dungeon_9.zelda",
  text = [[
$1$v... Gracias.
Tu victoria sobre el
mal demuestra de nuevo 
que la sabiduría
y la justicia siempre
prevalecerán ante
las fuerzas del mal.
Gracias a tu hazaña,
nuestro mundo ha sido
devuelto a su estado
original. El Reino
de Hyrule está entero
de nuevo.
]]
}
-----------------------

dialog{
  id = "dungeon_9.zelda_children",
  text = [[
$1Debo destruir esta
reliquia. El poder de
Solarus es demasiado
peligroso. 
Pero destruyéndolo,
no habrá forma de 
restaurar la Trifuerza
de sus fragmentos.
Incluso si es para un
buen fin como tú una
vez la usaste, el mal
siempre tratará de
llegar a él, al igual
que Agahnim y
Ganondorf.
Con el poder de los 
ocho seres creados por
la Esencia Solarus, la
reliquia podría romper
el sello.
Ahora entiendes por qué
debo destruirlo.
]]
}
-----------------------

dialog{
  id = "dungeon_9.zelda_end",
  text = [[
$1Es el final.$0


El poder de Solarus
ha desaparecido
para siempre.
La Trifuerza quedará
sellada hasta el fin
de los tiempos.
]]
}
-----------------------

dialog{
  id = "dungeon_10.welcome",
  skip = "current",
  text = [[
     Nivel secreto
     Torre Celestial
]]
}
-----------------------

dialog{
  id = "credits_1",
  text = [[
$1        Créditos$0


      Programación:$0
Christopho$0
]]
}
-----------------------

dialog{
  id = "credits_2",
  text = [[
$1   Mapas y puzzles:$0


Christopho$0


Metallizer$0
Binbin$0
Mymy$0
]]
}
-----------------------

dialog{
  id = "credits_3",
  text = [[
$1   Elementos gráficos:$0
Newlink$0

Neovyse$0
@PyroNet$0
Djipi$0
$1        Música:$0
Marine$0
Metallizer$0
]]
}
-----------------------

dialog{
  id = "credits_4",
  text = [[
$1       Historia:$0
Guillaume F.$0
Christopho$0
$1      Localización
     al castellano:$0

Clow_eriol$0    Emujioda$0
LuisCa$0   Musty$0   Xadou$0
Guopich$0       falvarez$0
]]
}
-----------------------

dialog{
  id = "credits_6",
  text = [[
$1        Pruebas:$0


Thyb$0
Morwenn$0
BenObiWan$0
$1   Agradecimientos a:$0


19oj19$0           Yohann$0
MultiSync_XV17$0   Krytzz$0
HelpTheWretched$0

        Nintendo$0


¡Gracias por jugar!$0



 www.solarus-games.org$0
]]
}
-----------------------

-- Grandma: beginning of the game.
dialog{
  id = "grandma_house.sword",
  skip = "all",
  text = [[
Monstruos acechan por
los campos. Eso no es
buena señal: Estoy
segura de que algo
terrible ha sucedido.

¿Estás buscando una
espada? Con mi edad no
sabría de esas cosas...
Mejor ve a visitar al
herrero en la cueva al
noroeste de la aldea.
Es un poco gruñón pero
podrá ayudarte.
]]
}
-----------------------

-- Grandma: after finding the sword.
dialog{
  id = "grandma_house.find_sahasrahla",
  skip = "all",
  text = [[
Con esta espada, puedes
cortar a través de los
arbustos que protegen
la aldea. ¿Buscas a
Sahasrahla el Antiguo,
no es así?
Su casa está al
suroeste de aquí, cerca
de la panadería. ¿No
lo recordabas?
]]
}
-----------------------

-- Grandma: after finding the Earth Key.
dialog{
  id = "grandma_house.go_lyriann_cave",
  skip = "all",
  text = [[
Esta llave te permite
entrar a la caverna
ubicada al norte de la
aldea.
]]
}
-----------------------

-- Grandma: after the village cave.
dialog{
  id = "grandma_house.go_dungeon_1",
  skip = "all",
  text = [[
Uno de los cuatro niños
que fueron secuestrados
podría estar retenido
en una sombría mazmorra
en el bosque al sur de
la aldea. ¿A qué ESTÁS
esperando?
]]
}
-----------------------

-- Grandma: after dungeon 1.
dialog{
  id = "grandma_house.go_back_sahasrahla",
  skip = "all",
  text = [[
Esta vez va mas allá de
mi conocimiento.
Sahasrahla sería de
mejor ayuda.
]]
}
-----------------------

-- Grandma: after finding the bow.
dialog{
  id = "grandma_house.go_twin_caves",
  skip = "all",
  text = [[
¿Así que encontraste un
Arco? Creo que puedes
acceder a las cavernas
gemelas al sur, y
descubrir los secretos
que contienen. ¡Ve por
ellas!
]]
}
-----------------------

-- Grandma: after finding the Rock Key.
dialog{
  id = "grandma_house.go_dungeon_2",
  skip = "all",
  text = [[
¡Qué buena llave la que
tienes! ¿No es hora de
que busques al segundo
niño perdido?
]]
}
-----------------------

dialog{
  id = "grandma_house.go_telepathic_booth",
  skip = "all",
  text = [[
¿Qué es lo que dices? 
¡No puedo oírte bien!
A mi edad mis oídos no
funcionan tan bien como
antes... ¿Qué tal
comunicarnos por
telepatía? Es moderna y
mucho mas conveniente
para mi anciano cuerpo.
]]
}
-----------------------

dialog{
  id = "grandma_house.dark_world_enabled",
  skip = "all",
  text = [[
Agahnim tomó control
del reino... El mal
crece a lo largo de su
camino. Uno de los
soldados del castillo,
Tom, es considerado
culpable de haberse
llevado a Sahasrahla,
¡pero eso es imposible!
¡Además unos bandidos
saquearon la Casa de
las Rupias!
]]
}
-----------------------

dialog{
  id = "telepathic_booth.not_working",
  skip = "all",
  text = [[
¿Hola? ... ¿Hola? ...
¿Hay alguien ahí? ...
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_sahasrahla",
  skip = "all",
  text = [[
$v, ¿me oyes?
¡Soy la Abuela Lyly!
¡La telepatía funciona!
Deberías visitar a
Sahasrahla, tiene
algunas cosas para ti.
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_twin_caves",
  skip = "all",
  text = [[
$v, ¿me oyes?
¡Soy la Abuela Lyly!
¡La telepatía funciona!
Algo me dice que las
cavernas gemelas al sur
de la mazmorra del
bosque esconden un
tesoro importante...
]]
}
-----------------------

dialog{
  id = "telepathic_booth.dungeon_2_not_really_finished",
  skip = "all",
  text = [[
$v, ¿me oyes?
¡Soy la Abuela Lyly!
¡La telepatía funciona!
¿Pero estás seguro de
que encontraste todo en
la Caverna del Roc?
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_master_arbror",
  skip = "all",
  text = [[
$v, ¿me oyes?
¡Soy la Abuela Lyly!
¡La telepatía funciona!
Parece que hay una vía
a través de los árboles
al norte de aquí. Se
dice que el Maestro
Arbror ronda las
tierras inundadas por
el río.
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_billy",
  skip = "all",
  text = [[
$v, ¿me oyes?
¡Soy la Abuela Lyly!
¡La telepatía funciona!
¿Conoces a Billy el
Temerario? ¡Parece que
volvió sano y salvo de
su viaje al Monte
Terror!
]]
}
-----------------------

dialog{
  id = "telepathic_booth.shop",
  skip = "all",
  text = [[
$v, ¿me oyes?
¡Soy la Abuela Lyly!
¡La telepatía funciona!
Pero los tiempos son
difíciles. La
desolación se ha
extendido a lo largo
del devastado reino...
Es como si la vida
misma se hubiera
detenido. ¡Excepto por
la tienda de la aldea!
¡Desde que sólo venden
armas para sobrevivir
están ganando Rupias de
verdad!
]]
}
-----------------------

-- Blacksmith dialog.
dialog{
  id = "smith_cave.without_sword",
  question = true,
  text = [[
Forjé esta gran Espada
de bronce con mis
propias manos. ¡Puedes
tenerla por sólo 75
Rupias!

Sólo con tu escudo no
llegarás muy lejos.

Entonces, ¿interesado?
Sí
No
]]
}
-----------------------

-- Blacksmith: already bought the sword.
dialog{
  id = "smith_cave.with_sword",
  text = [[
¡No vayas a romper mi
Espada porque no te
forjaré otra!
]]
}
-----------------------

-- Blacksmith: refused to buy the sword.
dialog{
  id = "smith_cave.not_buying",
  text = [[
Depende de ti, pero no
vayas a volver llorando
si te metes en serios
problemas.
]]
}
-----------------------

-- Blacksmith: not enough money to buy the sword.
dialog{
  id = "smith_cave.not_enough_money",
  text = [[
¿Estás tratando de
estafarme? ¡No tienes
suficientes Rupias!
]]
}
-----------------------

-- Blacksmith: buying the sword.
dialog{
  id = "smith_cave.thank_you",
  text = [[
Muchas gracias. Para
blandir tu espada,
pulsa C. ¡O mantén
pulsada la tecla C para
lanzar un ataque
giratorio!
]]
}
-----------------------

-- Shop: talking to the NPC.
dialog{
  id = "lyriann_shop.salesman",
  text = [[
Bienvenido. Escoge el
objeto que desees
comprar.
]]
}
-----------------------

-- Shop: watching the Apples.
dialog{
  id = "lyriann_shop.apples",
  next = "_unknown",
  text = [[
¡Tres manzanas recién
cortadas esta mañana!

Cada manzana recupera
un Corazón.
]]
}
-----------------------

-- Shop: watching the Lamp.
dialog{
  id = "lyriann_shop.lamp",
  next = "_unknown",
  text = [[
Una Lámpara.
¡Viaja por lugares
oscuros!
]]
}
-----------------------

-- Shop: watching the Heart.
dialog{
  id = "lyriann_shop.heart",
  next = "_unknown",
  text = [[
Un Corazón para uso
inmediato.
]]
}
-----------------------

-- Shop: watching the Large or Huge Bomb Bag.
dialog{
  id = "lyriann_shop.bomb_bag",
  next = "_unknown",
  text = [[
Un Saco de Bombas más
grande. ¡Muy de moda en
estos días!
]]
}
-----------------------

-- Shop: watching the Large or Huge Quiver.
dialog{
  id = "lyriann_shop.quiver",
  next = "_unknown",
  text = [[
Un Carcaj grande.
Útil en estos tiempos.
]]
}
-----------------------

-- Shop: watching the Large Wallet.
dialog{
  id = "lyriann_shop.rupee_bag",
  next = "_unknown",
  text = [[
Una nueva Bolsa para
cargar más Rupias.
]]
}
-----------------------

-- Bakery: talking to the NPC.
dialog{
  id = "cake_shop.seller.choose_item",
  text = [[
Bienvenido. Escoge el
pastel que desees
comprar.
]]
}
-----------------------

-- Bakery: watching the Pain au Chocolat.
dialog{
  id = "cake_shop.pain_au_chocolat",
  next = "_unknown",
  text = [[
Un delicioso Pan de
Chocolate que recupera
tres Corazones.
]]
}
-----------------------

-- Bakery: watching the Croissant.
dialog{
  id = "cake_shop.croissant",
  next = "_unknown",
  text = [[
Este crujiente Cruasán
recuperará siete
Corazones.
]]
}
-----------------------

-- Bakery: watching the Apple Pie.
dialog{
  id = "cake_shop.apple_pie",
  next = "_unknown",
  text = [[
Un Pastel de Manzana.
¡Horneado con tu ayuda!
]]
}
-----------------------

-- Bakery: leaving the store.
dialog{
  id = "cake_shop.dont_leave",
  question = true,
  text = [[
¡Hey, espera!
Estoy buscando manzanas
para hornear un Pastel
de Manzana. Seis serían
suficientes.

¿Quieres ayudar?
Sí
No
]]
}
-----------------------

-- Bakery: talking to the NPC after the first request about Apples.
dialog{
  id = "cake_shop.seller.ask_apples_again",
  skip = "all",
  question = true,
  text = [[
Aún estoy buscando seis
manzanas para hornear
un gran Pastel de
Manzana.


¿Quieres ayudar?
Sí
No
]]
}
-----------------------

-- Bakery: accepted to help her, having not enough Apples yet.
dialog{
  id = "cake_shop.not_enough_apples",
  text = [[
Oh, no tienes
suficientes manzanas...
Vuelve más tarde.
]]
}
-----------------------

-- Bakery: accepted to help her, having no Apples yet.
dialog{
  id = "cake_shop.no_apples",
  text = [[
Gracias... ¡Vuelve a
visitarme si encuentras
algunas!
]]
}
-----------------------

-- Bakery: accepted to help her, having enough Apples.
dialog{
  id = "cake_shop.thank_you",
  text = [[
Oh, gracias, ¡Qué
amable por tu parte!

Lo siento, solo tengo
esta Botella vacía...

Es una recompensa
pequeña pero estoy
seguro que harás buen
uso de ella.
]]
}
-----------------------

-- Sahasrahla: first talk.
dialog{
  id = "sahasrahla_house.beginning",
  next = "sahasrahla_house.beginning.12",
  text = [[
Oh, $v, escuchaste
mi llamada.
Tengo cosas importantes
que decirte. Son
tiempos difíciles.
Cuatro de los ocho
hijos de Solarus han
sido secuestrados...
Me temo que la Trifuerza
está en gran peligro.
Alguien quiere
aprovechar la muerte
del Rey y apoderarse
de la Trifuerza.
¿Quién podría haber
hecho eso?
Seguro que Ganondorf y
sus secuaces...
El Sello de los Siete
Sabios se debilitó
después de la muerte de
nuestro pobre Rey.
Ganon pudo haber
logrado escapar del
Mundo Oscuro.
¡No podemos permitirle
adquirir semejante
poder!
Puedo sentir el coraje
en ti, $v.
¿Te sientes capaz de
viajar por los más
peligrosos lugares de
esta tierra para salvar
a los niños y
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.beginning.12",
  skip = "none",
  question = true,
  next = "sahasrahla_house.beginning.thanks",
  next2 = "sahasrahla_house.beginning.insisting",
  text = [[
proteger la Trifuerza?
¡Estoy a la altura!
¡Nunca!
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.beginning.insisting",
  question = true,
  next = "sahasrahla_house.beginning.thanks",
  next2 = "sahasrahla_house.beginning.insisting",
  text = [[
$v, debo insistir,
eres nuestra única
esperanza para proteger
al reino...
¡De acuerdo!
¡Ni hablar!
]]
}
-----------------------

-- Sahasrahla: accepted the quest.
dialog{
  id = "sahasrahla_house.beginning.thanks",
  next = "sahasrahla_house.give_world_map",
  text = [[
Sabía que podría contar
con tu coraje.
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.give_world_map",
  text = [[
Aquí tienes un pequeño
objeto que encontrarás
útil en tu aventura...
]]
}
-----------------------

-- Sahasrahla: talking again after the quest has been accepted.
dialog{
  id = "sahasrahla_house.quest_accepted",
  text = [[
Deberías revisar la
caverna, almaceno
objetos que podrías
utilizar. Nada muy
lujoso supongo, ha
pasado mucho tiempo
desde que volví de
allí...
]]
}
-----------------------

-- Sahasrahla: after dungeon 1.
dialog{
  id = "sahasrahla_house.dungeon_1_finished",
  next = "sahasrahla_house.go_grandma",
  text = [[
Buen trabajo,
conseguiste superar los
retos de la mazmorra
del bosque.
Antes de proseguir tu
viaje, vuelve a mi
cueva, quizás puedas 
encontrar allí nuevos
objetos.
]]
}
-----------------------

-- Sahasrahla: watching the books.
dialog{
  id = "sahasrahla_house.memories",
  question = true,
  next = "sahasrahla_house.memories.read",
  text = [[
Memorias de Sahasrahla.


¿Leerlas?
Sí
No
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.memories.read",
  text = [[
¡Es muy largo!
]]
}
-----------------------

-- Sahasrahla: seen the frozen door.
dialog{
  id = "sahasrahla_house.frozen_door_advice",
  skip = "all",
  text = [[
¿La puerta está
congelada?
Intenta fundir el
hielo con algo de
agua.
]]
}
-----------------------

-- Sahasrahla: default dialog, nothing special to say right now.
dialog{
  id = "sahasrahla_house.default",
  skip = "all",
  next = "sahasrahla_house.go_grandma",
  text = [[
Tengo fe en ti.
Qué el valor y la
sabiduría te guíen.
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.go_grandma",
  text = [[
Si te pierdes durante
la aventura, ve a 
visitar a la Abuela
Lyly, al este del
pueblo. Ella es una
vieja amiga y lo sabe 
todo sobre este lugar.
]]
}
-----------------------

-- Sahasrahla: watching the frozen door.
dialog{
  id = "sahasrahla_house.frozen_door",
  skip = "all",
  text = [[
Esta puerta está
congelada. ¡Debe haber
alguna manera de 
derretir el hielo!
]]
}
-----------------------

-- Boomerang cave: first dialog with Tom.
dialog{
  id = "lyriann_cave.tom.first_time",
  question = true,
  next2 = "lyriann_cave.tom.refuse_help",
  text = [[
Hola, joven aventurero.
Soy Tom, un ex-guardia
de nuestro último Rey.
No pensaba que nadie
me encontraría aquí.
¿Qué haces en esta
triste caverna?
¿Qué? ¿La Trifuerza
está en peligro?
$0Nada de esto hubiera
pasado si nuestro Rey
estuviera todavía aquí
para protegerla.
¿Estás intentando
resolver los misterios
de esta caverna?
Este lugar rebosa
de enigmas, tesoros
y peligros. ¡Pareces
muy valiente!
Por favor, acepta mi
ayuda... He fallado. No
fui capaz de proteger a
nuestro Rey. Dame la
oportunidad de 
enmendarlo.

¿Aceptas mi ayuda?
Sí
No
]]
}
-----------------------

-- Boomerang cave: talking to Tom again without the Boomerang.
dialog{
  id = "lyriann_cave.tom.not_first_time",
  question = true,
  next2 = "lyriann_cave.tom.refuse_help",
  text = [[
Joven explorador,
acepta mi ayuda. He
fallado, no fui capaz
de proteger a nuestro
Rey. Dame la
oportunidad de 
enmendarlo.


¿Aceptas mi ayuda?
Sí
No
]]
}
-----------------------

-- Boomerang cave: accepted Tom's help.
dialog{
  id = "lyriann_cave.tom.accept_help",
  text = [[
Gracias. Puedo
prestarte esto, espero
que te sea de utilidad.
No olvides devolvérmelo
cuando hayas terminado.
¡Si consigues obtener
el Contenedor de
Corazón, estaré muy
impresionado!
]]
}
-----------------------

-- Boomerang cave: refused Tom's help.
dialog{
  id = "lyriann_cave.tom.refuse_help",
  text = [[
Bien, como desees.
]]
}
-----------------------

-- Boomerang cave: talking to Tom again, having the Boomerang, and the maze not finished yet.
dialog{
  id = "lyriann_cave.tom.not_finished",
  question = true,
  text = [[
¿Está todo bien?
Usa mi Bumerán para
superar obstáculos.
Necesitarás llegar
a dominarlo si quieres
encontrar todos los
secretos de esta
caverna... No olvides
que el Bumerán siempre
vuelve a ti, incluso
si te has movido.

¿Qué quieres hacer?
Continuar
Devolver el Bumerán
]]
}
-----------------------

-- Boomerang cave: just gave the Boomerang back and the maze is not finished yet.
dialog{
  id = "lyriann_cave.tom.gave_boomerang_back",
  text = [[
Gracias. Vuelve a verme
de nuevo si necesitas
mi ayuda.
]]
}
-----------------------

-- Boomerang cave: trying to leave the cave with Tom's Boomerang.
dialog{
  id = "lyriann_cave.tom.leaving",
  text = [[
¡Hey! ¡Espera!
]]
}
-----------------------

-- Boomerang cave: trying to leave the cave with Tom's Boomerang (maze not finished).
dialog{
  id = "lyriann_cave.tom.leaving.cavern_not_finished",
  text = [[
¿Has terminado de
explorar? No creo que
hayas encontrado
todo...
Si no te importa,
devuélveme mi
Bumerán. ¡Necesitas
cierto nivel de 
habilidad para usarlo!
Vuelve a verme de nuevo
si necesitas mi ayuda.
]]
}
-----------------------

-- Boomerang cave: giving the Boomerang back (maze finished).
dialog{
  id = "lyriann_cave.tom.cavern_finished",
  next = "lyriann_cave.tom.see_you_later",
  text = [[
¿Resolviste el misterio
de esta caverna?
¡Impresionante!
Eres tan habilidoso
como valiente.

Si no te importa,
devuélveme mi Bumerán.
]]
}
-----------------------

-- Boomerange cave: last dialog of Tom.
dialog{
  id = "lyriann_cave.tom.see_you_later",
  text = [[
Si quieres, puedo 
echarte una mano 
durante la aventura, 
siempre que lo
necesites.
]]
}
-----------------------

-- Dungeon 1 entrance: approaching the cliff (Boomerang cave finished).
dialog{
  id = "outside_world.tom_dungeon_1_entrance.hey",
  text = [[
¡Hey!
]]
}
-----------------------

dialog{
  id = "outside_world.tom_dungeon_1_entrance.need_help",
  text = [[
¿Necesitas ayuda?
]]
}
-----------------------

dialog{
  id = "outside_world.tom_dungeon_1_entrance.let_me_see",
  text = [[
Hmmm, apuesto a que
hay una escalera
escondida aquí. Vamos
a ver...
]]
}
-----------------------

-- Tom has found a ladder and is opening the access to dungeon 1.
dialog{
  id = "outside_world.tom_dungeon_1_entrance.open",
  text = [[
Creo que puedo
moverla.
$0Voilà!
]]
}
-----------------------

dialog{
  id = "outside_world.tom_dungeon_1_entrance.finished",
  text = [[
Ten cuidado, parece
muy oscuro ahí dentro.
]]
}
-----------------------

