-- Zelda Mystery of Solarus DX:
-- English dialogs

-- ****** Contributors ******
-- Please add your name to this list if you helped.
-- These names will appear in the English localization credits
-- at the end of the game.
-- * AleX_XelA
-- * Christopho
-- * JeFF
-- * rypervenche

-- ****** Please respect the limit of each line! ******
-- 23 chars for normal lines,
-- 20 chars for dialogs with an icon or lines that are answers to a question,
-- 17 chars for lines with both an icon and an answer.
-- Each dialog ends with a comment with dashes indicating the maximum line size.
-- Please don't exceed the maximum size of lines,
-- and don't break lines too early either.
-- Don't try to reproduce the exact same lines: it's normal for dialogs to be
-- shorter or longer than in the language you are translating from.
-- It's also normal for lines to end on different words.

-- ****** Typo warning! ******
-- Remember that ponctuation characters like ! ? : ; are preceeded by a space
-- character in French and NOT in English.

-- ****** More documentation ******
-- If you have a doubt, please refer to the doc:
-- http://www.solarus-games.org/doc/latest/dialog_syntax.html
-- or just ask.

-- Thanks for your contribution!


-- Plume / Feather
dialog{
  id = "_item_description.feather.1",
  icon = 0,
  skip = "all",
  text = [[
Use the Feather to
jump over obstacles.
]]
}
--------------------

-- Bombes / Bombs
dialog{
  id = "_item_description.bombs_counter.1",
  icon = 1,
  skip = "all",
  text = [[
Use Bombs against
enemies and to
destroy obstacles.
]]
}
--------------------

-- Arc / Bow
dialog{
  id = "_item_description.bow.1",
  icon = 2,
  skip = "all",
  text = [[
You don't have any
Arrows left!
]]
}
--------------------

-- Arc & Flèches / Bow & Arrows
dialog{
  id = "_item_description.bow.2",
  icon = 3,
  skip = "all",
  text = [[
Shoot Arrows to
defeat tough
enemies.
]]
}
--------------------

-- Boomerang
dialog{
  id = "_item_description.boomerang.1",
  icon = 4,
  skip = "all",
  text = [[
Use the Boomerang to
immobilize enemies
and pick up far-away
objects.
]]
}
--------------------

-- Super Boomerang
dialog{
  id = "_item_description.boomerang.2",
  icon = 35,
  skip = "all",
  text = [[
Use the Super
Boomerang to
immobilize enemies
and pick up far-away
objects.
]]
}
--------------------

-- Lanterne / Lamp
dialog{
  id = "_item_description.lamp.1",
  icon = 5,
  skip = "all",
  text = [[
Brighten dark places
and light torches
with the Lamp, but
watch your Magic
Meter!
]]
}
--------------------

-- Grappin / Hookshot
dialog{
  id = "_item_description.hookshot.1",
  icon = 6,
  skip = "all",
  text = [[
Hoist yourself up to
inaccessible places
with the help of the
Hookshot.
]]
}
--------------------

-- Flacon Magique vide / Empty bottle
dialog{
  id = "_item_description.bottle_1.1",
  icon = 7,
  skip = "all",
  text = [[
The Magic Bottle can
hold various
substances.
]]
}
--------------------

-- Eau dans Flacon / Water in Bottle
--#Second part may need changing
dialog{
  id = "_item_description.bottle_1.2",
  icon = 8,
  skip = "all",
  text = [[
Your Magic Bottle
is filled with
water.

Use it at an
appropriate spot...
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_item_description.bottle_1.3",
  icon = 9,
  skip = "all",
  text = [[
Drink Red Potion
to fill up your
Heart Meter.
]]
}
--------------------

-- Potion verte / Red potion
dialog{
  id = "_item_description.bottle_1.4",
  icon = 10,
  skip = "all",
  text = [[
Drink Green Potion
to fill up your
Magic Meter.
]]
}
--------------------

-- Potion bleue / Red potion
dialog{
  id = "_item_description.bottle_1.5",
  icon = 11,
  skip = "all",
  text = [[
Drink Blue Potion
to fill up both your
Heart and Magic
Meters!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_item_description.bottle_1.6",
  icon = 12,
  skip = "all",
  text = [[
This Fairy will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Flacon Magique vide / Empty bottle
dialog{
  id = "_item_description.bottle_2.1",
  icon = 7,
  skip = "all",
  text = [[
The Magic Bottle can
hold various
substances.
]]
}
--------------------

-- Eau dans Flacon / Water in Bottle
dialog{
  id = "_item_description.bottle_2.2",
  icon = 8,
  skip = "all",
  text = [[
Your Magic Bottle
is filled with
water.

Use it at an
appropriate spot...
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_item_description.bottle_2.3",
  icon = 9,
  skip = "all",
  text = [[
Drink Red Potion
to fill up your
Heart Meter.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_item_description.bottle_2.4",
  icon = 10,
  skip = "all",
  text = [[
Drink Green Potion
to fill up your
Magic Meter.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_item_description.bottle_2.5",
  icon = 11,
  skip = "all",
  text = [[
Drink Blue Potion
to fill up both your
Heart and Magic
Meters!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_item_description.bottle_2.6",
  icon = 12,
  skip = "all",
  text = [[
This Fairy will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Flacon Magique vide / Empty bottle
dialog{
  id = "_item_description.bottle_3.1",
  icon = 7,
  skip = "all",
  text = [[
The Magic Bottle can
hold various
substances.
]]
}
--------------------

-- Eau dans Flacon / Water in Bottle
dialog{
  id = "_item_description.bottle_3.2",
  icon = 8,
  skip = "all",
  text = [[
Your Magic Bottle
is filled with
water.

Use it at an
appropriate spot...
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_item_description.bottle_3.3",
  icon = 9,
  skip = "all",
  text = [[
Drink Red Potion
to fill up your
Heart Meter.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_item_description.bottle_3.4",
  icon = 10,
  skip = "all",
  text = [[
Drink Green Potion
to fill up your
Magic Meter.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_item_description.bottle_3.5",
  icon = 11,
  skip = "all",
  text = [[
Drink Blue Potion
to fill up both your
Heart and Magic
Meters!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_item_description.bottle_3.6",
  icon = 12,
  skip = "all",
  text = [[
This Fairy will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Flacon Magique vide / Empty bottle
dialog{
  id = "_item_description.bottle_4.1",
  icon = 7,
  skip = "all",
  text = [[
The Magic Bottle can
hold various
substances.
]]
}
--------------------

-- Eau dans Flacon / Water in Bottle
dialog{
  id = "_item_description.bottle_4.2",
  icon = 8,
  skip = "all",
  text = [[
Your Magic Bottle
is filled with
water.

Use it at an
appropriate spot...
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_item_description.bottle_4.3",
  icon = 9,
  skip = "all",
  text = [[
Drink Red Potion
to fill up your
Heart Meter.
]]
}
--------------------

-- Potion verte / Red potion
dialog{
  id = "_item_description.bottle_4.4",
  icon = 10,
  skip = "all",
  text = [[
Drink Green Potion
to fill up your
Magic Meter.
]]
}
--------------------

-- Potion bleue / Red potion
dialog{
  id = "_item_description.bottle_4.5",
  icon = 11,
  skip = "all",
  text = [[
Drink Blue Potion
to fill up both your
Heart and Magic
Meters!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_item_description.bottle_4.6",
  icon = 12,
  skip = "all",
  text = [[
This Fairy will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Bottes de Pégase / Pegasus Shoes
dialog{
  id = "_item_description.pegasus_shoes.1",
  icon = 13,
  skip = "all",
  text = [[
Run as fast as
lightning by using
the Pegasus Shoes.
Press and hold the
Action key to run.
]]
}
--------------------

-- Miroir Mystique / Mystic Mirror
dialog{
  id = "_item_description.mystic_mirror.1",
  icon = 14,
  skip = "all",
  text = [[
The Mystic Mirror
has strange
powers...
]]
}
--------------------

-- Canne de Somaria / Cane of Somaria
--#May need "blocks" or "a block"
dialog{
  id = "_item_description.cane_of_somaria.1",
  icon = 15,
  skip = "all",
  next = "_warning_magic",
  text = [[
Create a block and
hook yourself to it
using the Hookshot.
]]
}
--------------------

-- Pommes / Apples
dialog{
  id = "_item_description.apples_counter.1",
  icon = 16,
  skip = "all",
  text = [[
Eat Apples to
recover Hearts.
]]
}
--------------------

-- Pains au Chocolat / Pains au Chocolat
dialog{
  id = "_item_description.pains_au_chocolat_counter.1",
  icon = 17,
  skip = "all",
  text = [[
Eat a Pain au
Chocolat to recover
three Hearts.
]]
}
--------------------

-- Croissant / Croissant
dialog{
  id = "_item_description.croissants_counter.1",
  icon = 18,
  skip = "all",
  text = [[
Eat a Croissant to
recover seven
Hearts.
]]
}
--------------------

-- Clé de Roc / Rock Key
dialog{
  id = "_item_description.rock_key.1",
  icon = 19,
  skip = "all",
  text = [[
The Rock Key! But
where is the right
lock ?
]]
}
--------------------

-- Clé d'Os / Bone Key
dialog{
  id = "_item_description.bone_key.1",
  icon = 20,
  skip = "all",
  text = [[
What could the Bone
Key be used for?
]]
}
--------------------

-- Clé de Terre / Earth Key
--#Check translation
dialog{
  id = "_item_description.clay_key.1",
  icon = 21,
  skip = "all",
  text = [[
The Earth Key. It
allows access to the
village's cave.
]]
}
--------------------

-- Tarte aux Pommes / Apple Pie
dialog{
  id = "_item_description.level_4_way.1",
  icon = 22,
  skip = "all",
  text = [[
This Apple Pie looks
odd...
]]
}
--------------------

-- Lingots d'or / Gold bars
dialog{
  id = "_item_description.level_4_way.2",
  icon = 23,
  skip = "all",
  text = [[
Three authentic Gold
Bars!
]]
}
--------------------

-- Edelweiss / Edelweiss
dialog{
  id = "_item_description.level_4_way.3",
  icon = 24,
  skip = "all",
  text = [[
The Edelweiss is a
very rare flower in
the Kingdom of
Hyrule.
]]
}
--------------------

-- Précis d'escrime / Tiger scrolls
dialog{
  id = "_item_description.level_4_way.4",
  icon = 25,
  skip = "all",
  text = [[
These Tiger Scrolls
will let you master
advanced sword
techniques.
]]
}
--------------------

-- Palmes / Flippers
dialog{
  id = "_item_description.flippers.1",
  icon = 26,
  skip = "all",
  text = [[
Swim in deep waters
with these flippers.
]]
}
--------------------

-- Cape magique / Magic Cape
dialog{
  id = "_item_description.magic_cape.1",
  icon = 27,
  skip = "all",
  text = [[
The Magic Cape warns
you when you are
near a weak wall.
]]
}
--------------------

-- Clé de Fer / Iron Key
dialog{
  id = "_item_description.iron_key.1",
  icon = 28,
  skip = "all",
  text = [[
The Iron Key.
Be sure to use it in
the correct lock!
]]
}
--------------------

-- Clé de Pierre / Stone Key
dialog{
  id = "_item_description.stone_key.1",
  icon = 29,
  skip = "all",
  text = [[
The Stone Key!
Let's find the right
lock!
]]
}
--------------------

-- Clé de Bois / Wooden Key
--#May need to be translated better
dialog{
  id = "_item_description.wooden_key.1",
  icon = 30,
  skip = "all",
  text = [[
The Wooden Key.
There's only one
lock for this key!
]]
}
--------------------

-- Clé de Glace / Ice Key
dialog{
  id = "_item_description.ice_key.1",
  icon = 31,
  skip = "all",
  text = [[
The Ice Key. You must
find a frozen place for
it to work!
]]
}
-----------------------

-- Poigne de Fer / Iron Glove
dialog{
  id = "_item_description.glove.1",
  icon = 32,
  skip = "all",
  text = [[
These Iron Gloves
will let you lift
rocks.
]]
}
--------------------

-- Poigne d'Or / Golden Glove
dialog{
  id = "_item_description.glove.2",
  icon = 33,
  skip = "all",
  text = [[
Lift black rocks
with these Golden
Gloves.
]]
}
--------------------

-- Pierres de Feu / Fire Stones
dialog{
  id = "_item_description.fire_stones_counter.1",
  icon = 34,
  skip = "all",
  text = [[
Find all three Fire
Stones and bring
them to Inferno.
]]
}
--------------------

-- ---------------------
-- When finding a treasure
-- ---------------------
--
-- Messages shown below are seen when the player
-- obtains a treasure, usually by opening a chest or by buying it from a
-- merchant in a shop.
--------------------

-- Plume / Feather
dialog{
  id = "_treasure.feather.1",
  icon = 0,
  skip = "all",
  text = [[
You found the
Feather!$0 Use it to
jump in place and
over obstacles!
]]
}
--------------------

-- Arc seul / Bow alone
dialog{
  id = "_treasure.bow.1",
  icon = 2,
  text = [[
You found the Bow!$0
Find some Arrows and
you will be able to
defeat tough enemies
from afar!
]]
}
--------------------

-- Arc & Flèches / Bow & Arrows
--#Choose one
dialog{
  id = "_treasure.bow.2",
  icon = 3,
  text = [[
You found the Bow!$0
You can fight tough
enemies from afar!
]]
}
--------------------

-- Boomerang
dialog{
  id = "_treasure.boomerang.1",
  icon = 4,
  text = [[
You found the
Boomerang!$0 You can
immobilize enemies
and pick up far-away
objects.
There are several 
ways of using it,
it’s up to you to
discover them all!
]]
}
--------------------

-- Super Boomerang
--#Check for better word for "ancien"
dialog{
  id = "_treasure.boomerang.2",
  icon = 35,
  text = [[
You found the
Super Boomerang!$0

It's faster and
more powerful than
the original!
]]
}
--------------------

-- Lanterne / Lamp
dialog{
  id = "_treasure.lamp.1",
  icon = 5,
  next = "_warning_magic",
  text = [[
You found the Lamp!$0
Use it to brighten
dark places and
light torches.
]]
}
--------------------

-- Grappin / Hookshot
dialog{
  id = "_treasure.hookshot.1",
  icon = 6,
  text = [[
You found the
Hookshot!$0

Immobilize your
enemies and fling
yourself to
inaccessible places!
]]
}
--------------------

-- Flacon vide / empty Bottle
dialog{
  id = "_treasure.bottle_1.1",
  icon = 7,
  text = [[
You found a
Magic Bottle!$0

Fill it with
various substances.
]]
}
--------------------

-- Eau / Water
dialog{
  id = "_treasure.bottle_1.2",
  icon = 8,
  text = [[
You filled your
Magic Bottle with
water!
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_treasure.bottle_1.3",
  icon = 9,
  text = [[
You found some Red
Potion!$0

Drink it to recover
your health.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_treasure.bottle_1.4",
  icon = 10,
  text = [[
You found some
Green Potion!$0

Drink it to recover
your magic energy.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_treasure.bottle_1.5",
  icon = 11,
  text = [[
You found some 
Blue Potion!$0

Drink it to fully
restore both your
health and magic!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_treasure.bottle_1.6",
  icon = 12,
  skip = "all",
  text = [[
You captured a
Fairy! It will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Flacon vide / Empty Flask
dialog{
  id = "_treasure.bottle_2.1",
  icon = 7,
  text = [[
You found a
Magic Bottle!$0

Fill it with
various substances.
]]
}
--------------------

-- Eau / Water
dialog{
  id = "_treasure.bottle_2.2",
  icon = 8,
  text = [[
You filled your
Magic Bottle with
water!
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_treasure.bottle_2.3",
  icon = 9,
  text = [[
You found some Red
Potion!$0

Drink it to recover
your health.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_treasure.bottle_2.4",
  icon = 10,
  text = [[
You found some
Green Potion!$0

Drink it to recover
your magic energy.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_treasure.bottle_2.5",
  icon = 11,
  text = [[
You found some 
Blue Potion!$0

Drink it to fully
restore both your
health and magic!
]]
}

--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_treasure.bottle_2.6",
  icon = 12,
  skip = "all",
  text = [[
You captured a
Fairy! It will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Flacon vide / Empty Flask
dialog{
  id = "_treasure.bottle_3.1",
  icon = 7,
  text = [[
You found a
Magic Bottle!$0

Fill it with
various substances.
]]
}
--------------------

-- Eau / Water
dialog{
  id = "_treasure.bottle_3.2",
  icon = 8,
  text = [[
You filled your
Magic Bottle with
water!
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_treasure.bottle_3.3",
  icon = 9,
  text = [[
You found some Red
Potion!$0

Drink it to recover
your health.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_treasure.bottle_3.4",
  icon = 10,
  text = [[
You found some
Green Potion!$0

Drink it to recover
your magic energy.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_treasure.bottle_3.5",
  icon = 11,
  text = [[
You found some 
Blue Potion!$0

Drink it to fully
restore both your
health and magic!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_treasure.bottle_3.6",
  icon = 12,
  skip = "all",
  text = [[
You captured a
Fairy! It will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Flacon vide / Empty Flask
dialog{
  id = "_treasure.bottle_4.1",
  icon = 7,
  text = [[
You found a
Magic Bottle!$0

Fill it with
various substances.
]]
}
--------------------

-- Eau / Water
dialog{
  id = "_treasure.bottle_4.2",
  icon = 8,
  text = [[
You filled your
Magic Bottle with
water!
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_treasure.bottle_4.3",
  icon = 9,
  text = [[
You found some Red
Potion!$0

Drink it to recover
your health.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_treasure.bottle_4.4",
  icon = 10,
  text = [[
You found some
Green Potion!$0

Drink it to recover
your magic energy.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_treasure.bottle_4.5",
  icon = 11,
  text = [[
You found some 
Blue Potion!$0

Drink it to fully
restore both your
health and magic!
]]
}
--------------------

-- Fée dans Flacon / Fairy in Bottle
dialog{
  id = "_treasure.bottle_4.6",
  icon = 12,
  skip = "all",
  text = [[
You captured a
Fairy! It will help
you in time of need.
You can also use it
whenever you want to
recover your Hearts!
]]
}
--------------------

-- Bottes de Pégase / Pegasus Boots
dialog{
  id = "_treasure.pegasus_shoes.1",
  icon = 13,
  text = [[
You found the
Pegasus Shoes!$0

Run and charge
through the toughest
enemies!
Press and hold the
Action key to use
them.
]]
}
--------------------

-- Miroir Mystique / Mystic Mirror
dialog{
  id = "_treasure.mystic_mirror.1",
  icon = 14,
  text = [[
You found the
Mystic Mirror!$0

Its strange powers
will surely be of
help in your quest.
]]
}
--------------------

-- Canne de Somaria / Cane of Somaria
dialog{
  id = "_treasure.cane_of_somaria.1",
  icon = 15,
  next = "_warning_magic",
  text = [[
You found the
Cane of Somaria!$0
You can create a
block and grab onto
it with the
Hookshot.
]]
}
--------------------

-- 3 Pommes
dialog{
  id = "_treasure.apple.1",
  icon = 16,
  text = [[
You found 3 Apples!$0
Eat them later to
recover Hearts!
]]
}
--------------------

-- 1 Pain au Chocolat
dialog{
  id = "_treasure.pain_au_chocolat.1",
  icon = 17,
  text = [[
You found a Pain au
Chocolat!$0

Eat a Pain au
Chocolat to recover
some life.
]]
}
--------------------

-- 1 Croissant
dialog{
  id = "_treasure.croissant.1",
  icon = 18,
  text = [[
You found a
Croissant!$0 It's
all crispy! Eat a
Croissant to recover
Hearts.
]]
}
--------------------

-- Clé de Roc
dialog{
  id = "_treasure.rock_key.1",
  icon = 19,
  text = [[
You found the Rock
Key!$0
]]
}
--------------------

-- Clé d'os
dialog{
  id = "_treasure.bone_key.1",
  icon = 20,
  text = [[
You found the Bone
Key!$0

But what could it be
used for?
]]
}
--------------------

-- Clé de Terre
dialog{
  id = "_treasure.clay_key.1",
  icon = 21,
  text = [[
You found the Earth
Key!$0

Now you can access
the village's cave!
]]
}
--------------------

-- Tarte aux Pommes
dialog{
  id = "_treasure.level_4_way.1",
  icon = 22,
  text = [[
You found an Apple
Pie!$0
$1...$3 Hmmm, I
wouldn't taste it
if I were you, it
looks odd...
]]
}
--------------------

-- Lingots d'or
--#Really need a better translation
dialog{
  id = "_treasure.level_4_way.2",
  icon = 23,
  text = [[
You found some
Gold Bars!!!$0

They shimmer and
are very valuable!
]]
}
--------------------

-- Edelweiss
dialog{
  id = "_treasure.level_4_way.3",
  icon = 24,
  text = [[
You found an
Edelweiss!$0

This pretty flower
from Hyrule's 
mountains is
extremely rare!
]]
}
--------------------

-- Précis d'escrime / Tiger Scrolls
dialog{
  id = "_treasure.level_4_way.4",
  icon = 25,
  text = [[
You found the Tiger
Scrolls!$0 You now
master the long
forgotten Whirlwind
Attack.
]]
}
--------------------

-- Palmes / Flippers
dialog{
  id = "_treasure.flippers.1",
  icon = 26,
  text = [[
You found the
Flippers!$0

You can now swim
in deep waters!
]]
}
--------------------

-- Cape Magique
dialog{
  id = "_treasure.magic_cape.1",
  icon = 27,
  text = [[
You found the Magic
Cape!$0

It will warn you
when you are near a
weak wall.
]]
}
--------------------

-- Clé de Fer
dialog{
  id = "_treasure.iron_key.1",
  icon = 28,
  text = [[
You found the Iron
Key!$0

Surely it must open
a door!
]]
}
--------------------

-- Clé de Pierre
dialog{
  id = "_treasure.stone_key.1",
  icon = 29,
  text = [[
You found the Stone
Key!$0

But where is the
lock it opens?
]]
}
--------------------

-- Clé de Bois
dialog{
  id = "_treasure.wooden_key.1",
  icon = 30,
  text = [[
You found the Wooden
Key!$0

You must find where
to use it!
]]
}
--------------------

-- Clé de Glace
dialog{
  id = "_treasure.ice_key.1",
  icon = 31,
  text = [[
You found the Ice
Key!$0

It must open the way
to a frozen place...
]]
}
--------------------

-- Poigne de Fer / Iron Gloves
dialog{
  id = "_treasure.glove.1",
  icon = 32,
  text = [[
You found the Iron
Gloves!$0

With these you can
lift rocks.
]]
}
--------------------

-- Poigne d'Or / Golden Gloves
--#Still sounds odd.
dialog{
  id = "_treasure.glove.2",
  icon = 33,
  text = [[
You found the Golden
Gloves!$0

Now you can lift
black rocks!
]]
}
--------------------

-- Pierre de Feu / Fire Stone
dialog{
  id = "_treasure.fire_stone.1",
  icon = 34,
  text = [[
You found a Fire
Stone!
]]
}
--------------------

-- Carte du Monde / World Map
dialog{
  id = "_treasure.world_map.1",
  icon = 50,
  text = [[
You found the
World Map !$0

View it on the Map
screen.
]]
}
--------------------

-- Grand sac de rubis / Big Wallet
dialog{
  id = "_treasure.rupee_bag.2",
  icon = 52,
  text = [[
You found the Big
Wallet!$0

It can hold up to
300 Rupees!
]]
}
--------------------

-- Sac de rubis géant / Giant Wallet
dialog{
  id = "_treasure.rupee_bag.3",
  icon = 53,
  text = [[
You found the Giant
Wallet!$0

It can hold up to
999 Rupees!
]]
}
--------------------

-- Petit sac de bombes / Small Bomb Bag
--#Bomb away vs. bombs away
dialog{
  id = "_treasure.bomb_bag.1",
  icon = 54,
  text = [[
You found the Bomb
Bag!$0 It holds 10
Bombs.
Assign them to a key
and bombs away!
]]
}
--------------------

-- Grand sac de bombes / Large Bomb Bag
dialog{
  id = "_treasure.bomb_bag.2",
  icon = 55,
  text = [[
You found the Large
Bomb Bag!$0

It can hold up to 30
Bombs instead of 10!
]]
}
--------------------

-- Sac de bombes géant / Giant Bomb Bag
dialog{
  id = "_treasure.bomb_bag.3",
  icon = 56,
  text = [[
You found the Giant
Bomb Bag!$0

It can hold up to 99
Bombs instead of 30!
]]
}
--------------------

-- Grand carquois / Large Quiver
dialog{
  id = "_treasure.quiver.2",
  icon = 58,
  text = [[
You found the 
Large Quiver!$0

It can hold up to
30 Arrows instead of
10!
]]
}
--------------------

-- Carquois géant / Giant Quiver
dialog{
  id = "_treasure.quiver.3",
  icon = 59,
  text = [[
You found the
Giant Quiver!$0

It can hold up to
99 Arrows instead of
30!
]]
}
--------------------

-- Cotte de mailles bleue / Blue Mail
dialog{
  id = "_treasure.tunic.2",
  icon = 61,
  text = [[
You found the Blue
Mail!$0
It reduces damage
taken from enemies
and resists freezing
temperatures...
]]
}
--------------------

-- Cotte de mailles rouge / Red Mail
dialog{
  id = "_treasure.tunic.3",
  icon = 62,
  text = [[
You found the Red
Mail!$0

It provides even
better protection
than the Blue Mail!
]]
}
--------------------

-- Bouclier / Shield
dialog{
  id = "_treasure.shield.1",
  icon = 63,
  text = [[
You found the
Shield!$0

You can defend
yourself from enemy
attacks!
]]
}
--------------------

-- Bouclier de Feu / Fire Shield
dialog{
  id = "_treasure.shield.2",
  icon = 64,
  text = [[
You found the
Fire Shield!$0

You are now
protected from fire
attacks!
]]
}
--------------------

-- Bouclier Miroir / Mirror Shield
dialog{
  id = "_treasure.shield.3",
  icon = 65,
  text = [[
You found the
Mirror Shield!$0

You can now reflect
lasers!
]]
}
--------------------

-- Epée 1 (Epée du courage) / First Sword
dialog{
  id = "_treasure.sword.1",
  icon = 66,
  text = [[
You found the Sword
of Courage!$0

You can cross swords
and confront your
enemies!
]]
}
--------------------

-- Epée 2 (Glaive Hylien) / Hylian Blade
dialog{
  id = "_treasure.sword.2",
  icon = 67,
  next = "_treasure.sword.2.1",
  text = [[
$1You found the
Hylian Blade!$0$0$0
This new sword
]]
}
--------------------
--#Previous one or last?

dialog{
  id = "_treasure.sword.2.1",
  text = [[
is twice as
powerful as the
previous one!
]]
}
-----------------------

-- Epée 3 (Sabre du Héros) / Hero's Sword
dialog{
  id = "_treasure.sword.3",
  icon = 68,
  next = "_treasure.sword.2.1",
  text = [[
$1You found the
Hero's Sword!$0$0$0
This new blade
]]
}
--------------------

-- Epée 4 (Lame Purificatrice) / Master Sword
dialog{
  id = "_treasure.sword.4",
  icon = 69,
  text = [[
You found the
Master Sword!$0
The power of
this ultimate
sword is beyond
everything...
]]
}
--------------------

-- Demi de magie / Half Magic Meter
dialog{
  id = "_treasure.magic_bar.2",
  icon = 99,
  text = [[
You found the Half
Magic Meter!$0

Your Magic Meter
just doubled!
]]
}
--------------------

-- Carte / Map
dialog{
  id = "_treasure.map.1",
  icon = 70,
  text = [[
You found the Map!
Use it to see the
dungeon's layout.
]]
}
--------------------

-- Boussole / Compass
dialog{
  id = "_treasure.compass.1",
  icon = 71,
  text = [[
You found the
Compass! Now you can
see your position on
the Map, the
locations of chests,
as well as the
Boss's Lair! Now
we're getting
somewhere!
]]
}
--------------------

-- Petite clé / Small key
dialog{
  id = "_treasure.small_key.1",
  icon = 72,
  text = [[
You found a Small
Key!

This key will open
a locked door in
this dungeon.
]]
}
--------------------

-- Grande Clé / Large Key
dialog{
  id = "_treasure.big_key.1",
  icon = 73,
  text = [[
You found the Large
Key!

You can now open
special doors and
find new treasures!
]]
}
--------------------

-- Clé du Maître / Boss Key
dialog{
  id = "_treasure.boss_key.1",
  icon = 74,
  text = [[
You found the Boss
Key!

Now you can enter
the Boss's Lair!
]]
}
--------------------

-- Fragment de Coeur / Piece of Heart
dialog{
  id = "_treasure.piece_of_heart.1",
  icon = 79,
  text = [[
You found a
Piece of Heart!
]]
}
--------------------

-- Réceptacle de Coeur / Heart Container
dialog{
  id = "_treasure.heart_container.1",
  icon = 80,
  text = [[
You found a Heart
Container!

Your Heart Meter
increased by one!
]]
}
--------------------

-- 1 Bombe / 1 Bomb
dialog{
  id = "_treasure.bomb.1",
  icon = 82,
  next = "_treasure.bomb.1.1",
  text = [[
You found a Bomb!$0
]]
}
--------------------

dialog{
  id = "_treasure.bomb.1.1",
  text = [[
Use a Bomb to make
an enemy or obstacle
explode.
]]
}
--------------------

-- 3 Bombes / 3 Bombs
dialog{
  id = "_treasure.bomb.2",
  icon = 82,
  next = "_treasure.bomb.1.1",
  text = [[
You found three
Bombs!$0
]]
}
--------------------

-- 8 Bombes / 8 Bombs
dialog{
  id = "_treasure.bomb.3",
  icon = 82,
  next = "_treasure.bomb.1.1",
  text = [[
You found eight
Bombs!$0
]]
}
--------------------

-- 1 Flèche / 1 Arrow
dialog{
  id = "_treasure.arrow.1",
  icon = 83,
  next = "_treasure.arrow.1.1",
  text = [[
You found an Arrow!$0
Use the Bow and
Arrows to defeat
]]
}
--------------------

dialog{
  id = "_treasure.arrow.1.1",
  text = [[
tough enemies from
afar.
]]
}
--------------------

-- 5 Flèches / 5 Arrows
dialog{
  id = "_treasure.arrow.2",
  icon = 83,
  next = "_treasure.arrow.1.1",
  text = [[
You found 5 Arrows!$0
Use the Bow and
Arrows to defeat
]]
}
--------------------

-- 10 Flèches / 10 Arrows
dialog{
  id = "_treasure.arrow.3",
  icon = 83,
  next = "_treasure.arrow.1.1",
  text = [[
You found 10 Arrows!$0
Use the Bow and
Arrows to defeat
]]
}
--------------------

-- 1 Coeur / 1 Heart
dialog{
  id = "_treasure.heart.1",
  icon = 84,
  text = [[
You found a Heart!
]]
}
--------------------

-- Petite bouteille de magie / Magic Flask
dialog{
  id = "_treasure.magic_flask.1",
  icon = 85,
  text = [[
You found a Small
Magic Jar! Your
Magic Meter is
slightly filled.
]]
}
--------------------

-- Grande bouteille de magie / Magic Jar
dialog{
  id = "_treasure.magic_flask.2",
  icon = 86,
  text = [[
You found a Large
Magic Jar! Your
Magic Meter is
greatly filled.
]]
}
--------------------

-- 1 rubis vert / 1 green rupee
dialog{
  id = "_treasure.rupee.1",
  icon = 90,
  text = [[
You found a Green
Rupee!
That's one Rupee!
]]
}
--------------------

-- 1 rubis bleu / 1 blue rupee
dialog{
  id = "_treasure.rupee.2",
  icon = 91,
  text = [[
You found a Blue
Rupee!
That's 5 Rupees!
]]
}
--------------------

-- 1 rubis rouge / 1 red rupee
dialog{
  id = "_treasure.rupee.3",
  icon = 92,
  text = [[
You found a Red
Rupee!
That's 20 Rupees!
]]
}
--------------------

-- 50 rubis / 50 rupees
-- Remarque : clin d'oeil à Link's Awakening
dialog{
  id = "_treasure.rupee.4",
  icon = 90,
  text = [[
You found 50 Rupees!
Marvelous!
]]
}
--------------------

-- 100 rubis / 100 rupees
-- Remarque : clin d'oeil à Link's Awakening
dialog{
  id = "_treasure.rupee.5",
  icon = 90,
  text = [[
You found 100
Rupees! Fantastic!
]]
}
--------------------

-- 300 rubis / 300 rupees
-- Remarque : clin d'oeil à Link's Awakening
dialog{
  id = "_treasure.rupee.6",
  icon = 90,
  text = [[
You found 300 Rupees!
How wonderful!
]]
}
--------------------

-- Potion rouge / Red potion
dialog{
  id = "_treasure.red_potion.1",
  icon = 96,
  text = [[
You found some Red
Potion!$0

Drink it to
completely restore
your life energy.
]]
}
--------------------

-- Potion verte / Green potion
dialog{
  id = "_treasure.green_potion.1",
  icon = 97,
  text = [[
You found some Green
Potion!$0

Drink it to
completely restore
your magic energy.
]]
}
--------------------

-- Potion bleue / Blue potion
dialog{
  id = "_treasure.blue_potion.1",
  icon = 98,
  text = [[
You found some Blue
Potion!$0

Drink it to restore
both your life and
magic energy.
]]
}
--------------------

-- ---------------
-- Autres messages
-- ---------------
--
-- Autres messages divers affichés par le moteur de jeu
-- Affiché à la fin des dialogues expliquant
-- que le joueur a obtenu un objet qui consomme
-- de l'énergie magique (même message que dans ALTTP)
dialog{
  id = "_warning_magic",
  text = [[
Watch your Magic
Meter!
]]
}
--------------------

-- Lorsqu'on ouvre un coffre vide
dialog{
  id = "_empty_chest",
  text = [[
This chest is empty!
Too bad!
]]
}
-----------------------

-- Lorsqu'on regarde une porte verrouillé ou un bloc verrouillé
-- et qu'on ne possède pas de Petite Clé
dialog{
  id = "_small_key_required",
  icon = 72,
  skip = "all",
  text = [[
It's locked!
]]
}
--------------------

-- Lorsqu'on regarde le grand coffre ou une porte verrouillée nécessitant la Grande Clé
-- et qu'on ne possède pas celle-ci
dialog{
  id = "_big_key_required",
  icon = 73,
  skip = "all",
  text = [[
Eh? It's locked!
If you had the Large
Key you might be
able to open it!
]]
}
--------------------

-- Lorsqu'on regarde la porte du boss sans avoir la Clé du Maître
dialog{
  id = "_boss_key_required",
  icon = 74,
  skip = "all",
  text = [[
This door leads to
the Boss's Lair!
You will need the
Boss Key to open it.
]]
}
--------------------

-- Lorsqu'on tente de soulever un buisson
-- au lieu de le couper avec l'épée
dialog{
  id = "_cannot_lift_should_cut",
  skip = "all",
  text = [[
You will need something
sharp to cut through
these bushes.
]]
}
-----------------------

-- Lorsqu'on tente de soulever une pierre
-- sans avoir de bracelet de force
-- (Clin d'oeil à Link's Awakening)
dialog{
  id = "_cannot_lift_too_heavy",
  skip = "all",
  text = [[
Darn it, this is way
too heavy!

You'll never manage
with your bare hands!
]]
}
-----------------------

-- Lorsqu'on tente de soulever une pierre vraiment lourde
-- en ayant seulement la poigne de fer
dialog{
  id = "_cannot_lift_still_too_heavy",
  skip = "all",
  text = [[
It's still too heavy
for you!
]]
}
-----------------------

-- Lorsqu'on regarde un objet vendu dans un magasin
-- (message affiché après avoir lu la description de l'objet)
dialog{
  id = "_shop.question",
  question = true,
  text = [[
Price: $v Rupees.
Buy
Don't Buy
]]
}
-----------------------

-- Lorsqu'on veut acheter un objet dans un magasin
-- mais qu'on n'a pas assez de Rubis
dialog{
  id = "_shop.not_enough_money",
  skip = "all",
  text = [[
Sorry, you don't
have enough Rupees!
]]
}
-----------------------

-- Lorsqu'on veut acheter un objet dans un magasin
-- mais qu'on a déjà le maximum de la quantité possible
-- (pour des Bombes, des Flèches, etc.)
dialog{
  id = "_shop.amount_full",
  text = [[
You are already full!
]]
}
-----------------------

-- Lorsqu'on regarde un interrupteur de cristal
dialog{
  id = "_crystal",
  skip = "all",
  text = [[
It's a crystal switch.
Try to hit it with
something...
]]
}
-----------------------

-- Lorsqu'on pénètre dans le donjon 1
dialog{
  id = "dungeon_1",
  skip = "current",
  text = [[
         Level 1
      Forest Dungeon
]]
}
-----------------------

-- Lorsqu'on pénètre dans le donjon 2
dialog{
  id = "dungeon_2",
  skip = "current",
  text = [[
         Level 2
      Roc's Cavern
]]
}
-----------------------

-- Lorsqu'on pénètre dans le donjon 3
dialog{
  id = "dungeon_3",
  skip = "current",
  text = [[
         Level 3
  Master Arbror's Den
]]
}
-----------------------

dialog{
  id = "found_piece_of_heart.first",
  icon = 75,
  text = [[
Collect four pieces
to obtain a new
Heart.
]]
}
--------------------

dialog{
  id = "found_piece_of_heart.second",
  icon = 76,
  text = [[
Two more and you'll
have another Heart.
]]
}
--------------------

dialog{
  id = "found_piece_of_heart.third",
  icon = 77,
  text = [[
Find one more and
you will have
another Heart!
]]
}
--------------------

dialog{
  id = "found_piece_of_heart.fourth",
  icon = 78,
  text = [[
You found four
Pieces of Heart. You
got an extra Heart!
]]
}
--------------------

-- Lorsqu'on trouve une Fée en ayant au moins un Flacon (même dialogue que dans ALTTP)
dialog{
  id = "found_fairy",
  icon = 81,
  skip = "current",
  next = "found_fairy.1",
  text = [[
You found a Fairy,
she's wonderful!
]]
}
--------------------

-- |--------------------___|
dialog{
  id = "found_fairy.1",
  icon = -1,
  question = true,
  text = [[
What do you want to do?
Recover your health
Keep it
]]
}
--------------------

-- Lorsqu'on veut conserver une Fée mais qu'on n'a pas de Flacon vide
dialog{
  id = "found_fairy.no_empty_bottle",
  skip = "current",
  text = [[
You don't have an empty
Bottle!
]]
}
-----------------------

-- Lorsqu'on trouve de l'eau et qu'on a un Flacon vide
dialog{
  id = "found_water",
  icon = 8,
  question = true,
  text = [[
Do you want to put
some water in your

Magic Bottle?
Yes
No
]]
}
--------------------

-- Lorsqu'on trouve de l'eau mais qu'on n'a aucun Flacon
dialog{
  id = "found_water.no_bottle",
  skip = "all",
  text = [[
There is some water
here, but you have no
way of storing it...
]]
}
-----------------------

-- Lorsqu'on trouve de l'eau et qu'on a au moins un Flacon, mais pas de Flacon vide
dialog{
  id = "found_water.no_empty_bottle",
  icon = 8,
  skip = "all",
  text = [[
There is some water
here, but you need
an empty Magic
Bottle to store
it...
]]
}
--------------------

-- Utiliser un Flacon contenant de l'eau
--#Not sure on question syntax here again
dialog{
  id = "use_bottle_with_water",
  icon = 8,
  question = true,
  text = [[
Your Magic Bottle is
filled with water.
What do you
want to do?
Pour water
Keep it
]]
}
--------------------

-- Utiliser une Pomme
dialog{
  id = "use_apples",
  icon = 16,
  question = true,
  text = [[
Eating an apple will
restore one Heart.
What do you want to
do?
Eat an apple
Nothing
]]
}
--------------------

-- Use chocolate bread
dialog{
  id = "use_pains_au_chocolat",
  icon = 17,
  question = true,
  text = [[
A Pain au Chocolat
restores three
hearts. What do you
want to do?
Eat one
Nothing
]]
}
--------------------

-- Utiliser un Croissant
dialog{
  id = "use_croissants",
  icon = 18,
  question = true,
  text = [[
A Croissant restores
seven hearts. What
do you want to do?
Eat one
Nothing
]]
}
--------------------

dialog{
  id = "torch.need_lamp",
  skip = "all",
  text = [[
There must be a way to
light this torch...
]]
}
-----------------------

-- Intro : écran noir
dialog{
  id = "intro0",
  skip = "current",
  text = [[
$2Ancient legends tell
of a magnificent
kingdom called Hyrule
that existed long ago.
The kingdom prospered
under the blessing of
three goddesses
represented in the form
of the Triforce. Seven
sages sealed the
Triforce in the
Golden Land, the
Utopian reflection of
the world. Centuries
passed...
]]
}
-----------------------
-- Intro : fresque 1
dialog{
  id = "intro1",
  skip = "current",
  text = [[
$2Many generations
later, an evil spell
seemed to threaten
Hyrule. A mysterious
sorceror named Agahnim
fought back the
darkness. Acclaimed by
the people, the King
entrusted him with a
high-ranking status.
However, the sorceror
was in fact plotting
against the royal
family. He tried to
bring back Ganondorf,
King of thieves, from a
forgotten time.
]]
}
-----------------------

-- Intro : fresque 2
dialog{
  id = "intro2",
  skip = "current",
  text = [[
$2It is said that a young
man dressed in green
went on a quest,
exploring lost temples,
traveling through
plains and valleys.
]]
}
-----------------------

-- Intro : fresque 3
dialog{
  id = "intro3",
  skip = "current",
  text = [[
$2Eventually, he who was
known as the Hero
repelled the evil.
Thanks to his courage,
he defeated Ganondorf,
who had built an
impressive pyramid
within the Golden Land.
]]
}
-----------------------

-- Intro : fresque 4
dialog{
  id = "intro4",
  skip = "current",
  text = [[
$2The young Hero then
wished for Ganondorf
to be imprisoned
forever in the Golden
Land. The King of
Hyrule, a descendant
of the Seven Sages,
cast him away by using
the seal's magic.
]]
}
-----------------------

dialog{
  id = "intro5",
  skip = "current",
  text = [[
$2But a few years
later, Hyrule's King
became ill beyond
any chance of curing.
Doctors from across
the kingdom tried to
cure him but to no
avail... The King
vanished and so did
his power. The seal
of the Seven Sages
weakened once again.
]]
}
-----------------------

-- Intro : fresque 6
dialog{
  id = "intro6",
  skip = "current",
  text = [[
$2The Hero, under the
guidance of his master
Sahasrahla, trusted
the heiress of the
royal powers, Princess
Zelda with the
Triforce.
Zelda teamed with eight
mysterious children to
shatter the Triforce
into eight fragments
and to conceal them
across the kingdom.
Peace was restored.


And so begins our
journey...
]]
}
-----------------------

-- Pancarte du village
dialog{
  id = "outside_world.village.welcome_sign",
  text = [[
         Welcome
       to Lyriann
]]
}
-----------------------

-- Dialogue avec le singe tout au début du jeu
-- _unknown car on sait qu'il va y avoir une suite, mais on ne sait pas encore laquelle
-- cela permet d'indiquer au moteur d'afficher une flèche en bas de la boîte de dialogue et non un carré
-- Suite du dialogue avec le singe, dans le cas où on n'a pas le bouclier
dialog{
  id = "outside_world.village.monkey",
  next = "_unknown",
  text = [[
Help! Everyone is
scared since the night!

The village has been
surrounded by
monsters!
]]
}
-----------------------

dialog{
  id = "outside_world.village.monkey.without_shield",
  text = [[
I do not know what is
happening, but I
wouldn't leave town
without protection.
]]
}
-----------------------

-- Suite du dialogue avec le singe, dans le cas où on a le bouclier
dialog{
  id = "outside_world.village.monkey.with_shield",
  text = [[
I do not know what is
happening, but you are
right to at least have
a Shield with you...
Be cautious!
]]
}
-----------------------

-- Dialogue avec l'enfant
dialog{
  id = "outside_world.village.grand_son_npc",
  skip = "current",
  text = [[
If you do not know
what to do at one
point in your journey,
you should go see
Grandma Lyly, she
loves giving advice
and guiding
adventurers.
She lives next to
the Rupees' House.
But I don't know
much more, I'm just
a kid!
]]
}
-----------------------

-- Dialogue avec la femme au chignon
dialog{
  id = "outside_world.village.chignon_woman",
  skip = "all",
  text = [[
When the blue icon
appears, it tells what
you can do by pressing
the Action key (space).
Depending on what you
are examining, it will
trigger several actions
such as looking,
talking, reading a sign,
lifting a vase...
Keep an eye on the icon
to know when you can 
interact with your
environment!
]]
}
-----------------------

dialog{
  id = "outside_world.village.chignon_woman_dungeons",
  skip = "all",
  text = [[
It is said that every
dungeon hides a Piece
of Heart...
Funny, isn't it ?
]]
}
-----------------------

-- Dialogue avec le vieux près de la grotte de Tom dans le village
dialog{
  id = "outside_world.village.cliff_man_npc",
  skip = "all",
  text = [[
Did you know that
you can jump off
certain cliffs ?
It could allow you
to reach particular
spots.
]]
}
-----------------------

-- Dialogue avec l'homme au chapeau vert dans le village
dialog{
  id = "outside_world.village.hat_man_npc",
  skip = "all",
  text = [[
If you are in need of
Rupees, I recommend not
going to the Rupees'
House, as you might
just end up needing
even more Rupees!
Although, you do seem
smarter than me.

Perhaps you'll do
better than me!
]]
}
-----------------------

-- Dialogue avec l'homme au chapeau vert dans le village
-- (une fois le donjon 1 terminé
dialog{
  id = "outside_world.village.hat_man_npc_waterfall",
  skip = "all",
  text = [[ 
There is supposed to be
a treasure hidden by
the waterfall behind
the ancient castle.
Do you believe it's
true ?
]]
}
-----------------------

-- Pancarte à l'entrée de la maison des rubis
dialog{
  id = "outside_world.village.rupee_house_sign",
  text = [[
   - Rupees' House -
Earn some Rupees
while having fun!
]]
}
-----------------------

-- Pancarte près de la cascade du village
-- C'est un clin d'oeil à Majora's Mask
-- dans les Marais du Sud où on trouve
-- le même type de pancarte.
dialog{
  id = "outside_world.village.waterfall_sign",
  text = [[
Please feel free to
take our fresh spring
water home with you.
        Lyriann
     Tourist Center
]]
}
-----------------------

-- Pancarte à l'entrée de la pâtisserie
dialog{
  id = "outside_world.village.cake_shop_sign",
  text = [[

         Bakery
]]
}
-----------------------

-- Pancarte à l'entrée de la boutique
dialog{
  id = "outside_world.village.shop_sign",
  text = [[

          Shop
]]
}
-----------------------

-- Message affiché quand on regarde une boîte aux lettres
dialog{
  id = "outside_world.village.letter_box",
  skip = "all",
  text = [[
Don't start looking
into what's not yours!
]]
}
-----------------------

-- Long message de la femme près de l'arbre dans le village
dialog{
  id = "outside_world.village.tree_woman",
  skip = "all",
  next = "outside_world.village.tree_woman.long_text",
  text = [[
You're lost with the
HUD? Let me explain.
The icons above to the
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman.long_text",
  question = true,
  next = "outside_world.village.tree_woman.thank_you",
  next2 = "outside_world.village.tree_woman.again",
  text = [[
left are aligned like
the keys on a keyboard
The C key is the green
icon, you use the sword
by pressing it. But
when the game is
paused, the icon
changes and tells you
that the C key is used
to save your game!
And when you're talking
to someone, it allows
you to end a
conversation. Just keep
an eye on the green
icon to know what the C
key does.
The other icons are
the keys surrounding
the C key: the orange
icon (D key) pauses the
game, the blue icon
(spacebar) is the
Action key, and the
two grey icons are the
objects assigned to the
X and V keys. So always
keep an eye on what the
icons say. Don't forget
that you can customize
the controls in the
options screen, and
that you can even play
with a gamepad!


Did you get it all?
Yes
No, I did not
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman.again",
  next = "outside_world.village.tree_woman.long_text",
  text = [[
Well, let me explain
once again, but listen
carefully this time.
The icons above to the
]]
}
-----------------------

dialog{
  id = "outside_world.village.tree_woman.thank_you",
  text = [[
Thank you for listening
to the whole
explanation!
I am really thankful!
Here, you deserve this
little gift.
]]
}
-----------------------

-- Message affiché lorsqu'on tente d'ouvrir la grotte de Tom sans avoir la Clé de Terre
dialog{
  id = "outside_world.village.clay_key_required",
  text = [[
It's locked!
]]
}
-----------------------

-- Pancarte en haut de la falaise du village
dialog{
  id = "outside_world.warning_holes_sign",
  text = [[
Beware of the holes!
]]
}
-----------------------

-- Dialogue avec l'homme qui explique comment sauvegarder
dialog{
  id = "outside_world.how_to_save_npc",
  skip = "all",
  text = [[
To save your progress,
press D to pause the
game and then press C.
Keep an eye on the
green icon!
]]
}
-----------------------

-- Pancarte dans la forêt à l'est du village
dialog{
  id = "outside_world.flower_hole_sign",
  text = [[
The hole close to the
flower isn't as
dangerous as it looks
like...
]]
}
-----------------------

-- Pancarte à l'entrée de la cabine télépathique
dialog{
  id = "outside_world.telepathic_booth_sign",
  text = [[
Telepathic Booth
]]
}
-----------------------

-- Pancarte à l'entrée du mur aux surprises
dialog{
  id = "outside_world.surprise_wall_sign",
  text = [[
 - Wall of Surprises -
Come in and try your
luck to win the
hidden treasure!
]]
}
-----------------------

-- Pancarte à l'entrée de la caverne de Billy
dialog{
  id = "outside_world.billy_cavern_sign",
  text = [[
Billy the Reckless's
cavern.
Entry Forbidden!
]]
}
-----------------------

-- Pancarte près de la Colline de Beaumont
dialog{
  id = "outside_world.beaumont_hill_sign",
  text = [[
He who will plant an
edelweiss at the top
of the Beaumont Hill,
will have a nice day.
]]
}
-----------------------

-- Le joueur plante l'edelweiss au sommet de la Colline de Beaumont
dialog{
  id = "outside_world.beaumont_hill_put_edelweiss",
  text = [[
You're planting your
edelweiss...
]]
}
-----------------------

-- Tenter d'ouvrir la grotte du jeu des coffres sans avoir la Clé de Pierre
dialog{
  id = "outside_world.stone_key_required",
  text = [[
   - Stone Lock -
It's locked!
]]
}
-----------------------

-- Tenter d'ouvrir la fin de la grotte de la fée sans avoir la Clé de Fer
dialog{
  id = "outside_world.iron_key_required",
  text = [[
    - Iron Lock -
It's locked!
]]
}
-----------------------

-- Tenter d'ouvrir la grotte de la cascade sans avoir la Clé de Bois
dialog{
  id = "outside_world.wooden_key_required",
  text = [[
    - Wooden Lock -
It's locked!
]]
}
-----------------------

-- Tenter d'ouvrir le donjon 7 sans avoir la Clé de Glace
dialog{
  id = "outside_world.ice_key_required",
  text = [[
   - Ice Lock -
It's locked!
]]
}
-----------------------

-- Cascade au nord-est des montagnes
dialog{
  id = "outside_world.mountain_riverfall",
  skip = "all",
  text = [[
There must be a way
to go through this
waterfall...
]]
}
-----------------------

-- Link qui entend Sahasrahla en rêve en dormant dans son lit après l'intro
dialog{
  id = "link_house.dream",
  text = [[
... $v...
It's me...
... Sahasrahla...
I have... to speak...
Come quickly, $v...
]]
}
-----------------------

-- Jeu du coffre-mystère dans la maison des rubis
dialog{
  id = "rupee_house.game_1.intro",
  question = true,
  text = [[
Welcome to the mystery
chest game. Pay 20
Rupees to open one
of the three chests
and stand a chance of
earning more rupees!
Do you want to play?
Yes
No
]]
}
-----------------------

-- Coffre-mystère : quand on parle au vendeur après avoir déjà payé
dialog{
  id = "rupee_house.game_1.choose_chest",
  text = [[
Off you go now, choose
a chest!

Quit staring at me,
I won't tell you
which one to choose!
]]
}
-----------------------

-- Coffre-mystère : quand on accepte de jouer
dialog{
  id = "rupee_house.game_1.good_luck",
  text = [[
Good luck!
]]
}
-----------------------

-- Coffre-mystère : quand on a déjà trop gagné pour avoir le droit de rejouer
dialog{
  id = "rupee_house.game_1.not_allowed_to_play",
  text = [[
You've already won
haven't you? We are
ruined because of you!
]]
}
-----------------------

-- Coffre-mystère : veut-on rejouer ?
dialog{
  id = "rupee_house.game_1.play_again_question",
  question = true,
  text = [[
Do you want to play
again?

It's 20 Rupees!
Yes
No
]]
}
-----------------------

-- Coffre-mystère : quand on refuse de jouer
-- C'est un clin d'oeil à Link's Awakening, dans le stand
-- de pêche tout au début du jeu, quand on refuse de jouer ou de rejouer
-- English Translation taken from the actual LA text dump.
-- http://www.zeldalegends.net/files/emulation/dumps/zelda4/usa/z4dump(usa).html
dialog{
  id = "rupee_house.game_1.not_playing",
  text = [[
You have to have more
passion!
Live a little!
]]
}
-----------------------

-- Jeu du bandit manchot dans la maison des rubis
dialog{
  id = "rupee_house.game_2.intro",
  question = true,
  text = [[
Welcome to the
brand-new slot machine!
Put in 5 or 20 rupees
and try your best to
align three of the
same same symbol to
win several times
what you put in!

Do you want to play?
Yes
No
]]
}
-----------------------

-- Bandit manchot : quand on refuse de jouer
dialog{
  id = "rupee_house.game_2.not_playing",
  text = [[
Next time then...
]]
}
-----------------------

-- Bandit manchot : quand on accepte de jouer
dialog{
  id = "rupee_house.game_2.choose_bet",
  question = true,
  text = [[
How much do you bet?
5 Rupees
20 Rupees
]]
}
-----------------------

-- Bandit manchot : quand on a choisi une des deux sommes à miser
-- et qu'on a effectiement assez d'argent
dialog{
  id = "rupee_house.game_2.just_paid",
  next = "rupee_house.game_2.playing",
  text = [[
Thanks!
]]
}
-----------------------

-- Bandit manchot : quand on reparle au vendeur pendant que les roulettes tournent déjà
dialog{
  id = "rupee_house.game_2.playing",
  text = [[
Stand next to the
roulettes and press the
Action key to stop
them.
Good luck!
]]
}
-----------------------

-- Bandit manchot : quand on obtient 3 symboles identiques qui ne rapportent rien d'exceptionnel
dialog{
  id = "rupee_house.game_2.reward.same_any",
  text = [[
Three identical
symbols, not bad!
You win 4 times your
bet.
]]
}
-----------------------

-- Bandit manchot : quand on obtient 3 symboles de rubis verts
dialog{
  id = "rupee_house.game_2.reward.green_rupees",
  text = [[
Three green Rupees,
nice! You get 5 times
your bet.
]]
}
-----------------------

-- Bandit manchot : quand on obtient 3 symboles de rubis bleus
dialog{
  id = "rupee_house.game_2.reward.blue_rupees",
  text = [[
Three blue Rupees!
Congratulations, you
are off with 7 times
your initial bet!
]]
}
-----------------------

-- Bandit manchot : quand on obtient 3 symboles de rubis rouges
dialog{
  id = "rupee_house.game_2.reward.red_rupees",
  text = [[
Three red Rupees!!!
That's astonishing!
You earn no less than
10 times your bet!
]]
}
-----------------------

-- Bandit manchot : quand on obtient 3 symboles de rubis différents
dialog{
  id = "rupee_house.game_2.reward.different_rupees",
  text = [[
Wow!!! You got three
Rupees of different
color, it doesn't
happen every day!
The reward amounts to
15 times your bet.
]]
}
-----------------------

-- Bandit manchot : quand on obtient 3 symboles Yoshi (c'est la récompense maximale)
dialog{
  id = "rupee_house.game_2.reward.yoshi",
  text = [[
$1...$3Three Yoshi?!
I-n-c-r-e-d-i-b-l-e!
That's the best
possible combination...
Your initial bet is
multiplied by 20.
]]
}
-----------------------

-- Bandit manchot : quand on n'obtient rien
dialog{
  id = "rupee_house.game_2.reward.none",
  question = true,
  text = [[
Tough luck, you didn't
make any combination.

Want to try again?
Yes
No
]]
}
-----------------------

-- Jeu du labyrinthe dans la maison des rubis
dialog{
  id = "rupee_house.game_3.intro",
  question = true,
  text = [[
Navigate through the
maze before the time
is out. You may have
to push blocks along
the way to open up a
passage. You could win
a Piece of Heart, and 
I heard those are
pretty rare...
It's 10 Rupees only.


Do you want to play?
Yes
No
]]
}
-----------------------

-- Jeu du labyrinthe : quand on accepte de jouer et qu'on a assez d'argent
dialog{
  id = "rupee_house.game_3.go",
  text = [[
Here we go!
Good luck!
]]
}
-----------------------

-- Jeu du labyrinthe : quand on refuse de jouer
dialog{
  id = "rupee_house.game_3.not_playing",
  text = [[
It's your choice...
]]
}
-----------------------

-- Jeu du labyrinthe : quand on parle au vendeur alors qu'on a déjà obtenu le fragment de coeur
dialog{
  id = "rupee_house.game_3.not_allowed_to_play",
  text = [[
Sorry, you already beat
this game!
]]
}
-----------------------

-- Jeu du labyrinthe : quand on parle au vendeur alors que le jeu est déjà commencé
dialog{
  id = "rupee_house.game_3.restart_question",
  question = true,
  text = [[
You want to restart
from the beginning?

That will be 10 rupees.
Yes
No
]]
}
-----------------------

-- Maison des rubis : quand on n'a pas assez d'argent (quel que soit le jeu)
dialog{
  id = "rupee_house.not_enough_money",
  text = [[
You don't have enough
money!
]]
}
-----------------------

-- Maison des rubis : quand on interagit avec le jeu sans avoir payé (coffre-mystère et bandit manchot)
dialog{
  id = "rupee_house.pay_first",
  text = [[
Hey! You have to pay if
you want to play here!
]]
}
-----------------------

-- Maison des rubis dévalisée (PNJ de gauche)
dialog{
  id = "rupee_house_broken.help_us_left",
  text = [[
Help!
Help!

The house has been
robbed!
]]
}
-----------------------

-- Maison des rubis dévalisée (PNJ du milieu)
dialog{
  id = "rupee_house_broken.help_us_middle",
  text = [[
The bandits stole
the Rupees used to
pay the gains!
]]
}
-----------------------

-- Maison des rubis dévalisée (PNJ de droite)
dialog{
  id = "rupee_house_broken.help_us_right",
  text = [[
The culprits were
headed towards the
blacksmith's cave!
]]
}
-----------------------

-- Maison des rubis dévalisée (voleurs battus)
dialog{
  id = "rupee_house_broken.thanks",
  text = [[
You found our Rupees!
Thanks to you, we are
going to get our
business back up and
running. I don't know
how to repay you...
]]
}
-----------------------

dialog{
  id = "rupee_house_broken.thanks_again",
  text = [[
Thanks again!
]]
}
-----------------------

-- Dialogue chez la grand-mère (au début du jeu)
dialog{
  id = "grandma_house.sword",
  skip = "all",
  text = [[
Monsters are lurking
in the field. That's
not a good sign: I am
certain that something
terrible has happened.

You are looking for a
sword? With my age, I
wouldn't know what to
do with such things...
You had better go see
the blacksmith in the
cave to the northwest
of the village. He is
a bit grumpy but he
will be able to help
you.
]]
}
-----------------------

-- Dialogue chez la grand-mère (après avoir obtenu l'épée)
dialog{
  id = "grandma_house.find_sahasrahla",
  skip = "all",
  text = [[
With this sword, you
can slash through the
bushes protecting the
village. You are
looking for Sahasrahla
the Ancient, are you
not?
His house is southwest
of here, close to the
bakery. You did not
remember that?
]]
}
-----------------------

-- Dialogue chez la grand-mère (après avoir obtenu la clé de terre)
dialog{
  id = "grandma_house.go_lyriann_cave",
  skip = "all",
  text = [[
This key allows you to
get inside the cavern
located north of the
village.
]]
}
-----------------------

-- Dialogue chez la grand-mère (après avoir fini la grotte de Tom)
-- GoNintendo What are YOU waiting for?
dialog{
  id = "grandma_house.go_dungeon_1",
  skip = "all",
  text = [[
One of the four
children who was
kidnapped may be held
in a gloomy dungeon in
the forest down south
to the village. What
are YOU waiting for?
]]
}
-----------------------

-- Dialogue chez la grand-mère (après avoir fini le donjon 1)
dialog{
  id = "grandma_house.go_back_sahasrahla",
  skip = "all",
  text = [[
This time it goes
beyond my knowledge.
Sahasrahla would be
of better help.
]]
}
-----------------------

-- Dialogue chez la grand-mère (après avoir obtenu l'arc)
dialog{
  id = "grandma_house.go_twin_caves",
  skip = "all",
  text = [[
So you found a Bow?
I believe you could
access the twin caves
to the south, and
unveil the secrets
they withhold.
Go for them!
]]
}
-----------------------

-- Dialogue chez la grand-mère (après avoir obtenu la clé de roc)
dialog{
  id = "grandma_house.go_dungeon_2",
  skip = "all",
  text = [[
What a nice key you
are holding! Isn't it
time for you to look
for the second lost
child?
]]
}
-----------------------

dialog{
  id = "grandma_house.go_telepathic_booth",
  skip = "all",
  text = [[
What is that you say?
I can't hear you well!
Come my age, my ears
are not working as
well as they used to...
How about communicating
through telepathy?
Modern and more
convenient for my
elder body.
]]
}
-----------------------

dialog{
  id = "grandma_house.dark_world_enabled",
  skip = "all",
  text = [[
Agahnim seized control
of the kingdom...
Evil grows along his
path. One of the
castle's soldiers, Tom,
is considered guilty of
having taken Sahasrahla
away, but that is not
possible!
Moreover some culprits
ransacked the Rupees'
House!
]]
}
-----------------------

dialog{
  id = "telepathic_booth.not_working",
  skip = "all",
  text = [[
Hello? ... Hello? ...
Anybody there? ...
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_sahasrahla",
  skip = "all",
  text = [[
$v, do you hear me?
It's Grandma Lyly!
Telepathy, it works!
You should pay a visit
to Sahasrahla, he has
things for you.
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_twin_caves",
  skip = "all",
  text = [[
$v, do you hear me?
It's Grandma Lyly!
Telepathy, it works!
Something tells me that
the twin caves south to
the forest dungeon,
hide an important
treasure...
]]
}
-----------------------

dialog{
  id = "telepathic_booth.dungeon_2_not_really_finished",
  skip = "all",
  text = [[
$v, do you hear me?
It's Grandma Lyly!
Telepathy, it works!
But are you sure that
you found everything
in Roc's Cavern?
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_master_arbror",
  skip = "all",
  text = [[
$v, do you hear me?
It's Grandma Lyly!
Telepathy, it works!
It seems there is a
path through the trees
north of here.
Master Arbror is said
to haunt the land
flooded by the river.
]]
}
-----------------------

dialog{
  id = "telepathic_booth.go_billy",
  skip = "all",
  text = [[
$v, do you hear me?
It's Grandma Lyly!
Telepathy, it works!
Do you know Billy the
Reckless? It appears
he came back safe and
sound from his journey
to Mount Terror!
]]
}
-----------------------

dialog{
  id = "telepathic_booth.shop",
  skip = "all",
  text = [[
$v, do you hear me?
It's Grandma Lyly!
Telepathy, it works!
But times are hard.
Desolation has spread
across the devastated
kingdom... It is as if
life itself had come
to a halt.
Except for the town's
shop! Ever since they
only sell weapons for
survival and are making
real Rupees!
]]
}
-----------------------

-- Dialogue avec le forgeron
dialog{
  id = "smith_cave.without_sword",
  question = true,
  text = [[
I forged this great
bronze Sword with my
bare hands.
You can have it for
only 75 Rupees!

With your shield alone
you won't get far.

So, interested?
Yes
No
]]
}
-----------------------

-- Dialogue avec le forgeron: quand on a déjà acheté l'épée
dialog{
  id = "smith_cave.with_sword",
  text = [[
Don't go and break my
Sword because I won't
forge you another one!
]]
}
-----------------------

-- Dialogue avec le forgeron: quand on refuse d'acheter l'épée
dialog{
  id = "smith_cave.not_buying",
  text = [[
Up to you, but don't
come back here crying
if you get in serious
trouble.
]]
}
-----------------------

-- Dialogue avec le forgeron : quand on n'a pas assez d'argent
dialog{
  id = "smith_cave.not_enough_money",
  text = [[
Are you trying to rip
me off? You don't have
enough Rupees!
]]
}
-----------------------

-- Dialogue avec le forgeron : quand on achète l'épée
dialog{
  id = "smith_cave.thank_you",
  text = [[
Thanks a lot. To swing
your sword, press C. Or
hold the C key to
launch a spin attack!
]]
}
-----------------------

-- Boutique : quand on parle au vendeur
dialog{
  id = "lyriann_shop.salesman",
  text = [[
Welcome. Choose the
item you wish to buy.
]]
}
-----------------------

-- Boutique : quand on regarde les pommes
dialog{
  id = "lyriann_shop.apples",
  next = "_unknown",
  text = [[
Three freshly picked
apples from this
morning!
Each apple restores a
Heart.
]]
}
-----------------------

-- _unknown car c'est le moteur qui se chargera de la suite pour gérer la vente
-- cela permet d'afficher une flèche en bas de la boîte de dialogue au lieu du carré
-- Boutique : quand on regarde la lanterne
dialog{
  id = "lyriann_shop.lamp",
  next = "_unknown",
  text = [[
A Lamp.
Travel through dark
places!
]]
}
-----------------------

-- Boutique : quand on regarde le coeur
dialog{
  id = "lyriann_shop.heart",
  next = "_unknown",
  text = [[
A Heart to be used
right now.
]]
}
-----------------------

-- Boutique : quand on regarde le sac de bombes 2 ou 3
dialog{
  id = "lyriann_shop.bomb_bag",
  next = "_unknown",
  text = [[
A bigger Bomb Bag.
Really fashionable
nowadays!
]]
}
-----------------------

-- Boutique : quand on regarde le carquois 2 ou 3
dialog{
  id = "lyriann_shop.quiver",
  next = "_unknown",
  text = [[
A larger Quiver.
Useful in these times.
]]
}
-----------------------

-- Boutique : quand on regarde le sac de rubis 2
dialog{
  id = "lyriann_shop.rupee_bag",
  next = "_unknown",
  text = [[
A new Wallet to carry
more Rupees.
]]
}
-----------------------

-- Pâtisserie : quand on parle à la vendeuse
dialog{
  id = "cake_shop.seller.choose_item",
  text = [[
Welcome. Choose the
pastry you wish to buy.
]]
}
-----------------------

-- Pâtisserie : quand on regarde le pain au chocolat
dialog{
  id = "cake_shop.pain_au_chocolat",
  next = "_unknown",
  text = [[
A delicious Pain au
Chocolat that will
restore three Hearts.
]]
}
-----------------------

-- Pâtisserie : quand on regarde les croissants
dialog{
  id = "cake_shop.croissant",
  next = "_unknown",
  text = [[
This crispy croissant
will restore seven
Hearts.
]]
}
-----------------------

-- Pâtisserie : quand on regarde la tarte aux pommes
dialog{
  id = "cake_shop.apple_pie",
  next = "_unknown",
  text = [[
An Apple Pie.
Baked with your help!
]]
}
-----------------------

-- Pâtisserie : quand on est sur le point de partir
dialog{
  id = "cake_shop.dont_leave",
  question = true,
  text = [[
Hey, wait!
I am looking for apples
to bake an apple pie.
Six apples should do
it.

Do you want to help?
Yes
No
]]
}
-----------------------

-- Pâtisserie : quand on parle à la vendeuse une fois qu'elle a déjà parlé des pommes
dialog{
  id = "cake_shop.seller.ask_apples_again",
  skip = "all",
  question = true,
  text = [[
I am still looking for
six apples to bake a
great apple pie.
Do you want to help?
Yes
No
]]
}
-----------------------

-- Pâtisserie : quand on accepte d'aider la vendeuse en ayant des pommes mais pas assez
dialog{
  id = "cake_shop.not_enough_apples",
  text = [[
Oh, you don't have
eneough apples... Come
back later then.
]]
}
-----------------------

-- Pâtisserie : quand on accepte d'aider la vendeuse sans avoir de pommes
dialog{
  id = "cake_shop.no_apples",
  text = [[
Thank you... Come back
to see me if you find
some!
]]
}
-----------------------

-- Pâtisserie : quand on accepte d'aider la vendeuse en ayant assez de pommes
dialog{
  id = "cake_shop.thank_you",
  text = [[
Oh, thank you, how nice
of you!

I'm sorry I only have
this empty Bottle...

It's a small reward but
I'm sure you will make
good use of it.
]]
}
-----------------------

-- Chez Sahasrahla : première visite
dialog{
  id = "sahasrahla_house.beginning",
  next = "sahasrahla_house.beginning.12",
  text = [[
Oh, $v, you heard my
call.
I have important things
to say. We are in
critical times.
Four of the eight
Solarus' children have
been kidnapped...
I fear the Triforce is
in great danger.
Someone wants to
benefit from the King's
death and get ahold of
the Triforce.
Who could have done
that?
Surely Ganondorf and
his minions...
The Seal of the Seven
Sages weakened after
our poor King's death.
Ganon would have
managed to escape from
the Dark World?
We must not let him
acquire such power!
I can feel the courage
in you, $v.
Do you feel capable of
traveling through the
most dangerous places
of this land to rescue
the children and to
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.beginning.12",
  skip = "none",
  question = true,
  next = "sahasrahla_house.beginning.thanks",
  next2 = "sahasrahla_house.beginning.insisting",
  text = [[
protect the Triforce?
I am up to it!
Never
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.beginning.insisting",
  question = true,
  next = "sahasrahla_house.beginning.thanks",
  next2 = "sahasrahla_house.beginning.insisting",
  text = [[
$v, I must insist,
you are our only hope
to protect the
kingdom...
Alright
No way
]]
}
-----------------------

-- Chez Sahasrahla : quand on accepte la demande
dialog{
  id = "sahasrahla_house.beginning.thanks",
  next = "sahasrahla_house.give_world_map",
  text = [[
I knew I could count
on your courage.
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.give_world_map",
  text = [[
Here's a little item
that you will find
useful on your tale...
]]
}
-----------------------

-- Chez Sahasrahla : quand on lui reparle après avoir accepté
dialog{
  id = "sahasrahla_house.quest_accepted",
  text = [[
You should check out
the cave, I store some
objects that you could
use. Nothing too fancy
I guess, it's been a
while since I went back
there...
]]
}
-----------------------

-- Chez Sahasrahla : quand on lui reparle après avoir fini le donjon 1
dialog{
  id = "sahasrahla_house.dungeon_1_finished",
  next = "sahasrahla_house.go_grandma",
  text = [[
Good job, you managed
to overcome the
challenges of the
forest dungeon. Before
resuming your journey,
go back to my cave,
perhaps new items found
their way there.
]]
}
-----------------------

-- Chez Sahasrahla : quand on regarde sa bibliothèque
dialog{
  id = "sahasrahla_house.memories",
  question = true,
  next = "sahasrahla_house.memories.read",
  text = [[
Sahasrahla's memories.


Read them?
Yes
No
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.memories.read",
  text = [[
That's way too long!
]]
}
-----------------------

-- Chez Sahasrahla : quand on lui reparle après avoir vu la porte gelée dans la cave
dialog{
  id = "sahasrahla_house.frozen_door_advice",
  skip = "all",
  text = [[
The door is frozen?
Try to melt the ice
with some water.
]]
}
-----------------------

-- Chez Sahasrahla : dialogue par défaut quand il n'a rien de spécial à dire pour guider le joueur
dialog{
  id = "sahasrahla_house.default",
  skip = "all",
  next = "sahasrahla_house.go_grandma",
  text = [[
I have faith in you.
Courage and wisdom will
guide you.
]]
}
-----------------------

dialog{
  id = "sahasrahla_house.go_grandma",
  text = [[
If you are lost during
your adventure, go
visit Grandma Lyly,
east of the village.
She's an old friend
and knows everything
about the area.
]]
}
-----------------------

-- Cave de Sahasrahla : quand on regarde la porte gelée
dialog{
  id = "sahasrahla_house.frozen_door",
  skip = "all",
  text = [[
This door is frozen.
There must be a way to
melt the ice!
]]
}
-----------------------

-- Grotte de Tom : premier dialogue avec Tom
dialog{
  id = "lyriann_cave.tom.first_time",
  question = true,
  next2 = "lyriann_cave.tom.refuse_help",
  text = [[
Hello, young
adventurer. I am Tom,
an ex-guard of our late
King. I didn't think
anyone would find me
here. What are you doing
in this gloomy cavern?
What? The Triforce is
danger? $0None of this
would have happened if
our King were still
here to protect it...
You're trying to solve
the mysteries of this
cavern?  This place is
overflowing with
riddles, treasure, and
danger. You seem very
courageous!
Please, accept my
help... I have failed,
I wasn't able to
protect our King.
Give me a chance to
make it up!


Do you accept my help?
Yes
No
]]
}
-----------------------

-- Grotte de Tom : quand on lui reparle sans avoir son Boomerang,
-- car on a refusé son aide ou bien on lui a déjà rendu le Boomerang mais sans finir la grotte
dialog{
  id = "lyriann_cave.tom.not_first_time",
  question = true,
  next2 = "lyriann_cave.tom.refuse_help",
  text = [[
Young explorer, accept
my help. I have failed,
I wasn't able to
protect our King.
Give me a chance to
make it up!  Will you
accept my help?
Yes
No
]]
}
-----------------------

-- Grotte de Tom : quand on accepte son aide
--#I'm not extremely happy with this translation
--#"If you manage...impressed!" Too word for word.
dialog{
  id = "lyriann_cave.tom.accept_help",
  text = [[
Thank you. I can lend
you this, I hope it
will be useful.
Don't forget to return
it to me once you have
finished.
If you manage to obtain
the Heart Container, I
will be very impressed!
]]
}
-----------------------

-- Grotte de Tom : quand on refuse son aide
dialog{
  id = "lyriann_cave.tom.refuse_help",
  text = [[
Fine, as you wish.
]]
}
-----------------------

-- Grotte de Tom : quand on lui reparle en ayant son Boomerang et sans avoir fini la grotte
dialog{
  id = "lyriann_cave.tom.not_finished",
  question = true,
  text = [[
Is everything all
right? Use my Boomerang
to overcome obstacles.
You'll need to attain a
level of mastery over
it if you want to find
all the secrets in this
cavern...  Don't forget
that the Boomerang
always comes back to
you, even if you move.

What do you want to do?
Continue
Return the Boomerang
]]
}
-----------------------

-- Grotte de Tom : quand on vient de lui rendre son Boomerang sans avoir fini la grotte
dialog{
  id = "lyriann_cave.tom.gave_boomerang_back",
  text = [[
Thank you. Come see me
again if you would like
my help.
]]
}
-----------------------

-- Grotte de Tom : quand on tente de quitter la grotte sans lui avoir rendu son Boomerang
dialog{
  id = "lyriann_cave.tom.leaving",
  text = [[
Hey! Wait!
]]
}
-----------------------

-- Grotte de Tom : quand on tente de quitter la grotte sans lui avoir rendu son Boomerang
-- et sans avoir trouvé le Réceptacle de Coeur
dialog{
  id = "lyriann_cave.tom.leaving.cavern_not_finished",
  text = [[
You've already finished
exploring? I don't
think you have found
everything... If you
don't mind, I'll be
taking my Boomerang
back. You need a level
of skill to be able to
use it! Come see me
again if you would like
my help.
]]
}
-----------------------

-- Grotte de Tom : quand on a trouvé le Réceptacle de Coeur (et donc
-- fini la grotte) mais qu'on ne lui a pas encore rendu son Boomerang,
-- que ce soit en lui parlant directement ou en tentant de quitter la grotte
dialog{
  id = "lyriann_cave.tom.cavern_finished",
  next = "lyriann_cave.tom.see_you_later",
  text = [[
You solved the
mysteries of this
cavern? Impressive!
You are just as skilled
as you are courageous.

If you don't mind, I'll
be taking my Boomerang
back.
]]
}
-----------------------

-- Grotte de Tom : fin du dialogue ci-dessus
-- et également quand on vient le revoir à nouveau après
-- avoir fini la grotte et rendu le Boomerang
--#Slightly awkward translation
dialog{
  id = "lyriann_cave.tom.see_you_later",
  text = [[
If you like, I can come
give you a hand during
your adventures, if
ever you are in need.
]]
}
-----------------------

-- Entrée du donjon 1 : quand on s'approche
-- de la falaise en ayant fini la grotte de Tom
dialog{
  id = "outside_world.tom_dungeon_1_entrance.hey",
  text = [[
Hey!
]]
}
-----------------------

dialog{
  id = "outside_world.tom_dungeon_1_entrance.need_help",
  text = [[
Do you need any help?
]]
}
-----------------------

dialog{
  id = "outside_world.tom_dungeon_1_entrance.let_me_see",
  text = [[
Hmmm, I bet there is a
ladder hidden here.
Let's see...
]]
}
-----------------------

-- Tom has found a ladder and is opening the access to dungeon 1
dialog{
  id = "outside_world.tom_dungeon_1_entrance.open",
  text = [[
I think I can move it.
$0Voila!
]]
}
-----------------------

dialog{
  id = "outside_world.tom_dungeon_1_entrance.finished",
  text = [[
Be careful, it looks
ominous in there.
]]
}
-----------------------

dialog{
  id = "dungeon_1.solarus_child",
  text = [[
$2$v... Thank you. You
saved my life. I am one
of the eight protectors
called forth by
Princess Zelda. We are
devoted to watching
over the remains of the
holy relic, the
Triforce, creed left by
the three goddesses
after the creation of
your world. Throughout
the millennia, the
Triforce, although
source of life and
prosperity, was also
the source of great
greed and constant
struggles between the
forces of good and
evil. Even today, the
holy relic is in
danger. However,
history repeats itself.
Wherever there is
danger, there is a hero
whose courage drives
the Darkness away. Find
my brothers and
discover who is behind
all of this, before the
forces of Darkness
plunge Hyrule into
chaos...
May the hero bring
peace and prosperity
to the Kingdom!
]]
}
-----------------------

-- Message affiché lorsqu'on tente d'ouvrir la porte d'entrée
-- du donjon 2 sans avoir la Clé de Roc
dialog{
  id = "outside_world.rock_key_required",
  text = [[
It's locked!
]]
}
-----------------------

dialog{
  id = "dungeon_2.eye_hint",
  skip = "all",
  text = [[
Both eyes must be
pierced.
]]
}
-----------------------

dialog{
  id = "dungeon_2.eye_2_hint",
  skip = "all",
  text = [[
Both eyes must be
pierced with
perseverance.
]]
}
-----------------------

dialog{
  id = "dungeon_2.code_hint",
  skip = "all",
  text = [[
       F | B | E 
      ---|---|---
       C | D | A 
]]
}
-----------------------

dialog{
  id = "fairy_cave.first_time",
  text = [[
Welcome, young man,
full of wisdom. I have
been awaiting your
arrival. I am the
Enchanting Fairy. You,
who watch over justice,
allow me to present you
with this gift...

You have proven in the
past that you deserve
it.
]]
}
-----------------------

dialog{
  id = "fairy_cave.restore_health",
  text = [[
Welcome, young man,
full of wisdom.

I am the Enchanting
Fairy. Close your eyes
and relax.
]]
}
-----------------------

dialog{
  id = "north_fairy_fountain.first_time",
  text = [[
Welcome, young man,
filled with courage.
I have been awaiting
your arrival. I am the
Traveling Fairy. You,
who travel the world to
fight evil
relentlessly, allow me
to pass on to you an
ancient technique...
]]
}
-----------------------

dialog{
  id = "north_fairy_fountain.restore_health",
  text = [[
Welcome, young man,
filled with courage.

I am the Traveling
Fairy. Close your eyes
and relax.
]]
}
-----------------------

dialog{
  id = "mountain_cave.mountain_sign",
  skip = "all",
  text = [[
    Mount Terror
        --->
]]
}
-----------------------

dialog{
  id = "mountain_cave.not_much_done",
  skip = "all",
  text = [[
If you are reading this,
then you haven't gotten
very far.
]]
}
-----------------------

dialog{
  id = "mountain_cave.patience",
  skip = "all",
  text = [[
Patience is the virtue
of a true hero.
 - Author unknown (?) -
]]
}
-----------------------

dialog{
  id = "mountain_cave.almost_done",
  skip = "all",
  text = [[
The worst is yet to
come.
]]
}
-----------------------

dialog{
  id = "outside_world.old_castle_sign",
  skip = "all",
  text = [[

     Ancient Castle
         <---
]]
}
-----------------------

dialog{
  id = "billy_cave.hello",
  skip = "current",
  text = [[
I hope you have come
with something worth
doing if you dare enter
my cavern. I am Billy
the Reckless, the
greatest adventurer of
all time.


During my expedition to
Mount Terror, I brought
back a priceless
treasure. Even Princess
Zelda would not have
been able to find it.
It's an extremely rare
plant.

I am the only living
soul to have one in his
possession. I cleared
all of the obstacles of
Mount Terror, faced
every danger, and
walked away unscathed.


It is heroically so
that I found this
flower of extreme
value: an edelweiss!
]]
}
-----------------------

dialog{
  id = "billy_cave.what_do_you_have",
  skip = "current",
  next = "_unknown",
  text = [[
Don't expect me to give
you my edelweiss for
free. I confronted the
dangers of Mount Terror
to find it. If you
don't have anything of
value to give me, then
run along.
]]
}
-----------------------

dialog{
  id = "billy_cave.without_golden_bars",
  question = true,
  text = [[
What will you give me?
A croissant
An apple pie
]]
}
-----------------------

dialog{
  id = "billy_cave.with_golden_bars",
  question = true,
  text = [[
What will you give me?
Gold bars
An apple pie
]]
}
-----------------------

dialog{
  id = "billy_cave.give_croissant_without",
  text = [[
You don't even have a
croissant! Thief!
]]
}
-----------------------

dialog{
  id = "billy_cave.give_croissant",
  text = [[
A croissant?
Are you kidding me?
]]
}
-----------------------

dialog{
  id = "billy_cave.give_apple_pie_without",
  text = [[
Pfft! You don't even
have any apple pies!
]]
}
-----------------------

dialog{
  id = "billy_cave.give_apple_pie",
  text = [[
No thanks, that's far
from fair...
]]
}
-----------------------

dialog{
  id = "billy_cave.give_golden_bars",
  text = [[
What? You have gold
bars?$1...
$0...$0....................
$3Deal!
Here, take your stupid
flower...
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.closed",
  text = [[
If you give me
something to eat, I'll
let you on the other
side of this wall.
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.give_me_apple_pie",
  question = true,
  text = [[
Give me that apple pie!


Well?
OK
No way
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.open",
  text = [[
Some people believe
there is treasure
behind this wall, but
I've never found any.
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_guy.thanks",
  next = "outside_world.surprise_wall_guy.open",
  text = [[
Super! I'll eat the pie
in appreciation.
]]
}
-----------------------

dialog{
  id = "outside_world.surprise_wall_closed",
  text = [[
It's closed!
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_0",
  text = [[

          Right
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_1",
  text = [[

           Up
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_2",
  text = [[

          Left
]]
}
-----------------------

dialog{
  id = "surprise_wall.direction_3",
  text = [[

          Down
]]
}
-----------------------

dialog{
  id = "lake_shop.seller",
  text = [[
Welcome to the Lake
Shop! Our items are the
cheapest in the area.
What can I do for you?
]]
}
-----------------------
--#A bit difficult to translate. Maybe "discount(ed)" could work

dialog{
  id = "lake_shop.apples",
  text = [[
Three apples at value
price.
]]
}
-----------------------
--#This is apparently an English expression. Change if you like

dialog{
  id = "lake_shop.bombs",
  text = [[
Eight bombs. I'll give
them to you at cost
price!
]]
}
-----------------------
--#Perhaps a better translation out there? "ratio" maybe?

dialog{
  id = "lake_shop.arrows",
  text = [[
Ten arrows, an
excellent value for its
price.
]]
}
-----------------------

dialog{
  id = "lake_shop.big_magic_flask",
  text = [[
Special offer:
a jar of magic
energy.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.first_time",
  next = "chests_game_cave.play_question",
  text = [[
How did you get here??


... Now that you're
here, how would you
like to be the first to
play my new game? One
game costs 30 Rupees.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.not_first_time",
  skip = "current",
  next = "chests_game_cave.play_question",
  text = [[
Hi! One game costs 30
Rupees.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.play_question",
  question = true,
  text = [[
Do you want to play?
Yes
No
]]
}
-----------------------

dialog{
  id = "chests_game_cave.not_enough_money",
  skip = "all",
  text = [[
You don't have enough
Rupees!
]]
}
-----------------------

dialog{
  id = "chests_game_cave.start_game_wooden_key",
  skip = "all",
  text = [[
Thanks! To play the
game, just open one of
the chests. Its
contents are yours to
keep. The grand prize
of the day is a
magnificent wooden key.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.start_game_piece_of_heart",
  skip = "all",
  text = [[
Thanks! To play the
game, just open one of
the chests. Its
contents are yours to
keep. The grand prize
of the day is a
Piece of Heart.
]]
}
-----------------------
--#Might be able to translate this a little better

dialog{
  id = "chests_game_cave.start_game",
  skip = "all",
  text = [[
Thanks! You can open
one of the chests.
Its contents are yours
to keep.
]]
}
-----------------------

dialog{
  id = "chests_game_cave.already_playing",
  skip = "all",
  text = [[
Pick a chest!
]]
}
-----------------------

dialog{
  id = "outside_world.junk_shop_sign",
  skip = "all",
  text = [[

       Junk Shop

The largest selection
at exceptional prices!
]]
}
-----------------------

dialog{
  id = "junk_shop.seller",
  skip = "all",
  text = [[
Welcome to the Junk
Shop! Top of the line
items at extraordinary
prices! Help yourself!
]]
}
-----------------------

dialog{
  id = "junk_shop.croissant",
  text = [[
One Croissant. To fill
your Hearts.
]]
}
-----------------------

dialog{
  id = "junk_shop.arrows",
  text = [[
Standard Arrows.
]]
}
-----------------------

dialog{
  id = "junk_shop.red_rupee",
  text = [[
A special offer Red
Rupee, but it's the
floor model.
]]
}
-----------------------

dialog{
  id = "junk_shop.mystic_mirror",
  text = [[
The Mystic Mirror. They
say it can reverse the
flow of water!
]]
}
-----------------------

dialog{
  id = "junk_shop.heart",
  text = [[
A Heart. Useful if you
need energy.
]]
}
-----------------------

dialog{
  id = "junk_shop.bombs",
  text = [[
Eight bombs at a
reduced price.
]]
}
-----------------------

dialog{
  id = "junk_shop.piece_of_heart",
  text = [[
An authentic Piece of
Heart.
]]
}
-----------------------

dialog{
  id = "junk_shop.pain_au_chocolat",
  text = [[
A Pain au Chocolat for
recovering Hearts.
]]
}
-----------------------
--#Needs work. Won't remove French until it's fixed

dialog{
  id = "castle.welcome",
  skip = "all",
  text = [[
Welcome to the ancient
royal castle, listed as
a historical monument.
Please refrain from
disturbing the
surroundings.
]]
}
-----------------------

dialog{
  id = "castle.forbidden_stairs",
  skip = "all",
  text = [[
This stairs lead to the
upper level and to the
balcony.
Access is forbidden to
the public though.
]]
}
-----------------------

dialog{
  id = "castle.forbidden_door",
  skip = "all",
  text = [[
I am sorry sir, but you
are not allowed to
access to the dungeon
cells.
]]
}
-----------------------

dialog{
  id = "castle.forbidden_door_wtf",
  text = [[
........$0....?!$#!@&=!??
.....$0..................

How did you get here?
You are walking on
a forbidden area!
]]
}
-----------------------

dialog{
  id = "castle.npc_1",
  skip = "all",
  text = [[
This castle once
belonged to the Royal
family.
Nowadays, tourists from
all around Hyrule make
the trip to witness the
beauty of the place!
]]
}
-----------------------

dialog{
  id = "castle.npc_2",
  skip = "all",
  text = [[
Can you believe all the
efforts that were put
in the construction of
this castle?
I can only wonder how
they managed to pull
off such a wonderful
piece of architecture
with the means they had
at that time...
]]
}
-----------------------

dialog{
  id = "castle.where_is_tom",
  skip = "all",
  text = [[
Tom, one of our best
soldiers, has
mysteriously
disappeared while he
was gone exploring a
cave.
]]
}
-----------------------

dialog{
  id = "castle.npc_3",
  skip = "all",
  text = [[
What luxury! This
place is magnificent!
]]
}
-----------------------

dialog{
  id = "castle.prison",
  skip = "all",
  text = [[
Prisoners of the King
were held captive
inside these dark
cells.
]]
}
-----------------------

dialog{
  id = "castle.cannon",
  skip = "all",
  text = [[
What a magnificent
barrel!
You had better not be
an enemy of the King!
]]
}
-----------------------

dialog{
  id = "inferno.first_time",
  next = "inferno.find_fire_stones",
  text = [[
Who dares walk on my
lands? Child!
Don't you know how
foolish it is to
disturb the great
Inferno, Lord of
Flames?!
You will be punished
for such behaviour!
Shall you wish to
redeem yourself, try
and find the three
Fire Stones I hid
inside my gloomy
mazes.
]]
}
-----------------------

dialog{
  id = "inferno.find_fire_stones",
  skip = "current",
  text = [[
You will endure three
courage ordeals.

River.
$0Mountain.
$0Beaumont.
Overcome the challenges
that await you, bring
back the three Fire
Stones, and only then
shall Inferno's rage
be calmed.
]]
}
-----------------------

dialog{
  id = "inferno.found_fire_stones",
  question = true,
  text = [[
You made it through
the three ordeals with
success! Your bravery
is truly unique, I must
bow down before it.
I will grant you
anything you wish.


What do you want?
The black stones...
100 Rupees?
]]
}
-----------------------

dialog{
  id = "inferno.want_rupees",
  text = [[
So be it.
]]
}
-----------------------

dialog{
  id = "inferno.want_rupees_again",
  text = [[
I already gave you
this prize.
]]
}
-----------------------

dialog{
  id = "inferno.want_black_stones",
  text = [[
Before you can lift
these black stones,
you will have to
survive in an infernal
land, and overcome
many dangers.
Let me bring you to
the hell of flames...
]]
}
-----------------------

dialog{
  id = "potion_shop.witch",
  text = [[
Welcome to the Potion
Shop!
Hehehe...
Red gives life, green
gives magic, blue gives
both life and magic!
]]
}
-----------------------

dialog{
  id = "potion_shop.witch_bottle_offered",
  text = [[
Welcome to the Potion
Shop!
Hehehe...
A Magic Bottle is
given for free to every
new client! Hehehe...
Red gives life, green
gives magic, blue gives
both life and magic!
]]
}
-----------------------

dialog{
  id = "potion_shop.no_empty_bottle",
  text = [[
You can't buy this
Potion without an empty
Bottle! Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.red_potion",
  text = [[
Red Potion:
restores life!
Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.green_potion",
  text = [[
Green Potion:
restores your magic
bar! Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.blue_potion",
  text = [[
Blue Potion:
restores life and
magic! Hehehe...
]]
}
-----------------------

dialog{
  id = "potion_shop.give_bottle",
  text = [[
As a new customer, you
get to walk away with a
Magic Bottle for free.
Hehehe...
]]
}
-----------------------

dialog{
  id = "outside_world.vine_start",
  skip = "all",
  text = [[
The land seems very
fertile around here,
but it lacks
humidity...
]]
}
-----------------------

dialog{
  id = "cave_to_dungeon_8.hint",
  skip = "all",
  text = [[
Only an attentive
observer will be able
to follow the path.
]]
}
-----------------------

dialog{
  id = "bone_key_cave.hint",
  skip = "all",
  text = [[
Only by repelling light
will then shine light
anew.
]]
}
-----------------------

dialog{
  id = "hidden_palace.door_closed",
  skip = "all",
  text = [[
This door won't open...
]]
}
-----------------------

dialog{
  id = "hidden_palace.using_bone_key",
  icon = 20,
  text = [[
$1You use the Bone
Key...
]]
}
--------------------

dialog{
  id = "dungeon_2.solarus_child",
  text = [[
$2$v... Thank you.
You saved my life.
I am one of the eight
protectors called forth
by Princess Zelda to
watch over the Triforce.
Using the power of the
Solarus amulet, a relic
worn by Princess Zelda,
is the only way to
restore the Triforce.
We have shattered it
into eight pieces
hidden across the
kingdom. We are here
to guard the eight
fragments, as Zelda
watches over the
Solarus Amulet.
It must not fall into
the wrong hands. We
trust your courage.
May the hero bring
peace and prosperity
to the Kingdom!
]]
}
-----------------------

dialog{
  id = "dungeon_3.arbror_direction_hint",
  text = [[

  North: Master Arbror
]]
}
-----------------------

dialog{
  id = "dungeon_3.water_drained_somewhere",
  text = [[
Far away... a noise...
]]
}
-----------------------

dialog{
  id = "dungeon_3.arbror_hello",
  text = [[
Haa!!! You'll never
defeat me, Master
Arbror!
]]
}
-----------------------

dialog{
  id = "dungeon_3.arbror_killed",
  text = [[
KARGHHH!!! I have been
defeated, but you won't
go far...
You will
never succeed...
]]
}
-----------------------

dialog{
  id = "dungeon_3.solarus_child",
  text = [[
$2$v... Thank you.
You saved my life.
Thanks to you, this
horrible creature will
not never trouble the
Kingdom again.
I am one of the eight
protectors called forth
by Princess Zelda.
The Triforce is still
in danger as long as
one of my brothers is
held captive.
The end of your journey
is near.
Save him and return
peace to these lands.
May the hero bring
peace and prosperity
to the Kingdom!
]]
}
-----------------------

dialog{
  id = "dungeon_4.welcome",
  skip = "current",
  text = [[
         Level 4
    Beaumont's Palace
]]
}
-----------------------

dialog{
  id = "dungeon_4.hint_use_map",
  text = [[
When the exits do not
appear upon you, use
the map.
]]
}
-----------------------

dialog{
  id = "dungeon_4.hint_chests",
  text = [[
The way is shown by
the crossing of four
chests.
]]
}
-----------------------

-- The hero attemps to enter the frozen room in dungeon 4
-- but doesn't have the blue tunic.
dialog{
  id = "dungeon_4.too_cold",
  text = [[
It's too cold here...
You need to leave!
]]
}
-----------------------

dialog{
  id = "dungeon_4.solarus_child",
  text = [[
$2$v... Thank you.
You saved my life.
I am one of the eight
protectors called forth
by Princess Zelda.
You have demonstrated
a remarkable courage.
Thanks to you, we are
now all together again,
and the Triforce is
safe.

May the hero bring
peace and prosperity
to the Kingdom!
]]
}
-----------------------

dialog{
  id = "dungeon_4.agahnim",
  text = [[
$1A G A H N I M !
$3Yes, himself!

The sorcerer back from
the land of the dead!!!
Ah ah ah ah ah ah!!!
So you managed to
gather the four kids?
This child doesn't have
a clue of what awaits
him outside by saying
that the Triforce is
safe...
Ah ah ah ah ah ah!!!
Acknowledge, young man,
that I did not come
back to free the
despicable Ganon, he
who once dared call me
his alter ego...
I would rather leave
that filthy culprit
sealed away in his
Dark World! Thus I can
keep the Triforce for
myself and rule as the
only master...
Ah ah ah ah ah!
Upon leaving this room,
you will witness my
control over this
kingdom...
Ah ah ah ah ah ah ah!
Now you, young and
impetuous adventurer,
and I shall meet again.
For the time being, I
am going back to the
castle!
Ah ah ah ah ah! We will
see each other again,
and with my powers, I
will put an end to your
tale!
Ah ah ah ah ah ah!!!
]]
}
-----------------------

dialog{
  id = "dungeon_5.welcome",
  skip = "current",
  text = [[
         Level 5
     Ancient Castle
]]
}
-----------------------

dialog{
  id = "dungeon_5.pots_hint",
  skip = "all",
  text = [[
The key to the puzzle
is to circle the jars
in the right direction.
]]
}
-----------------------

dialog{
  id = "dungeon_5.hero_seen_by_guard",
  text = [[
HALT!
Don't move!
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_1_locked",
  text = [[
     - Iron Lock -
None of your keys seem
to fit...
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_1_use_iron_key",
  icon = 28,
  text = [[
$1You use the Iron
Key...
]]
}
--------------------

dialog{
  id = "dungeon_5.prison_2_locked_1",
  text = [[
It's locked!
]]
}
-----------------------

dialog{
  id = "dungeon_5.prison_2_locked_2",
  text = [[
It's so rusty that even
the Large Key won't
work.
]]
}
-----------------------
--#May need to be prettied up

dialog{
  id = "dungeon_5.prison_2_locked_3",
  text = [[
Perhaps there is a way
to force open this old
lock...
]]
}
-----------------------

dialog{
  id = "dungeon_5.puzzle_solved",
  text = [[
Somewhere deep within
the castle, a trigger
is activated...
]]
}
-----------------------

dialog{
  id = "dungeon_5.agahnim_beginning",
  text = [[
You were able to pass
through the security of
my guards and avoid the
traps laid in the
castle.
I don't care, your
flight ends here!
]]
}
-----------------------

dialog{
  id = "dungeon_5.agahnim_end",
  text = [[
...$0...........$0
You defeated me this
time...
But we will meet
again!

Your little journey
won't change
anything...
Sahasrahla is under
my control and he will
tell me where the
Princess and the eight
children are...
Ah ah ah ah ah!
I must leave now. See
you later!
]]
}
-----------------------

dialog{
  id = "dungeon_6.welcome",
  skip = "current",
  text = [[
         Level 6
     Inferno's Maze
]]
}
-----------------------

-- Hint for the weak floor
dialog{
  id = "dungeon_6.torches_hint",
  text = [[
The three lights show
the way to the fall.
]]
}
-----------------------

dialog{
  id = "dungeon_6.dont_fall_hint",
  text = [[
Do not fall, but jump.
]]
}
-----------------------

dialog{
  id = "dungeon_6.close_way_hint",
  text = [[
Then close the path
behind you.
]]
}
-----------------------

dialog{
  id = "dungeon_6.tom",
  text = [[
$2$v... Thank you.
You saved my life.
You have gone through a
lengthy journey and
overcome many ordeals
since we last met.
]]
}
-----------------------

dialog{
  id = "dungeon_6.tom_revelation",
  text = [[
$2I need to confess
some serious facts...
Our king's death was
not accidental.
I poisoned him.
I was under Agahnim's
control...
He cast a spell on me
and I lost my free
will... There is
nothing I could do...
When the spell broke I
realised what had
happened... Thus I
decided to retire to
the cave where we first
met. Then I was thrown
in jail while trying
to resist when Agahnim
seized control of the
castle...
$v... You must now
travel to Mount Terror.
Agahnim went there
to look for Zelda.
You must first free
Sahasrahla before the
sorcerer manages to
get the information
he needs...
Please take this, my
little contribution
to your quest...
]]
}
-----------------------

dialog{
  id = "dungeon_7.welcome",
  skip = "current",
  text = [[
         Level 7
     Crystal Temple
]]
}
-----------------------

dialog{
  id = "dungeon_7.code",
  skip = "all",
  text = [[
        4  7  2        
        6  1  8        
           3  5        
]]
}
-----------------------

-- The original dialog was a reference
-- to Link's Awakening
dialog{
  id = "dungeon_7.2f_weak_floor_hint",
  text = [[
In soil sleeps secrets,
beneath your soles...
]]
}
-----------------------

dialog{
  id = "dungeon_7.2f_dont_fall_alone_hint",
  text = [[
The solution was to not
fall alone.
]]
}
-----------------------

dialog{
  id = "dungeon_7.sahasrahla",
  text = [[
$2$v... Thank you.
You saved my life.

Had I only been able
to resist a while
more...
Those culprits coaxed
me into revealing the
location of Zelda and
the Solarus children.
Protect them from all
danger, before
something dreadful
happens...
They are hiding in a
palace sitting east
of the mountains. The
eight Solarus beings
must escape from
Agahnim, else the
sorcerer could break
the seal created by
the Solarus Amulet, the
relic worn by Zelda,
necessary to the
gathering of the
Triforce shards.
The mystery of Solarus
is kept safe inside
the relic.
The relic's owner has
the ability to summon
the Solarus power to
seal an object, a
place or even a world,
as the seven sages once
did when they sealed
away the Golden Land.
Zelda is the heiress of
that power. She used it
to seal the Triforce
shards, using the eight
beings created by the
Solarus.
Thus, as long as she
alone knows the secret
of the relic, she alone
masters the Triforce's
seal. This is why you
must protect the seal.
]]
}
-----------------------

dialog{
  id = "dungeon_8.welcome",
  skip = "current",
  text = [[
         Level 8
   Rock Peaks Dungeon
]]
}
-----------------------

dialog{
  id = "dungeon_8.hint_1F",
  skip = "current",
  text = [[
Throw yourself into
the depths of the
dungeon and carry on
your journey.
]]
}
-----------------------

dialog{
  id = "dungeon_8.hint_B1",
  skip = "current",
  text = [[
If you are stuck, fight
the spades with spades.
]]
}
-----------------------

dialog{
  id = "dungeon_8.billy",
  text = [[
You did not think you
would find your old
buddy Billy the
Reckless, greatest
hero of all times?!
The princess and the
eight childs are not
here anymore.
They did find shelter
in my palace, but I
took the responsability
of handing them to
Agahnim...


Now, it is your turn
to die!
]]
}
-----------------------

dialog{
  id = "dungeon_8.agahnim",
  text = [[
$1That Billy was really
incapable of anything.
Seeing as how he, along
with all my other
minions, could not end
you, little parasite, I
am making it a private
matter. You will
disappear once and for
all. And then, finally,
I will get my hands on
the Triforce and extend
my power to the whole
world. Ah ah ah ah!
]]
}
-----------------------

dialog{
  id = "dungeon_8.agahnim_middle",
  text = [[
$1$0...$0.............$0
You are rather tough,
that is no lie.
But what about this?
]]
}
-----------------------

dialog{
  id = "dungeon_8.agahnim_end",
  text = [[
$1$0...$0 .........$0
I am defeated...$0
This is the end...$0
I was not up to it...


I bow down before your
bravery.$0

Since I was not able
to defeat you, it is
now time for me to free
my Master...
Ah ah ah ah ah ah!!!
]]
}
-----------------------

dialog{
  id = "dungeon_8.ganon",
  text = [[
$1Thus, you have
managed to defeat my
alter ego, the dark
sorcerer Agahnim...
That was pretty useless
considering it made him
free me, the dark times
are not over! As a
reward for your work,
you, the Princess as
well as the eight
children, are invited
to join me in my
palace. I will take
the Triforce back and
you shall be the first
to witness this amazing
event.
Let your spirit travel
freely...
]]
}
-----------------------

dialog{
  id = "dungeon_9.welcome",
  skip = "current",
  text = [[
         Level 9
   Shrine of Memories
]]
}
-----------------------

dialog{
  id = "dungeon_9.clockwise_switches_hint",
  skip = "all",
  text = [[
Go clockwise.
]]
}
-----------------------

dialog{
  id = "dungeon_9.3f_door_b_hint_0",
  skip = "all",
  text = [[
To the right.
]]
}
-----------------------

dialog{
  id = "dungeon_9.3f_door_b_hint_2",
  skip = "all",
  text = [[
To the left.
]]
}
-----------------------

dialog{
  id = "dungeon_9.3f_door_b_hint_3",
  skip = "all",
  text = [[
Down.
]]
}
-----------------------

dialog{
  id = "dungeon_9.5f_childs_hint",
  skip = "all",
  text = [[
$1To defeat Ganon,
the torches must be
lit clockwise.
]]
}
-----------------------

dialog{
  id = "dungeon_9.boss",
  text = [[
There you are, young
weakling.

I have been waiting
for you for a long
time now.
The time for revenge
has finally come!
Prepare to die.
]]
}
-----------------------

dialog{
  id = "dungeon_9.zelda",
  text = [[
$1$v... Thank you.
Your victory on evil
shows once again that
wisdom and justice
always triumph over
the forces of evil.
Thanks to your
accomplishments, our
world has been restored
to its original state.
The Kingdom of Hyrule
is whole once again.
]]
}
-----------------------

dialog{
  id = "dungeon_9.zelda_children",
  text = [[
$1I must destroy this
relic. The power of
Solarus is too
dangerous. By
destroying it, there
will be no way to
restore the Triforce
from its fragments.
Even if it is for a
good purpose as you
once used it, the evil
will always try to
reach for it, like
Agahnim and Ganondorf.
With the power of the
eight beings created
by the Solarus Essence,
the relic could break
the Seal.
Now you understand why
I must destroy it.
]]
}
-----------------------

dialog{
  id = "dungeon_9.zelda_end",
  text = [[
$1It is over.$0


The power of the
Solarus has vanished
forever.
The Triforce will
remain sealed until
time ends.
]]
}
-----------------------

dialog{
  id = "dungeon_10.welcome",
  skip = "current",
  text = [[
     Secret level
     Skyward Tower
]]
}
-----------------------

dialog{
  id = "credits_1",
  text = [[
$1        Credits$0


      Programming:$0
Christopho$0
]]
}
-----------------------

dialog{
  id = "credits_2",
  text = [[
$1   Maps and puzzles:$0


Christopho$0


Metallizer$0
Binbin$0
Mymy$0
]]
}
-----------------------

dialog{
  id = "credits_3",
  text = [[
$1   Graphical assets:$0
Newlink$0

Neovyse$0
@PyroNet$0
Djipi$0
$1        Music:$0
Marine$0
Metallizer$0
]]
}
-----------------------

dialog{
  id = "credits_4",
  text = [[
$1        Story:$0
Guillaume F.$0
Christopho$0
$1        English
     localization :$0

Alex_XelA$0
Rypervenche$0
Jeff$0
]]
}
-----------------------

dialog{
  id = "credits_6",
  text = [[
$1        Tests:$0


Thyb$0
Morwenn$0
BenObiWan$0
$1   Special thanks to:$0


19oj19$0           Yohann$0
MultiSync_XV17$0   Krytzz$0
HelpTheWretched$0

        Nintendo$0


Thanks for playing!$0



 www.solarus-games.org$0
]]
}
-----------------------

