-- Mini Mowatulla: a small spider that comes from an egg.
-- This enemy is usually be generated by a bigger one.

in_shell = nil

-- The enemy appears: create its movement
function event_appear()
  
  sol.enemy.set_life(2)
  sol.enemy.set_damage(2)
  sol.enemy.create_sprite("enemies/mini_mowatulla")
  sol.enemy.set_size(16, 16)
  sol.enemy.set_origin(8, 13)
  sol.enemy.set_invincible()

  local sprite = sol.enemy.get_sprite()
  sol.main.sprite_set_animation(sprite, "shell")
  in_shell = true
  sol.main.timer_start(break_shell, 1000)
end

-- The enemy was stopped for some reason and should restart
function event_restart()

  if in_shell then
    local sprite = sol.enemy.get_sprite()
    sol.main.sprite_set_animation(sprite, "shell")
    local m = sol.main.target_movement_create(64)
    sol.enemy.start_movement(m)
  else
    local m = sol.main.path_finding_movement_create(64)
    sol.enemy.start_movement(m)
  end
end

-- Starts breaking the shell
function break_shell()

  local sprite = sol.enemy.get_sprite()
  sol.enemy.stop_movement()
  sol.main.sprite_set_animation(sprite, "shell_breaking")
end

--  The animation of a sprite is finished
function event_sprite_animation_finished(sprite, animation)

  -- if the shell was breaking, let the mini mowatulla go
  if animation == "shell_breaking" then
    sol.main.sprite_set_animation(sprite, "walking")
    sol.enemy.snap_to_grid()
    sol.enemy.set_default_attack_consequences()
    in_shell = false
    sol.enemy.restart()
  end
end

