/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.spi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;
import sun.net.spi.nameservice.NameService;

public class DNSJavaNameService
implements NameService {
    private static final String nsProperty = "sun.net.spi.nameservice.nameservers";
    private static final String domainProperty = "sun.net.spi.nameservice.domain";
    private static final String v6Property = "java.net.preferIPv6Addresses";
    private boolean preferV6 = false;

    protected DNSJavaNameService() {
        String nameServers = System.getProperty(nsProperty);
        String domain = System.getProperty(domainProperty);
        String v6 = System.getProperty(v6Property);
        if (nameServers != null) {
            StringTokenizer st = new StringTokenizer(nameServers, ",");
            String[] servers = new String[st.countTokens()];
            int n = 0;
            while (st.hasMoreTokens()) {
                servers[n++] = st.nextToken();
            }
            try {
                ExtendedResolver res = new ExtendedResolver(servers);
                Lookup.setDefaultResolver(res);
            }
            catch (UnknownHostException e) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.nameservers");
            }
        }
        if (domain != null) {
            try {
                Lookup.setDefaultSearchPath(new String[]{domain});
            }
            catch (TextParseException e) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.domain");
            }
        }
        if (v6 != null && v6.equalsIgnoreCase("true")) {
            this.preferV6 = true;
        }
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        Name name = null;
        try {
            name = new Name(host);
        }
        catch (TextParseException e) {
            throw new UnknownHostException(host);
        }
        Record[] records = null;
        if (this.preferV6) {
            records = new Lookup(name, 28).run();
        }
        if (records == null) {
            records = new Lookup(name, 1).run();
        }
        if (records == null && !this.preferV6) {
            records = new Lookup(name, 28).run();
        }
        if (records == null) {
            throw new UnknownHostException(host);
        }
        InetAddress[] array = new InetAddress[records.length];
        for (int i = 0; i < records.length; ++i) {
            Record record = records[i];
            if (records[i] instanceof ARecord) {
                ARecord a = (ARecord)records[i];
                array[i] = a.getAddress();
                continue;
            }
            AAAARecord aaaa = (AAAARecord)records[i];
            array[i] = aaaa.getAddress();
        }
        return array;
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(InetAddress.getByAddress(addr));
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException();
        }
        return ((PTRRecord)records[0]).getTarget().toString();
    }
}

