/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.mozilla.dom.NamedNodeMapImpl;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeListImpl;
import org.mozilla.dom.SharedUtils;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.dom.events.EventImpl;
import org.mozilla.dom.events.EventListenerImpl;
import org.mozilla.interfaces.inIDOMUtils;
import org.mozilla.interfaces.nsIDOM3Node;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeImpl
implements Node,
EventTarget {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();
    private HashMap<String, Object> userData = new HashMap();

    public nsIDOMNode getInstance() {
        return this.getInstanceAsnsIDOMNode();
    }

    protected NodeImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public NodeImpl(nsIDOMNode mozInst) {
        this((nsISupports)mozInst);
    }

    public static NodeImpl getDOMInstance(nsIDOMNode mozInst) {
        NodeImpl node = (NodeImpl)instances.get(mozInst);
        return node == null ? new NodeImpl(mozInst) : node;
    }

    public nsIDOMNode getInstanceAsnsIDOMNode() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMNode)this.moz.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
    }

    public Node appendChild(Node newChild) {
        final nsIDOMNode mozNewchild = newChild != null ? ((NodeImpl)newChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeImpl.this.getInstanceAsnsIDOMNode().appendChild(mozNewchild);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String lookupPrefix(final String namespaceURI) {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.lookupPrefix(namespaceURI);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setNodeValue(final String nodeValue) {
        Runnable r = new Runnable(){

            public void run() {
                NodeImpl.this.getInstanceAsnsIDOMNode().setNodeValue(nodeValue);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public boolean isSameNode(Node other) {
        final nsIDOMNode mozOther = other != null ? ((NodeImpl)other).getInstance() : null;
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOM3MozObject.isSameNode(mozOther);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node cloneNode(final boolean deep) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeImpl.this.getInstanceAsnsIDOMNode().cloneNode(deep);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getFirstChild() {
        final Node[] result = new Node[]{null};
        final Runnable r = new Runnable(){

            public void run() {
                nsIDOMNode current = NodeImpl.this.getInstanceAsnsIDOMNode();
                result[0] = NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current) ? SharedUtils.frameNodeToDocument(current) : NodeFactory.getNodeInstance(current.getFirstChild());
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Node>(){

            @Override
            public Node call() {
                r.run();
                return result[0];
            }
        });
    }

    public void setTextContent(final String textContent) {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Runnable r = new Runnable(){

            public void run() {
                DOM3MozObject.setTextContent(textContent);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public boolean isEqualNode(Node arg) {
        final nsIDOMNode mozArg = arg != null ? ((NodeImpl)arg).getInstance() : null;
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOM3MozObject.isEqualNode(mozArg);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void normalize() {
        Runnable r = new Runnable(){

            public void run() {
                NodeImpl.this.getInstanceAsnsIDOMNode().normalize();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public boolean isSupported(final String feature, final String version) {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = NodeImpl.this.getInstanceAsnsIDOMNode().isSupported(feature, version);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Object getFeature(final String feature, final String version) {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                nsISupports result = DOM3MozObject.getFeature(feature, version);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Object getUserData(String key) {
        return this.userData.get(key);
    }

    public String getPrefix() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = NodeImpl.this.getInstanceAsnsIDOMNode().getPrefix();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public short getNodeType() {
        Callable<Short> c = new Callable<Short>(){

            @Override
            public Short call() {
                int result = NodeImpl.this.getInstanceAsnsIDOMNode().getNodeType();
                return (short)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getNextSibling() {
        final Node[] result = new Node[]{null};
        final Runnable r = new Runnable(){

            public void run() {
                inIDOMUtils utils;
                nsIDOMNode parentNode;
                nsIDOMNode current = NodeImpl.this.getInstanceAsnsIDOMNode();
                if (NodeFactory.getExpandFrames() && SharedUtils.isHTMLNode(current) && (parentNode = (utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}")).getParentForNode(current, false)) != null) {
                    result[0] = null;
                    return;
                }
                result[0] = NodeFactory.getNodeInstance(current.getNextSibling());
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Node>(){

            @Override
            public Node call() {
                r.run();
                return result[0];
            }
        });
    }

    public Node getLastChild() {
        final Node[] result = new Node[]{null};
        final Runnable r = new Runnable(){

            public void run() {
                nsIDOMNode current = NodeImpl.this.getInstanceAsnsIDOMNode();
                result[0] = NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current) ? SharedUtils.frameNodeToDocument(current) : NodeFactory.getNodeInstance(current.getFirstChild());
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Node>(){

            @Override
            public Node call() {
                r.run();
                return result[0];
            }
        });
    }

    public boolean hasChildNodes() {
        final boolean[] result = new boolean[]{false};
        final Runnable r = new Runnable(){

            public void run() {
                nsIDOMNode current = NodeImpl.this.getInstanceAsnsIDOMNode();
                result[0] = NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current) ? true : current.hasChildNodes();
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                r.run();
                return result[0];
            }
        });
    }

    public short compareDocumentPosition(final Node other) {
        final short[] result = new short[]{0};
        final Runnable r = new Runnable(){

            public void run() {
                if (NodeFactory.getExpandFrames()) {
                    Document startDoc2;
                    Document startDoc1 = NodeImpl.this.getOwnerDocument();
                    if (startDoc1.isSameNode(startDoc2 = other.getOwnerDocument())) {
                        nsIDOMNode mozOther = ((NodeImpl)other).getInstance();
                        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)NodeImpl.this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
                        int cresult = DOM3MozObject.compareDocumentPosition(mozOther);
                        result[0] = (short)cresult;
                    } else {
                        Node frame2;
                        Stack<Document> docs1 = new Stack<Document>();
                        Document d = startDoc1;
                        while (d != null) {
                            docs1.push(d);
                            Node p = d.getParentNode();
                            if (p == null) {
                                d = null;
                                continue;
                            }
                            d = p.getOwnerDocument();
                        }
                        Stack<Document> docs2 = new Stack<Document>();
                        Document d2 = startDoc2;
                        while (d2 != null) {
                            docs2.push(d2);
                            Node p = d2.getParentNode();
                            if (p == null) {
                                d2 = null;
                                continue;
                            }
                            d2 = p.getOwnerDocument();
                        }
                        Document lastCommon = null;
                        Document doc1 = null;
                        Document doc2 = null;
                        while (!docs1.isEmpty() && !docs2.isEmpty() && (doc1 = (Document)docs1.pop()).isSameNode(doc2 = (Document)docs2.pop())) {
                            lastCommon = doc1;
                        }
                        if (lastCommon == null || doc1 == null || doc2 == null) {
                            result[0] = 33;
                            return;
                        }
                        Node frame1 = doc1.getParentNode();
                        if (frame1 == null) {
                            frame1 = docs1.isEmpty() ? NodeImpl.this : ((Document)docs1.peek()).getParentNode();
                        }
                        if ((frame2 = doc2.getParentNode()) == null) {
                            frame2 = docs2.isEmpty() ? other : ((Document)docs2.peek()).getParentNode();
                        }
                        assert (frame1 != null && frame2 != null);
                        assert (frame1.getOwnerDocument().isSameNode(frame2.getOwnerDocument()));
                        nsIDOM3Node mozFrame1 = (nsIDOM3Node)((NodeImpl)frame1).getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
                        nsIDOMNode mozFrame2 = ((NodeImpl)frame2).getInstance();
                        int cresult = mozFrame1.compareDocumentPosition(mozFrame2);
                        result[0] = (short)cresult;
                    }
                } else {
                    nsIDOMNode mozOther = ((NodeImpl)other).getInstance();
                    nsIDOM3Node DOM3MozObject = (nsIDOM3Node)NodeImpl.this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
                    int cresult = DOM3MozObject.compareDocumentPosition(mozOther);
                    result[0] = (short)cresult;
                }
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Short>(){

            @Override
            public Short call() {
                r.run();
                return result[0];
            }
        });
    }

    public String getBaseURI() {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.getBaseURI();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public boolean isDefaultNamespace(final String namespaceURI) {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOM3MozObject.isDefaultNamespace(namespaceURI);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public boolean hasAttributes() {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = NodeImpl.this.getInstanceAsnsIDOMNode().hasAttributes();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        final nsIDOMNode mozNewchild = newChild != null ? ((NodeImpl)newChild).getInstance() : null;
        final nsIDOMNode mozRefchild = refChild != null ? ((NodeImpl)refChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeImpl.this.getInstanceAsnsIDOMNode().insertBefore(mozNewchild, mozRefchild);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public NodeList getChildNodes() {
        final NodeList[] result = new NodeList[]{null};
        final Runnable r = new Runnable(){

            public void run() {
                nsIDOMNode current = NodeImpl.this.getInstanceAsnsIDOMNode();
                result[0] = NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current) ? new NodeListImpl(((NodeImpl)((Object)SharedUtils.frameNodeToDocument(current))).getInstance().getChildNodes()) : new NodeListImpl(current.getChildNodes());
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<NodeList>(){

            @Override
            public NodeList call() {
                r.run();
                return result[0];
            }
        });
    }

    public Node getParentNode() {
        final Node[] result = new Node[]{null};
        final Runnable r = new Runnable(){

            public void run() {
                nsIDOMNode currentNode = NodeImpl.this.getInstance();
                if (NodeFactory.getExpandFrames()) {
                    if (currentNode.getNodeType() == 9) {
                        inIDOMUtils utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
                        nsIDOMNode parentNode = utils.getParentForNode(currentNode, false);
                        if (parentNode == null) {
                            result[0] = null;
                            return;
                        }
                        result[0] = NodeFactory.getNodeInstance(parentNode);
                    } else {
                        nsIDOMNode parentNode = NodeImpl.this.getInstance().getParentNode();
                        if (parentNode != null && parentNode.getNodeType() == 9) {
                            inIDOMUtils utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
                            nsIDOMNode parentParentNode = utils.getParentForNode(parentNode, false);
                            if (parentParentNode == null) {
                                result[0] = NodeFactory.getNodeInstance(parentNode);
                            }
                            result[0] = NodeFactory.getNodeInstance(parentParentNode);
                        } else {
                            result[0] = NodeFactory.getNodeInstance(parentNode);
                        }
                    }
                } else {
                    result[0] = NodeFactory.getNodeInstance(currentNode.getParentNode());
                }
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Node>(){

            @Override
            public Node call() {
                r.run();
                return result[0];
            }
        });
    }

    public String getNodeName() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = NodeImpl.this.getInstanceAsnsIDOMNode().getNodeName();
                if (result != null && NodeFactory.getConvertNodeNamesToLowerCase()) {
                    return result.toLowerCase();
                }
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getPreviousSibling() {
        final Node[] result = new Node[]{null};
        final Runnable r = new Runnable(){

            public void run() {
                inIDOMUtils utils;
                nsIDOMNode parentNode;
                nsIDOMNode current = NodeImpl.this.getInstanceAsnsIDOMNode();
                if (NodeFactory.getExpandFrames() && SharedUtils.isHTMLNode(current) && (parentNode = (utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}")).getParentForNode(current, false)) != null) {
                    result[0] = null;
                    return;
                }
                result[0] = NodeFactory.getNodeInstance(current.getPreviousSibling());
            }
        };
        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        }
        return ThreadProxy.getSingleton().syncExec(new Callable<Node>(){

            @Override
            public Node call() {
                r.run();
                return result[0];
            }
        });
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        final nsIDOMNode mozNewchild = newChild != null ? ((NodeImpl)newChild).getInstance() : null;
        final nsIDOMNode mozOldchild = oldChild != null ? ((NodeImpl)oldChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeImpl.this.getInstanceAsnsIDOMNode().replaceChild(mozNewchild, mozOldchild);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Document getOwnerDocument() {
        Callable<Document> c = new Callable<Document>(){

            @Override
            public Document call() {
                nsIDOMDocument result = NodeImpl.this.getInstanceAsnsIDOMNode().getOwnerDocument();
                return (Document)NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getLocalName() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = NodeImpl.this.getInstanceAsnsIDOMNode().getLocalName();
                if (result != null && NodeFactory.getConvertNodeNamesToLowerCase()) {
                    return result.toLowerCase();
                }
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.userData.put(key, data);
    }

    public String getTextContent() {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.getTextContent();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String lookupNamespaceURI(final String prefix) {
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.lookupNamespaceURI(prefix);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getNodeValue() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = NodeImpl.this.getInstanceAsnsIDOMNode().getNodeValue();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node removeChild(Node oldChild) {
        final nsIDOMNode mozOldchild = oldChild != null ? ((NodeImpl)oldChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeImpl.this.getInstanceAsnsIDOMNode().removeChild(mozOldchild);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public NamedNodeMap getAttributes() {
        Callable<NamedNodeMap> c = new Callable<NamedNodeMap>(){

            @Override
            public NamedNodeMap call() {
                nsIDOMNamedNodeMap result = NodeImpl.this.getInstanceAsnsIDOMNode().getAttributes();
                return new NamedNodeMapImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getNamespaceURI() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = NodeImpl.this.getInstanceAsnsIDOMNode().getNamespaceURI();
                if (result == null) {
                    return "";
                }
                String prefix = NodeImpl.this.lookupPrefix(result);
                if (prefix == null || prefix.equalsIgnoreCase("xmlns")) {
                    return "";
                }
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setPrefix(final String prefix) {
        Runnable r = new Runnable(){

            public void run() {
                NodeImpl.this.getInstanceAsnsIDOMNode().setPrefix(prefix);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public NodeImpl(nsIDOMEventTarget mozInst) {
        this((nsISupports)mozInst);
    }

    public static NodeImpl getDOMInstance(nsIDOMEventTarget mozInst) {
        NodeImpl node = (NodeImpl)instances.get(mozInst);
        return node == null ? new NodeImpl(mozInst) : node;
    }

    public nsIDOMEventTarget getInstanceAsnsIDOMEventTarget() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMEventTarget)this.moz.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
    }

    public boolean dispatchEvent(Event evt) {
        final nsIDOMEvent mozEvt = evt != null ? ((EventImpl)evt).getInstance() : null;
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = NodeImpl.this.getInstanceAsnsIDOMEventTarget().dispatchEvent(mozEvt);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void removeEventListener(final String type, EventListener listener, final boolean useCapture) {
        final nsIDOMEventListener mozListener = listener != null ? ((EventListenerImpl)listener).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                NodeImpl.this.getInstanceAsnsIDOMEventTarget().removeEventListener(type, mozListener, useCapture);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void addEventListener(final String type, EventListener listener, final boolean useCapture) {
        final nsIDOMEventListener mozListener = listener != null ? ((EventListenerImpl)listener).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                NodeImpl.this.getInstanceAsnsIDOMEventTarget().addEventListener(type, mozListener, useCapture);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }
}

