/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaConfig;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.test.MozillaTest;

public class ImagesTest
extends MozillaTest {
    private static final String TEST_URL = ImagesTest.resolveURL("image.html");

    public void testImagesExisting() {
        ImagesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, TEST_URL));
        MozillaAutomation.sleep(400);
        MozillaConfig.disableImages();
        ImagesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, TEST_URL));
        MozillaAutomation.sleep(400);
        MozillaConfig.enableImages();
        ImagesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, TEST_URL));
        MozillaAutomation.sleep(400);
    }

    public void testImagesNew() {
        MozillaConfig.disableImages();
        MozillaWindow win2 = new MozillaWindow();
        MozillaPanel moz2 = win2.getPanel();
        win2.setBounds(300, 300, 600, 450);
        win2.setVisible(true);
        ImagesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(moz2, TEST_URL));
        MozillaAutomation.sleep(400);
        MozillaConfig.enableImages();
        ImagesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(moz2, TEST_URL));
        MozillaAutomation.sleep(400);
        win2.setVisible(false);
        win2.dispose();
    }
}

