/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaConfig;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.MozillaCanvas;
import org.mozilla.browser.impl.components.JErrorPanel;
import org.mozilla.browser.mt;

public class MozillaContainer
extends JPanel {
    private static final long serialVersionUID = 1893904117076267801L;
    static Log log = LogFactory.getLog(MozillaCanvas.class);
    private ChromeAdapter chromeAdapter;
    private MozillaCanvas mozCanvas;

    public MozillaContainer() {
        this.setLayout(new BorderLayout());
        this.mozCanvas = new MozillaCanvas();
        if (MozillaInitialization.isInitialized()) {
            this.add((Component)this.mozCanvas, "Center");
        } else {
            String details = MozillaConfig.getConfigSummary();
            String strace = JErrorPanel.stackTraceToString(MozillaInitialization.getError());
            if (strace != null) {
                details = details + "\n";
                details = details + "--------------------------------------------------\n";
                details = details + "\n";
                details = details + strace;
            }
            JErrorPanel p = new JErrorPanel(mt.t("MozillaContainer.InitFailed"), details);
            this.add((Component)p, "Center");
        }
    }

    public void onAttachBrowser(ChromeAdapter chromeAdapter) {
        assert (chromeAdapter != null);
        assert (this.chromeAdapter == null);
        this.chromeAdapter = chromeAdapter;
        assert (this.mozCanvas != null);
        this.mozCanvas.onAttachBrowser(chromeAdapter);
    }

    public void onDetachBrowser() {
        assert (this.mozCanvas != null);
        this.mozCanvas.onDetachBrowser();
        this.chromeAdapter = null;
    }

    public MozillaCanvas getMozillaCanvas() {
        return this.mozCanvas;
    }

    public void addNotify() {
        super.addNotify();
    }
}

