/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventBroadcaster;
import org.limewire.xmpp.activity.XmppActivityEvent;
import org.limewire.xmpp.client.impl.IdleTime;

public class IdleStatusMonitor {
    private static final int TWENTY_MINUTES_IN_MILLIS = 1200000;
    private final IdleTime idleTime;
    private final ScheduledExecutorService backgroundExecutor;
    private final EventBroadcaster<XmppActivityEvent> activityBroadcaster;
    private EventBean<FriendConnectionEvent> connectionEvent;
    private Future task;

    @Inject
    public IdleStatusMonitor(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, IdleTime idleTime, EventBroadcaster<XmppActivityEvent> activityBroadcaster, EventBean<FriendConnectionEvent> connectionSupport) {
        this.backgroundExecutor = backgroundExecutor;
        this.idleTime = idleTime;
        this.activityBroadcaster = activityBroadcaster;
        this.connectionEvent = connectionSupport;
    }

    public void start() {
        this.task = this.backgroundExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FriendConnectionEvent lastEvent = (FriendConnectionEvent)IdleStatusMonitor.this.connectionEvent.getLastEvent();
                if (IdleStatusMonitor.this.idleTime.supportsIdleTime() && lastEvent != null && ((FriendConnectionEvent.Type)((Object)lastEvent.getType())).equals((Object)FriendConnectionEvent.Type.CONNECTED)) {
                    if (IdleStatusMonitor.this.idleTime.getIdleTime() > 1200000L) {
                        IdleStatusMonitor.this.activityBroadcaster.broadcast(new XmppActivityEvent(XmppActivityEvent.ActivityState.Idle));
                    } else {
                        IdleStatusMonitor.this.activityBroadcaster.broadcast(new XmppActivityEvent(XmppActivityEvent.ActivityState.Active));
                    }
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel(false);
        }
    }
}

