/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryProvider;
import java.util.ArrayList;
import java.util.List;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.friend.api.FileOfferEvent;
import org.limewire.friend.api.FriendRequestEvent;
import org.limewire.friend.api.RosterEvent;
import org.limewire.friend.impl.LimeWireFriendXmppModule;
import org.limewire.listener.AsynchronousEventBroadcaster;
import org.limewire.listener.AsynchronousMulticasterImpl;
import org.limewire.listener.BroadcastPolicy;
import org.limewire.listener.CachingEventMulticasterImpl;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.ListenerSupport;
import org.limewire.xmpp.activity.XmppActivityEvent;
import org.limewire.xmpp.api.client.JabberSettings;
import org.limewire.xmpp.client.impl.ConnectionConfigurationFactory;
import org.limewire.xmpp.client.impl.DNSConnectionConfigurationFactory;
import org.limewire.xmpp.client.impl.FallbackConnectionConfigurationFactory;
import org.limewire.xmpp.client.impl.IdleStatusMonitor;
import org.limewire.xmpp.client.impl.IdleStatusMonitorFactory;
import org.limewire.xmpp.client.impl.IdleTime;
import org.limewire.xmpp.client.impl.IdleTimeImpl;
import org.limewire.xmpp.client.impl.XMPPConnectionFactoryImpl;
import org.limewire.xmpp.client.impl.XMPPConnectionImplFactory;
import org.limewire.xmpp.client.impl.XMPPFriendConnectionImpl;
import org.limewire.xmpp.client.impl.messages.address.AddressIQListener;
import org.limewire.xmpp.client.impl.messages.address.AddressIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.authtoken.AuthTokenIQListener;
import org.limewire.xmpp.client.impl.messages.authtoken.AuthTokenIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.connectrequest.ConnectBackRequestIQListener;
import org.limewire.xmpp.client.impl.messages.connectrequest.ConnectBackRequestIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.filetransfer.FileTransferIQListener;
import org.limewire.xmpp.client.impl.messages.filetransfer.FileTransferIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.library.LibraryChangedIQListener;
import org.limewire.xmpp.client.impl.messages.library.LibraryChangedIQListenerFactory;

public class LimeWireXMPPModule
extends AbstractModule {
    private final Class<? extends JabberSettings> jabberSettingsClass;

    public LimeWireXMPPModule(Class<? extends JabberSettings> jabberSettingsClass) {
        this.jabberSettingsClass = jabberSettingsClass;
    }

    @Override
    protected void configure() {
        this.install(new LimeWireFriendXmppModule());
        if (this.jabberSettingsClass != null) {
            this.bind(JabberSettings.class).to(this.jabberSettingsClass);
        }
        this.bind(XMPPConnectionFactoryImpl.class);
        ListeningExecutorService executor = ExecutorsHelper.newProcessingQueue("XMPPEventThread");
        AsynchronousMulticasterImpl rosterMulticaster = new AsynchronousMulticasterImpl(executor);
        this.bind(new TypeLiteral<AsynchronousEventBroadcaster<RosterEvent>>(){}).toInstance(rosterMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<RosterEvent>>(){}).toInstance(rosterMulticaster);
        EventMulticasterImpl fileOfferMulticaster = new EventMulticasterImpl();
        this.bind(new TypeLiteral<EventBroadcaster<FileOfferEvent>>(){}).toInstance(fileOfferMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FileOfferEvent>>(){}).toInstance(fileOfferMulticaster);
        EventMulticasterImpl friendRequestMulticaster = new EventMulticasterImpl();
        this.bind(new TypeLiteral<EventBroadcaster<FriendRequestEvent>>(){}).toInstance(friendRequestMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FriendRequestEvent>>(){}).toInstance(friendRequestMulticaster);
        CachingEventMulticasterImpl activityMulticaster = new CachingEventMulticasterImpl(BroadcastPolicy.IF_NOT_EQUALS);
        this.bind(new TypeLiteral<EventBroadcaster<XmppActivityEvent>>(){}).toInstance(activityMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<XmppActivityEvent>>(){}).toInstance(activityMulticaster);
        ArrayList<ConnectionConfigurationFactory> connectionConfigurationFactories = new ArrayList<ConnectionConfigurationFactory>(2);
        connectionConfigurationFactories.add(new DNSConnectionConfigurationFactory());
        connectionConfigurationFactories.add(new FallbackConnectionConfigurationFactory());
        this.bind(new TypeLiteral<List<ConnectionConfigurationFactory>>(){}).toInstance(connectionConfigurationFactories);
        this.bind(XMPPConnectionImplFactory.class).toProvider(FactoryProvider.newFactory(XMPPConnectionImplFactory.class, XMPPFriendConnectionImpl.class));
        this.bind(AddressIQListenerFactory.class).toProvider(FactoryProvider.newFactory(AddressIQListenerFactory.class, AddressIQListener.class));
        this.bind(AuthTokenIQListenerFactory.class).toProvider(FactoryProvider.newFactory(AuthTokenIQListenerFactory.class, AuthTokenIQListener.class));
        this.bind(ConnectBackRequestIQListenerFactory.class).toProvider(FactoryProvider.newFactory(ConnectBackRequestIQListenerFactory.class, ConnectBackRequestIQListener.class));
        this.bind(LibraryChangedIQListenerFactory.class).toProvider(FactoryProvider.newFactory(LibraryChangedIQListenerFactory.class, LibraryChangedIQListener.class));
        this.bind(FileTransferIQListenerFactory.class).toProvider(FactoryProvider.newFactory(FileTransferIQListenerFactory.class, FileTransferIQListener.class));
        this.bind(IdleTime.class).to(IdleTimeImpl.class);
        this.bind(IdleStatusMonitorFactory.class).toProvider(FactoryProvider.newFactory(IdleStatusMonitorFactory.class, IdleStatusMonitor.class));
    }
}

