/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.BorderLayout;
import javax.swing.SwingUtilities;
import org.limewire.activation.api.ActivationEvent;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationState;
import org.limewire.core.api.Application;
import org.limewire.core.api.library.LibraryData;
import org.limewire.core.settings.ActivationSettings;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.wizard.SetupActivationPanel;
import org.limewire.ui.swing.wizard.SetupActivationThankYouPanel;
import org.limewire.ui.swing.wizard.SetupComponentDecorator;
import org.limewire.ui.swing.wizard.Wizard;
import org.limewire.ui.swing.wizard.WizardPage;

public class SetupPage3
extends WizardPage {
    private final ActivationManager activationManager;
    private final Wizard wizard;
    private final Application application;
    private final boolean userHasPreexistingLicense;
    private ActivationListener activationListener;
    private String footerText;
    private String forwardText;
    private boolean hasBackButton;
    private boolean showingThankYouPage = false;
    private SetupActivationPanel activationPanel;

    public SetupPage3(SetupComponentDecorator decorator, Application application, LibraryData libraryData, ActivationManager activationManager, Wizard wizard) {
        super(decorator, application);
        GuiUtils.assignResources(this);
        this.application = application;
        this.activationManager = activationManager;
        this.wizard = wizard;
        this.userHasPreexistingLicense = !ActivationSettings.ACTIVATION_KEY.isDefault();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        if (activationManager.getActivationState() != ActivationState.AUTHORIZED) {
            this.activationListener = new ActivationListener();
            this.activationManager.addListener(this.activationListener);
            this.showLicenseEntryPage();
        } else {
            this.showModuleInfoPage();
        }
    }

    public void finalize() {
        if (this.activationListener != null) {
            this.activationManager.removeListener(this.activationListener);
            this.activationListener = null;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.activationPanel != null) {
            this.activationPanel.reset();
        }
        super.setVisible(visible);
    }

    @Override
    protected String getForwardButtonText() {
        return this.forwardText;
    }

    @Override
    protected boolean hasBackButton() {
        return this.hasBackButton;
    }

    @Override
    public void applySettings() {
        if (!this.showingThankYouPage) {
            this.activationPanel.applySettings();
        }
    }

    @Override
    public String getFooter() {
        return this.footerText;
    }

    @Override
    public String getLine1() {
        return I18n.tr("LimeWire PRO");
    }

    @Override
    public String getLine2() {
        return "";
    }

    private void showLicenseEntryPage() {
        this.footerText = I18n.tr("You can activate LimeWire PRO later from File > License");
        this.forwardText = I18n.tr("No thanks");
        this.hasBackButton = true;
        this.activationPanel = new SetupActivationPanel(this, this.activationManager, this.application);
        this.add(this.activationPanel);
    }

    private void showModuleInfoPage() {
        this.removeAll();
        this.add(new SetupActivationThankYouPanel(this, this.activationManager.getActivationItems(), this.userHasPreexistingLicense, this.application));
        this.footerText = I18n.tr("You can edit your licenses from File > License");
        this.forwardText = I18n.tr("Done");
        this.hasBackButton = false;
        this.wizard.updateControls();
        this.showingThankYouPage = true;
    }

    private class ActivationListener
    implements EventListener<ActivationEvent> {
        private ActivationListener() {
        }

        @Override
        public void handleEvent(ActivationEvent event) {
            if (event.getData() == ActivationState.AUTHORIZED) {
                SetupPage3.this.activationManager.removeListener(SetupPage3.this.activationListener);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SetupPage3.this.showModuleInfoPage();
                    }
                });
            }
        }
    }
}

