/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.warnings;

import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.HorizonalCheckBoxListPanel;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.Line;
import org.limewire.ui.swing.components.OverlayPopupPanel;
import org.limewire.ui.swing.components.PopupHeaderBar;
import org.limewire.ui.swing.mainframe.GlobalLayeredPane;
import org.limewire.ui.swing.options.ExtensionClassificationPanel;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.warnings.LibraryFileAdder;
import org.limewire.util.FileUtils;

class LibraryWarningDialog
extends OverlayPopupPanel {
    private static int HEIGHT_COLLAPSED = 185;
    private static int HEIGHT_OPEN = 240;
    private final CategoryManager categoryManager;
    private final LibraryFileAdder libraryFileAdder;
    private final Provider<ExtensionClassificationPanel> classificationPanelProvider;
    @Resource
    private Color border;
    @Resource
    private Font normalFont;
    @Resource
    private Color fontColor;
    @Resource
    private Icon upIcon;
    @Resource
    private Icon downIcon;
    private boolean isShared;
    private CancelAction cancelAction;
    private LocalFileList localFileList;
    private List<File> files;
    private JRadioButton recursiveButton;
    private JRadioButton nonRecursiveButton;
    private Line horizontalLine;
    private JToggleButton advancedToggleButton;
    private JTextField extensionTextField;
    private JLabel advancedLabel;
    private HorizonalCheckBoxListPanel<Category> categories;

    @Inject
    public LibraryWarningDialog(@GlobalLayeredPane JLayeredPane layeredPane, LibraryFileAdder libraryFileAdder, CategoryManager categoryManager, Provider<ExtensionClassificationPanel> classificationPanelProvider) {
        super(layeredPane);
        this.libraryFileAdder = libraryFileAdder;
        this.categoryManager = categoryManager;
        this.classificationPanelProvider = classificationPanelProvider;
        GuiUtils.assignResources(this);
        this.setLayout(new BorderLayout());
    }

    public void initialize(LocalFileList fileList, List<File> files) {
        this.localFileList = fileList;
        this.files = files;
        this.cancelAction = new CancelAction();
        this.setIsShared(fileList);
        PopupHeaderBar header = new PopupHeaderBar(this.getHeaderString(), this.cancelAction);
        this.add((Component)header, "North");
        this.add((Component)this.createBody(), "Center");
        this.repaint();
        this.validate();
    }

    private JPanel createBody() {
        JPanel p = new JPanel(new MigLayout("fill, gap 0"));
        p.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.border));
        JLabel messageLabel = new JLabel(this.getMessageString(this.localFileList));
        this.decorateComponent(messageLabel);
        HyperlinkButton learnMoreLink = new HyperlinkButton(new AbstractAction("(" + I18n.tr("Learn More") + ")"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ExtensionClassificationPanel)LibraryWarningDialog.this.classificationPanelProvider.get()).showDialogue();
            }
        });
        p.add((Component)messageLabel, "span, split 2");
        p.add((Component)learnMoreLink, "wrap");
        this.categories = this.createCheckBoxes();
        p.add(this.categories, "span, alignx center, gapbottom 5, wrap");
        File folder = this.getFolderBeingAdded(this.files);
        int folderCount = this.getFolderCount(this.files);
        String recursiveText = this.toHTML(this.getRecursiveLabel(folder, folderCount));
        this.recursiveButton = new JRadioButton(recursiveText);
        this.recursiveButton.setBorder(BorderFactory.createEmptyBorder());
        String nonRecursiveText = this.toHTML(this.getNonRecursiveLabel(folder, folderCount));
        this.nonRecursiveButton = new JRadioButton(nonRecursiveText);
        this.nonRecursiveButton.setBorder(BorderFactory.createEmptyBorder());
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this.recursiveButton);
        radioButtonGroup.add(this.nonRecursiveButton);
        this.recursiveButton.setSelected(LibrarySettings.DEFAULT_RECURSIVELY_ADD_FOLDERS_OPTION.getValue());
        JLabel fromLabel = new JLabel(I18n.tr("From:"));
        this.decorateComponent(fromLabel);
        p.add((Component)fromLabel, "span, wrap");
        p.add((Component)this.recursiveButton, "span, growy, wrap, gapleft 10");
        p.add((Component)this.nonRecursiveButton, "span, growy, wrap, gapleft 10");
        this.horizontalLine = Line.createHorizontalLine(this.border, 1);
        this.horizontalLine.setVisible(false);
        p.add((Component)this.horizontalLine, "span, growx, gapleft 10, gapright 10, gaptop 10, hidemode 3, wrap");
        p.add((Component)this.createAdvancedPanel(), "gaptop 5");
        p.add((Component)new JButton(new OKAction()), "split, aligny bottom, tag ok");
        p.add((Component)new JButton(this.cancelAction), "tag cancel, aligny bottom, wrap");
        return p;
    }

    private HorizonalCheckBoxListPanel<Category> createCheckBoxes() {
        List<Category> categoryList = Arrays.asList(Category.AUDIO, Category.VIDEO, Category.IMAGE, Category.DOCUMENT, Category.PROGRAM);
        HorizonalCheckBoxListPanel<Category> categoriesPanel = new HorizonalCheckBoxListPanel<Category>(categoryList);
        categoriesPanel.setSelected(SwingUiSettings.getDefaultSelectedCategories());
        categoriesPanel.setForeground(this.fontColor);
        categoriesPanel.setFont(this.normalFont);
        if (!((Boolean)LibrarySettings.ALLOW_PROGRAMS.get()).booleanValue()) {
            categoriesPanel.getCheckBox(Category.PROGRAM).setEnabled(false);
            categoriesPanel.getCheckBox(Category.PROGRAM).setSelected(false);
        }
        if (this.isShared && this.localFileList instanceof SharedFileList && ((SharedFileList)this.localFileList).isPublic() && !((Boolean)LibrarySettings.ALLOW_DOCUMENT_GNUTELLA_SHARING.get()).booleanValue()) {
            categoriesPanel.getCheckBox(Category.DOCUMENT).setEnabled(false);
            categoriesPanel.getCheckBox(Category.DOCUMENT).setSelected(false);
        }
        return categoriesPanel;
    }

    private JPanel createAdvancedPanel() {
        JPanel p = new JPanel(new MigLayout("fill, insets 0, gap 0, hidemode 3"));
        this.advancedToggleButton = new JToggleButton(I18n.tr("Advanced"));
        this.advancedToggleButton.setSelectedIcon(this.upIcon);
        this.advancedToggleButton.setIcon(this.downIcon);
        this.advancedToggleButton.setBorder(BorderFactory.createEmptyBorder());
        this.advancedToggleButton.setOpaque(false);
        this.advancedToggleButton.setContentAreaFilled(false);
        this.advancedToggleButton.setFocusPainted(false);
        this.advancedToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryWarningDialog.this.horizontalLine.setVisible(LibraryWarningDialog.this.advancedToggleButton.isSelected());
                LibraryWarningDialog.this.extensionTextField.setVisible(LibraryWarningDialog.this.advancedToggleButton.isSelected());
                LibraryWarningDialog.this.advancedLabel.setVisible(LibraryWarningDialog.this.advancedToggleButton.isSelected());
                LibraryWarningDialog.this.resize();
            }
        });
        this.advancedLabel = new JLabel(I18n.tr("Include files with the following extensions(abc, xyz)"));
        this.decorateComponent(this.advancedLabel);
        this.advancedLabel.setVisible(false);
        this.extensionTextField = new JTextField();
        this.extensionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (LibraryWarningDialog.this.extensionTextField.getText().trim().length() > 0) {
                    LibraryWarningDialog.this.advancedToggleButton.setEnabled(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (LibraryWarningDialog.this.extensionTextField.getText().trim().length() == 0) {
                    LibraryWarningDialog.this.advancedToggleButton.setEnabled(true);
                }
            }
        });
        this.decorateComponent(this.extensionTextField);
        this.extensionTextField.setVisible(false);
        p.add((Component)this.advancedToggleButton, "span, wrap, aligny bottom");
        p.add((Component)this.advancedLabel, "span, gaptop 5, wrap");
        p.add((Component)this.extensionTextField, "gaptop 5, growx");
        return p;
    }

    private void decorateComponent(JComponent component) {
        component.setFont(this.normalFont);
        component.setForeground(this.fontColor);
    }

    private String toHTML(String text) {
        return "<HTML><HEAD>" + this.createFontCSS(this.normalFont) + "</HEAD>" + text + "</HTML>";
    }

    private String createFontCSS(Font font) {
        return "<style TYPE=\"text/css\"><!--body {font-family: " + font.getFamily() + ";" + "font-size: " + font.getSize() + "pt;" + "font-weight: lighter;}-->" + "</style>";
    }

    private void setIsShared(LocalFileList fileList) {
        this.isShared = fileList instanceof SharedFileList && (((SharedFileList)fileList).isPublic() || ((SharedFileList)fileList).getFriendIds().size() > 0);
    }

    private String getHeaderString() {
        if (this.isShared) {
            return I18n.tr("Choose What to Share");
        }
        return I18n.tr("Choose What to Add");
    }

    private String getMessageString(LocalFileList fileList) {
        if (this.isShared) {
            if (fileList instanceof SharedFileList && ((SharedFileList)fileList).isPublic()) {
                return I18n.tr("Choose the type of files to share with the world");
            }
            return I18n.trn("Choose the types of files to share with {0} friend", "Choose the types of files to share with {0} friends", ((SharedFileList)fileList).getFriendIds().size());
        }
        return I18n.tr("Add these types of files");
    }

    private File getFolderBeingAdded(List<File> files) {
        int directoryCount = 0;
        File folder = null;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            folder = file;
            if (++directoryCount <= 1) continue;
            folder = null;
            break;
        }
        return folder;
    }

    private int getFolderCount(List<File> files) {
        int folderCount = 0;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            ++folderCount;
        }
        return folderCount;
    }

    private String getRecursiveLabel(File folder, int folderCount) {
        if (folder != null) {
            return I18n.tr("\"{0}\" and all its subfolders", folder.getName());
        }
        return I18n.tr("{0} folders and all their subfolders", folderCount);
    }

    private String getNonRecursiveLabel(File folder, int folderCount) {
        if (folder != null) {
            return I18n.tr("\"{0}\" only", folder.getName());
        }
        return I18n.tr("{0} folders only", folderCount);
    }

    @Override
    public void resize() {
        Rectangle parentBounds = this.getParent().getBounds();
        int w = 520;
        int h = HEIGHT_COLLAPSED;
        h = this.advancedToggleButton != null && this.advancedToggleButton.isSelected() ? HEIGHT_OPEN : HEIGHT_COLLAPSED;
        this.setBounds((int)parentBounds.getWidth() / 2 - w / 2, (int)parentBounds.getHeight() / 2 - h / 2, w, h);
    }

    private List<String> getAdvancedExtensions() {
        String text = this.extensionTextField.getText();
        String[] parsed = text.split(",\\s*\\.?|\\s*\\.|\\s+");
        return Arrays.asList(parsed);
    }

    private class Filter
    implements FileFilter {
        private final Set<String> extensionSet;
        private final boolean isRecursive;

        public Filter(Collection<Category> categories, List<String> advancedExtensions, boolean isRecursive) {
            this.isRecursive = isRecursive;
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER);
            builder.addAll(advancedExtensions);
            for (Category category : categories) {
                builder.addAll(LibraryWarningDialog.this.categoryManager.getExtensionsForCategory(category));
            }
            this.extensionSet = builder.build();
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return this.isRecursive;
            }
            return this.extensionSet.contains(FileUtils.getFileExtension(file));
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(I18n.tr("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryWarningDialog.this.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            if (LibraryWarningDialog.this.isShared) {
                this.putValue("Name", I18n.tr("Share"));
            } else {
                this.putValue("Name", I18n.tr("Add"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List includedExtensions = LibraryWarningDialog.this.getAdvancedExtensions();
            LibraryWarningDialog.this.libraryFileAdder.addFilesInner(LibraryWarningDialog.this.localFileList, LibraryWarningDialog.this.files, new Filter(LibraryWarningDialog.this.categories.getSelected(), includedExtensions, LibraryWarningDialog.this.recursiveButton.isSelected()));
            LibraryWarningDialog.this.dispose();
        }
    }
}

