/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.limewire.core.settings.SharingSettings;
import org.limewire.io.IOUtils;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class SaveDirectoryHandler {
    private SaveDirectoryHandler() {
    }

    public static void validateSaveDirectoryAndPromptForNewOne() {
        File saveDir = SharingSettings.getSaveDirectory();
        if (!SaveDirectoryHandler.isDirectoryValid(saveDir)) {
            SaveDirectoryHandler.promptAndSetNewSaveDirectory();
        }
    }

    public static boolean isDirectoryValid(File dir) {
        return SaveDirectoryHandler.isSaveDirectoryValid(dir) && SaveDirectoryHandler.showVistaWarningIfNeeded(dir);
    }

    private static void promptAndSetNewSaveDirectory() {
        File dir = null;
        while (!SaveDirectoryHandler.isSaveDirectoryValid(dir) || !SaveDirectoryHandler.showVistaWarningIfNeeded(dir)) {
            FocusJOptionPane.showMessageDialog(GuiUtils.getMainFrame(), I18n.tr("Your save folder is not valid. It may have been deleted, you may not have permissions to write to it, or there may be another problem. Please choose a different folder."), I18n.tr("Invalid Folder"), 2);
            dir = SaveDirectoryHandler.showChooser();
            if (dir == null) continue;
            FileUtils.setWriteable(dir);
        }
    }

    private static File showChooser() {
        File dir = FileChooser.getInputDirectory(GuiUtils.getMainFrame());
        if (dir != null) {
            try {
                SharingSettings.setSaveDirectory(dir);
                return dir;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSaveDirectoryValid(File saveDir) {
        boolean bl;
        if (saveDir == null || saveDir.isFile()) {
            return false;
        }
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        if (!saveDir.isDirectory()) {
            return false;
        }
        FileUtils.setWriteable(saveDir);
        Random generator = new Random();
        File testFile = null;
        for (int i = 0; i < 10 && testFile == null; ++i) {
            StringBuilder name = new StringBuilder();
            for (int j = 0; j < 8; ++j) {
                name.append((char)(97 + generator.nextInt(25)));
            }
            name.append(".tmp");
            testFile = new File(saveDir, name.toString());
            if (!testFile.exists()) continue;
            testFile = null;
        }
        if (testFile == null) {
            return false;
        }
        RandomAccessFile testRAFile = null;
        try {
            testRAFile = new RandomAccessFile(testFile, "rw");
            testRAFile.write(7);
            testRAFile.close();
        }
        catch (FileNotFoundException e) {
            bl = false;
            return bl;
        }
        catch (IOException e) {
            bl = false;
            return bl;
        }
        finally {
            testFile.delete();
            IOUtils.close(testRAFile);
        }
        return FileUtils.canWrite(saveDir);
    }

    private static boolean isGoodVistaDirectory(File f) {
        if (!OSUtils.isWindowsVista()) {
            return true;
        }
        try {
            return FileUtils.isReallyInParentPath(CommonUtils.getUserHomeDir(), f);
        }
        catch (IOException iox) {
            return true;
        }
    }

    private static boolean showVistaWarningIfNeeded(File f) {
        if (SaveDirectoryHandler.isGoodVistaDirectory(f)) {
            return true;
        }
        if (SwingUiSettings.VISTA_WARN_DIRECTORIES.contains(f)) {
            return true;
        }
        int ret = FocusJOptionPane.showOptionDialog(GuiUtils.getMainFrame(), I18n.tr("Saving downloads to {0} may not function correctly.\nTo be sure downloads are saved properly you should save them to a sub-folder of\n{1}.\nWould you like to choose another location?", f, CommonUtils.getUserHomeDir()), I18n.tr("Folder Warning"), 0, 2, null, null, 0);
        if (ret == 1) {
            SwingUiSettings.VISTA_WARN_DIRECTORIES.add(f);
        }
        return ret == 1;
    }
}

