/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.Category;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadListManager;
import org.limewire.core.api.upload.UploadState;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.transfer.TransferTrayNavigator;
import org.limewire.ui.swing.upload.UploadHeaderPopupMenu;
import org.limewire.ui.swing.upload.table.UploadTable;
import org.limewire.ui.swing.upload.table.UploadTableFactory;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

@EagerSingleton
public class UploadMediator {
    public static final String NAME = "UploadPanel";
    private final UploadListManager uploadListManager;
    private final Provider<TorrentManager> torrentManager;
    private final UploadTableFactory uploadTableFactory;
    private final Provider<TransferTrayNavigator> transferTrayNavigator;
    private EventList<UploadItem> activeList;
    private SortedList<UploadItem> sortedList;
    private JPanel uploadPanel;
    private UploadTable uploadTable;
    private JButton clearFinishedButton;
    private List<JButton> headerButtons;
    private JPopupMenu headerPopupMenu;

    @Inject
    public UploadMediator(UploadListManager uploadListManager, Provider<TorrentManager> torrentManager, UploadTableFactory uploadTableFactory, Provider<TransferTrayNavigator> transferTrayNavigator) {
        this.uploadListManager = uploadListManager;
        this.torrentManager = torrentManager;
        this.uploadTableFactory = uploadTableFactory;
        this.transferTrayNavigator = transferTrayNavigator;
        this.sortedList = GlazedListsFactory.sortedList(uploadListManager.getSwingThreadSafeUploads(), new OrderedComparator<UploadItem>(this.getSortComparator(this.getSortOrder()), this.isSortAscending()));
    }

    @Inject
    public void register(ServiceRegistry serviceRegister) {
        serviceRegister.start(this.uploadListManager);
        SharingSettings.CLEAR_UPLOAD.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean clearUploads = SharingSettings.CLEAR_UPLOAD.getValue();
                        if (clearUploads) {
                            UploadMediator.this.clearFinished();
                        }
                        if (UploadMediator.this.clearFinishedButton != null) {
                            UploadMediator.this.clearFinishedButton.setVisible(!clearUploads);
                        }
                    }
                });
            }
        });
        FilterList<UploadItem> doneList = GlazedListsFactory.filterList(this.uploadListManager.getSwingThreadSafeUploads(), new CompleteUploadMatcher());
        doneList.addListEventListener(new ListEventListener<UploadItem>(){

            @Override
            public void listChanged(ListEvent<UploadItem> listChanges) {
                if (UploadMediator.this.clearFinishedButton != null) {
                    UploadMediator.this.clearFinishedButton.setEnabled(listChanges.getSourceList().size() > 0);
                }
            }
        });
    }

    public JComponent getComponent() {
        if (this.uploadPanel == null) {
            this.uploadPanel = this.createUploadPanel();
        }
        return this.uploadPanel;
    }

    private JPanel createUploadPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.uploadTable = this.uploadTableFactory.create(this);
        this.uploadTable.setTableHeader(null);
        JScrollPane scrollPane = new JScrollPane(this.uploadTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    public EventList<UploadItem> getActiveList() {
        if (this.activeList == null) {
            this.activeList = GlazedListsFactory.filterList(this.uploadListManager.getSwingThreadSafeUploads(), new ActiveUploadMatcher());
        }
        return this.activeList;
    }

    public List<JButton> getHeaderButtons() {
        if (this.headerButtons == null) {
            this.clearFinishedButton = new HyperlinkButton(new ClearFinishedAction());
            this.clearFinishedButton.setVisible(!SharingSettings.CLEAR_UPLOAD.getValue());
            this.headerButtons = new ArrayList<JButton>();
            this.headerButtons.add(this.clearFinishedButton);
        }
        return this.headerButtons;
    }

    public JPopupMenu getHeaderPopupMenu() {
        if (this.headerPopupMenu == null) {
            this.headerPopupMenu = new UploadHeaderPopupMenu(this, this.torrentManager, this.transferTrayNavigator);
        }
        return this.headerPopupMenu;
    }

    public EventList<UploadItem> getUploadList() {
        return this.sortedList;
    }

    public List<UploadItem> getSelectedUploads() {
        if (this.uploadTable != null) {
            return this.uploadTable.getSelectedItems();
        }
        return Collections.emptyList();
    }

    public boolean isSortAscending() {
        return SwingUiSettings.UPLOAD_SORT_ASCENDING.getValue();
    }

    public SortOrder getSortOrder() {
        try {
            String sortKey = SwingUiSettings.UPLOAD_SORT_KEY.get();
            return SortOrder.valueOf(sortKey);
        }
        catch (IllegalArgumentException ex) {
            return SortOrder.ORDER_STARTED;
        }
    }

    public void setSortOrder(SortOrder sortOrder, boolean ascending) {
        SwingUiSettings.UPLOAD_SORT_KEY.set(sortOrder.toString());
        SwingUiSettings.UPLOAD_SORT_ASCENDING.setValue(ascending);
        this.sortedList.setComparator(new OrderedComparator<UploadItem>(this.getSortComparator(sortOrder), ascending));
    }

    private Comparator<UploadItem> getSortComparator(SortOrder sortOrder) {
        switch (sortOrder) {
            case ORDER_STARTED: {
                return new OrderStartedComparator();
            }
            case NAME: {
                return new NameComparator();
            }
            case PROGRESS: {
                return new ProgressComparator();
            }
            case TIME_REMAINING: {
                return new TimeRemainingComparator();
            }
            case SPEED: {
                return new SpeedComparator();
            }
            case STATUS: {
                return new StateComparator();
            }
            case FILE_TYPE: {
                return new CategoryComparator();
            }
            case FILE_EXTENSION: {
                return new FileExtensionComparator();
            }
            case USER_NAME: {
                return new HostNameComparator();
            }
        }
        throw new IllegalArgumentException("Unknown SortOrder: " + (Object)((Object)sortOrder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPausable() {
        EventList<UploadItem> uploadList = this.getUploadList();
        uploadList.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : uploadList) {
                if (!UploadMediator.isPausable(item)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            uploadList.getReadWriteLock().readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResumable() {
        EventList<UploadItem> uploadList = this.getUploadList();
        uploadList.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : uploadList) {
                if (!UploadMediator.isResumable(item)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            uploadList.getReadWriteLock().readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        EventList<UploadItem> uploadList = this.getUploadList();
        uploadList.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : uploadList) {
                if (!item.getState().isError()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            uploadList.getReadWriteLock().readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTorrents() {
        EventList<UploadItem> uploadList = this.getUploadList();
        uploadList.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : uploadList) {
                if (item.getUploadItemType() != UploadItem.UploadItemType.BITTORRENT) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            uploadList.getReadWriteLock().readLock().unlock();
        }
        return false;
    }

    public static boolean isBrowseHost(UploadItem uploadItem) {
        UploadState state = uploadItem.getState();
        return state == UploadState.BROWSE_HOST || state == UploadState.BROWSE_HOST_DONE;
    }

    public static boolean isPausable(UploadItem uploadItem) {
        return uploadItem.getUploadItemType() == UploadItem.UploadItemType.BITTORRENT && uploadItem.getState() == UploadState.UPLOADING;
    }

    public static boolean isResumable(UploadItem uploadItem) {
        return uploadItem.getUploadItemType() == UploadItem.UploadItemType.BITTORRENT && uploadItem.getState() == UploadState.PAUSED;
    }

    public static boolean isRemovable(UploadItem uploadItem) {
        UploadState state = uploadItem.getState();
        return state.isFinished() || state.isError();
    }

    public void cancel(UploadItem uploadItem, boolean remove) {
        this.cancel(uploadItem, remove, true);
    }

    public void cancel(UploadItem uploadItem, boolean remove, boolean prompt) {
        boolean approved = true;
        if (uploadItem.getUploadItemType() == UploadItem.UploadItemType.BITTORRENT) {
            if (!uploadItem.isStarted()) {
                approved = false;
            } else if (prompt && !uploadItem.isFinished()) {
                approved = this.promptUser(I18n.tr("If you stop this upload, the torrent download will stop.  Are you sure you want to do this?"));
            } else if (prompt && uploadItem.getSeedRatio() < 1.0f) {
                approved = this.promptUser(I18n.tr("Are you sure you want to stop this upload?"));
            }
        }
        if (approved) {
            uploadItem.cancel();
            if (remove) {
                this.remove(uploadItem);
            }
        }
    }

    public void remove(UploadItem uploadItem) {
        this.uploadListManager.remove(uploadItem);
    }

    private boolean promptUser(String message) {
        return FocusJOptionPane.showConfirmDialog(GuiUtils.getMainFrame(), new MultiLineLabel(message, 400), I18n.tr("Uploads"), 0) == 0;
    }

    public void cancelAll() {
        ArrayList<UploadItem> uploadList = new ArrayList<UploadItem>(this.getUploadList());
        for (UploadItem item : uploadList) {
            this.cancel(item, false, false);
        }
    }

    public void cancelAllError() {
        ArrayList<UploadItem> uploadList = new ArrayList<UploadItem>(this.getUploadList());
        for (UploadItem item : uploadList) {
            if (!item.getState().isError()) continue;
            this.cancel(item, false, false);
        }
    }

    public void cancelAllTorrents() {
        ArrayList<UploadItem> uploadList = new ArrayList<UploadItem>(this.getUploadList());
        for (UploadItem item : uploadList) {
            if (item.getUploadItemType() != UploadItem.UploadItemType.BITTORRENT) continue;
            this.cancel(item, false, false);
        }
    }

    private void clearFinished() {
        this.uploadListManager.clearFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll() {
        EventList<UploadItem> uploadList = this.getUploadList();
        uploadList.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : uploadList) {
                if (!UploadMediator.isPausable(item)) continue;
                item.pause();
            }
        }
        finally {
            uploadList.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll() {
        EventList<UploadItem> uploadList = this.getUploadList();
        uploadList.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : uploadList) {
                if (!UploadMediator.isResumable(item)) continue;
                item.resume();
            }
        }
        finally {
            uploadList.getReadWriteLock().readLock().unlock();
        }
    }

    private static class OrderedComparator<T>
    implements Comparator<T> {
        private final Comparator<T> delegate;
        private final boolean ascending;

        public OrderedComparator(Comparator<T> delegate, boolean ascending) {
            this.delegate = delegate;
            this.ascending = ascending;
        }

        @Override
        public int compare(T o1, T o2) {
            return (this.ascending ? 1 : -1) * this.delegate.compare(o1, o2);
        }
    }

    private static class HostNameComparator
    implements Comparator<UploadItem> {
        private HostNameComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            String name1 = o1.getRenderName();
            String name2 = o2.getRenderName();
            return Objects.compareToNullIgnoreCase(name1, name2, false);
        }
    }

    private static class FileExtensionComparator
    implements Comparator<UploadItem> {
        private FileExtensionComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            String name1 = o1.getFileName();
            String name2 = o2.getFileName();
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            String ext1 = FileUtils.getFileExtension(name1);
            String ext2 = FileUtils.getFileExtension(name2);
            return Objects.compareToNullIgnoreCase(ext1, ext2, false);
        }
    }

    private static class CategoryComparator
    implements Comparator<UploadItem> {
        private CategoryComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            Category cat1 = o1.getCategory();
            Category cat2 = o2.getCategory();
            return cat1.compareTo(cat2);
        }
    }

    private static class StateComparator
    implements Comparator<UploadItem> {
        private StateComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            int value1 = this.getSortValue(o1.getState());
            int value2 = this.getSortValue(o2.getState());
            return value1 - value2;
        }

        private int getSortValue(UploadState state) {
            switch (state) {
                case DONE: {
                    return 1;
                }
                case UPLOADING: {
                    return 2;
                }
                case PAUSED: {
                    return 3;
                }
                case QUEUED: {
                    return 4;
                }
                case REQUEST_ERROR: {
                    return 5;
                }
                case LIMIT_REACHED: {
                    return 5;
                }
                case CANCELED: {
                    return 6;
                }
                case BROWSE_HOST: {
                    return 7;
                }
                case BROWSE_HOST_DONE: {
                    return 8;
                }
            }
            throw new IllegalArgumentException("Unknown UploadState: " + (Object)((Object)state));
        }
    }

    private static class SpeedComparator
    implements Comparator<UploadItem> {
        private SpeedComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            float speed1 = o1.getUploadSpeed();
            float speed2 = o2.getUploadSpeed();
            return (int)(speed1 - speed2);
        }
    }

    private static class TimeRemainingComparator
    implements Comparator<UploadItem> {
        private TimeRemainingComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            long time1 = o1.getRemainingUploadTime();
            long time2 = o2.getRemainingUploadTime();
            return (int)(time1 - time2);
        }
    }

    private static class ProgressComparator
    implements Comparator<UploadItem> {
        private ProgressComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            int pct1 = this.getProgressPct(o1);
            int pct2 = this.getProgressPct(o2);
            return pct1 - pct2;
        }

        private int getProgressPct(UploadItem item) {
            if (item.getFileSize() <= 0L) {
                return -1;
            }
            return (int)(100L * item.getTotalAmountUploaded() / item.getFileSize());
        }
    }

    private static class NameComparator
    implements Comparator<UploadItem> {
        private NameComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            String name1 = o1.getFileName();
            String name2 = o2.getFileName();
            return Objects.compareToNullIgnoreCase(name1, name2, false);
        }
    }

    private static class OrderStartedComparator
    implements Comparator<UploadItem> {
        private OrderStartedComparator() {
        }

        @Override
        public int compare(UploadItem o1, UploadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return (int)(o1.getStartTime() - o2.getStartTime());
        }
    }

    private class CompleteUploadMatcher
    implements Matcher<UploadItem> {
        private CompleteUploadMatcher() {
        }

        @Override
        public boolean matches(UploadItem item) {
            if (item == null) {
                return false;
            }
            UploadState state = item.getState();
            return state == UploadState.DONE || state == UploadState.LIMIT_REACHED || state == UploadState.CANCELED || state == UploadState.BROWSE_HOST || state == UploadState.BROWSE_HOST_DONE || state == UploadState.REQUEST_ERROR;
        }
    }

    private class ActiveUploadMatcher
    implements Matcher<UploadItem> {
        private ActiveUploadMatcher() {
        }

        @Override
        public boolean matches(UploadItem item) {
            if (item == null) {
                return false;
            }
            UploadState state = item.getState();
            return state == UploadState.QUEUED || state == UploadState.UPLOADING;
        }
    }

    private class ClearFinishedAction
    extends AbstractAction {
        public ClearFinishedAction() {
            super(I18n.tr("Clear Finished"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UploadMediator.this.clearFinished();
        }
    }

    public static enum SortOrder {
        ORDER_STARTED,
        NAME,
        PROGRESS,
        TIME_REMAINING,
        SPEED,
        STATUS,
        FILE_TYPE,
        FILE_EXTENSION,
        USER_NAME;

    }
}

