/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.FileProcessingEvent;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.PopupHeaderBar;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.util.FileUtils;

public class FileProcessingPopupContentPanel
extends JPanel
implements Disposable {
    @Resource
    private Color border = PainterUtils.TRASPARENT;
    @Resource
    private Font font;
    @Resource
    private Color foreground;
    private final LibraryManager libraryManager;
    private final JLabel processingLine;
    private final HyperlinkButton stopButton;
    private EventListener<FileProcessingEvent> listener;

    @Inject
    public FileProcessingPopupContentPanel(final LibraryManager libraryManager) {
        super(new BorderLayout());
        this.libraryManager = libraryManager;
        GuiUtils.assignResources(this);
        this.add((Component)new PopupHeaderBar(I18n.tr("Adding Files"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileProcessingPopupContentPanel.this.setVisible(false);
            }
        }), "North");
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, this.border));
        this.processingLine = new JLabel(I18n.tr("Scanning..."));
        this.stopButton = new HyperlinkButton(new AbstractAction(I18n.tr("stop")){

            @Override
            public void actionPerformed(ActionEvent e) {
                libraryManager.getLibraryManagedList().cancelPendingTasks();
            }
        });
        this.processingLine.setFont(this.font);
        this.processingLine.setForeground(this.foreground);
        this.processingLine.setMaximumSize(new Dimension(140, 40));
        this.stopButton.setFont(this.font);
        JPanel bottomPanel = new JPanel(new MigLayout("insets 0 6 2 6, gap 5, fill"));
        bottomPanel.add(this.processingLine);
        bottomPanel.add((Component)this.stopButton, "gapbefore push");
        this.add((Component)bottomPanel, "Center");
    }

    @Inject
    void register(final IconManager iconManager) {
        this.listener = new EventListener<FileProcessingEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FileProcessingEvent event) {
                switch ((FileProcessingEvent.Type)((Object)event.getType())) {
                    case PROCESSING: {
                        String fileName = ((File)event.getSource()).getName();
                        FileProcessingPopupContentPanel.this.processingLine.setText(fileName);
                        FileProcessingPopupContentPanel.this.processingLine.setToolTipText(fileName);
                        FileProcessingPopupContentPanel.this.processingLine.setIcon(iconManager.getIconForExtension(FileUtils.getFileExtension(((File)event.getSource()).getName())));
                        FileProcessingPopupContentPanel.this.stopButton.setVisible(true);
                    }
                }
            }
        };
        this.libraryManager.getLibraryManagedList().addFileProcessingListener(this.listener);
    }

    public void notifyDone() {
        this.stopButton.setVisible(false);
        this.processingLine.setText(I18n.tr("All Completed"));
        this.processingLine.setIcon(null);
    }

    @Override
    public void dispose() {
        this.libraryManager.getLibraryManagedList().removeFileProcessingListener(this.listener);
    }
}

