/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.list;

import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.components.RemoteHostWidget;
import org.limewire.ui.swing.components.RemoteHostWidgetFactory;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.listener.MousePopupListener;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoDialogFactory;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.DownloadHandler;
import org.limewire.ui.swing.search.resultpanel.ResultsTable;
import org.limewire.ui.swing.search.resultpanel.SearchHeading;
import org.limewire.ui.swing.search.resultpanel.SearchHeadingDocumentBuilder;
import org.limewire.ui.swing.search.resultpanel.SearchResultMenu;
import org.limewire.ui.swing.search.resultpanel.SearchResultMenuFactory;
import org.limewire.ui.swing.search.resultpanel.SearchResultTruncator;
import org.limewire.ui.swing.search.resultpanel.list.ListViewDisplayedRowsLimit;
import org.limewire.ui.swing.search.resultpanel.list.ListViewRowHeightRule;
import org.limewire.ui.swing.table.TransparentCellTableRenderer;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class ListViewTableEditorRenderer
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final Log LOG = LogFactory.getLog(ListViewTableEditorRenderer.class);
    private static final int LEFT_COLUMN_WIDTH = 450;
    private final CategoryIconManager categoryIconManager;
    private static final String HTML = "<html>";
    private static final String CLOSING_HTML_TAG = "</html>";
    @Resource
    private Icon similarResultsIcon;
    @Resource
    private Color subHeadingLabelColor;
    @Resource
    private Color metadataLabelColor;
    @Resource
    private Color downloadSourceCountColor;
    @Resource
    private Color similarResultsBackgroundColor;
    @Resource
    private Color surplusRowLimitColor;
    @Resource
    private String headingColor;
    @Resource
    private Font headingFont;
    @Resource
    private Font subHeadingFont;
    @Resource
    private Font metadataFont;
    @Resource
    private Font downloadSourceCountFont;
    @Resource
    private Font surplusRowLimitFont;
    @Resource
    private Icon spamIcon;
    @Resource
    private Icon downloadingIcon;
    @Resource
    private Icon libraryIcon;
    @Resource
    private Icon warningIcon;
    @Resource
    private Icon propertiesPressedIcon;
    @Resource
    private Icon propertiesHoverIcon;
    @Resource
    private Icon propertiesIcon;
    @Resource
    private Icon propertiesSimilarShownPressedIcon;
    @Resource
    private Icon propertiesSimilarShownHoverIcon;
    @Resource
    private Icon propertiesSimilarShownIcon;
    @Resource
    private Icon similarHiddenIcon;
    @Resource
    private Icon similarHiddenPressedIcon;
    @Resource
    private Icon similarHiddenHoverIcon;
    @Resource
    private Icon similarShownIcon;
    @Resource
    private Icon similarShownPressedIcon;
    @Resource
    private Icon similarShownHoverIcon;
    @Resource
    private Icon dividerIcon;
    private final Provider<SearchHeadingDocumentBuilder> headingBuilder;
    private final ListViewRowHeightRule rowHeightRule;
    private final ListViewDisplayedRowsLimit displayLimit;
    private final Provider<SearchResultTruncator> truncator;
    private final HeadingFontWidthResolver headingFontWidthResolver = new HeadingFontWidthResolver();
    private final FileInfoDialogFactory fileInfoFactory;
    private RemoteHostWidget fromWidget;
    private JButton itemIconButton;
    private IconButton similarButton = new IconButton();
    private IconButton propertiesButton = new IconButton();
    private JEditorPane heading = new JEditorPane();
    private JLabel subheadingLabel = new NoDancingHtmlLabel();
    private JLabel metadataLabel = new NoDancingHtmlLabel();
    private JLabel downloadSourceCount = new TransparentCellTableRenderer();
    private JXPanel editorComponent;
    private VisualSearchResult vsr;
    private JTable table;
    private JComponent similarResultIndentation;
    private JPanel lastRowPanel;
    private final JPanel emptyPanel = new JPanel();
    private JXPanel searchResultTextPanel;
    private JLabel lastRowMessage;
    private DownloadHandler downloadHandler;
    private int textPanelWidth;
    private final SearchResultMenuFactory searchResultMenuFactory;

    @Inject
    ListViewTableEditorRenderer(CategoryIconManager categoryIconManager, RemoteHostWidgetFactory fromWidgetFactory, Navigator navigator, @Assisted DownloadHandler downloadHandler, Provider<SearchHeadingDocumentBuilder> headingBuilder, @Assisted ListViewRowHeightRule rowHeightRule, @Assisted ListViewDisplayedRowsLimit displayLimit, LibraryMediator libraryMediator, Provider<SearchResultTruncator> truncator, FileInfoDialogFactory fileInfoFactory, SearchResultMenuFactory searchResultMenuFactory) {
        this.categoryIconManager = categoryIconManager;
        this.headingBuilder = headingBuilder;
        this.rowHeightRule = rowHeightRule;
        this.displayLimit = displayLimit;
        this.truncator = truncator;
        this.downloadHandler = downloadHandler;
        this.fileInfoFactory = fileInfoFactory;
        this.searchResultMenuFactory = searchResultMenuFactory;
        GuiUtils.assignResources(this);
        this.fromWidget = fromWidgetFactory.create(RemoteHostWidget.RemoteWidgetType.SEARCH_LIST);
        this.makePanel(navigator, libraryMediator);
        this.setupButtons();
        this.layoutEditorComponent();
    }

    private void makePanel(Navigator navigator, LibraryMediator libraryMediator) {
        this.initializeComponents();
        this.makeIndentation();
        this.setupListeners(navigator, libraryMediator);
        this.lastRowPanel = new JPanel(new MigLayout("insets 10 30 0 0", "[]", "[]"));
        this.lastRowPanel.setOpaque(false);
        this.lastRowMessage = new JLabel();
        this.lastRowMessage.setFont(this.surplusRowLimitFont);
        this.lastRowMessage.setForeground(this.surplusRowLimitColor);
        this.lastRowPanel.add(this.lastRowMessage);
        this.emptyPanel.setOpaque(false);
    }

    private void setupButtons() {
        this.similarButton.setFocusable(false);
        this.similarButton.setIcon(this.similarHiddenIcon);
        this.similarButton.setPressedIcon(this.similarHiddenPressedIcon);
        this.similarButton.setRolloverIcon(this.similarHiddenHoverIcon);
        this.similarButton.setToolTipText(I18n.tr("Show Similar Files"));
        this.propertiesButton.setFocusable(false);
        this.propertiesButton.setIcon(this.propertiesIcon);
        this.propertiesButton.setPressedIcon(this.propertiesPressedIcon);
        this.propertiesButton.setRolloverIcon(this.propertiesHoverIcon);
        this.propertiesButton.setToolTipText(I18n.tr("View File Info"));
        this.itemIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListViewTableEditorRenderer.this.isDownloadEligible(ListViewTableEditorRenderer.this.vsr)) {
                    ListViewTableEditorRenderer.this.downloadHandler.download(ListViewTableEditorRenderer.this.vsr);
                    ListViewTableEditorRenderer.this.table.editingStopped(new ChangeEvent(ListViewTableEditorRenderer.this.table));
                }
            }
        });
        this.similarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListViewTableEditorRenderer.this.vsr.toggleChildrenVisibility();
                if (ListViewTableEditorRenderer.this.vsr.isChildrenVisible()) {
                    ListViewTableEditorRenderer.this.similarButton.setIcon(ListViewTableEditorRenderer.this.similarShownIcon);
                    ListViewTableEditorRenderer.this.similarButton.setPressedIcon(ListViewTableEditorRenderer.this.similarShownPressedIcon);
                    ListViewTableEditorRenderer.this.similarButton.setRolloverIcon(ListViewTableEditorRenderer.this.similarShownHoverIcon);
                    ListViewTableEditorRenderer.this.similarButton.setToolTipText(I18n.tr("Hide Similar Files"));
                    ListViewTableEditorRenderer.this.propertiesButton.setIcon(ListViewTableEditorRenderer.this.propertiesSimilarShownIcon);
                    ListViewTableEditorRenderer.this.propertiesButton.setPressedIcon(ListViewTableEditorRenderer.this.propertiesSimilarShownPressedIcon);
                    ListViewTableEditorRenderer.this.propertiesButton.setRolloverIcon(ListViewTableEditorRenderer.this.propertiesSimilarShownHoverIcon);
                } else {
                    ListViewTableEditorRenderer.this.similarButton.setIcon(ListViewTableEditorRenderer.this.similarHiddenIcon);
                    ListViewTableEditorRenderer.this.similarButton.setPressedIcon(ListViewTableEditorRenderer.this.similarHiddenPressedIcon);
                    ListViewTableEditorRenderer.this.similarButton.setRolloverIcon(ListViewTableEditorRenderer.this.similarHiddenHoverIcon);
                    ListViewTableEditorRenderer.this.similarButton.setToolTipText(I18n.tr("Show Similar Files"));
                    ListViewTableEditorRenderer.this.propertiesButton.setIcon(ListViewTableEditorRenderer.this.propertiesIcon);
                    ListViewTableEditorRenderer.this.propertiesButton.setPressedIcon(ListViewTableEditorRenderer.this.propertiesPressedIcon);
                    ListViewTableEditorRenderer.this.propertiesButton.setRolloverIcon(ListViewTableEditorRenderer.this.propertiesHoverIcon);
                }
                ListViewTableEditorRenderer.this.table.editingStopped(new ChangeEvent(ListViewTableEditorRenderer.this.table));
            }
        });
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInfoDialog dialog = ListViewTableEditorRenderer.this.fileInfoFactory.createFileInfoDialog(ListViewTableEditorRenderer.this.vsr, FileInfoDialog.FileInfoType.REMOTE_FILE);
                dialog.setVisible(true);
            }
        });
    }

    private void layoutEditorComponent() {
        this.searchResultTextPanel.setLayout(new MigLayout("nogrid, ins 0 0 0 0, gap 0! 0!, novisualpadding"));
        this.searchResultTextPanel.setOpaque(false);
        this.searchResultTextPanel.add((Component)this.heading, "left, shrinkprio 200, growx, wmax pref, hidemode 3, wrap");
        this.searchResultTextPanel.add((Component)this.subheadingLabel, "left, shrinkprio 200, growx, hidemode 3, wrap");
        this.searchResultTextPanel.add((Component)this.metadataLabel, "left, shrinkprio 200, hidemode 3");
        this.editorComponent.setLayout(new MigLayout("ins 0 0 0 0, gap 0! 0!, novisualpadding"));
        this.editorComponent.add((Component)this.similarResultIndentation, "growy, hidemode 3, shrinkprio 0");
        this.editorComponent.add((Component)this.itemIconButton, "left, aligny 50%, gapleft 4, shrinkprio 0");
        this.editorComponent.add((Component)this.searchResultTextPanel, "left, , aligny 50%, gapleft 4, growx, shrinkprio 200, growprio 200, push");
        this.editorComponent.add((Component)this.downloadSourceCount, "gapbottom 3, gapright 2, shrinkprio 0");
        this.editorComponent.add((Component)new JLabel(this.dividerIcon), "shrinkprio 0");
        this.editorComponent.add((Component)this.fromWidget, "wmin 90, left, shrinkprio 0");
        this.editorComponent.add((Component)this.similarButton, "gapright 4, hidemode 0, hmax 25, wmax 27, shrinkprio 0");
        this.editorComponent.add((Component)this.propertiesButton, "gapright 4, hmax 25, wmax 27, shrinkprio 0");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.vsr = (VisualSearchResult)value;
        this.table = table;
        this.editorComponent.setBackground(table.getBackground());
        if (value == null) {
            return this.emptyPanel;
        }
        LOG.debugf("row: {0} shouldIndent: {1}", (Object)row, (Object)(this.vsr.getSimilarityParent() != null ? 1 : 0));
        if (row == this.displayLimit.getLastDisplayedRow()) {
            this.lastRowMessage.setText(I18n.tr("Not showing {0} results.  Narrow results to see more.", this.displayLimit.getTotalResultsReturned() - this.displayLimit.getLastDisplayedRow()));
            return this.lastRowPanel;
        }
        this.update(this.vsr);
        return this.editorComponent;
    }

    private void update(VisualSearchResult vsr) {
        this.fromWidget.setPeople(vsr.getSources());
        this.propertiesButton.setIcon(vsr.isChildrenVisible() ? this.propertiesSimilarShownIcon : this.propertiesIcon);
        this.similarButton.setVisible(vsr.getSimilarResults().size() > 0);
        this.similarButton.setIcon(vsr.isChildrenVisible() ? this.similarShownIcon : this.similarHiddenIcon);
        this.similarResultIndentation.setVisible(vsr.getSimilarityParent() != null);
        this.itemIconButton.setIcon(this.getIcon(vsr));
        this.itemIconButton.setCursor(this.getIconCursor(vsr));
        ListViewRowHeightRule.RowDisplayResult result = this.rowHeightRule.getDisplayResult(vsr);
        this.setLabelVisibility(result.getConfig());
        this.populateHeading(result, vsr.getDownloadState());
        this.populateSubheading(result);
        this.populateMetadata(result);
    }

    private Icon getIcon(VisualSearchResult vsr) {
        if (vsr.isSpam()) {
            return this.spamIcon;
        }
        switch (vsr.getDownloadState()) {
            case DOWNLOADING: {
                return this.downloadingIcon;
            }
            case DOWNLOADED: 
            case LIBRARY: {
                return this.libraryIcon;
            }
            case REMOVED: {
                return this.warningIcon;
            }
        }
        return this.categoryIconManager.getIcon(vsr);
    }

    private Cursor getIconCursor(VisualSearchResult vsr) {
        boolean useDefaultCursor = !this.isDownloadEligible(vsr);
        return Cursor.getPredefinedCursor(useDefaultCursor ? 0 : 12);
    }

    private void setLabelVisibility(ListViewRowHeightRule.RowDisplayConfig config) {
        switch (config) {
            case HeadingOnly: {
                this.subheadingLabel.setVisible(false);
                this.metadataLabel.setVisible(false);
                break;
            }
            case HeadingAndSubheading: {
                this.subheadingLabel.setVisible(true);
                this.metadataLabel.setVisible(false);
                break;
            }
            case HeadingAndMetadata: {
                this.subheadingLabel.setVisible(false);
                this.metadataLabel.setVisible(true);
                break;
            }
            case HeadingSubHeadingAndMetadata: {
                this.subheadingLabel.setVisible(true);
                this.metadataLabel.setVisible(true);
            }
        }
    }

    private void populateHeading(final ListViewRowHeightRule.RowDisplayResult result, BasicDownloadState downloadState) {
        int width = this.textPanelWidth == 0 ? 450 : this.textPanelWidth;
        final int fudgeFactorPixelWidth = width - 10;
        SearchHeading searchHeading = new SearchHeading(){

            @Override
            public String getText() {
                String headingText = result.getHeading();
                String truncatedHeading = ((SearchResultTruncator)ListViewTableEditorRenderer.this.truncator.get()).truncateHeading(headingText, fudgeFactorPixelWidth, ListViewTableEditorRenderer.this.headingFontWidthResolver);
                this.handleHeadingTooltip(headingText, truncatedHeading);
                return truncatedHeading;
            }

            private void handleHeadingTooltip(String headingText, String truncatedHeading) {
                String toolTipText = ListViewTableEditorRenderer.HTML + headingText + ListViewTableEditorRenderer.CLOSING_HTML_TAG;
                ListViewTableEditorRenderer.this.editorComponent.setToolTipText(toolTipText);
                ListViewTableEditorRenderer.this.heading.setToolTipText(toolTipText);
            }

            @Override
            public String getText(String adjoiningFragment) {
                int adjoiningTextPixelWidth = ListViewTableEditorRenderer.this.headingFontWidthResolver.getPixelWidth(adjoiningFragment);
                String headingText = result.getHeading();
                String truncatedHeading = ((SearchResultTruncator)ListViewTableEditorRenderer.this.truncator.get()).truncateHeading(headingText, fudgeFactorPixelWidth - adjoiningTextPixelWidth, ListViewTableEditorRenderer.this.headingFontWidthResolver);
                this.handleHeadingTooltip(headingText, truncatedHeading);
                return truncatedHeading;
            }
        };
        this.heading.setText(this.headingBuilder.get().getHeadingDocument(searchHeading, downloadState, result.isSpam()));
        this.downloadSourceCount.setText(Integer.toString(this.vsr.getSources().size()));
    }

    private void populateSubheading(ListViewRowHeightRule.RowDisplayResult result) {
        this.subheadingLabel.setText(result.getSubheading());
    }

    private void populateMetadata(ListViewRowHeightRule.RowDisplayResult result) {
        this.metadataLabel.setText(null);
        ListViewRowHeightRule.RowDisplayConfig config = result.getConfig();
        if (config != ListViewRowHeightRule.RowDisplayConfig.HeadingSubHeadingAndMetadata && config != ListViewRowHeightRule.RowDisplayConfig.HeadingAndMetadata) {
            return;
        }
        ListViewRowHeightRule.PropertyMatch pm = result.getMetadata();
        if (pm != null) {
            String html = pm.getHighlightedValue();
            html = html.replace(HTML, "").replace(CLOSING_HTML_TAG, "");
            html = HTML + pm.getKey() + ":" + html + CLOSING_HTML_TAG;
            this.metadataLabel.setText(html);
        }
    }

    private boolean isDownloadEligible(VisualSearchResult vsr) {
        return !vsr.isSpam() && vsr.getDownloadState() == BasicDownloadState.NOT_STARTED;
    }

    private void initializeComponents() {
        this.searchResultTextPanel = new JXPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                ListViewTableEditorRenderer.this.textPanelWidth = this.getSize().width;
            }
        };
        this.editorComponent = new JXPanel();
        this.itemIconButton = new IconButton();
        this.heading.setContentType("text/html");
        HTMLDocument document = new HTMLDocument();
        this.heading.setDocument(document);
        this.heading.setEditable(false);
        this.heading.setCaretPosition(0);
        this.heading.setSelectionColor(HTMLLabel.TRANSPARENT_COLOR);
        this.heading.setOpaque(false);
        this.heading.setFocusable(false);
        StyleSheet mainStyle = document.getStyleSheet();
        String rules = "body { font-family: " + this.headingFont.getFamily() + "; }" + ".title { color: " + this.headingColor + "; font-size: " + this.headingFont.getSize() + "; }" + "a { color: " + this.headingColor + "; }";
        StyleSheet newStyle = new StyleSheet();
        newStyle.addRule(rules);
        mainStyle.addStyleSheet(newStyle);
        this.heading.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        this.heading.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.subheadingLabel.setForeground(this.subHeadingLabelColor);
        this.subheadingLabel.setFont(this.subHeadingFont);
        this.subheadingLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 1, 3));
        this.metadataLabel.setForeground(this.metadataLabelColor);
        this.metadataLabel.setFont(this.metadataFont);
        this.metadataLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        this.downloadSourceCount.setForeground(this.downloadSourceCountColor);
        this.downloadSourceCount.setFont(this.downloadSourceCountFont);
    }

    private void makeIndentation() {
        this.similarResultIndentation = new JPanel(new BorderLayout());
        this.similarResultIndentation.add((Component)new JLabel(this.similarResultsIcon), "Center");
        this.similarResultIndentation.setBackground(this.similarResultsBackgroundColor);
    }

    private void setupListeners(Navigator navigator, LibraryMediator libraryMediator) {
        this.heading.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType() && e.getDescription().equals("#download")) {
                    ListViewTableEditorRenderer.this.downloadHandler.download(ListViewTableEditorRenderer.this.vsr);
                    ListViewTableEditorRenderer.this.table.editingStopped(new ChangeEvent(ListViewTableEditorRenderer.this.table));
                }
            }
        });
        Component[] listenerComponents = new Component[]{this.editorComponent, this.heading, this.subheadingLabel, this.metadataLabel, this.similarResultIndentation, this.searchResultTextPanel, this.downloadSourceCount, this.itemIconButton};
        MousePopupListener popupListener = new MousePopupListener(){

            @Override
            public void handlePopupMouseEvent(MouseEvent e) {
                int[] selectedRows;
                if (ListViewTableEditorRenderer.this.table.isEditing()) {
                    int editRow = ListViewTableEditorRenderer.this.table.getEditingRow();
                    if (!ListViewTableEditorRenderer.this.table.isRowSelected(editRow)) {
                        ListViewTableEditorRenderer.this.updateSelection(e);
                    }
                }
                ArrayList<VisualSearchResult> selectedResults = new ArrayList<VisualSearchResult>();
                DefaultEventTableModel model = ((ResultsTable)ListViewTableEditorRenderer.this.table).getEventTableModel();
                for (int row : selectedRows = ListViewTableEditorRenderer.this.table.getSelectedRows()) {
                    Object element = model.getElementAt(row);
                    if (!(element instanceof VisualSearchResult)) continue;
                    selectedResults.add((VisualSearchResult)element);
                }
                if (selectedResults.size() == 0) {
                    selectedResults.add(ListViewTableEditorRenderer.this.vsr);
                }
                SearchResultMenu searchResultMenu = ListViewTableEditorRenderer.this.searchResultMenuFactory.create(ListViewTableEditorRenderer.this.downloadHandler, selectedResults, SearchResultMenu.ViewType.List);
                searchResultMenu.show(e.getComponent(), e.getX() + 3, e.getY() + 3);
            }
        };
        this.addMouseListener(popupListener, listenerComponents);
        MouseAdapter selectionDownloadAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ListViewTableEditorRenderer.this.updateSelection(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ListViewTableEditorRenderer.this.vsr != null && !ListViewTableEditorRenderer.this.vsr.isSpam() && e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ListViewTableEditorRenderer.this.downloadHandler.download(ListViewTableEditorRenderer.this.vsr);
                }
            }
        };
        this.addMouseListener(selectionDownloadAdapter, listenerComponents);
    }

    private void addMouseListener(MouseListener listener, Component ... components) {
        for (Component c : components) {
            c.addMouseListener(listener);
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.vsr;
    }

    private void updateSelection(MouseEvent e) {
        if (this.table.isEditing()) {
            int editRow = this.table.getEditingRow();
            int editCol = this.table.getEditingColumn();
            if (editRow > -1 && editRow < this.table.getRowCount()) {
                this.table.changeSelection(editRow, editCol, e.isControlDown(), e.isShiftDown());
                this.table.prepareEditor(this, editRow, editCol);
            }
        }
        e.getComponent().requestFocusInWindow();
    }

    private static class NoDancingHtmlLabel
    extends TransparentCellTableRenderer {
        public NoDancingHtmlLabel() {
            this.setVerticalAlignment(1);
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
        }
    }

    private class HeadingFontWidthResolver
    implements SearchResultTruncator.FontWidthResolver {
        private static final String EMPTY_STRING = "";
        private final Pattern findHTMLTagsOrReplacementTokens = Pattern.compile("([<][/]?[\\w =\"#]*[>])|([{][\\d]*[}])");
        private final Matcher matcher = this.findHTMLTagsOrReplacementTokens.matcher("");

        private HeadingFontWidthResolver() {
        }

        @Override
        public int getPixelWidth(String text) {
            FontMetrics fontMetrics;
            if (ListViewTableEditorRenderer.this.heading.getEditorKit() instanceof HTMLEditorKit) {
                HTMLEditorKit editorKit = (HTMLEditorKit)ListViewTableEditorRenderer.this.heading.getEditorKit();
                StyleSheet css = editorKit.getStyleSheet();
                fontMetrics = css.getFontMetrics(ListViewTableEditorRenderer.this.headingFont);
            } else {
                Graphics graphics = ListViewTableEditorRenderer.this.heading.getGraphics();
                fontMetrics = graphics.getFontMetrics(ListViewTableEditorRenderer.this.headingFont);
            }
            this.matcher.reset(text);
            text = this.matcher.replaceAll(EMPTY_STRING);
            return fontMetrics.stringWidth(text);
        }
    }
}

