/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryProvider;
import com.google.inject.name.Names;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.StringTrieSet;
import org.limewire.inject.LazyBinder;
import org.limewire.ui.swing.filter.AdvancedFilterPanelFactory;
import org.limewire.ui.swing.search.BrowseFailedMessagePanel;
import org.limewire.ui.swing.search.BrowseFailedMessagePanelFactory;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.search.FriendPresenceActionsImpl;
import org.limewire.ui.swing.search.ResultsContainer;
import org.limewire.ui.swing.search.ResultsContainerFactory;
import org.limewire.ui.swing.search.SearchFilterPanelFactory;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.search.SearchHandlerImpl;
import org.limewire.ui.swing.search.SearchResultsPanel;
import org.limewire.ui.swing.search.SearchResultsPanelFactory;
import org.limewire.ui.swing.search.SortAndFilterPanel;
import org.limewire.ui.swing.search.SortAndFilterPanelFactory;
import org.limewire.ui.swing.search.TextSearchHandlerImpl;
import org.limewire.ui.swing.search.model.SimilarResultsDetectorFactory;
import org.limewire.ui.swing.search.model.SimilarResultsDetectorFactoryImpl;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.model.VisualSearchResultFactory;
import org.limewire.ui.swing.search.model.VisualSearchResultFactoryImpl;
import org.limewire.ui.swing.search.resultpanel.BaseResultPanel;
import org.limewire.ui.swing.search.resultpanel.BaseResultPanelFactory;
import org.limewire.ui.swing.search.resultpanel.SearchHeadingDocumentBuilder;
import org.limewire.ui.swing.search.resultpanel.SearchHeadingDocumentBuilderImpl;
import org.limewire.ui.swing.search.resultpanel.SearchResultTruncator;
import org.limewire.ui.swing.search.resultpanel.SearchResultTruncatorImpl;
import org.limewire.ui.swing.search.resultpanel.list.ListViewRowHeightRule;
import org.limewire.ui.swing.search.resultpanel.list.ListViewRowHeightRuleImpl;
import org.limewire.ui.swing.search.resultpanel.list.ListViewTableEditorRenderer;
import org.limewire.ui.swing.search.resultpanel.list.ListViewTableEditorRendererFactory;

public class LimeWireUiSearchModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(AutoCompleteDictionary.class).annotatedWith(Names.named("searchHistory")).toInstance(new StringTrieSet(true));
        this.bind(SearchHandler.class).to(SearchHandlerImpl.class);
        this.bind(SearchHandler.class).annotatedWith(Names.named("text")).to(TextSearchHandlerImpl.class);
        this.bind(SimilarResultsDetectorFactory.class).to(SimilarResultsDetectorFactoryImpl.class);
        this.bind(VisualSearchResultFactory.class).to(VisualSearchResultFactoryImpl.class);
        this.bind(SearchResultsPanelFactory.class).toProvider(FactoryProvider.newFactory(SearchResultsPanelFactory.class, SearchResultsPanel.class));
        this.bind(ResultsContainerFactory.class).toProvider(FactoryProvider.newFactory(ResultsContainerFactory.class, ResultsContainer.class));
        this.bind(SortAndFilterPanelFactory.class).toProvider(FactoryProvider.newFactory(SortAndFilterPanelFactory.class, SortAndFilterPanel.class));
        this.bind(new TypeLiteral<AdvancedFilterPanelFactory<VisualSearchResult>>(){}).to(SearchFilterPanelFactory.class);
        this.bind(BaseResultPanelFactory.class).toProvider(FactoryProvider.newFactory(BaseResultPanelFactory.class, BaseResultPanel.class));
        this.bind(ListViewTableEditorRendererFactory.class).toProvider(FactoryProvider.newFactory(ListViewTableEditorRendererFactory.class, ListViewTableEditorRenderer.class));
        this.bind(FriendPresenceActions.class).toProvider(LazyBinder.newLazyProvider(FriendPresenceActions.class, FriendPresenceActionsImpl.class));
        this.bind(SearchHeadingDocumentBuilder.class).toProvider(LazyBinder.newLazyProvider(SearchHeadingDocumentBuilder.class, SearchHeadingDocumentBuilderImpl.class));
        this.bind(ListViewRowHeightRule.class).to(ListViewRowHeightRuleImpl.class);
        this.bind(SearchResultTruncator.class).toProvider(LazyBinder.newLazyProvider(SearchResultTruncator.class, SearchResultTruncatorImpl.class));
        this.bind(BrowseFailedMessagePanelFactory.class).toProvider(FactoryProvider.newFactory(BrowseFailedMessagePanelFactory.class, BrowseFailedMessagePanel.class));
    }
}

