/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.core.api.Application;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.core.settings.ContentSettings;
import org.limewire.core.settings.FilterSettings;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.NonNullJComboBox;
import org.limewire.ui.swing.options.FilterFileExtensionsOptionPanel;
import org.limewire.ui.swing.options.FilterKeywordOptionPanel;
import org.limewire.ui.swing.options.LearnMoreButton;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.UnsafeTypeOptionPanel;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.options.actions.DialogDisplayAction;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.search.SearchCategoryUtils;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SearchSettingListener;

public class SearchOptionPanel
extends OptionPanel {
    private final AutoCompleteDictionary searchHistory;
    private final SpamManager spamManager;
    private final Application application;
    private final UnsafeTypeOptionPanel unsafeOptionPanel;
    private final Provider<FilterKeywordOptionPanel> filterKeywordOptionPanelProvider;
    private final Provider<FilterFileExtensionsOptionPanel> filterFileExtensionsOptionPanelProvider;
    private SearchBarPanel searchBarPanel;
    private FilteringPanel filteringPanel;
    private JCheckBox groupSimilarResults;

    @Inject
    public SearchOptionPanel(@Named(value="searchHistory") AutoCompleteDictionary searchHistory, SpamManager spamManager, UnsafeTypeOptionPanel unsafeOptionPanel, Application application, Provider<FilterKeywordOptionPanel> filterKeywordOptionPanelProvider, Provider<FilterFileExtensionsOptionPanel> filterFileExtensionsOptionPanelProvider) {
        this.application = application;
        this.spamManager = spamManager;
        this.searchHistory = searchHistory;
        this.unsafeOptionPanel = unsafeOptionPanel;
        this.filterKeywordOptionPanelProvider = filterKeywordOptionPanelProvider;
        this.filterFileExtensionsOptionPanelProvider = filterFileExtensionsOptionPanelProvider;
        this.groupSimilarResults = new JCheckBox(I18n.tr("Group similar search results together"));
        this.groupSimilarResults.setContentAreaFilled(false);
        this.setLayout(new MigLayout("nogrid, insets 15 15 15 15, fillx, gap 4"));
        this.add((Component)this.getSearchBarPanel(), "growx, wrap");
        this.add((Component)this.getFilteringPanel(), "growx, wrap");
        this.add(this.groupSimilarResults);
        this.add((Component)new LearnMoreButton("http://www.limewire.com/client_redirect/?page=groupSimilarResults", application), "wrap");
    }

    private OptionPanel getSearchBarPanel() {
        if (this.searchBarPanel == null) {
            this.searchBarPanel = new SearchBarPanel();
        }
        return this.searchBarPanel;
    }

    @Override
    boolean applyOptions() {
        SwingUiSettings.GROUP_SIMILAR_RESULTS_ENABLED.setValue(this.groupSimilarResults.isSelected());
        boolean restart = this.getSearchBarPanel().applyOptions();
        return restart |= this.getFilteringPanel().applyOptions();
    }

    @Override
    boolean hasChanged() {
        return this.getSearchBarPanel().hasChanged() || this.getFilteringPanel().hasChanged() || this.groupSimilarResults.isSelected() != SwingUiSettings.GROUP_SIMILAR_RESULTS_ENABLED.getValue();
    }

    @Override
    public void initOptions() {
        this.getSearchBarPanel().initOptions();
        this.getFilteringPanel().initOptions();
        this.groupSimilarResults.setSelected(SwingUiSettings.GROUP_SIMILAR_RESULTS_ENABLED.getValue());
    }

    private OptionPanel getFilteringPanel() {
        if (this.filteringPanel == null) {
            this.filteringPanel = new FilteringPanel();
        }
        return this.filteringPanel;
    }

    private class FilteringPanel
    extends OptionPanel {
        private FilterKeywordOptionPanel filterKeywordPanel;
        private FilterFileExtensionsOptionPanel filterFileExtensionPanel;
        private JCheckBox copyrightContentCheckBox;
        private JCheckBox adultContentCheckBox;
        private JButton filterKeywordsButton;
        private JButton filterFileExtensionsButton;
        private final JButton configureButton;
        private JButton clearSpamButton;

        public FilteringPanel() {
            super(I18n.tr("Search Filtering"));
            this.configureButton = new JButton(new DialogDisplayAction(SearchOptionPanel.this, SearchOptionPanel.this.unsafeOptionPanel, I18n.tr("Unsafe File Sharing"), I18n.tr("Configure..."), I18n.tr("Configure unsafe file sharing settings")));
            this.filterKeywordPanel = (FilterKeywordOptionPanel)SearchOptionPanel.this.filterKeywordOptionPanelProvider.get();
            this.filterKeywordPanel.setPreferredSize(new Dimension(300, 400));
            this.filterFileExtensionPanel = (FilterFileExtensionsOptionPanel)SearchOptionPanel.this.filterFileExtensionsOptionPanelProvider.get();
            this.filterFileExtensionPanel.setPreferredSize(new Dimension(300, 400));
            this.copyrightContentCheckBox = new JCheckBox("<html>" + I18n.tr("Don't let me download or upload files copyright owners request not be shared.") + "</html>");
            this.copyrightContentCheckBox.setContentAreaFilled(false);
            this.adultContentCheckBox = new JCheckBox("<html>" + I18n.tr("Don't show adult content in search results") + "</html>");
            this.adultContentCheckBox.setContentAreaFilled(false);
            this.filterKeywordsButton = new JButton(new DialogDisplayAction(SearchOptionPanel.this, this.filterKeywordPanel, I18n.tr("Filter Keywords"), I18n.tr("Filter Keywords..."), I18n.tr("Restrict files with certain words from being displayed in search results")));
            this.filterFileExtensionsButton = new JButton(new DialogDisplayAction(SearchOptionPanel.this, this.filterFileExtensionPanel, I18n.tr("Filter File Extensions"), I18n.tr("Filter File Extensions..."), I18n.tr("Restrict files with certain extensions from being displayed in search results")));
            this.clearSpamButton = new JButton(new DialogDisplayAction(SearchOptionPanel.this, new SpamOptionPanel(), I18n.tr("Reset Spam Filter"), I18n.tr("Reset Spam Filter..."), I18n.tr("Reset the Spam filter by clearing all files marked as spam")));
            JLabel programSharingLabel = new JLabel(I18n.tr("Change the ability to search for Programs"));
            this.add((Component)programSharingLabel, "");
            this.add((Component)this.configureButton, "wrap");
            this.add(this.copyrightContentCheckBox);
            this.add((Component)new LearnMoreButton("http://www.limewire.com/client_redirect/?page=copyright", SearchOptionPanel.this.application), "wrap");
            this.add((Component)this.adultContentCheckBox, "gapbottom 10, wrap");
            this.add((Component)this.filterKeywordsButton, "gapright 10, alignx left");
            this.add((Component)this.filterFileExtensionsButton, "gapright 10, alignx left");
            this.add((Component)this.clearSpamButton, "gapright 10, alignx left, wrap");
        }

        @Override
        boolean applyOptions() {
            ContentSettings.USER_WANTS_MANAGEMENTS.setValue(this.copyrightContentCheckBox.isSelected());
            if (FilterSettings.FILTER_ADULT.getValue() != this.adultContentCheckBox.isSelected()) {
                FilterSettings.FILTER_ADULT.setValue(this.adultContentCheckBox.isSelected());
                BackgroundExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        SearchOptionPanel.this.spamManager.adjustSpamFilters();
                    }
                });
            }
            return this.filterKeywordPanel.applyOptions() || this.filterFileExtensionPanel.applyOptions() || SearchOptionPanel.this.unsafeOptionPanel.applyOptions();
        }

        @Override
        boolean hasChanged() {
            return ContentSettings.USER_WANTS_MANAGEMENTS.getValue() != this.copyrightContentCheckBox.isSelected() || FilterSettings.FILTER_ADULT.getValue() != this.adultContentCheckBox.isSelected() || this.filterKeywordPanel.hasChanged() || this.filterFileExtensionPanel.hasChanged() || SearchOptionPanel.this.unsafeOptionPanel.hasChanged();
        }

        @Override
        public void initOptions() {
            this.copyrightContentCheckBox.setSelected(ContentSettings.USER_WANTS_MANAGEMENTS.getValue());
            this.adultContentCheckBox.setSelected(FilterSettings.FILTER_ADULT.getValue());
            this.filterKeywordPanel.initOptions();
            this.filterFileExtensionPanel.initOptions();
            SearchOptionPanel.this.unsafeOptionPanel.initOptions();
        }

        private final class SpamOptionPanel
        extends JPanel {
            private SpamOptionPanel() {
                this.setLayout(new MigLayout("gapy 10, nogrid"));
                this.add((Component)new JLabel(I18n.tr("Do you want to reset the Spam Filter?")), "wrap");
                this.add((Component)new MultiLineLabel(I18n.tr("This will clear all the files marked as spam. Doing this may result in more spam in search results."), 400), "wrap");
                JButton okButton = new JButton(new OKDialogAction(I18n.tr("Reset")));
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchOptionPanel.this.spamManager.clearFilterData();
                    }
                });
                this.add((Component)okButton, "tag ok, alignx right,");
                this.add((Component)new JButton(new CancelDialogAction()), "tag cancel");
            }
        }
    }

    private static class CategoryCellRenderer
    extends DefaultListCellRenderer {
        public CategoryCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            SearchCategory category = (SearchCategory)((Object)value);
            this.setText(SearchCategoryUtils.getOptionsName(category));
            return this;
        }
    }

    private class SearchBarPanel
    extends OptionPanel {
        private JComboBox defaultSearchSpinner;
        private JCheckBox searchTabNumberCheckBox;
        private JCheckBox suggestFriendFiles;
        private JButton clearNowButton;

        public SearchBarPanel() {
            super(I18n.tr("Search Bar"));
            this.createComponents();
            this.add(new JLabel(I18n.tr("By default, search for")));
            this.add((Component)this.defaultSearchSpinner, "wrap");
            this.add((Component)this.suggestFriendFiles, "wrap");
            this.add((Component)this.searchTabNumberCheckBox, "gapright push");
            this.add((Component)this.clearNowButton, "alignx right, wrap");
        }

        private void createComponents() {
            this.defaultSearchSpinner = new NonNullJComboBox((Object[])SearchCategory.values());
            this.defaultSearchSpinner.setRenderer(new CategoryCellRenderer());
            this.defaultSearchSpinner.removeItem((Object)SearchCategory.OTHER);
            LibrarySettings.ALLOW_PROGRAMS.addSettingListener(new SearchSettingListener(LibrarySettings.ALLOW_PROGRAMS, SearchCategory.PROGRAM, this.defaultSearchSpinner));
            this.suggestFriendFiles = new JCheckBox(I18n.tr("Suggest files from friends"));
            this.suggestFriendFiles.setOpaque(false);
            this.searchTabNumberCheckBox = new JCheckBox(I18n.tr("Remember my recent searches"));
            this.searchTabNumberCheckBox.setOpaque(false);
            this.clearNowButton = new JButton(new AbstractAction(I18n.tr("Clear Now")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchOptionPanel.this.searchHistory.clear();
                }
            });
        }

        @Override
        boolean applyOptions() {
            SearchCategory category = (SearchCategory)((Object)this.defaultSearchSpinner.getSelectedItem());
            if (category != null) {
                SwingUiSettings.DEFAULT_SEARCH_CATEGORY_ID.setValue(category.getId());
            }
            SwingUiSettings.SHOW_FRIEND_SUGGESTIONS.setValue(this.suggestFriendFiles.isSelected());
            SwingUiSettings.KEEP_SEARCH_HISTORY.setValue(this.searchTabNumberCheckBox.isSelected());
            return false;
        }

        @Override
        boolean hasChanged() {
            return SwingUiSettings.DEFAULT_SEARCH_CATEGORY_ID.getValue() != ((SearchCategory)((Object)this.defaultSearchSpinner.getSelectedItem())).getId() || SwingUiSettings.SHOW_FRIEND_SUGGESTIONS.getValue() != this.suggestFriendFiles.isSelected() || SwingUiSettings.KEEP_SEARCH_HISTORY.getValue() != this.searchTabNumberCheckBox.isSelected();
        }

        @Override
        public void initOptions() {
            this.defaultSearchSpinner.setSelectedItem((Object)SearchCategory.forId(SwingUiSettings.DEFAULT_SEARCH_CATEGORY_ID.getValue()));
            this.suggestFriendFiles.setSelected(SwingUiSettings.SHOW_FRIEND_SUGGESTIONS.getValue());
            this.searchTabNumberCheckBox.setSelected(SwingUiSettings.KEEP_SEARCH_HISTORY.getValue());
        }
    }
}

