/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.ui.swing.components.AbstractTabList;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.FlexibleTabList;
import org.limewire.ui.swing.components.FlexibleTabListFactory;
import org.limewire.ui.swing.components.NoOpAction;
import org.limewire.ui.swing.components.SelectableJXButton;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.friends.refresh.AllFriendsRefreshManager;
import org.limewire.ui.swing.home.HomeMediator;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.mainframe.FriendsButton;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavItemListener;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.NavSelectable;
import org.limewire.ui.swing.nav.NavigationListener;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.nav.NavigatorUtils;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.painter.factories.SearchTabPainterFactory;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.DefaultSearchRepeater;
import org.limewire.ui.swing.search.KeywordAssistedSearchBuilder;
import org.limewire.ui.swing.search.SearchBar;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.SearchNavItem;
import org.limewire.ui.swing.search.SearchNavigator;
import org.limewire.ui.swing.search.SearchResultMediator;
import org.limewire.ui.swing.search.UiSearchListener;
import org.limewire.ui.swing.search.advanced.AdvancedSearchPanel;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.StringUtils;

@Singleton
class TopPanel
extends JXPanel
implements SearchNavigator {
    @Resource
    private Icon browseIcon;
    private final JXButton friendButton;
    private final SearchBar searchBar;
    private final FlexibleTabList searchList;
    private final Navigator navigator;
    private final NavItem homeNav;
    private final NavItem libraryNav;
    private final Provider<KeywordAssistedSearchBuilder> keywordAssistedSearchBuilder;
    private final Provider<AdvancedSearchPanel> advancedSearchPanel;
    private final SearchHandler searchHandler;
    private final HomeMediator homeMediator;
    private final String repeatSearchTitle = I18n.tr("Repeat Search");
    private final String refreshBrowseTitle = I18n.tr("Refresh");
    @InspectablePrimitive(value="maximum tab count", category=DataCategory.USAGE)
    private volatile long maxTabCount = 0L;
    private final AllFriendsRefreshManager allFriendsRefreshManager;
    @InspectablePrimitive(value="advanced search opened", category=DataCategory.USAGE)
    private int advancedSearches;

    @Inject
    public TopPanel(SearchHandler searchHandler, Navigator navigator, HomeMediator homeMediator, SearchBar searchBar, FlexibleTabListFactory tabListFactory, BarPainterFactory barPainterFactory, SearchTabPainterFactory tabPainterFactory, LibraryMediator myLibraryMediator, Provider<KeywordAssistedSearchBuilder> keywordAssistedSearchBuilder, Provider<AdvancedSearchPanel> advancedSearchPanel, Provider<FriendsButton> friendsButtonProvider, AllFriendsRefreshManager allFriendsRefreshManager, ButtonDecorator buttonDecorator) {
        GuiUtils.assignResources(this);
        this.searchHandler = searchHandler;
        this.searchBar = searchBar;
        this.navigator = navigator;
        this.searchBar.addSearchActionListener(new Searcher(searchHandler));
        this.keywordAssistedSearchBuilder = keywordAssistedSearchBuilder;
        this.advancedSearchPanel = advancedSearchPanel;
        this.homeMediator = homeMediator;
        this.allFriendsRefreshManager = allFriendsRefreshManager;
        this.setName("WireframeTop");
        this.setBackgroundPainter(barPainterFactory.createTopBarPainter());
        this.homeNav = navigator.createNavItem(NavCategory.LIMEWIRE, "Home", homeMediator);
        this.libraryNav = navigator.createNavItem(NavCategory.LIBRARY, "Library", myLibraryMediator);
        SelectableJXButton libraryButton = new SelectableJXButton(NavigatorUtils.getNavAction(this.libraryNav));
        libraryButton.setName("WireframeTop.libraryButton");
        libraryButton.setText(I18n.tr("My Files"));
        buttonDecorator.decorateBasicHeaderButton(libraryButton);
        this.friendButton = friendsButtonProvider.get();
        this.friendButton.setName("WireframeTop.friendsButton");
        this.searchList = tabListFactory.create();
        this.searchList.setName("WireframeTop.SearchList");
        this.searchList.setCloseAllText(I18n.tr("Close All Searches"));
        this.searchList.setCloseOneText(I18n.tr("Close Search"));
        this.searchList.setCloseOtherText(I18n.tr("Close Other Searches"));
        this.searchList.setRemovable(true);
        this.searchList.setSelectionPainter(tabPainterFactory.createSelectionPainter());
        this.searchList.setHighlightPainter(tabPainterFactory.createHighlightPainter());
        this.searchList.setNormalPainter(tabPainterFactory.createNormalPainter());
        this.searchList.setTabInsets(new Insets(0, 10, 2, 10));
        this.setLayout(new MigLayout("gap 0, insets 0, fill, alignx leading"));
        this.add((Component)libraryButton, "gapleft 5, gapbottom 2, gaptop 0");
        this.add((Component)this.friendButton, "gapleft 3, gapbottom 2, gaptop 0");
        this.add((Component)searchBar, "gapleft 11, gapbottom 2, gaptop 1");
        this.add((Component)this.searchList.getComponent(), "gapleft 10, gaptop 4, gapbottom 0, grow, push");
        navigator.addNavigationListener(new NavigationListener(){

            @Override
            public void categoryRemoved(NavCategory category, boolean wasSelected) {
                if (wasSelected && category == NavCategory.SEARCH_RESULTS) {
                    TopPanel.this.goHome();
                }
            }

            @Override
            public void categoryAdded(NavCategory category) {
            }

            @Override
            public void itemAdded(NavCategory category, NavItem navItem) {
            }

            @Override
            public void itemRemoved(NavCategory category, NavItem navItem, boolean wasSelected) {
            }

            @Override
            public void itemSelected(NavCategory category, NavItem navItem, NavSelectable selectable, NavMediator navMediator) {
                if (category != NavCategory.SEARCH_RESULTS) {
                    TopPanel.this.searchBar.setText("");
                }
            }
        });
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.searchBar.requestFocusInWindow();
    }

    @Override
    public SearchNavItem addSearch(String title, JComponent searchPanel, BrowseSearch search, SearchResultsModel model) {
        return this.addSearch(title, searchPanel, search, model, this.createBrowseActions(search, model), this.browseIcon, false);
    }

    @Override
    public SearchNavItem addSearch(String title, JComponent searchPanel, Search search, SearchResultsModel model) {
        return this.addSearch(title, searchPanel, search, model, this.createSearchActions(search, model), null, true);
    }

    @Override
    public SearchNavItem addAdvancedSearch() {
        ++this.advancedSearches;
        String title = I18n.tr("Advanced Search");
        AdvancedSearchPanel advancedPanel = this.advancedSearchPanel.get();
        NavItem item = this.navigator.createNavItem(NavCategory.SEARCH_RESULTS, title, new SearchResultMediator(advancedPanel));
        SearchAction action = new SearchAction(item);
        action.putValue("LongDescription", action.getValue("Name"));
        NoOpAction moreTextAction = new NoOpAction();
        TabActionMap actionMap = new TabActionMap(action, action, moreTextAction, new ArrayList());
        this.searchList.addTabActionMapAt(actionMap, 0);
        this.maybeIncrementMaxTabCount();
        item.addNavItemListener(new SearchTabNavItemListener(action, actionMap, advancedPanel, "", SearchCategory.ALL));
        final SearchNavItemImpl searchNavItem = new SearchNavItemImpl(item, action, true);
        advancedPanel.addSearchListener(new UiSearchListener(){

            @Override
            public void searchTriggered(SearchInfo searchInfo) {
                TopPanel.this.searchList.freezeTabLayout();
                TopPanel.this.searchHandler.doSearch(searchInfo);
                if (searchInfo.getSearchCategory() != SearchCategory.PROGRAM || LibrarySettings.ALLOW_PROGRAMS.getValue()) {
                    searchNavItem.remove();
                }
                TopPanel.this.searchList.updateTabLayout(AbstractTabList.ChangeType.ADDED);
            }
        });
        return searchNavItem;
    }

    private SearchNavItem addSearch(String title, JComponent searchPanel, Search search, SearchResultsModel model, List<Action> contextActions, Icon icon, boolean stopSpinnerAfter50Results) {
        NavItem item = this.navigator.createNavItem(NavCategory.SEARCH_RESULTS, title, new SearchResultMediator(searchPanel));
        SearchAction action = new SearchAction(item);
        action.putValue("SwingLargeIconKey", icon);
        search.addSearchListener(action);
        NoOpAction moreTextAction = new NoOpAction();
        action.putValue("LongDescription", action.getValue("Name"));
        TabActionMap actionMap = new TabActionMap(action, action, moreTextAction, contextActions);
        this.searchList.addTabActionMapAt(actionMap, 0);
        this.maybeIncrementMaxTabCount();
        String searchText = "";
        if (model.getSearchType() == SearchDetails.SearchType.KEYWORD) {
            searchText = title;
        }
        item.addNavItemListener(new SearchTabNavItemListener(action, actionMap, (Disposable)((Object)searchPanel), searchText, search.getCategory()));
        return new SearchNavItemImpl(item, action, stopSpinnerAfter50Results);
    }

    public void goHome() {
        this.homeNav.select();
        this.homeMediator.getComponent().loadDefaultUrl();
    }

    private List<Action> createSearchActions(Search search, SearchResultsModel model) {
        SearchListenerAction moreResults = new MoreResultsAction(search).register();
        SearchListenerAction repeatSearch = new RepeatSearchAction(this.repeatSearchTitle, search, model).register();
        SearchListenerAction stopSearch = new StopSearchAction(search).register();
        return Arrays.asList(stopSearch, repeatSearch, TabActionMap.SEPARATOR, moreResults);
    }

    private List<Action> createBrowseActions(Search search, SearchResultsModel model) {
        SearchListenerAction refresh = new RepeatSearchAction(this.refreshBrowseTitle, search, model).register();
        return Arrays.asList(refresh);
    }

    private void maybeIncrementMaxTabCount() {
        if ((long)this.searchList.getTabs().size() > this.maxTabCount) {
            this.maxTabCount = this.searchList.getTabs().size();
        }
    }

    private static class StopSearchAction
    extends SearchListenerAction {
        StopSearchAction(Search search) {
            super(I18n.tr("Stop Search"), search);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.search.stop();
        }

        @Override
        public void searchStarted(Search search) {
            this.setEnabled(true);
        }

        @Override
        public void searchStopped(Search search) {
            this.setEnabled(false);
        }
    }

    private class RepeatSearchAction
    extends SearchListenerAction {
        private SearchResultsModel model;

        RepeatSearchAction(String title, Search search, SearchResultsModel model) {
            super(title, search);
            this.model = model;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.model.getSearchType() == SearchDetails.SearchType.ALL_FRIENDS_BROWSE) {
                TopPanel.this.allFriendsRefreshManager.refresh();
            } else {
                new DefaultSearchRepeater(this.search, this.model).refresh();
            }
        }

        @Override
        public void searchStopped(Search search) {
        }

        @Override
        public void searchStarted(Search search) {
            this.setEnabled(true);
        }
    }

    private static class MoreResultsAction
    extends SearchListenerAction {
        MoreResultsAction(Search search) {
            super(I18n.tr("Find More Results"), search);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.search.repeat();
        }

        @Override
        public void searchStarted(Search search) {
            this.setEnabled(true);
        }

        @Override
        public void searchStopped(Search search) {
        }
    }

    private static abstract class SearchListenerAction
    extends AbstractAction
    implements SearchListener {
        protected final Search search;

        public SearchListenerAction(String tr, Search search) {
            super(tr);
            this.search = search;
        }

        public SearchListenerAction register() {
            this.search.addSearchListener(this);
            return this;
        }

        @Override
        public void handleSearchResult(Search search, SearchResult searchResult) {
        }

        @Override
        public void handleSearchResults(Search search, Collection<? extends SearchResult> searchResults) {
        }

        @Override
        public void handleSponsoredResults(Search search, List<SponsoredResult> sponsoredResults) {
        }
    }

    private class SearchAction
    extends AbstractAction
    implements SearchListener {
        private final NavItem item;
        private Timer busyTimer;

        public SearchAction(NavItem item) {
            super(item.getId());
            this.item = item;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue().equals(Boolean.TRUE)) {
                        SearchAction.this.item.select();
                        SearchAction.this.putValue("new.indicator", null);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("tab.select")) {
                this.item.select();
                if (!StringUtils.isEmpty(TopPanel.this.searchBar.getSearchText())) {
                    TopPanel.this.searchBar.requestSearchFocus();
                }
            } else if (e.getActionCommand().equals("tab.remove")) {
                this.item.remove();
            }
        }

        @Override
        public void handleSearchResult(Search search, SearchResult searchResult) {
        }

        @Override
        public void handleSearchResults(Search search, Collection<? extends SearchResult> searchResults) {
        }

        @Override
        public void handleSponsoredResults(Search search, List<SponsoredResult> sponsoredResults) {
        }

        void killBusy() {
            if (this.busyTimer != null && this.busyTimer.isRunning()) {
                this.busyTimer.stop();
            }
            this.putValue("busy.indicator", Boolean.FALSE);
        }

        @Override
        public void searchStarted(Search search) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchAction.this.busyTimer = new Timer(60000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SearchAction.this.putValue("busy.indicator", Boolean.FALSE);
                        }
                    });
                    SearchAction.this.busyTimer.setRepeats(false);
                    SearchAction.this.busyTimer.start();
                    SearchAction.this.putValue("busy.indicator", Boolean.TRUE);
                }
            });
        }

        @Override
        public void searchStopped(Search search) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchAction.this.killBusy();
                }
            });
        }
    }

    private class Searcher
    implements ActionListener {
        private final SearchHandler searchHandler;

        Searcher(SearchHandler searchHandler) {
            this.searchHandler = searchHandler;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String searchText = TopPanel.this.searchBar.getSearchText();
            if (!searchText.isEmpty()) {
                SearchInfo search;
                SearchCategory category = TopPanel.this.searchBar.getCategory();
                String query = searchText;
                KeywordAssistedSearchBuilder.CategoryOverride categoryOverride = ((KeywordAssistedSearchBuilder)TopPanel.this.keywordAssistedSearchBuilder.get()).parseCategoryOverride(query);
                if (categoryOverride != null && categoryOverride.getCategory() != SearchCategory.OTHER) {
                    category = categoryOverride.getCategory();
                    query = categoryOverride.getCutQuery();
                    TopPanel.this.searchBar.setCategory(category);
                }
                if ((search = ((KeywordAssistedSearchBuilder)TopPanel.this.keywordAssistedSearchBuilder.get()).attemptToCreateAdvancedSearch(query, category)) == null) {
                    search = DefaultSearchInfo.createKeywordSearch(query, category);
                }
                if (this.searchHandler.doSearch(search)) {
                    TopPanel.this.searchBar.selectAllSearchText();
                }
            }
        }
    }

    private static final class SearchNavItemImpl
    implements SearchNavItem {
        private final NavItem item;
        private final SearchAction action;
        private final boolean stopSpinnerAfter50Results;

        private SearchNavItemImpl(NavItem item, SearchAction action, boolean stopSpinnerAfter50Results) {
            this.item = item;
            this.action = action;
            this.stopSpinnerAfter50Results = stopSpinnerAfter50Results;
        }

        @Override
        public void sourceCountUpdated(int newSourceCount) {
            if (!this.item.isSelected()) {
                this.action.putValue("new.indicator", true);
            }
            if (this.stopSpinnerAfter50Results && newSourceCount >= 50) {
                this.action.killBusy();
            }
        }

        @Override
        public String getId() {
            return this.item.getId();
        }

        @Override
        public void remove() {
            this.item.remove();
        }

        @Override
        public void select() {
            this.select(null);
        }

        @Override
        public void select(NavSelectable selectable) {
            this.item.select();
        }

        @Override
        public void addNavItemListener(NavItemListener listener) {
            this.item.addNavItemListener(listener);
        }

        @Override
        public void removeNavItemListener(NavItemListener listener) {
            this.item.removeNavItemListener(listener);
        }

        @Override
        public boolean isSelected() {
            return this.item.isSelected();
        }
    }

    private class SearchTabNavItemListener
    implements NavItemListener {
        private final SearchAction action;
        private final TabActionMap actionMap;
        private final String searchText;
        private final Disposable panel;
        private final SearchCategory category;

        private SearchTabNavItemListener(SearchAction action, TabActionMap actionMap, Disposable panel, String searchText, SearchCategory category) {
            this.action = action;
            this.actionMap = actionMap;
            this.searchText = searchText;
            this.panel = panel;
            this.category = category;
        }

        @Override
        public void itemRemoved(boolean wasSelected) {
            TopPanel.this.searchList.removeTabActionMap(this.actionMap);
            this.panel.dispose();
            if (TopPanel.this.searchList.getTabs().size() == 0) {
                TopPanel.this.searchBar.setText(null);
            }
        }

        @Override
        public void itemSelected(boolean selected) {
            TopPanel.this.searchBar.setText(this.searchText);
            TopPanel.this.searchBar.setCategory(this.category);
            this.action.putValue("SwingSelectedKey", selected);
        }
    }

    @InspectableContainer
    private final class LazyInspectableContainer {
        @InspectablePrimitive(value="search tab count", category=DataCategory.USAGE)
        private final int tabCount;

        private LazyInspectableContainer() {
            this.tabCount = TopPanel.this.searchList.getTabs().size();
        }
    }
}

