/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.table.TableColumnExt;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.Category;
import org.limewire.core.api.URN;
import org.limewire.core.api.library.FileItem;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.library.table.DeletionKeyListener;
import org.limewire.ui.swing.library.table.IsPlayingRenderer;
import org.limewire.ui.swing.library.table.LaunchFileAction;
import org.limewire.ui.swing.library.table.LibraryPopupHandler;
import org.limewire.ui.swing.library.table.LibraryPopupMenu;
import org.limewire.ui.swing.library.table.LibraryTableModel;
import org.limewire.ui.swing.library.table.NameCategoryRenderer;
import org.limewire.ui.swing.library.table.RemoveEditor;
import org.limewire.ui.swing.library.table.RemoveRenderer;
import org.limewire.ui.swing.listener.MousePopupListener;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.table.ColumnStateHandler;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.table.FileSizeRenderer;
import org.limewire.ui.swing.table.IconLabelRenderer;
import org.limewire.ui.swing.table.IconLabelRendererFactory;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.table.NameRenderer;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.table.TableColumnSelector;
import org.limewire.ui.swing.table.TableDoubleClickHandler;
import org.limewire.ui.swing.table.TimeRenderer;
import org.limewire.ui.swing.util.EventListJXTableSorting;
import org.limewire.ui.swing.util.I18n;

@LazySingleton
public class LibraryTable
extends MouseableTable {
    private final int rowHeight = 20;
    private LibraryTableModel cachedLibraryTableModel;
    private DefaultEventSelectionModel<LocalFileItem> cachedEventSelectionModel;
    private EventListJXTableSorting cachedTableSorting;
    private SortedList<LocalFileItem> cachedSortedList;
    private FilterList<LocalFileItem> cachedPlayableList;
    private AbstractLibraryFormat<LocalFileItem> fileItemFormat;
    private ColumnStateHandler columnStateHandler;
    private MousePopupListener mousePopupListener;
    private Provider<DefaultLimeTableCellRenderer> defaultCellRenderer;
    private final Provider<NameCategoryRenderer> nameCategoryRenderer;
    private final Provider<TimeRenderer> timeRenderer;
    private final Provider<FileSizeRenderer> fileSizeRenderer;
    private final Provider<NameRenderer> nameRenderer;
    private final Provider<RemoveRenderer> removeRenderer;
    private final Provider<IsPlayingRenderer> isPlayingRenderer;
    private final Provider<LaunchFileAction> launchAction;
    private final IconLabelRenderer iconLabelRenderer;
    private final RemoveEditor removeEditor;

    @Inject
    public LibraryTable(Provider<DefaultLimeTableCellRenderer> defaultCellRenderer, Provider<NameCategoryRenderer> nameCategoryRenderer, Provider<TimeRenderer> timeRenderer, Provider<FileSizeRenderer> fileSizeRenderer, Provider<NameRenderer> nameRenderer, Provider<LibraryPopupMenu> libraryPopupMenu, Provider<RemoveRenderer> removeRenderer, Provider<IsPlayingRenderer> isPlayingRenderer, Provider<LaunchFileAction> launchAction, IconLabelRendererFactory iconLabelRendererFactory, RemoveEditor removeEditor, DeletionKeyListener deletionKeyListener) {
        this.defaultCellRenderer = defaultCellRenderer;
        this.nameCategoryRenderer = nameCategoryRenderer;
        this.timeRenderer = timeRenderer;
        this.fileSizeRenderer = fileSizeRenderer;
        this.nameRenderer = nameRenderer;
        this.removeRenderer = removeRenderer;
        this.isPlayingRenderer = isPlayingRenderer;
        this.launchAction = launchAction;
        this.iconLabelRenderer = iconLabelRendererFactory.createIconRenderer(false);
        this.removeEditor = removeEditor;
        this.initTable();
        this.mousePopupListener = new MousePopupListener(){

            @Override
            public void handlePopupMouseEvent(MouseEvent e) {
                LibraryTable.this.showHeaderPopupMenu(e.getPoint());
            }
        };
        this.setPopupHandler(new LibraryPopupHandler(this, libraryPopupMenu));
        this.addKeyListener(deletionKeyListener);
    }

    private void initTable() {
        this.setShowHorizontalLines(false);
        this.setShowGrid(false, true);
        this.setFillsViewportHeight(true);
        this.setDragEnabled(true);
        this.setRowHeight(20);
        this.setDropMode(DropMode.ON);
        this.setDoubleClickHandler(new DoubleClickHandler());
        this.setEnterKeyAction(this.launchAction.get());
    }

    private void uninstallListeners() {
        this.getTableHeader().removeMouseListener(this.mousePopupListener);
        if (this.columnStateHandler != null) {
            this.columnStateHandler.removeListeners();
        }
    }

    private void installListeners() {
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(this.mousePopupListener);
        this.columnStateHandler = new ColumnStateHandler(this, this.fileItemFormat);
    }

    public void showHeaderPopupMenu(Point p) {
        JPopupMenu menu = new TableColumnSelector(this, this.fileItemFormat).getPopupMenu();
        menu.show(this.getTableHeader(), p.x, p.y);
    }

    public LibraryTableModel getLibraryTableModel() {
        return this.cachedLibraryTableModel;
    }

    public LocalFileItem getSelectedItem() {
        if (this.getSelectedRow() >= 0) {
            return (LocalFileItem)this.cachedLibraryTableModel.getElementAt(this.getSelectedRow());
        }
        return null;
    }

    public void setEventList(EventList<LocalFileItem> eventList, AbstractLibraryFormat<LocalFileItem> tableFormat, boolean playable) {
        FilterList<LocalFileItem> newPlayableList;
        this.uninstallListeners();
        this.fileItemFormat = tableFormat;
        SortedList<LocalFileItem> newSortedList = GlazedListsFactory.sortedList(eventList, null);
        LibraryTableModel newLibraryTableModel = new LibraryTableModel((EventList<LocalFileItem>)newSortedList, (TableFormat<LocalFileItem>)tableFormat);
        DefaultEventSelectionModel<LocalFileItem> newEventSelectionModel = new DefaultEventSelectionModel<LocalFileItem>(newSortedList);
        FilterList<LocalFileItem> filterList = newPlayableList = playable ? this.createPlayableList(newSortedList) : null;
        if (this.cachedTableSorting != null) {
            this.cachedTableSorting.uninstall();
        }
        this.setSelectionModel(newEventSelectionModel);
        this.setModel(newLibraryTableModel);
        newEventSelectionModel.setSelectionMode(103);
        if (this.cachedPlayableList != null) {
            this.cachedPlayableList.dispose();
        }
        if (this.cachedLibraryTableModel != null) {
            this.cachedEventSelectionModel.dispose();
            this.cachedLibraryTableModel.dispose();
            this.cachedSortedList.dispose();
        }
        EventListJXTableSorting newTableSorting = EventListJXTableSorting.install(this, newSortedList, tableFormat);
        this.cachedSortedList = newSortedList;
        this.cachedLibraryTableModel = newLibraryTableModel;
        this.cachedEventSelectionModel = newEventSelectionModel;
        this.cachedTableSorting = newTableSorting;
        this.cachedPlayableList = newPlayableList;
        this.installListeners();
    }

    private FilterList<LocalFileItem> createPlayableList(EventList<LocalFileItem> sourceList) {
        return GlazedListsFactory.filterList(sourceList, new Matcher<LocalFileItem>(){

            @Override
            public boolean matches(LocalFileItem item) {
                return PlayerUtils.isFileAllowedInPlaylist(item.getFile());
            }
        });
    }

    public EventList<LocalFileItem> getPlayableList() {
        return this.cachedPlayableList;
    }

    public boolean isRowDisabled(int row) {
        LocalFileItem item = this.getLibraryTableModel().getFileItem(this.convertRowIndexToModel(row));
        if (item instanceof LocalFileItem) {
            return item.isIncomplete();
        }
        return item == null;
    }

    public void selectAndScrollTo(File file) {
        this.requestFocus();
        LibraryTableModel model = this.getLibraryTableModel();
        for (int y = 0; y < model.getRowCount(); ++y) {
            FileItem fileItem = (FileItem)model.getElementAt(y);
            if (!(fileItem instanceof LocalFileItem) || !file.equals(((LocalFileItem)fileItem).getFile())) continue;
            this.getSelectionModel().setSelectionInterval(y, y);
            break;
        }
        this.ensureRowVisible(this.getSelectedRow());
    }

    public void selectAndScrollTo(URN urn) {
        this.requestFocus();
        LibraryTableModel model = this.getLibraryTableModel();
        for (int y = 0; y < model.getRowCount(); ++y) {
            FileItem fileItem = (FileItem)model.getElementAt(y);
            if (!((Object)urn).equals(fileItem.getUrn())) continue;
            this.getSelectionModel().setSelectionInterval(y, y);
            break;
        }
        this.ensureRowVisible(this.getSelectedRow());
    }

    public void applySavedColumnSettings() {
        if (this.columnStateHandler != null) {
            this.columnStateHandler.setupColumnWidths();
            this.columnStateHandler.setupColumnVisibility(false);
            this.columnStateHandler.setupColumnOrder();
        }
    }

    public void setupCellRenderers(Category category, AbstractLibraryFormat format) {
        block10: {
            block9: {
                for (int i = 0; i < format.getColumnCount(); ++i) {
                    Class clazz = format.getColumnClass(i);
                    if (clazz != String.class) continue;
                    this.setCellRenderer(i, this.defaultCellRenderer.get());
                }
                if (category == null) break block9;
                switch (category) {
                    case AUDIO: {
                        this.setHeaderRenderer(4, new TableCellHeaderRenderer(11));
                        this.setCellRenderer(0, this.isPlayingRenderer.get());
                        this.setUnsortable(0);
                        this.setCellRenderer(7, this.fileSizeRenderer.get());
                        this.setCellRenderer(4, this.timeRenderer.get());
                        this.setCellRenderer(1, this.nameRenderer.get());
                        this.setCellRenderer(16, this.removeRenderer.get());
                        this.setCellEditor(16, this.removeEditor);
                        this.setUnsortable(16);
                        break block10;
                    }
                    case VIDEO: {
                        this.setHeaderRenderer(2, new TableCellHeaderRenderer(11));
                        this.setCellRenderer(2, this.timeRenderer.get());
                        this.setCellRenderer(5, this.fileSizeRenderer.get());
                        this.setCellRenderer(0, this.nameRenderer.get());
                        this.setCellRenderer(14, this.removeRenderer.get());
                        this.setCellEditor(14, this.removeEditor);
                        this.setUnsortable(14);
                        break block10;
                    }
                    case IMAGE: {
                        this.setCellRenderer(1, this.fileSizeRenderer.get());
                        this.setCellRenderer(2, this.removeRenderer.get());
                        this.setCellEditor(2, this.removeEditor);
                        this.setUnsortable(2);
                        break block10;
                    }
                    case DOCUMENT: {
                        this.setCellRenderer(0, this.iconLabelRenderer);
                        this.setCellRenderer(2, this.fileSizeRenderer.get());
                        this.setCellRenderer(9, this.removeRenderer.get());
                        this.setCellEditor(9, this.removeEditor);
                        this.setUnsortable(9);
                        break block10;
                    }
                    case PROGRAM: {
                        this.setCellRenderer(0, this.iconLabelRenderer);
                        this.setCellRenderer(1, this.fileSizeRenderer.get());
                        this.setCellRenderer(9, this.removeRenderer.get());
                        this.setCellEditor(9, this.removeEditor);
                        this.setUnsortable(9);
                        break block10;
                    }
                    case OTHER: {
                        this.setCellRenderer(0, this.iconLabelRenderer);
                        this.setCellRenderer(2, this.fileSizeRenderer.get());
                        this.setCellRenderer(7, this.removeRenderer.get());
                        this.setCellEditor(7, this.removeEditor);
                        this.setUnsortable(7);
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown category:" + (Object)((Object)category));
                    }
                }
            }
            this.setCellRenderer(0, this.isPlayingRenderer.get());
            this.setUnsortable(0);
            this.setCellRenderer(1, this.nameCategoryRenderer.get());
            this.setCellRenderer(3, this.fileSizeRenderer.get());
            this.setCellRenderer(8, this.removeRenderer.get());
            this.setCellEditor(8, this.removeEditor);
            this.setUnsortable(8);
        }
    }

    protected void setHeaderRenderer(int column, TableCellRenderer headerRenderer) {
        TableColumnModel tcm = this.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        tc.setHeaderRenderer(headerRenderer);
    }

    private void setCellRenderer(int column, TableCellRenderer renderer) {
        this.getColumnModel().getColumn(column).setCellRenderer(renderer);
    }

    private void setCellEditor(int column, TableCellEditor editor) {
        this.getColumnModel().getColumn(column).setCellEditor(editor);
    }

    private void setUnsortable(int column) {
        ((TableColumnExt)this.getColumnModel().getColumn(column)).setSortable(false);
    }

    public List<LocalFileItem> getSelection() {
        return this.cachedEventSelectionModel.getSelected();
    }

    @Override
    protected String getToolTipText(int row, int col) {
        Object value = this.getValueAt(row, col);
        if (value != null && value instanceof LocalFileItem) {
            LocalFileItem localFileItem = (LocalFileItem)value;
            if (!localFileItem.isLoaded()) {
                return I18n.tr("This file is still processing.");
            }
            if (!localFileItem.isShareable()) {
                return I18n.tr("This file cannot be shared.");
            }
        }
        return super.getToolTipText(row, col);
    }

    private class DoubleClickHandler
    implements TableDoubleClickHandler {
        private DoubleClickHandler() {
        }

        @Override
        public void handleDoubleClick(int row) {
            if (LibraryTable.this.getSelectedItem() == null) {
                LibraryTable.this.getSelectionModel().setSelectionInterval(row, row);
            }
            ((LaunchFileAction)LibraryTable.this.launchAction.get()).actionPerformed(null);
        }
    }
}

