/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.sharing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXTable;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.friend.api.Friend;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.TextFieldDecorator;
import org.limewire.ui.swing.library.sharing.ApplySharingAction;
import org.limewire.ui.swing.library.sharing.CancelSharingAction;
import org.limewire.ui.swing.library.sharing.EditableSharingData;
import org.limewire.ui.swing.library.sharing.LibrarySharingAction;
import org.limewire.ui.swing.library.sharing.LibrarySharingEditableRendererEditor;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

@LazySingleton
class LibrarySharingEditablePanel {
    @Resource
    private Color borderColor;
    @Resource
    private Font sharingLabelFont;
    @Resource
    private Color sharingLabelColor;
    @Resource
    private Font selectFont;
    @Resource
    private Color selectColor;
    private final JPanel component;
    private final PromptTextField filterTextField;
    private final HyperlinkButton allButton;
    private final HyperlinkButton noneButton;
    private final JXButton applyButton;
    private final HyperlinkButton cancelButton;
    private final Map<String, Friend> knownFriends;
    private final EventList<EditableSharingData> baseEventList;
    private final EventList<EditableSharingData> filteredList;
    private final JXTable friendTable;

    @Inject
    public LibrarySharingEditablePanel(ApplySharingAction applyAction, CancelSharingAction cancelAction, LibrarySharingAction libraryAction, TextFieldDecorator textFieldDecorator, ButtonDecorator buttonDecorator, @Named(value="known") Map<String, Friend> knownFriends) {
        GuiUtils.assignResources(this);
        this.knownFriends = knownFriends;
        this.component = new JPanel(new MigLayout("insets 0, gap 0, fillx", "[134!]", ""));
        this.component.setOpaque(false);
        JLabel shareLabel = new JLabel(I18n.tr("Sharing list with..."));
        shareLabel.setFont(this.sharingLabelFont);
        shareLabel.setForeground(this.sharingLabelColor);
        this.component.add((Component)shareLabel, "gapleft 5, gaptop 5, wrap");
        this.filterTextField = new PromptTextField(I18n.tr("Filter..."));
        textFieldDecorator.decorateClearablePromptField(this.filterTextField, BorderPainter.AccentType.NONE);
        this.component.add((Component)this.filterTextField, "gapleft 5, gaptop 4, gapright 5, wmax 124, wrap");
        JLabel selectLabel = new JLabel(I18n.tr("Select"));
        selectLabel.setFont(this.selectFont);
        selectLabel.setForeground(this.selectColor);
        this.component.add((Component)selectLabel, "gapleft 5, gaptop 2, split 3");
        this.allButton = new HyperlinkButton(new AbstractAction(I18n.tr("all")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibrarySharingEditablePanel.this.setSelectedStateForAll(true);
            }
        });
        this.allButton.setFont(this.selectFont);
        this.noneButton = new HyperlinkButton(new AbstractAction(I18n.tr("none")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibrarySharingEditablePanel.this.setSelectedStateForAll(false);
            }
        });
        this.noneButton.setFont(this.selectFont);
        this.component.add((Component)this.allButton, "gapleft 6, gaptop 2");
        this.component.add((Component)this.noneButton, "gapleft 6, gaptop 2, wrap");
        this.baseEventList = new BasicEventList<EditableSharingData>();
        SortedList<EditableSharingData> sortedList = GlazedListsFactory.sortedList(this.baseEventList, new FriendComparator());
        TextComponentMatcherEditor<EditableSharingData> matcher = new TextComponentMatcherEditor<EditableSharingData>(this.filterTextField, new FriendFilterator());
        this.filteredList = GlazedListsFactory.filterList(sortedList, matcher);
        SwingThreadProxyEventList<EditableSharingData> stpl = GlazedListsFactory.swingThreadProxyEventList(this.filteredList);
        this.friendTable = new GlazedJXTable(new DefaultEventTableModel<EditableSharingData>(stpl, new EditTableFormat())){

            @Override
            public void editingStopped(ChangeEvent e) {
                TableCellEditor editor = this.getCellEditor();
                if (editor != null) {
                    this.removeEditor();
                }
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(super.getPreferredScrollableViewportSize().width, this.getModel().getRowCount() * this.getRowHeight());
            }
        };
        this.filteredList.addListEventListener(new ListEventListener<EditableSharingData>(){

            @Override
            public void listChanged(ListEvent<EditableSharingData> listChanges) {
                if (LibrarySharingEditablePanel.this.getComponent().isShowing()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibrarySharingEditablePanel.this.component.revalidate();
                        }
                    });
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.friendTable);
        scrollPane.setMinimumSize(new Dimension(0, 0));
        scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.borderColor));
        this.friendTable.getColumnExt(0).setCellRenderer(new LibrarySharingEditableRendererEditor());
        this.friendTable.getColumnExt(0).setCellEditor(new LibrarySharingEditableRendererEditor());
        this.friendTable.setTableHeader(null);
        this.friendTable.setShowGrid(false, false);
        this.friendTable.setRowHeight(20);
        this.component.add((Component)scrollPane, "growx, gaptop 3, wrap");
        this.applyButton = new JXButton(applyAction);
        this.applyButton.setFont(this.selectFont);
        this.applyButton.addActionListener(libraryAction);
        buttonDecorator.decorateDarkFullButton(this.applyButton, BorderPainter.AccentType.NONE);
        this.cancelButton = new HyperlinkButton(cancelAction);
        this.cancelButton.setFont(this.selectFont);
        this.cancelButton.addActionListener(libraryAction);
        this.component.add((Component)this.applyButton, "split 2, gaptop 5, gapbottom 5, gapright unrelated, alignx center");
        this.component.add((Component)this.cancelButton, "gaptop 5, gapbottom 5, wrap");
    }

    public JComponent getComponent() {
        return this.component;
    }

    void clear() {
        this.baseEventList.clear();
    }

    void refreshSelectedList() {
        HashSet<String> selectedIds = new HashSet<String>();
        for (EditableSharingData data : this.baseEventList) {
            if (!data.isSelected()) continue;
            selectedIds.addAll(data.getIds());
        }
        this.addItemsToList(selectedIds);
    }

    void editWithSelectedIds(List<String> selectedIds) {
        this.filterTextField.setText("");
        this.addItemsToList(new HashSet<String>(selectedIds));
    }

    private void addItemsToList(Set<String> setOfIds) {
        this.baseEventList.clear();
        for (Friend friend : this.knownFriends.values()) {
            this.baseEventList.add(new EditableSharingData(friend, setOfIds.remove(friend.getId())));
        }
        if (!setOfIds.isEmpty()) {
            this.baseEventList.add(new EditableSharingData(new ArrayList<String>(setOfIds), true));
        }
        this.component.revalidate();
    }

    List<String> getSelectedFriendIds() {
        ArrayList<String> friends = new ArrayList<String>();
        for (EditableSharingData data : this.baseEventList) {
            if (!data.isSelected()) continue;
            friends.addAll(data.getIds());
        }
        return friends;
    }

    private void setSelectedStateForAll(boolean isSelected) {
        for (EditableSharingData data : this.filteredList) {
            data.setSelected(isSelected);
        }
        this.friendTable.repaint();
    }

    private static class EditTableFormat
    implements WritableTableFormat<EditableSharingData> {
        private EditTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Object getColumnValue(EditableSharingData baseObject, int column) {
            return baseObject;
        }

        @Override
        public boolean isEditable(EditableSharingData baseObject, int column) {
            return true;
        }

        @Override
        public EditableSharingData setColumnValue(EditableSharingData baseObject, Object editedValue, int column) {
            return baseObject;
        }
    }

    private static class FriendComparator
    implements Comparator<EditableSharingData> {
        private FriendComparator() {
        }

        @Override
        public int compare(EditableSharingData data1, EditableSharingData data2) {
            Friend friend2;
            Friend friend1 = data1.getFriend();
            if (friend1 == (friend2 = data2.getFriend())) {
                return 0;
            }
            if (friend1 == null || friend2 == null) {
                if (friend1 == null && friend2 == null) {
                    return 0;
                }
                if (friend1 == null) {
                    return 1;
                }
                return -1;
            }
            return friend1.getRenderName().compareToIgnoreCase(friend2.getRenderName());
        }
    }

    private static class FriendFilterator
    implements TextFilterator<EditableSharingData> {
        private FriendFilterator() {
        }

        @Override
        public void getFilterStrings(List<String> baseList, EditableSharingData data) {
            Friend friend = data.getFriend();
            if (friend != null) {
                if (friend.getName() != null) {
                    baseList.add(friend.getName());
                }
                baseList.add(friend.getId());
            }
        }
    }
}

