/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.util.OSUtils;

class LibraryNavTableEditor
extends JPanel
implements TableCellEditor {
    @Resource
    private Color selectedColor;
    @Resource
    private Font font;
    @Resource
    private Color fontColor;
    @Resource
    private int iconGap;
    @Resource
    private Icon libraryIcon;
    @Resource
    private Icon publicIcon;
    @Resource
    private Icon listIcon;
    @Resource
    private Icon listSharedIcon;
    private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private final JLabel iconHolder;
    private final JTextField textField;

    public LibraryNavTableEditor() {
        super(new MigLayout("gap 0, insets 0 6 0 6, fill"));
        GuiUtils.assignResources(this);
        this.iconHolder = new JLabel();
        this.textField = new JTextField();
        TextFieldClipboardControl.install(this.textField);
        this.textField.setPreferredSize(new Dimension(120, 22));
        this.textField.setFont(this.font);
        this.textField.setForeground(this.fontColor);
        this.textField.setDocument(new TextFieldLimit(40));
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryNavTableEditor.this.stopCellEditing();
            }
        });
        if (OSUtils.isMacOSX()) {
            this.textField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        this.setBackground(this.selectedColor);
        this.add((Component)this.iconHolder, "aligny 50%, gapright " + this.iconGap);
        this.add((Component)this.textField, "growx");
    }

    void prepareForEditing() {
        this.textField.requestFocusInWindow();
        this.textField.selectAll();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof LibraryNavItem) {
            LibraryNavItem item = (LibraryNavItem)value;
            this.textField.setText(item.getDisplayText());
            this.textField.selectAll();
            this.setIconType(item);
        } else {
            this.textField.setText("");
            this.iconHolder.setIcon(null);
        }
        this.setOpaque(isSelected);
        return this;
    }

    private void setIconType(LibraryNavItem item) {
        if (item.getType() == LibraryNavItem.NavType.LIBRARY) {
            this.iconHolder.setIcon(this.libraryIcon);
        } else if (item.getType() == LibraryNavItem.NavType.PUBLIC_SHARED) {
            this.iconHolder.setIcon(this.publicIcon);
        } else if (item.getLocalFileList() instanceof SharedFileList) {
            if (((SharedFileList)item.getLocalFileList()).getFriendIds().size() > 0) {
                this.iconHolder.setIcon(this.listSharedIcon);
            } else {
                this.iconHolder.setIcon(this.listIcon);
            }
        } else {
            this.iconHolder.setIcon(this.listIcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(lis)) {
                this.listeners.add(lis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText().trim();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(lis)) {
                this.listeners.remove(lis);
            }
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingStopped(new ChangeEvent(this));
            }
        }
        return true;
    }

    private static class TextFieldLimit
    extends PlainDocument {
        private int maxLength;

        TextFieldLimit(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() < this.maxLength) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

