/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.RangeFilterFormat;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class FileSizeFilterFormat<E extends FilterableItem>
implements RangeFilterFormat<E> {
    private static final long[] DEFAULT_SIZES = new long[]{0L, 10240L, 51200L, 102400L, 512000L, 0x100000L, 0x500000L, 0xA00000L, 0x3200000L, 0x6400000L, 524288000L, 0x40000000L, 0x140000000L, 0x280000000L, 0xC80000000L, 0x1900000000L};
    private static final long[] AUDIO_SIZES = new long[]{0L, 102400L, 256000L, 512000L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1900000L, 0x3200000L, 0x6400000L, 0xFA00000L, 524288000L, 0x40000000L};
    private static final long[] VIDEO_SIZES = new long[]{0L, 0xA00000L, 0x1900000L, 0x3200000L, 0x6400000L, 0xFA00000L, 524288000L, 0x40000000L, 0x80000000L, 0x140000000L, 0x280000000L, 0x640000000L, 0xC80000000L, 0x1900000000L};
    private static final long[] IMAGE_SIZES = new long[]{0L, 10240L, 25600L, 51200L, 102400L, 256000L, 512000L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1900000L, 0x3200000L, 0x6400000L};
    private long[] sizes = this.getSizes(SearchCategory.ALL);

    @Override
    public String getHeaderText() {
        return I18n.tr("Size");
    }

    @Override
    public Matcher<E> getMatcher(long minValue, long maxValue) {
        return new FileSizeMatcher(minValue, maxValue);
    }

    @Override
    public long[] getValues() {
        return this.sizes;
    }

    @Override
    public String getValueText(int valueIndex) {
        return GuiUtils.formatUnitFromBytes(this.sizes[valueIndex]);
    }

    @Override
    public boolean isMaximumAbsolute() {
        return false;
    }

    @Override
    public boolean isUpperLimitEnabled() {
        return true;
    }

    @Override
    public boolean updateValues(SearchCategory filterCategory, long lowerValue, long upperValue) {
        long[] newSizes = this.getSizes(filterCategory);
        List<Long> valueList = this.createValueList(newSizes, lowerValue, upperValue);
        this.sizes = new long[valueList.size()];
        int len = valueList.size();
        for (int i = 0; i < len; ++i) {
            this.sizes[i] = valueList.get(i);
        }
        return true;
    }

    List<Long> createValueList(long[] values, long lowerValue, long upperValue) {
        ArrayList<Long> valueList = new ArrayList<Long>();
        for (int i = 0; i < values.length; ++i) {
            if (lowerValue > -1L) {
                if (values[i] == lowerValue) {
                    lowerValue = -1L;
                } else if (values[i] > lowerValue) {
                    valueList.add(lowerValue);
                    lowerValue = -1L;
                }
            }
            if (upperValue > -1L) {
                if (values[i] == upperValue) {
                    upperValue = -1L;
                } else if (values[i] > upperValue) {
                    valueList.add(upperValue);
                    upperValue = -1L;
                }
            }
            valueList.add(values[i]);
        }
        if (lowerValue > -1L) {
            valueList.add(lowerValue);
        }
        if (upperValue > -1L) {
            valueList.add(upperValue);
        }
        return valueList;
    }

    private long[] getSizes(SearchCategory filterCategory) {
        switch (filterCategory) {
            case AUDIO: {
                return AUDIO_SIZES;
            }
            case VIDEO: {
                return VIDEO_SIZES;
            }
            case IMAGE: 
            case DOCUMENT: {
                return IMAGE_SIZES;
            }
        }
        return DEFAULT_SIZES;
    }

    private class FileSizeMatcher
    implements Matcher<E> {
        private final long minSize;
        private final long maxSize;

        public FileSizeMatcher(long minSize, long maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        @Override
        public boolean matches(E item) {
            long size = item.getSize();
            boolean minValid = this.minSize == FileSizeFilterFormat.this.sizes[0] || size >= this.minSize;
            boolean maxValid = this.maxSize == FileSizeFilterFormat.this.sizes[FileSizeFilterFormat.this.sizes.length - 1] || size <= this.maxSize;
            return minValid && maxValid;
        }
    }
}

