/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.logging.Log;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.dnd.LocalFileListTransferable;
import org.limewire.ui.swing.util.DNDUtils;
import org.limewire.ui.swing.warnings.LibraryWarningController;

public abstract class LocalFileListTransferHandler
extends TransferHandler {
    private static final Log LOG = LogFactory.getLog(LocalFileListTransferHandler.class);
    private final WeakHashMap<Transferable, Map<LocalFileList, Boolean>> canImportCache = new WeakHashMap();
    private final LibraryWarningController librarySupport;

    public LocalFileListTransferHandler(LibraryWarningController librarySupport) {
        this.librarySupport = librarySupport;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        List<File> files = this.getSelectedFiles();
        if (!files.isEmpty()) {
            return new LocalFileListTransferable(this.getLocalFileList(), files.toArray(new File[files.size()]));
        }
        return null;
    }

    protected abstract List<File> getSelectedFiles();

    protected abstract LocalFileList getLocalFileList();

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        try {
            Boolean canImport;
            Transferable t = info.getTransferable();
            LocalFileList localFileList = this.getLocalFileList();
            Map<LocalFileList, Boolean> canImportMap = this.canImportCache.get(t);
            if (canImportMap == null) {
                canImportMap = new HashMap<LocalFileList, Boolean>();
                this.canImportCache.put(t, canImportMap);
            }
            if ((canImport = canImportMap.get(localFileList)) == null) {
                canImport = this.canImportInternal(info);
                canImportMap.put(localFileList, canImport);
            }
            return canImport;
        }
        catch (RuntimeException e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
        catch (Error e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
    }

    private boolean canImportInternal(TransferHandler.TransferSupport info) {
        if (this.getLocalFileList() == null || !DNDUtils.containsFileFlavors(info)) {
            return false;
        }
        Transferable t = info.getTransferable();
        if (t.isDataFlavorSupported(LocalFileListTransferable.LOCAL_FILE_LIST_DATA_FLAVOR)) {
            try {
                LocalFileList localFileList = (LocalFileList)t.getTransferData(LocalFileListTransferable.LOCAL_FILE_LIST_DATA_FLAVOR);
                if (localFileList == this.getLocalFileList()) {
                    return false;
                }
            }
            catch (IOException e) {
                LOG.debug("Error get Trasferable contents.", e);
            }
            catch (UnsupportedFlavorException e) {
                LOG.debug("Error get Trasferable contents.", e);
            }
        }
        List<Object> files = Collections.emptyList();
        if (DNDUtils.containsFileFlavors(info)) {
            try {
                files = Arrays.asList(DNDUtils.getFiles(t));
            }
            catch (Throwable e) {
                LOG.debug("Error get Trasferable contents.", e);
                return true;
            }
        }
        LocalFileList localFileList = this.getLocalFileList();
        for (File file : files) {
            if (!localFileList.isFileAllowed(file) && !localFileList.isDirectoryAllowed(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            this.canImportCache.remove(t);
            List<File> files = Collections.emptyList();
            if (DNDUtils.containsFileFlavors(info)) {
                try {
                    files = Arrays.asList(DNDUtils.getFiles(t));
                }
                catch (Throwable failed) {
                    return false;
                }
            }
            this.handleFiles(files);
            return true;
        }
        catch (RuntimeException e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
        catch (Error e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
    }

    private void handleFiles(List<File> files) {
        LocalFileList localFileList = this.getLocalFileList();
        this.librarySupport.addFiles(localFileList, files);
    }
}

