/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components.decorators;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.limewire.ui.swing.activation.LicenseKeyTextField;
import org.limewire.ui.swing.components.PromptPasswordField;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.factories.TextFieldPainterFactory;
import org.limewire.ui.swing.util.SwingHacks;

@Singleton
public class TextFieldDecorator {
    private final Provider<TextFieldPainterFactory> painterFactory;
    private TextFieldPainterFactory factory;

    @Inject
    TextFieldDecorator(Provider<TextFieldPainterFactory> painterFactory) {
        this.painterFactory = painterFactory;
    }

    public void decorateClearablePromptField(PromptTextField field, BorderPainter.AccentType accent) {
        field.setBackgroundPainter(this.getTextFieldFactory().createClearableBackgroundPainter(field, accent));
        Border border = field.getBorder();
        this.decorateGeneralText(field);
        field.setBorder(border);
    }

    public void decoratePromptField(PromptTextField field, BorderPainter.AccentType accent, Paint border) {
        field.setBackgroundPainter(this.getTextFieldFactory().createBasicBackgroundPainter(accent, border));
        this.decorateGeneralText(field);
    }

    public void decoratePromptField(PromptTextField field, BorderPainter.AccentType accent) {
        field.setBackgroundPainter(this.getTextFieldFactory().createBasicBackgroundPainter(accent));
        this.decorateGeneralText(field);
    }

    public void decorateLicenseField(LicenseKeyTextField field, BorderPainter.AccentType accent) {
        field.setBackgroundPainter(this.getTextFieldFactory().createBasicBackgroundPainter(accent));
        this.decorateGeneral(field);
    }

    public void decoratePromptField(PromptPasswordField field, BorderPainter.AccentType accent, Paint border) {
        field.setBackgroundPainter(this.getTextFieldFactory().createBasicBackgroundPainter(accent, border));
        this.decorateGeneralPassword(field);
    }

    public void decoratePromptField(PromptPasswordField field, BorderPainter.AccentType accent) {
        field.setBackgroundPainter(this.getTextFieldFactory().createBasicBackgroundPainter(accent));
        this.decorateGeneralPassword(field);
    }

    private void decorateGeneralText(PromptTextField field) {
        field.setPromptPainter(this.getTextFieldFactory().createBasicPromptPainter());
        this.decorateGeneral(field);
    }

    private void decorateGeneralPassword(PromptPasswordField field) {
        field.setPromptPainter(this.getTextFieldFactory().createBasicPromptPainter());
        this.decorateGeneral(field);
    }

    private void decorateGeneral(JTextField field) {
        field.setOpaque(false);
        field.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 12));
        SwingHacks.fixTextFieldScrollClippingWithNonDefaultInsets(field);
    }

    private TextFieldPainterFactory getTextFieldFactory() {
        if (this.factory == null) {
            this.factory = this.painterFactory.get();
        }
        return this.factory;
    }
}

