/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import org.limewire.collection.SortedList;
import org.limewire.ui.swing.components.BoxPanel;
import org.limewire.ui.swing.components.CheckBoxList;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.SeperatorBorder;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.I18n;

public class CheckBoxList<E>
extends BoxPanel {
    private static final String REMOVE_TEXT = I18n.tr("remove");
    private String disabledTooltip = null;
    private boolean areAllRemoveable = false;
    private boolean selectOff;
    private JScrollPane scrollPane;
    private JTable checkBoxList;
    private CheckBoxListSelectionListener selectionListener;
    private CheckBoxListCheckChangeListener checkListener;
    private Object parent;
    private final Set<E> elements = new HashSet();
    private final Set<E> unchecked = new HashSet();
    private final Set<E> checked = new HashSet();
    private final Set<E> removableElements = new HashSet();
    private final Set<E> disabled = new HashSet();
    private final Set<E> bolded = new HashSet();
    private Object selected;
    public static final int SELECT_FIRST_ON = 0;
    public static final int SELECT_FIRST_OFF = 1;
    private static final int DEFAULT_ROW_HEIGHT = 22;
    private TextProvider<E> provider;
    private ExtrasProvider<E> extrasProvider;
    private List<E> items;
    private int visibleRowCount = -1;
    public static final String TEXT_PROVIDER_PROPERTY = "textProvider";
    private CheckBoxCellEditor editor;
    private boolean checkBoxesVisible = true;

    public CheckBoxList(Collection<E> elements, Collection<E> notCheckedElements, TextProvider<E> provider, ExtrasProvider<E> separatorProvider, int mode) {
        this.provider = provider;
        this.extrasProvider = separatorProvider;
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        this.parent = this;
        this.selectionListener = null;
        this.selectOff = mode == 1;
        this.initialize();
        this.setElements(elements, notCheckedElements);
    }

    public CheckBoxList(Collection<E> elements, Collection<E> notCheckedElements, TextProvider<E> provider, int mode) {
        this(elements, notCheckedElements, provider, null, mode);
    }

    public CheckBoxList(Collection<E> elements, TextProvider<E> provider, boolean checkAll, int mode) {
        this(elements, checkAll ? new HashSet() : elements, provider, null, mode);
    }

    public CheckBoxList(Collection<E> totalElements, Collection<E> notCheckedElements, int mode) {
        this(totalElements, notCheckedElements, new DefaultTextProvider(), null, mode);
    }

    public CheckBoxList(Collection<E> elements, TextProvider<E> provider, int mode) {
        this(elements, new HashSet(), provider, null, mode);
    }

    public CheckBoxList(Collection<E> elements) {
        this(elements, new DefaultTextProvider(), 0);
    }

    public CheckBoxList(Collection<E> elements, TextProvider<E> provider) {
        this(elements, provider, 0);
    }

    public void setElements(Collection<E> elements) {
        this.setElements(elements, true);
    }

    public void setElements(Collection<E> elements, boolean checked) {
        if (checked) {
            this.setElements(elements, new HashSet());
        } else {
            this.setElements(elements, elements);
        }
    }

    public void setElements(Collection<E> elements, Collection<E> notCheckedElements) {
        this.items = new SortedList<E>(elements);
        Object[][] rowData = new Object[elements.size()][1];
        for (int i = 0; i < elements.size(); ++i) {
            rowData[i][0] = this.items.get(i);
        }
        this.elements.clear();
        this.checked.clear();
        this.unchecked.clear();
        this.elements.addAll(elements);
        this.checked.addAll(elements);
        this.checked.removeAll(notCheckedElements);
        this.unchecked.addAll(notCheckedElements);
        if (rowData.length > 0) {
            this.selected = rowData[0];
        }
        this.checkBoxList.setModel(new DefaultTableModel(rowData, new String[]{""}));
    }

    public void update() {
        ((DefaultTableModel)this.checkBoxList.getModel()).fireTableStructureChanged();
    }

    public void removeItem(E key) {
        HashSet<E> newElements = new HashSet<E>(this.elements);
        HashSet<E> newUnchecked = new HashSet<E>(this.unchecked);
        newElements.remove(key);
        newUnchecked.remove(key);
        this.setElements(newElements, newUnchecked);
        this.removableElements.remove(key);
    }

    public void addItem(E key) {
        HashSet<E> newElements = new HashSet<E>(this.elements);
        HashSet<E> newUnchecked = new HashSet<E>(this.unchecked);
        newElements.add(key);
        newUnchecked.add(key);
        this.setElements(newElements, newUnchecked);
    }

    public void setAllRemovable(boolean state) {
        this.areAllRemoveable = state;
        this.update();
    }

    public void setRemovable(E key, boolean state) {
        if (state) {
            this.removableElements.add(key);
        } else {
            this.removableElements.remove(key);
        }
        this.update();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBoxList.setEnabled(enabled);
    }

    public void setCheckBoxesVisible(boolean visible) {
        this.checkBoxesVisible = visible;
        this.update();
    }

    public void setDisabledTooltip(String tooltip) {
        this.disabledTooltip = tooltip;
    }

    public String getDisabledTooltip() {
        return this.disabledTooltip;
    }

    private static void ensureRowVisible(JTable table, int row) {
        if (row != -1) {
            Rectangle cellRect = table.getCellRect(row, 0, false);
            Rectangle visibleRect = table.getVisibleRect();
            if (!visibleRect.intersects(cellRect)) {
                table.scrollRectToVisible(cellRect);
            }
        }
    }

    public void ensureRowVisible(E key) {
        int row;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        for (row = 0; row < this.checkBoxList.getModel().getRowCount(); ++row) {
            Object item = this.checkBoxList.getModel().getValueAt(row, 0);
            if (item == null) {
                return;
            }
            if (item.equals(key)) break;
        }
        CheckBoxList.ensureRowVisible(this.checkBoxList, row);
    }

    public void setItemSelected(E key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.selected = key;
        this.ensureRowVisible(key);
        this.editor.notifyChange();
        this.update();
    }

    public boolean setItemChecked(E key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.checked.contains(key)) {
            this.checked.add(key);
            this.unchecked.remove(key);
        }
        this.bolded.add(key);
        this.update();
        this.ensureRowVisible(key);
        new Timer(2000, new BoldRemoveListener(key)).start();
        return true;
    }

    public void setItemsEnabled(Set<E> keys, boolean state) {
        if (state) {
            HashSet<E> toUncheck = new HashSet<E>(this.checked);
            toUncheck.retainAll(keys);
            toUncheck.retainAll(this.disabled);
            this.checked.removeAll(toUncheck);
            this.unchecked.addAll(toUncheck);
            this.disabled.removeAll(keys);
        } else {
            this.disabled.addAll(keys);
        }
        this.update();
    }

    public void setItemsChecked(Set<E> keys, boolean state) {
        if (state) {
            this.unchecked.removeAll(keys);
            this.checked.addAll(keys);
        } else {
            this.unchecked.addAll(keys);
            this.checked.removeAll(keys);
        }
        this.update();
    }

    @Override
    public boolean isEnabled() {
        return this.checkBoxList.isEnabled();
    }

    public void setVisibleRowCount(int rows) {
        this.visibleRowCount = rows;
        this.setPreferredSize(this.getPreferredScrollableViewportSize());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.visibleRowCount > 0 && this.items.size() > 0 ? new Dimension(this.getPreferredSize().width, this.visibleRowCount * this.checkBoxList.getRowHeight()) : this.getPreferredSize();
    }

    public void setSelectionListener(CheckBoxListSelectionListener listener) {
        this.selectionListener = listener;
    }

    public void setCheckChangeListener(CheckBoxListCheckChangeListener listener) {
        this.checkListener = listener;
    }

    public void setTextProvider(TextProvider<E> provider) {
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        TextProvider<E> oldProvider = this.provider;
        this.provider = provider;
        this.firePropertyChange(TEXT_PROVIDER_PROPERTY, oldProvider, this.provider);
    }

    public List<E> getCheckedElements() {
        if (this.checkBoxList.isEnabled() && this.checked.size() > 0) {
            HashSet<E> totalChecked = new HashSet<E>(this.checked);
            totalChecked.removeAll(this.disabled);
            return new LinkedList<E>(totalChecked);
        }
        return Collections.emptyList();
    }

    public List<E> getUncheckedElements() {
        if (!this.checkBoxList.isEnabled()) {
            return new LinkedList<E>(this.elements);
        }
        HashSet<E> toUncheck = new HashSet<E>(this.checked);
        toUncheck.retainAll(this.disabled);
        if (this.unchecked.size() > 0) {
            HashSet<E> totalUnchecked = new HashSet<E>(this.unchecked);
            totalUnchecked.addAll(toUncheck);
            return new LinkedList<E>(totalUnchecked);
        }
        return new LinkedList<E>(toUncheck);
    }

    public Set<E> getElements() {
        return new HashSet<E>(this.elements);
    }

    public Set<E> getRawUncheckedElementsAsSet() {
        return new HashSet<E>(this.unchecked);
    }

    public Action[] getActions() {
        return new Action[]{new SelectAllAction(), new DeselectAllAction()};
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.editor = new CheckBoxCellEditor();
        this.checkBoxList = new JTable();
        this.checkBoxList.setDefaultRenderer(Object.class, new CheckBoxCellRenderer());
        this.checkBoxList.setDefaultEditor(Object.class, this.editor);
        this.checkBoxList.setRowHeight(22);
        this.checkBoxList.setTableHeader(new JTableHeader());
        this.checkBoxList.getTableHeader().setVisible(false);
        this.checkBoxList.getTableHeader().setSize(0, 0);
        this.scrollPane = new JScrollPane(this.checkBoxList);
        this.add(this.scrollPane);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.checkBoxList == null) {
            return;
        }
        this.setBackground(UIManager.getColor("List.textBackground"));
        this.checkBoxList.setBackground(UIManager.getColor("List.background"));
        this.checkBoxList.setGridColor(UIManager.getColor("List.background"));
        this.scrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
    }

    private class IconDataCheckBox
    extends BoxPanel {
        private E obj;
        private JCheckBox checkBox;
        private JLabel label;
        private JLabel commentlabel;
        private org.limewire.ui.swing.components.CheckBoxList$IconDataCheckBox.DeleteButton button;
        private Border blankBorder;
        private SeperatorBorder sepBorder;
        private Font originalFont;
        private Font boldFont;

        public IconDataCheckBox() {
            super(0);
            this.sepBorder = new SeperatorBorder();
            this.blankBorder = BorderFactory.createMatteBorder(4, 4, 4, 0, (Icon)null);
            this.label = new JLabel();
            this.label.setBorder(this.blankBorder);
            this.commentlabel = new JLabel();
            this.commentlabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            this.checkBox = new JCheckBox("", true);
            this.checkBox.setVisible(CheckBoxList.this.checkBoxesVisible);
            this.button = new DeleteButton();
            this.add(Box.createHorizontalStrut(4));
            this.add(this.checkBox);
            this.add(this.label);
            this.add(this.commentlabel);
            this.add(Box.createHorizontalStrut(1));
            this.add(Box.createHorizontalGlue());
            this.add((Component)this.button);
            this.updateLook();
            this.originalFont = this.label.getFont();
            this.boldFont = this.originalFont.deriveFont(this.originalFont.getStyle() | 1 | 2);
            this.commentlabel.setFont(this.originalFont);
        }

        public void setRemovable(boolean state) {
            this.button.setVisible(state);
        }

        public void setData(E obj) {
            this.obj = obj;
            this.checkBox.setVisible(CheckBoxList.this.checkBoxesVisible);
            this.setRemovable(CheckBoxList.this.areAllRemoveable || CheckBoxList.this.removableElements.contains(obj));
            String text = CheckBoxList.this.provider.getText(obj);
            this.label.setIcon(CheckBoxList.this.provider.getIcon(obj));
            if (CheckBoxList.this.extrasProvider != null) {
                this.label.setText(text + " ");
                Rectangle2D textSize = FontUtils.getLongestTextArea(this.originalFont, text);
                if ((double)CheckBoxList.this.extrasProvider.getCommentFieldSize() > textSize.getWidth() + 26.0) {
                    this.label.setPreferredSize(new Dimension(CheckBoxList.this.extrasProvider.getCommentFieldSize(), 18));
                    this.label.setSize(this.label.getPreferredSize());
                    this.label.setMinimumSize(this.label.getPreferredSize());
                    this.label.setMaximumSize(this.label.getPreferredSize());
                }
                this.commentlabel.setText(CheckBoxList.this.extrasProvider.getComment(obj));
                if (CheckBoxList.this.extrasProvider.isSeparated(obj)) {
                    this.label.setBorder(this.sepBorder);
                } else {
                    this.label.setBorder(this.blankBorder);
                }
            } else {
                this.label.setText(text);
            }
            this.setToolTipText(CheckBoxList.this.provider.getToolTipText(obj));
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.checkBox.setEnabled(enabled);
            this.label.setEnabled(enabled);
        }

        @Override
        public void setForeground(Color c) {
            if (this.label != null) {
                this.label.setForeground(c);
            }
        }

        public void setBold(boolean b) {
            if (b) {
                this.label.setFont(this.boldFont);
            } else {
                this.label.setFont(this.originalFont);
            }
        }

        private void updateLook() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setForeground(UIManager.getColor("List.foreground"));
            this.checkBox.setFont(UIManager.getFont("Table.font"));
            this.checkBox.setOpaque(false);
            this.label.setBackground(UIManager.getColor("List.background"));
            this.label.setForeground(UIManager.getColor("List.foreground"));
            this.label.setFont(UIManager.getFont("Table.font"));
            this.label.setOpaque(false);
        }

        public void addActionListener(ActionListener l) {
            this.checkBox.addActionListener(l);
        }

        public void addTopMouseListener(MouseListener l) {
            this.addMouseListener(l);
            this.label.addMouseListener(l);
            this.commentlabel.addMouseListener(l);
        }

        private class DeleteButton
        extends HyperlinkButton {
            public DeleteButton() {
                this.setFont(new Font("Dialog", 0, 11));
                this.setText(REMOVE_TEXT);
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                this.setVisible(false);
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        CheckBoxList.this.removeItem(IconDataCheckBox.this.obj);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }
        }
    }

    public static interface TextProvider<E> {
        public String getText(E var1);

        public String getToolTipText(E var1);

        public Icon getIcon(E var1);
    }

    public static interface ExtrasProvider<E> {
        public boolean isSeparated(E var1);

        public String getComment(E var1);

        public int getCommentFieldSize();
    }

    public static interface CheckBoxListCheckChangeListener<E> {
        public void valueChanged(CheckBoxListCheckChangeEvent<E> var1);
    }

    public static interface CheckBoxListSelectionListener {
        public void valueChanged(CheckBoxListSelectionEvent var1);
    }

    public static class CheckBoxListCheckChangeEvent<E>
    extends EventObject {
        private E selected;
        private boolean checked;

        public CheckBoxListCheckChangeEvent(Object source, E selected, boolean checked) {
            super(source);
            this.selected = selected;
            this.checked = checked;
        }

        public E getSelected() {
            return this.selected;
        }

        public boolean getChecked() {
            return this.checked;
        }
    }

    public static class CheckBoxListSelectionEvent
    extends EventObject {
        private Object selected;

        public CheckBoxListSelectionEvent(Object source, Object selected) {
            super(source);
            this.selected = selected;
        }

        public Object getSelected() {
            return this.selected;
        }
    }

    private class CheckBoxCellEditor
    extends DefaultCellEditor {
        private org.limewire.ui.swing.components.CheckBoxList$CheckBoxCellEditor.CustomEditorDelegate customDelegate;

        public CheckBoxCellEditor() {
            super(new JCheckBox());
            IconDataCheckBox checkBox = new IconDataCheckBox();
            this.editorComponent = checkBox;
            checkBox.setRequestFocusEnabled(false);
            this.customDelegate = new CustomEditorDelegate();
            this.delegate = this.customDelegate;
            checkBox.addActionListener((ActionListener)this.customDelegate);
            checkBox.addTopMouseListener((MouseListener)this.customDelegate);
        }

        public void notifyChange() {
            this.customDelegate.notifyChange();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }

        private class CustomEditorDelegate
        extends DefaultCellEditor.EditorDelegate
        implements MouseListener {
            private static final long serialVersionUID = -7007164079207676831L;
            private Object lastValue;

            public CustomEditorDelegate() {
                super(CheckBoxCellEditor.this);
                this.lastValue = this.value;
            }

            public void notifyChange() {
                this.lastValue = null;
            }

            @Override
            public void setValue(Object value) {
                boolean isSelected;
                if (value == null) {
                    return;
                }
                IconDataCheckBox box = (IconDataCheckBox)CheckBoxCellEditor.this.editorComponent;
                box.setData(value);
                box.setEnabled(CheckBoxList.this.isEnabled());
                if (CheckBoxList.this.disabled.contains(value)) {
                    if (CheckBoxList.this.disabledTooltip != null) {
                        box.setToolTipText(CheckBoxList.this.disabledTooltip);
                    }
                    box.setEnabled(false);
                    box.setSelected(false);
                    this.value = value;
                    return;
                }
                CheckBoxList.this.selected = value;
                if (this.lastValue == value) {
                    isSelected = true;
                } else {
                    isSelected = false;
                    CheckBoxList.this.repaint();
                    if (CheckBoxList.this.selectionListener != null) {
                        CheckBoxList.this.selectionListener.valueChanged(new CheckBoxListSelectionEvent(CheckBoxList.this.parent, value));
                    }
                }
                if (CheckBoxList.this.checkBoxesVisible && (CheckBoxList.this.selectOff || isSelected)) {
                    boolean decheck = CheckBoxList.this.unchecked.contains(value);
                    if (decheck) {
                        CheckBoxList.this.unchecked.remove(value);
                        CheckBoxList.this.checked.add(value);
                    } else {
                        CheckBoxList.this.unchecked.add(value);
                        CheckBoxList.this.checked.remove(value);
                    }
                    if (CheckBoxList.this.checkListener != null) {
                        CheckBoxList.this.checkListener.valueChanged(new CheckBoxListCheckChangeEvent<Object>(CheckBoxList.this.parent, value, decheck));
                    }
                }
                box.setSelected(CheckBoxList.this.checked.contains(value));
                this.lastValue = value;
                this.value = value;
            }

            @Override
            public Object getCellEditorValue() {
                return this.value;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.stopCellEditing();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        }
    }

    private class CheckBoxCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8209871264709364379L;
        private IconDataCheckBox checkBox;

        private CheckBoxCellRenderer() {
            this.checkBox = new IconDataCheckBox();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.checkBox.setData(value);
            }
            if (!CheckBoxList.this.selectOff && value != null && value.equals(CheckBoxList.this.selected)) {
                this.checkBox.setBackground(UIManager.getColor("List.selectionBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.checkBox.setBackground(UIManager.getColor("List.textBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.textForeground"));
            }
            if (CheckBoxList.this.bolded.contains(value)) {
                this.checkBox.setBold(true);
            } else {
                this.checkBox.setBold(false);
            }
            if (CheckBoxList.this.disabled.contains(value)) {
                if (CheckBoxList.this.disabledTooltip != null) {
                    this.checkBox.setToolTipText(CheckBoxList.this.disabledTooltip);
                }
                this.checkBox.setEnabled(false);
                this.checkBox.setSelected(false);
            } else {
                this.checkBox.setSelected(!CheckBoxList.this.unchecked.contains(value));
                this.checkBox.setEnabled(table.isEnabled());
            }
            return this.checkBox;
        }
    }

    private class DeselectAllAction
    extends AbstractAction {
        public DeselectAllAction() {
            this.putValue("Name", I18n.tr("Deselect All"));
            this.putValue("ShortDescription", I18n.tr("Deselects all Items in the List"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.unchecked.addAll(CheckBoxList.this.checked);
            CheckBoxList.this.checked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("Name", I18n.tr("Select All"));
            this.putValue("ShortDescription", I18n.tr("Marks all Items as Selected"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.checked.addAll(CheckBoxList.this.unchecked);
            CheckBoxList.this.unchecked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    public static class DefaultTextProvider<E>
    implements TextProvider<E> {
        @Override
        public String getText(E obj) {
            return obj.toString();
        }

        @Override
        public String getToolTipText(E obj) {
            return null;
        }

        @Override
        public Icon getIcon(E obj) {
            return null;
        }
    }

    private class BoldRemoveListener
    implements ActionListener {
        private E key;

        public BoldRemoveListener(E key) {
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.bolded.remove(this.key);
            CheckBoxList.this.update();
        }
    }
}

