/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.http;

import java.io.IOException;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.IOControl;
import org.apache.http.protocol.HttpContext;
import org.limewire.collection.Range;
import org.limewire.io.IOUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class SwarmHttpUtils {
    private static final Log LOG = LogFactory.getLog(SwarmHttpUtils.class);

    private SwarmHttpUtils() {
    }

    public static void closeConnectionFromContext(HttpContext context) {
        IOControl ioctrl = (IOControl)context.getAttribute("http.connection");
        try {
            ioctrl.shutdown();
        }
        catch (IOException ignored) {
            LOG.warn("Error shutting down IOControl.", ignored);
        }
    }

    public static Range rangeForContentRange(String headerValue, long contentLength) throws IOException {
        try {
            int start = headerValue.indexOf("bytes") + 6;
            int slash = headerValue.indexOf(47);
            if (headerValue.substring(start, slash).equals("*")) {
                return Range.createRange(0L, contentLength - 1L);
            }
            int dash = headerValue.lastIndexOf("-");
            long numBeforeDash = SwarmHttpUtils.numberFor(headerValue.substring(start, dash));
            long numBeforeSlash = SwarmHttpUtils.numberFor(headerValue.substring(dash + 1, slash));
            if (numBeforeSlash < numBeforeDash) {
                IOException e = new IOException("invalid range, high (" + numBeforeSlash + ") less than low (" + numBeforeDash + ")");
                LOG.warn(e.getMessage(), e);
                throw e;
            }
            return Range.createRange(numBeforeDash, numBeforeSlash);
        }
        catch (IndexOutOfBoundsException e) {
            IOException ioException = IOUtils.getIOException("Invalid Header: " + headerValue, e);
            LOG.warn(ioException.getMessage(), ioException);
            throw ioException;
        }
    }

    public static long numberFor(String number) throws IOException {
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException nfe) {
            IOException e = IOUtils.getIOException("Invalid number: " + number, nfe);
            LOG.warn(e.getMessage(), e);
            throw e;
        }
    }

    public static Range parseContentRange(HttpResponse response) throws IOException {
        Range actualRange;
        Header contentRange = response.getFirstHeader("Content-Range");
        Header contentLengthHeader = response.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            long contentLength = SwarmHttpUtils.numberFor(contentLengthHeader.getValue());
            if (contentLength < 0L) {
                IOException e = new IOException("Invalid content length: " + contentLength);
                LOG.warn(e.getMessage(), e);
                throw e;
            }
            actualRange = contentRange != null ? SwarmHttpUtils.rangeForContentRange(contentRange.getValue(), contentLength) : Range.createRange(0L, contentLength - 1L);
        } else {
            if (contentRange == null) {
                IOException e = new IOException("No Content Range Found.");
                LOG.warn(e.getMessage(), e);
                throw e;
            }
            IOException e = new IOException("No content length, though content range existed.");
            LOG.warn(e.getMessage(), e);
            throw e;
        }
        return actualRange;
    }

    public static String logRequest(String message, HttpRequest request) {
        String requestLine = request != null ? request.getRequestLine().toString() : "null";
        String headers = request != null ? Arrays.asList(request.getAllHeaders()).toString() : "null";
        String log = message + " request : " + requestLine + " headers: " + headers;
        return log;
    }

    public static String logReponse(String message, HttpResponse response) {
        String statusLine = response != null ? response.getStatusLine().toString() : "null";
        String headers = response != null ? Arrays.asList(response.getAllHeaders()).toString() : "null";
        String log = message + ": " + statusLine + " headers: " + headers;
        return log;
    }
}

