/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.collection.Range;
import org.limewire.io.IOUtils;
import org.limewire.swarm.SwarmFile;
import org.limewire.swarm.SwarmFileSystem;
import org.limewire.swarm.file.SwarmFileImpl;

public class SwarmFileSystemImpl
implements SwarmFileSystem {
    private final List<SwarmFile> swarmFiles = new CopyOnWriteArrayList<SwarmFile>();
    private final Map<SwarmFile, FileHandle> fileHandles = new HashMap<SwarmFile, FileHandle>();
    private long completeSize = 0L;

    public SwarmFileSystemImpl() {
    }

    public SwarmFileSystemImpl(SwarmFileImpl swarmFile) {
        this();
        this.addSwarmFile(swarmFile);
    }

    @Override
    public long getCompleteSize() {
        return this.completeSize;
    }

    @Override
    public SwarmFile getSwarmFile(long position) {
        for (SwarmFile swarmFile : this.swarmFiles) {
            long startByte = swarmFile.getStartBytePosition();
            long endByte = swarmFile.getEndBytePosition();
            if (startByte > position || endByte < position) continue;
            return swarmFile;
        }
        return null;
    }

    @Override
    public List<SwarmFile> getSwarmFiles() {
        return this.swarmFiles;
    }

    public synchronized void addSwarmFile(SwarmFileImpl swarmFile) {
        this.swarmFiles.add(swarmFile);
        swarmFile.setStartByte(this.completeSize);
        this.completeSize += swarmFile.getFileSize();
    }

    @Override
    public long write(ByteBuffer byteBuffer, long start) throws IOException {
        this.initialize();
        long currentPosition = start;
        long wroteTotal = 0L;
        while (byteBuffer.position() < byteBuffer.limit()) {
            SwarmFile swarmFile = this.getSwarmFile(currentPosition);
            long writeStart = currentPosition - swarmFile.getStartBytePosition();
            long wrote = this.getFileHandle(swarmFile).write(byteBuffer, writeStart);
            currentPosition += wrote;
            wroteTotal += wrote;
        }
        return wroteTotal;
    }

    @Override
    public long read(ByteBuffer byteBuffer, long position) throws IOException {
        this.initialize();
        SwarmFile swarmFile = this.getSwarmFile(position);
        long read = this.getFileHandle(swarmFile).read(byteBuffer, position);
        return read;
    }

    @Override
    public void closeSwarmFile(SwarmFile swarmFile) throws IOException {
        FileHandle fileHandle = this.getFileHandle(swarmFile);
        fileHandle.close();
        this.fileHandles.put(swarmFile, null);
    }

    @Override
    public synchronized void close() throws IOException {
        IOException firstException = null;
        for (SwarmFile swarmFile : this.swarmFiles) {
            try {
                this.closeSwarmFile(swarmFile);
            }
            catch (IOException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public List<SwarmFile> getSwarmFiles(Range range) {
        ArrayList<SwarmFile> filesRet = new ArrayList<SwarmFile>();
        long rangeStart = range.getLow();
        long rangeEnd = range.getHigh();
        for (SwarmFile swarmFile : this.swarmFiles) {
            long startByte = swarmFile.getStartBytePosition();
            long endByte = swarmFile.getEndBytePosition();
            if (startByte > rangeEnd || endByte < rangeStart) continue;
            filesRet.add(swarmFile);
        }
        return filesRet;
    }

    @Override
    public synchronized void initialize() throws IOException {
    }

    private synchronized FileHandle getFileHandle(SwarmFile swarmFile) {
        FileHandle fileHandle = this.fileHandles.get(swarmFile);
        if (fileHandle == null) {
            fileHandle = new FileHandle(swarmFile);
            this.fileHandles.put(swarmFile, fileHandle);
        }
        return fileHandle;
    }

    private static class FileHandle {
        private SwarmFile swarmFile = null;
        private Object LOCK = new Object();
        private RandomAccessFile raFile;
        private FileChannel fileChannel;
        private File file = null;

        public FileHandle(SwarmFile swarmFile) {
            this.swarmFile = swarmFile;
            this.file = swarmFile.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialize() throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.raFile == null) {
                    this.raFile = new RandomAccessFile(this.file, "rw");
                    this.fileChannel = this.raFile.getChannel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                IOUtils.close(this.fileChannel);
                IOUtils.close(this.raFile);
                this.fileChannel = null;
                this.raFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(ByteBuffer byteBuffer, long position) throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                this.initialize();
                long read = this.fileChannel.read(byteBuffer, position);
                return read;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long write(ByteBuffer byteBuffer, long start) throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                this.initialize();
                long pendingBytes = this.swarmFile.getFileSize() - start;
                int oldLimit = byteBuffer.limit();
                int position = byteBuffer.position();
                long wrote = 0L;
                try {
                    int pending;
                    int limit;
                    if (pendingBytes < Integer.MAX_VALUE && (limit = position + (pending = (int)pendingBytes)) < oldLimit) {
                        byteBuffer.limit(limit);
                    }
                    wrote = this.fileChannel.write(byteBuffer, start);
                }
                finally {
                    byteBuffer.limit(oldLimit);
                }
                return wrote;
            }
        }
    }
}

