/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;

public class StringSetSetting
extends AbstractSetting<Set<String>> {
    private Set<String> value;

    StringSetSetting(Properties defaultProps, Properties props, String key, String defaultValue) {
        super(defaultProps, props, key, defaultValue);
    }

    @Override
    public synchronized Set<String> get() {
        return this.value;
    }

    public synchronized String[] getValueAsArray() {
        return this.value.toArray(new String[this.value.size()]);
    }

    @Override
    protected synchronized void loadValue(String sValue) {
        this.value = StringSetSetting.encode(sValue);
    }

    private static Set<String> encode(String src) {
        if (src == null || src.length() == 0) {
            return new HashSet<String>();
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        int size = tokenizer.countTokens();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            set.add(tokenizer.nextToken());
        }
        return set;
    }

    private static String decode(Set<String> src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String str : src) {
            buffer.append(str).append(';');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Override
    public synchronized void set(Set<String> value) {
        this.setValueInternal(StringSetSetting.decode(value));
    }

    public synchronized boolean add(String s) {
        if (this.value.add(s)) {
            this.setValueInternal(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String s) {
        if (this.value.remove(s)) {
            this.setValueInternal(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean contains(String s) {
        return this.value.contains(s);
    }
}

