/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.CertificateTools;
import org.limewire.security.certificate.KeyStoreProvider;

@Singleton
class KeyStoreProviderImpl
implements KeyStoreProvider {
    private volatile KeyStore keyStore = null;
    private final Provider<HttpClient> httpClient;
    private volatile File keyStoreLocation;
    private volatile char[] keyStorePassword;
    private static final Log LOG = LogFactory.getLog(KeyStoreProviderImpl.class);

    @Inject
    KeyStoreProviderImpl(Provider<HttpClient> httpClient) {
        this.httpClient = httpClient;
        this.keyStoreLocation = CertificateTools.getKeyStoreLocation();
        this.keyStorePassword = CertificateTools.getKeyStorePassword();
    }

    void setKeyStoreLocation(File location) {
        this.keyStoreLocation = location;
    }

    void setKeyStorePassword(char[] password) {
        this.keyStorePassword = password;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyStore getKeyStore() throws IOException {
        KeyStore ks = this.keyStore;
        if (this.isValid(ks)) {
            return ks;
        }
        try {
            this.keyStore = ks = this.getKeyStoreFromDisk();
            return ks;
        }
        catch (IOException ex) {
            KeyStore keyStore;
            LOG.debug("IOException trying to load keystore from disk.", ex);
            FileOutputStream out = null;
            try {
                this.keyStore = ks = this.getKeyStoreFromNetwork();
                this.keyStoreLocation.getParentFile().mkdirs();
                out = new FileOutputStream(this.keyStoreLocation);
                ks.store(out, this.keyStorePassword);
                keyStore = ks;
            }
            catch (KeyStoreException ex2) {
                try {
                    throw IOUtils.getIOException("KeyStoreException while saving keystore: ", ex2);
                    catch (NoSuchAlgorithmException ex3) {
                        throw IOUtils.getIOException("NoSuchAlgorithmException while saving keystore: ", ex3);
                    }
                    catch (CertificateException ex4) {
                        throw IOUtils.getIOException("CertificateException while saving keystore: ", ex4);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(out);
                    throw throwable;
                }
            }
            IOUtils.close(out);
            return keyStore;
        }
    }

    KeyStore getKeyStoreFromNetwork() throws IOException {
        KeyStore newKeyStore;
        HttpClient client = this.httpClient.get();
        HttpGet get = new HttpGet(CertificateTools.getKeyStoreURI());
        try {
            newKeyStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException ex) {
            throw new IOException("KeyStoreException instantiating keystore: " + ex.getMessage());
        }
        HttpResponse response = null;
        try {
            response = client.execute(get);
            if (response.getStatusLine().getStatusCode() == 200) {
                try {
                    newKeyStore.load(response.getEntity().getContent(), this.keyStorePassword);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw IOUtils.getIOException("NoSuchAlgorithmException while parsing keystore: ", ex);
                }
                catch (CertificateException ex) {
                    throw IOUtils.getIOException("CertificateException while parsing keystore: ", ex);
                }
                KeyStore keyStore = newKeyStore;
                return keyStore;
            }
            throw new IOException("Failed to download new keystore (" + CertificateTools.getKeyStoreURI().toString() + "): " + response.getStatusLine());
        }
        finally {
            if (response != null && response.getEntity() != null) {
                try {
                    response.getEntity().consumeContent();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    KeyStore getKeyStoreFromDisk() throws IOException {
        KeyStore keyStore;
        BufferedInputStream in = null;
        try {
            KeyStore newKeyStore = KeyStore.getInstance("jks");
            in = new BufferedInputStream(new FileInputStream(this.keyStoreLocation));
            newKeyStore.load(in, this.keyStorePassword);
            keyStore = newKeyStore;
        }
        catch (KeyStoreException ex) {
            try {
                throw IOUtils.getIOException("KeyStoreException while creating keystore in memory: ", ex);
                catch (NoSuchAlgorithmException ex2) {
                    throw IOUtils.getIOException("NoSuchAlgorithmException while parsing keystore: ", ex2);
                }
                catch (CertificateException ex3) {
                    throw IOUtils.getIOException("CertificateException while parsing keystore: ", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
        }
        IOUtils.close(in);
        return keyStore;
    }

    @Override
    public void invalidateKeyStore() {
        this.keyStore = null;
        this.keyStoreLocation.delete();
    }

    private boolean isValid(KeyStore ks) {
        if (ks == null) {
            return false;
        }
        try {
            if (ks.size() > 0) {
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isCached() {
        if (this.isValid(this.keyStore)) {
            return true;
        }
        if (this.keyStoreLocation.exists()) {
            try {
                if (this.isValid(this.getKeyStoreFromDisk())) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

