/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.inject.EagerSingleton;
import org.limewire.security.MACCalculator;
import org.limewire.security.MACCalculatorFactory;
import org.limewire.security.MACCalculatorRepository;
import org.limewire.security.MACCalculatorRotator;
import org.limewire.security.SecurityToken;
import org.limewire.security.SettingsProvider;
import org.limewire.security.SimpleMACCalculatorRepository;
import org.limewire.security.TEAMACCalculatorFactory;

@EagerSingleton
public class MACCalculatorRepositoryManager {
    private final MACCalculatorRepository repository;

    @Inject
    public MACCalculatorRepositoryManager(@Named(value="backgroundExecutor") ScheduledExecutorService executor, SettingsProvider provider) {
        this.repository = new MACCalculatorRotator(executor, new TEAMACCalculatorFactory(), provider);
    }

    public MACCalculatorRepositoryManager() {
        this.repository = new SimpleMACCalculatorRepository(new TEAMACCalculatorFactory());
    }

    public byte[] getMACBytes(SecurityToken.TokenData data) {
        return this.repository.getCurrentMACCalculator().getMACBytes(data);
    }

    public Iterable<byte[]> getAllBytes(SecurityToken.TokenData data) {
        ArrayList<byte[]> l = new ArrayList<byte[]>(2);
        for (MACCalculator validKey : this.repository.getValidMACCalculators()) {
            l.add(validKey.getMACBytes(data));
        }
        return l;
    }

    public static MACCalculatorFactory createDefaultCalculatorFactory() {
        return new TEAMACCalculatorFactory();
    }
}

