/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.jdbcDriver;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;
import org.limewire.promotion.DatabaseExecutionException;
import org.limewire.promotion.InitializeException;
import org.limewire.promotion.KeywordUtil;
import org.limewire.promotion.PromotionBinder;
import org.limewire.promotion.SearcherDatabase;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.promotion.exceptions.PromotionException;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.security.certificate.KeyStoreProvider;
import org.limewire.util.CommonUtils;

@Singleton
public class SearcherDatabaseImpl
implements SearcherDatabase {
    private static final Log LOG = LogFactory.getLog(SearcherDatabaseImpl.class);
    private Connection connection;
    private final KeywordUtil keywordUtil;
    private final CipherProvider cipherProvider;
    private final KeyStoreProvider keyStoreProvider;
    private final CertificateVerifier certificateVerifier;

    static String getDBLocation() {
        return new File(CommonUtils.getUserSettingsDir(), "promotion/promodb").getAbsolutePath();
    }

    @Inject
    public SearcherDatabaseImpl(KeywordUtil keywordUtil, CipherProvider cipherProvider, KeyStoreProvider keyStoreProvider, CertificateVerifier certificateVerifier) {
        this.keywordUtil = keywordUtil;
        this.cipherProvider = cipherProvider;
        this.keyStoreProvider = keyStoreProvider;
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void init() throws InitializeException {
        try {
            new jdbcDriver();
            this.connection = DriverManager.getConnection("jdbc:hsqldb:file:" + SearcherDatabaseImpl.getDBLocation(), "sa", "");
            this.createDBIfNeeded();
        }
        catch (SQLException sqlException) {
            throw new InitializeException(sqlException);
        }
        catch (DatabaseExecutionException e) {
            throw new InitializeException(e);
        }
    }

    @Override
    public void shutDown() {
        if (this.connection != null) {
            try {
                this.executeUpdate("SHUTDOWN", new Object[0]);
            }
            catch (DatabaseExecutionException databaseExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(String sql, Object ... values) throws DatabaseExecutionException {
        int n;
        PreparedStatement statement = this.connection.prepareStatement(sql);
        try {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] instanceof java.util.Date) {
                    statement.setDate(i + 1, new Date(((java.util.Date)values[i]).getTime()));
                    continue;
                }
                statement.setObject(i + 1, values[i]);
            }
            n = statement.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException ex) {
                throw new DatabaseExecutionException(ex);
            }
        }
        statement.close();
        return n;
    }

    private static Stmt stmt(String sql) {
        return new Stmt(sql);
    }

    private synchronized int executeUpdates(Stmt ... stmts) throws DatabaseExecutionException {
        int numAffectedRows = 0;
        for (Stmt stmt : stmts) {
            numAffectedRows += this.executeUpdate(stmt.sql, stmt.values);
        }
        return numAffectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private long executeInsert(String sql, Object ... values) throws DatabaseExecutionException {
        try {
            this.executeUpdate(sql, values);
            PreparedStatement statement = this.connection.prepareStatement("CALL IDENTITY()");
            try {
                long l;
                ResultSet rs = statement.executeQuery();
                try {
                    rs.next();
                    l = rs.getLong(1);
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return l;
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException during update", ex);
        }
    }

    private void createDBIfNeeded() throws DatabaseExecutionException {
        try {
            this.query("foo");
        }
        catch (RuntimeException ignored) {
            this.clear();
        }
    }

    @Override
    public void clear() throws DatabaseExecutionException {
        this.executeUpdates(SearcherDatabaseImpl.stmt("DROP TABLE keywords IF EXISTS"), SearcherDatabaseImpl.stmt("DROP TABLE entries IF EXISTS"), SearcherDatabaseImpl.stmt("DROP TABLE binders IF EXISTS"), SearcherDatabaseImpl.stmt("CREATE CACHED TABLE entries (entry_id IDENTITY, unique_id BIGINT, probability_num FLOAT, type_byte TINYINT, valid_start_dt DATETIME, valid_end_dt DATETIME, entry_ggep BINARY )"), SearcherDatabaseImpl.stmt("CREATE CACHED TABLE keywords (keyword_id IDENTITY, binder_unique_name VARCHAR(1000),phrase VARCHAR,entry_id INTEGER, FOREIGN KEY (entry_id) REFERENCES entries (entry_id) ON DELETE CASCADE )"), SearcherDatabaseImpl.stmt("CREATE CACHED TABLE binders (binder_id IDENTITY, binder_unique_name VARCHAR(1000), binder_bucket_id INTEGER, valid_end_dt DATETIME, binder_blob BINARY)"));
    }

    @Override
    public void expungeExpired() throws DatabaseExecutionException {
        this.executeUpdates(SearcherDatabaseImpl.stmt("DELETE FROM entries WHERE valid_end_dt < CURRENT_TIMESTAMP"), SearcherDatabaseImpl.stmt("DELETE FROM binders WHERE valid_end_dt < CURRENT_TIMESTAMP"));
    }

    private synchronized void saveBinder(PromotionBinder binder) throws DatabaseExecutionException {
        this.executeUpdate("DELETE FROM binders where binder_unique_name = ?", binder.getUniqueName());
        this.executeInsert("INSERT INTO binders (binder_unique_name, binder_bucket_id, valid_end_dt, binder_blob) VALUES (?,?,?,?)", binder.getUniqueName(), binder.getBucketNumber(), binder.getValidEnd(), binder.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromotionBinder getBinder(String binderUniqueName) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT binder_blob FROM binders WHERE binder_unique_name = ? ORDER BY binder_id DESC");
            statement.setString(1, binderUniqueName);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                PromotionBinder binder = new PromotionBinder(this.cipherProvider, this.keyStoreProvider, this.certificateVerifier);
                binder.initialize(rs.getBytes("binder_blob"));
                PromotionBinder promotionBinder = binder;
                return promotionBinder;
            }
            PromotionBinder promotionBinder = null;
            return promotionBinder;
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException during query.", ex);
        }
        catch (PromotionException ex) {
            LOG.error("promotion error", ex);
            PromotionBinder promotionBinder = null;
            return promotionBinder;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromotionBinder getBinder(int bucketNumber) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT binder_blob FROM binders WHERE binder_bucket_id = ? ORDER BY binder_id DESC");
            statement.setInt(1, bucketNumber);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                PromotionBinder binder = new PromotionBinder(this.cipherProvider, this.keyStoreProvider, this.certificateVerifier);
                binder.initialize(rs.getBytes("binder_blob"));
                PromotionBinder promotionBinder = binder;
                return promotionBinder;
            }
            PromotionBinder promotionBinder = null;
            return promotionBinder;
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException during query.", ex);
        }
        catch (PromotionException ex) {
            PromotionBinder promotionBinder = null;
            return promotionBinder;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    synchronized void ingest(PromotionMessageContainer promo, String binderUniqueName) throws DatabaseExecutionException {
        this.executeUpdate("DELETE FROM entries WHERE unique_id = ?", promo.getUniqueID());
        long entryID = this.executeInsert("INSERT INTO entries (unique_id, probability_num, type_byte, valid_start_dt, valid_end_dt, entry_ggep) values (?,?,?,?,?,?)", promo.getUniqueID(), Float.valueOf(promo.getProbability()), promo.getMediaType().getValue(), promo.getValidStart(), promo.getValidEnd(), promo.encode());
        for (String keyword : this.keywordUtil.splitKeywords(promo.getKeywords())) {
            this.executeInsert("INSERT INTO keywords (phrase, binder_unique_name, entry_id) values (?,?,?)", this.keywordUtil.normalizeQuery(keyword), binderUniqueName, entryID);
        }
    }

    @Override
    public void ingest(PromotionBinder binder) throws DatabaseExecutionException {
        for (PromotionMessageContainer promo : binder.getPromoMessageList()) {
            this.ingest(promo, binder.getUniqueName());
        }
        this.saveBinder(binder);
    }

    @Override
    public List<SearcherDatabase.QueryResult> query(String query) {
        ArrayList<SearcherDatabase.QueryResult> results = new ArrayList<SearcherDatabase.QueryResult>();
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT DISTINCT e.entry_id, k.binder_unique_name, e.probability_num FROM keywords k JOIN entries e ON e.entry_id = k.entry_id WHERE e.valid_start_dt <= CURRENT_TIMESTAMP AND e.valid_end_dt >= CURRENT_TIMESTAMP AND k.phrase = ? ORDER BY e.probability_num DESC, RAND()");
            statement.setString(1, this.keywordUtil.normalizeQuery(query));
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                String binderUniqueName = rs.getString("binder_unique_name");
                PromotionMessageContainer promo = this.getPromotionMessageContainer(rs.getLong("entry_id"));
                if (promo == null || binderUniqueName == null) continue;
                results.add(new QueryResultImpl(binderUniqueName, promo, query));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException during query.", ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return results;
    }

    PromotionMessageContainer getPromotionMessageContainer(long entryID) {
        PromotionMessageContainer promotionMessageContainer;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("select entry_ggep from entries where entry_id = ?");
            statement.setLong(1, entryID);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                byte[] ggep = rs.getBytes(1);
                PromotionMessageContainer promo = new PromotionMessageContainer();
                promo.decode(new GGEP(ggep, 0));
                PromotionMessageContainer promotionMessageContainer2 = promo;
                return promotionMessageContainer2;
            }
            rs.close();
            promotionMessageContainer = null;
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException during query.", ex);
        }
        catch (BadGGEPBlockException ex) {
            throw new RuntimeException("GGEPException during query.", ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return promotionMessageContainer;
    }

    private static class QueryResultImpl
    implements SearcherDatabase.QueryResult {
        private final String binderUniqueName;
        private final java.util.Date creationDate = new java.util.Date();
        private final PromotionMessageContainer promotionMessageContainer;
        private final String query;

        QueryResultImpl(String binderUniqueName, PromotionMessageContainer promo, String query) {
            this.binderUniqueName = binderUniqueName;
            this.promotionMessageContainer = promo;
            this.query = query;
        }

        @Override
        public String getBinderUniqueName() {
            return this.binderUniqueName;
        }

        @Override
        public java.util.Date getDate() {
            return this.creationDate;
        }

        @Override
        public PromotionMessageContainer getPromotionMessageContainer() {
            return this.promotionMessageContainer;
        }

        @Override
        public String getQuery() {
            return this.query;
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueryResultImpl) {
                QueryResultImpl other = (QueryResultImpl)obj;
                return this.promotionMessageContainer.equals(other.promotionMessageContainer);
            }
            return false;
        }

        public int hashCode() {
            return this.promotionMessageContainer.hashCode();
        }
    }

    private static final class Stmt {
        private static final Object[] EMPTY_VALUES = new Object[0];
        final String sql;
        final Object[] values;

        Stmt(String sql, Object[] values) {
            this.sql = sql;
            this.values = values;
        }

        Stmt(String sql) {
            this(sql, EMPTY_VALUES);
        }
    }
}

