/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net.address;

import java.util.Comparator;
import java.util.Set;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public class FirewalledAddress
implements Address {
    private final Connectable publicAddress;
    private final Connectable privateAddress;
    private final Set<Connectable> pushProxies;
    private final int fwtVersion;
    private final GUID clientGuid;
    private int hashCode;

    public FirewalledAddress(Connectable publicAddress, Connectable privateAddress, GUID clientGuid, Set<Connectable> pushProxies, int fwtVersion) {
        this.publicAddress = Objects.nonNull(publicAddress, "publicAddress");
        this.privateAddress = Objects.nonNull(privateAddress, "privateAddress");
        this.clientGuid = clientGuid;
        this.pushProxies = pushProxies;
        this.fwtVersion = fwtVersion;
        if (fwtVersion > 0 && !NetworkUtils.isValidIpPort(publicAddress)) {
            throw new IllegalArgumentException("inconsistent firewalled address: " + this);
        }
    }

    @Override
    public String getAddressDescription() {
        if (NetworkUtils.isValidIpPort(this.getPublicAddress())) {
            return this.publicAddress.getAddressDescription();
        }
        return this.privateAddress.getAddressDescription();
    }

    public Connectable getPublicAddress() {
        return this.publicAddress;
    }

    public Connectable getPrivateAddress() {
        return this.privateAddress;
    }

    public Set<Connectable> getPushProxies() {
        return this.pushProxies;
    }

    public int getFwtVersion() {
        return this.fwtVersion;
    }

    public GUID getClientGuid() {
        return this.clientGuid;
    }

    public String toString() {
        return StringUtils.toString(this, this.publicAddress, this.privateAddress, this.clientGuid, this.pushProxies, this.fwtVersion);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FirewalledAddress)) {
            return false;
        }
        FirewalledAddress other = (FirewalledAddress)obj;
        if (!this.equals(Connectable.COMPARATOR, this.publicAddress, other.getPublicAddress())) {
            return false;
        }
        if (!this.equals(Connectable.COMPARATOR, this.privateAddress, other.getPrivateAddress())) {
            return false;
        }
        if (!Objects.equalOrNull(this.pushProxies, other.getPushProxies())) {
            return false;
        }
        if (!Objects.equalOrNull(this.clientGuid, other.getClientGuid())) {
            return false;
        }
        return this.fwtVersion == other.getFwtVersion();
    }

    private int hashCode(Connectable connectable) {
        if (connectable == null) {
            return 0;
        }
        return connectable.getInetSocketAddress().hashCode() + (connectable.isTLSCapable() ? 1 : 0);
    }

    private int hashCode(Set<Connectable> set) {
        int hashCode = 0;
        for (Connectable connectable : set) {
            hashCode = 31 * hashCode + this.hashCode(connectable);
        }
        return hashCode;
    }

    private int hashCode(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = this.hashCode(this.publicAddress);
            hash = 31 * hash + this.hashCode(this.privateAddress);
            hash = 31 * hash + this.hashCode(this.pushProxies);
            hash = 31 * hash + this.hashCode(this.clientGuid);
            this.hashCode = hash = 31 * hash + this.fwtVersion;
        }
        return this.hashCode;
    }

    private <T> boolean equals(Comparator<T> comparator, T t1, T t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return comparator.compare(t1, t2) == 0;
    }
}

